/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.dailyplan.db.Calendar2DB;
import com.sos.jitl.dailyplan.db.DailyPlanDBLayer;
import com.sos.jitl.jobstreams.db.DBItemJobStream;
import com.sos.jitl.jobstreams.db.DBItemJobStreamParameter;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarter;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarterJob;
import com.sos.jitl.jobstreams.db.DBLayerInConditions;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamHistory;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamParameters;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamStarters;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamsStarterJobs;
import com.sos.jitl.jobstreams.db.DBLayerOutConditions;
import com.sos.jitl.jobstreams.db.FilterInConditions;
import com.sos.jitl.jobstreams.db.FilterJobStreamHistory;
import com.sos.jitl.jobstreams.db.FilterJobStreamParameters;
import com.sos.jitl.jobstreams.db.FilterJobStreamStarterJobs;
import com.sos.jitl.jobstreams.db.FilterJobStreamStarters;
import com.sos.jitl.jobstreams.db.FilterJobStreams;
import com.sos.jitl.jobstreams.db.FilterOutConditions;
import com.sos.joc.model.common.NameValuePair;
import com.sos.joc.model.jobstreams.JobStream;
import com.sos.joc.model.jobstreams.JobStreamJob;
import com.sos.joc.model.jobstreams.JobStreamStarter;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerJobStreams {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerJobStreams.class);
    private static final String DBItemJobStream = DBItemJobStream.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerJobStreams(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemJobStream getJobStreamsDbItem(Long id) throws SOSHibernateException {
        return (DBItemJobStream)this.sosHibernateSession.get(DBItemJobStream.class, (Serializable)id);
    }

    public FilterJobStreams resetFilter() {
        FilterJobStreams filter = new FilterJobStreams();
        filter.setStatus("");
        filter.setJobStream("");
        return filter;
    }

    private String getWhere(FilterJobStreams filter) {
        String where = " ";
        String and = " ";
        if (filter.getSchedulerId() != null && !"".equals(filter.getSchedulerId())) {
            where = where + and + " schedulerId = :schedulerId";
            and = " and ";
        }
        if (filter.getStatus() != null && !"".equals(filter.getStatus())) {
            where = where + and + " state = :state";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " jobStream = :jobStream";
            and = " and ";
        }
        if (filter.getJobStreamId() != null) {
            where = where + and + " id  = :id";
            and = " and ";
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            where = where + and + " folder  = :folder";
            and = " and ";
        }
        if (filter.getFolderItem() != null) {
            where = filter.getFolderItem().getRecursive() != false ? where + and + " folder like :folder" : where + and + " folder  = :folder";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = " where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterJobStreams filter, Query<T> query) {
        if (filter.getSchedulerId() != null && !"".equals(filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)filter.getSchedulerId());
        }
        if (filter.getJobStreamId() != null) {
            query.setParameter("id", (Object)filter.getJobStreamId());
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            query.setParameter("folder", (Object)filter.getFolder());
        }
        if (filter.getFolderItem() != null) {
            if (filter.getFolderItem().getRecursive().booleanValue()) {
                query.setParameter("folder", (Object)(filter.getFolderItem().getFolder() + "%"));
            } else {
                query.setParameter("folder", (Object)filter.getFolderItem().getFolder());
            }
        }
        if (filter.getStatus() != null && !"".equals(filter.getStatus())) {
            query.setParameter("state", (Object)filter.getStatus());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobStream", (Object)filter.getJobStream());
        }
        return query;
    }

    public Long getJobStreamCount() throws SOSHibernateException {
        String q = "select count(*) from " + DBItemJobStream;
        Query query = this.sosHibernateSession.createQuery(q);
        Long count = (Long)this.sosHibernateSession.getResultList(query).get(0);
        return count;
    }

    public List<DBItemJobStream> getJobStreamsList(FilterJobStreams filter, int limit) throws SOSHibernateException {
        String q = "  from " + DBItemJobStream + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public Integer deleteCascading(FilterJobStreams filter, Boolean withConditionsAndStarters) throws SOSHibernateException {
        int row = 0;
        String hql = "";
        DBLayerJobStreamStarters dbLayerJobStreamStarters = new DBLayerJobStreamStarters(this.sosHibernateSession);
        DBLayerJobStreamParameters dbLayerJobStreamParameters = new DBLayerJobStreamParameters(this.sosHibernateSession);
        DBLayerJobStreamsStarterJobs dbLayerJobStreamsStarterJobs = new DBLayerJobStreamsStarterJobs(this.sosHibernateSession);
        DBLayerInConditions dbLayerInConditions = new DBLayerInConditions(this.sosHibernateSession);
        DBLayerOutConditions dbLayerOutConditions = new DBLayerOutConditions(this.sosHibernateSession);
        DBLayerJobStreamHistory dbLayerJobStreamHistory = new DBLayerJobStreamHistory(this.sosHibernateSession);
        DailyPlanDBLayer dailyPlanDBLayer = new DailyPlanDBLayer(this.sosHibernateSession);
        List<DBItemJobStream> lJobStreams = this.getJobStreamsList(filter, 0);
        for (DBItemJobStream dbItemJobStream : lJobStreams) {
            FilterJobStreamStarterJobs filterJobStreamStarterJobs = new FilterJobStreamStarterJobs();
            FilterJobStreamParameters filterJobStreamParameters = new FilterJobStreamParameters();
            if (filter.getJobStreamId() != null) {
                filter.setFolder(dbItemJobStream.getFolder());
            }
            FilterJobStreamStarters filterJobStreamStarters = new FilterJobStreamStarters();
            filterJobStreamStarters.setJobStreamId(dbItemJobStream.getId());
            List<DBItemJobStreamStarter> lStarters = dbLayerJobStreamStarters.getJobStreamStartersList(filterJobStreamStarters, 0);
            for (DBItemJobStreamStarter dbItemJobStreamStarter : lStarters) {
                filterJobStreamStarterJobs.setJobStreamStarter(dbItemJobStreamStarter.getId());
                dbLayerJobStreamsStarterJobs.delete(filterJobStreamStarterJobs);
                filterJobStreamParameters.setJobStreamStarterId(dbItemJobStreamStarter.getId());
                dbLayerJobStreamParameters.delete(filterJobStreamParameters);
            }
            if (withConditionsAndStarters.booleanValue()) {
                DBItemJobStream jobstream;
                FilterJobStreamHistory filterJobStreamHistory = new FilterJobStreamHistory();
                filterJobStreamHistory.setJobStreamId(dbItemJobStream.getId());
                filterJobStreamHistory.setSchedulerId(filter.getSchedulerId());
                dbLayerJobStreamHistory.deleteCascading(filterJobStreamHistory);
                dailyPlanDBLayer.getFilter().setJobStream(filter.getJobStream());
                if (filter.getJobStreamId() != null && (filter.getJobStream() == null || "".equals(filter.getJobStream())) && (jobstream = this.getJobStreamsDbItem(filter.getJobStreamId())) != null) {
                    dailyPlanDBLayer.getFilter().setJobStream(jobstream.getJobStream());
                }
                dailyPlanDBLayer.delete(true);
            }
            if (!withConditionsAndStarters.booleanValue()) continue;
            FilterInConditions filterInConditions = new FilterInConditions();
            filterInConditions.setJobStream(dbItemJobStream.getJobStream());
            filterInConditions.setJobSchedulerId(filter.getSchedulerId());
            filterInConditions.setFolder(filter.getFolder());
            dbLayerInConditions.deleteCascading(filterInConditions);
            FilterOutConditions filterOutConditions = new FilterOutConditions();
            filterOutConditions.setJobStream(dbItemJobStream.getJobStream());
            filterOutConditions.setJobSchedulerId(filter.getSchedulerId());
            filterOutConditions.setFolder(filter.getFolder());
            dbLayerOutConditions.deleteCascading(filterOutConditions);
            dbLayerJobStreamStarters.delete(filterJobStreamStarters);
        }
        hql = "delete from " + DBItemJobStream + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filter, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public Long store(DBItemJobStream dbItemJobStream) throws SOSHibernateException {
        Long newId;
        Long oldId;
        DBLayerJobStreamHistory dbLayerJobStreamHistory = new DBLayerJobStreamHistory(this.sosHibernateSession);
        FilterJobStreams filter = new FilterJobStreams();
        filter.setFolder(dbItemJobStream.getFolder());
        filter.setJobStream(dbItemJobStream.getJobStream());
        filter.setSchedulerId(dbItemJobStream.getSchedulerId());
        List<DBItemJobStream> listOfJobStreams = this.getJobStreamsList(filter, 1);
        this.deleteCascading(filter, false);
        this.sosHibernateSession.save((Object)dbItemJobStream);
        if (listOfJobStreams.size() > 0 && (oldId = listOfJobStreams.get(0).getId()) != (newId = dbItemJobStream.getId())) {
            dbLayerJobStreamHistory.updateHistoryWithJobStream(oldId, newId);
        }
        return dbItemJobStream.getId();
    }

    public Long deleteInsert(JobStream jobStream, String timezone) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DBLayerJobStreamStarters dbLayerJobStreamStarters = new DBLayerJobStreamStarters(this.sosHibernateSession);
        DBLayerJobStreamsStarterJobs dbLayerJobStreamsStarterJobs = new DBLayerJobStreamsStarterJobs(this.sosHibernateSession);
        DBLayerJobStreamParameters dbLayerJobStreamParameters = new DBLayerJobStreamParameters(this.sosHibernateSession);
        Calendar2DB calendar2Db = new Calendar2DB(this.sosHibernateSession, jobStream.getJobschedulerId());
        DBItemJobStream dbItemJobStream = new DBItemJobStream();
        dbItemJobStream.setCreated(new Date());
        dbItemJobStream.setJobStream(jobStream.getJobStream());
        dbItemJobStream.setSchedulerId(jobStream.getJobschedulerId());
        dbItemJobStream.setFolder(jobStream.getFolder());
        dbItemJobStream.setState(jobStream.getState());
        Long newId = this.store(dbItemJobStream);
        LOGGER.debug("Store Jobstream with new id:" + newId);
        jobStream.setJobStreamId(newId);
        for (JobStreamStarter jobstreamStarter : jobStream.getJobstreamStarters()) {
            Long oldId = jobstreamStarter.getJobStreamStarterId();
            boolean isNew = false;
            DBItemJobStreamStarter dbItemJobStreamStarter = dbLayerJobStreamStarters.getJobStreamStartersDbItem(oldId);
            if (dbItemJobStreamStarter == null) {
                LOGGER.debug("new Jobstream starter found");
                isNew = true;
                dbItemJobStreamStarter = new DBItemJobStreamStarter();
                dbItemJobStreamStarter.setCreated(new Date());
            }
            dbItemJobStreamStarter.setJobStream(newId);
            dbItemJobStreamStarter.setEndOfJobStream(jobstreamStarter.getEndOfJobStream());
            dbItemJobStreamStarter.setRequiredJob(jobstreamStarter.getRequiredJob());
            dbItemJobStreamStarter.setStarterName(jobstreamStarter.getStarterName());
            dbItemJobStreamStarter.setTitle(jobstreamStarter.getTitle());
            dbItemJobStreamStarter.setState(jobstreamStarter.getState());
            if (jobstreamStarter.getRunTime() != null) {
                dbItemJobStreamStarter.setRunTime(objectMapper.writeValueAsString((Object)jobstreamStarter.getRunTime()));
            }
            dbItemJobStreamStarter.setNextStart(dbLayerJobStreamStarters.getNextStartTime(objectMapper, timezone, dbItemJobStreamStarter.getRunTime()));
            if (isNew) {
                LOGGER.debug("save jobstream starter with jobstream id: " + dbItemJobStreamStarter.getJobStream());
                dbLayerJobStreamStarters.save(dbItemJobStreamStarter);
            } else {
                LOGGER.debug("update jobstream starter with jobstream id: " + dbItemJobStreamStarter.getJobStream());
                dbLayerJobStreamStarters.update(dbItemJobStreamStarter);
            }
            jobstreamStarter.setJobStreamStarterId(dbItemJobStreamStarter.getId());
            for (JobStreamJob jobStreamJob : jobstreamStarter.getJobs()) {
                DBItemJobStreamStarterJob dbItemJobStreamStarterJob = new DBItemJobStreamStarterJob();
                dbItemJobStreamStarterJob.setCreated(new Date());
                dbItemJobStreamStarterJob.setDelay(jobStreamJob.getStartDelay());
                dbItemJobStreamStarterJob.setJob(jobStreamJob.getJob());
                dbItemJobStreamStarterJob.setJobStreamStarter(dbItemJobStreamStarter.getId());
                if (jobStreamJob.getSkipOutCondition() == null) {
                    dbItemJobStreamStarterJob.setSkipOutCondition(false);
                } else {
                    dbItemJobStreamStarterJob.setSkipOutCondition(jobStreamJob.getSkipOutCondition());
                }
                Long newJobId = dbLayerJobStreamsStarterJobs.store(dbItemJobStreamStarterJob);
                jobStreamJob.setJobId(newJobId);
            }
            for (NameValuePair param : jobstreamStarter.getParams()) {
                if (param.getName() == null || param.getName().isEmpty()) continue;
                DBItemJobStreamParameter dbItemParameter = new DBItemJobStreamParameter();
                dbItemParameter.setCreated(new Date());
                dbItemParameter.setJobStreamStarter(dbItemJobStreamStarter.getId());
                dbItemParameter.setName(param.getName());
                dbItemParameter.setValue(param.getValue());
                dbLayerJobStreamParameters.save(dbItemParameter);
            }
            if (!isNew) {
                DailyPlanDBLayer dailyPlanDBLayer = new DailyPlanDBLayer(this.sosHibernateSession);
                dailyPlanDBLayer.getFilter().setJobStreamStarterId(oldId);
                dailyPlanDBLayer.delete(false);
            }
            FilterJobStreams filterJobStreams = new FilterJobStreams();
            filterJobStreams.setJobStreamId(jobStream.getJobStreamId());
            calendar2Db.processJobStreamStarterFilter(filterJobStreams, timezone);
        }
        return newId;
    }
}

