/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.db.DBItemOutCondition;
import com.sos.jitl.jobstreams.db.DBItemOutConditionEvent;
import com.sos.jitl.jobstreams.db.FilterOutConditionEvents;
import com.sos.joc.model.jobstreams.OutCondition;
import com.sos.joc.model.jobstreams.OutConditionEvent;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerOutConditionEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerOutConditionEvents.class);
    private static final String DBItemOutConditionEvent = DBItemOutConditionEvent.class.getSimpleName();
    private static final String DBItemOutCondition = DBItemOutCondition.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerOutConditionEvents(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemOutConditionEvent getOutConditionEventdDbItem(Long id) throws Exception {
        return (DBItemOutConditionEvent)this.sosHibernateSession.get(DBItemOutConditionEvent.class, (Serializable)id);
    }

    public FilterOutConditionEvents resetFilter() {
        FilterOutConditionEvents filter = new FilterOutConditionEvents();
        filter.setEvent("");
        return filter;
    }

    private String getWhere(FilterOutConditionEvents filter) {
        String where = "";
        String and = "";
        if (filter.getEvent() != null && !"".equals(filter.getEvent())) {
            where = where + and + " event = :event";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " jobStream = :jobstream";
            and = " and ";
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            where = where + and + " folder = :folder";
            and = " and ";
        }
        if (filter.getCommand() != null && !"".equals(filter.getCommand())) {
            where = where + and + " command = :command";
            and = " and ";
        }
        if (filter.getOutConditionId() != null) {
            where = where + and + " outConditionId = :outConditionId";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = " where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterOutConditionEvents filter, Query<T> query) {
        if (filter.getCommand() != null && !"".equals(filter.getCommand())) {
            query.setParameter("command", (Object)filter.getCommand());
        }
        if (filter.getEvent() != null && !"".equals(filter.getEvent())) {
            query.setParameter("event", (Object)filter.getEvent());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobstream", (Object)filter.getJobStream());
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            query.setParameter("folder", (Object)filter.getFolder());
        }
        if (filter.getOutConditionId() != null) {
            query.setParameter("outConditionId", (Object)filter.getOutConditionId());
        }
        if (filter.getJob() != null) {
            query.setParameter("job", (Object)filter.getJob());
        }
        return query;
    }

    public int delete(FilterOutConditionEvents filterConditionEvents) throws SOSHibernateException {
        String hql = "delete from " + DBItemOutConditionEvent + " i " + this.getWhere(filterConditionEvents);
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filterConditionEvents, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public void deleteInsert(DBItemOutCondition dbItemOutCondition, OutCondition outCondition) throws SOSHibernateException {
        FilterOutConditionEvents filterOutConditionEvents = new FilterOutConditionEvents();
        filterOutConditionEvents.setOutConditionId(outCondition.getId());
        if (outCondition.getId() != null) {
            this.delete(filterOutConditionEvents);
        }
        for (OutConditionEvent outConditionEvent : outCondition.getOutconditionEvents()) {
            DBItemOutConditionEvent dbItemOutConditionEvent = new DBItemOutConditionEvent();
            dbItemOutConditionEvent.setOutConditionId(dbItemOutCondition.getId());
            dbItemOutConditionEvent.setEvent(outConditionEvent.getEvent());
            dbItemOutConditionEvent.setCommand(outConditionEvent.getCommand());
            if (outConditionEvent.getGlobalEvent() == null) {
                outConditionEvent.setGlobalEvent(Boolean.valueOf(false));
            }
            dbItemOutConditionEvent.setGlobalEvent(outConditionEvent.getGlobalEvent());
            dbItemOutConditionEvent.setCreated(new Date());
            this.sosHibernateSession.save((Object)dbItemOutConditionEvent);
        }
    }

    public int deleteByJobstream(FilterOutConditionEvents filterOutConditionEvents) throws SOSHibernateException {
        FilterOutConditionEvents filter = new FilterOutConditionEvents();
        filter.setJobStream(filterOutConditionEvents.getJobStream());
        filter.setFolder(filterOutConditionEvents.getFolder());
        String select = "select id from " + DBItemOutCondition + this.getWhere(filter);
        String hql = "delete from " + DBItemOutConditionEvent + " where outConditionId in ( " + select + ")";
        Query query = this.sosHibernateSession.createQuery(hql);
        this.bindParameters(filter, query);
        int row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }
}

