/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.classes.JSEventKey;
import com.sos.jitl.jobstreams.db.DBItemOutCondition;
import com.sos.jitl.jobstreams.db.DBItemOutConditionEvent;
import com.sos.jitl.jobstreams.db.DBItemOutConditionWithConfiguredEvent;
import com.sos.jitl.jobstreams.db.DBLayerEvents;
import com.sos.jitl.jobstreams.db.DBLayerOutConditionEvents;
import com.sos.jitl.jobstreams.db.FilterEvents;
import com.sos.jitl.jobstreams.db.FilterOutConditionEvents;
import com.sos.jitl.jobstreams.db.FilterOutConditions;
import com.sos.joc.model.jobstreams.JobOutCondition;
import com.sos.joc.model.jobstreams.OutCondition;
import com.sos.joc.model.jobstreams.OutConditions;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerOutConditions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerOutConditions.class);
    private static final String DBItemOutCondition = DBItemOutCondition.class.getSimpleName();
    private static final String DBItemOutConditionEvent = DBItemOutConditionEvent.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerOutConditions(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemOutCondition getOutConditionsDbItem(Long id) throws Exception {
        return (DBItemOutCondition)this.sosHibernateSession.get(DBItemOutCondition.class, (Serializable)id);
    }

    public FilterOutConditions resetFilter() {
        FilterOutConditions filter = new FilterOutConditions();
        filter.setJobSchedulerId("");
        filter.setJob("");
        filter.setJobStream("");
        return filter;
    }

    public String getEventListSql(Set<JSEventKey> list) {
        StringBuilder sql = new StringBuilder();
        for (JSEventKey s : list) {
            if (s.getJobStream().isEmpty()) {
                sql.append("e.globalEvent = " + s.getGlobalEvent() + " and e.event = '" + s.getEvent() + "'").append(" or ");
                continue;
            }
            sql.append("(e.globalEvent = " + s.getGlobalEvent() + " and e.event = '" + s.getEvent() + "'").append(" and ").append("o.jobStream = '" + s.getJobStream() + "')").append(" or ");
        }
        String s = sql.toString();
        s = s.substring(0, s.length() - 4);
        return " (" + s + ") ";
    }

    private String getWhere(FilterOutConditions filter) {
        String where = "";
        String and = "";
        if (filter.getJobSchedulerId() != null && !"".equals(filter.getJobSchedulerId())) {
            where = where + and + " o.schedulerId = :schedulerId";
            and = " and ";
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            where = where + and + " o.job = :job";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " o.jobStream = :jobStream";
            and = " and ";
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            where = where + and + " o.folder = :folder";
            and = " and ";
        }
        if (filter.getListOfEvents() != null && filter.getListOfEvents().size() > 0) {
            where = where + and + this.getEventListSql(filter.getListOfEvents());
        }
        if (filter.getJoin() != null && !"".equals(filter.getJoin())) {
            where = where + and + filter.getJoin();
            and = " and ";
        }
        if (!"".equals(where)) {
            where = "where  " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterOutConditions filter, Query<T> query) {
        if (filter.getJobSchedulerId() != null && !"".equals(filter.getJobSchedulerId())) {
            query.setParameter("schedulerId", (Object)filter.getJobSchedulerId());
        }
        if (filter.getJob() != null && !"".equals(filter.getJob())) {
            query.setParameter("job", (Object)filter.getJob());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobStream", (Object)filter.getJobStream());
        }
        if (filter.getFolder() != null && !"".equals(filter.getFolder())) {
            query.setParameter("folder", (Object)filter.getFolder());
        }
        return query;
    }

    public List<DBItemOutConditionWithConfiguredEvent> getOutConditionsList(FilterOutConditions filter, int limit) throws SOSHibernateException {
        filter.setJoin("o.id=e.outConditionId");
        String q = "select o.id as outId, o.schedulerId as jobSchedulerId, o.job as job, o.expression as expression, o.jobStream as jobStream, o.folder as folder, o.created as created, e.id as oEventId, e.outConditionId as outConditionId, e.event as event, e.command as command, e.globalEvent as globalEvent from " + DBItemOutCondition + " o, " + DBItemOutConditionEvent + " e " + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        query.setResultTransformer(Transformers.aliasToBean(DBItemOutConditionWithConfiguredEvent.class));
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<DBItemOutCondition> getSimpleOutConditionsList(FilterOutConditions filter, int limit) throws SOSHibernateException {
        String q = " from " + DBItemOutCondition + " o " + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public int delete(FilterOutConditions filterOutConditions) throws SOSHibernateException {
        String hql = "delete from " + DBItemOutCondition + " o " + this.getWhere(filterOutConditions);
        int row = 0;
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filterOutConditions, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public String deleteInsert(OutConditions outConditions) throws SOSHibernateException {
        String jobStream = "";
        DBLayerOutConditions dbLayerOutConditions = new DBLayerOutConditions(this.sosHibernateSession);
        DBLayerOutConditionEvents dbLayerOutConditionEvents = new DBLayerOutConditionEvents(this.sosHibernateSession);
        DBLayerEvents dbLayerEvents = new DBLayerEvents(this.sosHibernateSession);
        for (JobOutCondition jobOutCondition : outConditions.getJobsOutconditions()) {
            if ("".equals(jobOutCondition.getJob())) continue;
            String folder = Paths.get(jobOutCondition.getJob(), new String[0]).getParent().toString().replace('\\', '/');
            FilterOutConditions filterOutConditions = new FilterOutConditions();
            filterOutConditions.setJob(jobOutCondition.getJob());
            filterOutConditions.setJobSchedulerId(outConditions.getJobschedulerId());
            List<DBItemOutCondition> listOfOutConditions = dbLayerOutConditions.getSimpleOutConditionsList(filterOutConditions, 0);
            this.delete(filterOutConditions);
            for (OutCondition outCondition : jobOutCondition.getOutconditions()) {
                Long oldId = outCondition.getId();
                DBItemOutCondition dbItemOutCondition = new DBItemOutCondition();
                String expression = outCondition.getConditionExpression().getExpression();
                if (expression == null || expression.isEmpty()) {
                    expression = "false";
                }
                dbItemOutCondition.setExpression(expression);
                dbItemOutCondition.setJob(jobOutCondition.getJob());
                dbItemOutCondition.setSchedulerId(outConditions.getJobschedulerId());
                jobStream = outCondition.getJobStream();
                dbItemOutCondition.setJobStream(outCondition.getJobStream());
                dbItemOutCondition.setFolder(folder);
                dbItemOutCondition.setCreated(new Date());
                this.sosHibernateSession.save((Object)dbItemOutCondition);
                dbLayerOutConditionEvents.deleteInsert(dbItemOutCondition, outCondition);
                Long newId = dbItemOutCondition.getId();
                if (oldId == null) continue;
                dbLayerEvents.updateEvents(oldId, newId);
            }
            for (DBItemOutCondition dbItemOutCondition : listOfOutConditions) {
                FilterOutConditionEvents filterOutConditionEvents = new FilterOutConditionEvents();
                filterOutConditionEvents.setOutConditionId(dbItemOutCondition.getId());
                dbLayerOutConditionEvents.delete(filterOutConditionEvents);
                FilterEvents filterEvents = new FilterEvents();
                filterEvents.setOutConditionId(dbItemOutCondition.getId());
                dbLayerEvents.delete(filterEvents);
            }
        }
        return jobStream;
    }

    public void deleteCascading(FilterOutConditions filterOutConditions) throws SOSHibernateException {
        DBLayerOutConditionEvents dbLayerOutConditionEvents = new DBLayerOutConditionEvents(this.sosHibernateSession);
        FilterOutConditionEvents filterOutConditionEvents = new FilterOutConditionEvents();
        filterOutConditionEvents.setJobStream(filterOutConditions.getJobStream());
        filterOutConditionEvents.setFolder(filterOutConditions.getFolder());
        dbLayerOutConditionEvents.deleteByJobstream(filterOutConditionEvents);
        this.delete(filterOutConditions);
    }
}

