/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.managed.job;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.managed.job.ManagedDatabaseJobOptions;
import com.sos.jitl.managed.model.ManagedDatabaseModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Variable_set;

public class ManagedDatabaseJob
extends JSJobUtilitiesClass<ManagedDatabaseJobOptions> {
    private static Logger LOGGER = LoggerFactory.getLogger(ManagedDatabaseJob.class);
    ManagedDatabaseModel model;

    public ManagedDatabaseJob() {
        super((Object)new ManagedDatabaseJobOptions());
    }

    public void execute(boolean isOrder, Variable_set orderParams) throws Exception {
        String methodName = ManagedDatabaseJob.class.getSimpleName() + "::execute";
        SOSHibernateFactory factory = null;
        SOSHibernateSession session = null;
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            factory = new SOSHibernateFactory(this.getOptions().hibernate_configuration_file.getValue());
            factory.setIdentifier("managed");
            factory.build();
            session = factory.openStatelessSession();
            this.model = new ManagedDatabaseModel(session, this.getOptions(), isOrder, orderParams);
            this.model.process();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s: %s", methodName, e.toString()), (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (factory != null) {
                factory.close();
            }
        }
    }

    public ManagedDatabaseJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new ManagedDatabaseJobOptions();
        }
        return (ManagedDatabaseJobOptions)((Object)this.objOptions);
    }

    public ManagedDatabaseModel getModel() {
        return this.model;
    }
}

