/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.messaging;

import com.sos.JSHelper.Basics.IJSCommands;
import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.messaging.MessageConsumerJob;
import com.sos.jitl.messaging.options.MessageConsumerOptions;
import sos.scheduler.job.JobSchedulerJobAdapter;

public class MessageConsumerJobJSAdapter
extends JobSchedulerJobAdapter {
    private String targetJobChains;
    private String delimiter;

    public boolean spooler_process() throws Exception {
        MessageConsumerJob job = new MessageConsumerJob();
        try {
            super.spooler_process();
            MessageConsumerOptions options = job.getOptions();
            options.setAllOptions(this.getSchedulerParameterAsProperties(this.getSpoolerProcess().getOrder()));
            this.targetJobChains = options.getTargetJobChainName().getValue();
            this.delimiter = options.getParamKeyValueDelimiter().getValue();
            job.setJSJobUtilites((JSJobUtilities)this);
            job.setJSCommands((IJSCommands)this);
            job.execute();
            if (options.getExecuteXml().value()) {
                this.executeXmlForAllTargets(job.getMessageXml());
            }
            return this.getSpoolerProcess().isOrderJob();
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error occured in spooler_process of MessageConsumerJob: ", (Throwable)e);
        }
    }

    private void executeXml(String message) {
        this.spooler_log.debug9("execute XML started");
        String answer = this.spooler.execute_xml(message);
        this.spooler_log.debug9("Return value of executeXML: " + answer);
        this.spooler_log.debug9("order send");
    }

    private void executeXmlForAllTargets(String message) {
        if (this.targetJobChains.contains(this.delimiter) && message.contains("add_order")) {
            String[] jobChainNames;
            for (String name : jobChainNames = this.targetJobChains.split("[" + this.delimiter + "]")) {
                this.spooler_log.debug9("add_order XML will be adjusted for JobChain: " + name);
                this.executeXml(message.replaceFirst("job_chain='[^']*'", "job_chain='" + name + "'"));
            }
        } else {
            this.executeXml(message);
        }
    }
}

