/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.helper.elements.timer;

import com.sos.jitl.notification.helper.EEndTimeType;
import com.sos.jitl.notification.helper.EStartTimeType;
import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.elements.timer.ElementTimerJob;
import com.sos.jitl.notification.helper.elements.timer.ElementTimerJobChain;
import com.sos.jitl.notification.helper.elements.timer.ElementTimerScript;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementTimer {
    private Node xml;
    private String name;
    private ArrayList<ElementTimerJobChain> jobChains;
    private ArrayList<ElementTimerJob> jobs;
    private ElementTimerScript minimum;
    private ElementTimerScript maximum;
    private TimerResult result;

    public ElementTimer(Node node) throws Exception {
        this.xml = node;
        Element el = (Element)this.xml;
        this.name = NotificationXmlHelper.getTimerName(el);
        this.jobChains = new ArrayList();
        NodeList nlJobChains = NotificationXmlHelper.selectTimerJobChains(this.xml);
        for (int i = 0; i < nlJobChains.getLength(); ++i) {
            this.jobChains.add(new ElementTimerJobChain(this, nlJobChains.item(i)));
        }
        this.jobs = new ArrayList();
        NodeList nlJobs = NotificationXmlHelper.selectTimerJobs(this.xml);
        for (int i = 0; i < nlJobs.getLength(); ++i) {
            this.jobs.add(new ElementTimerJob(this, nlJobs.item(i)));
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        this.maximum = NotificationXmlHelper.getTimerMaximum(xPath, this.xml, this.name);
        this.minimum = NotificationXmlHelper.getTimerMinimum(xPath, this.xml, this.name);
    }

    public Node getXml() {
        return this.xml;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<ElementTimerJobChain> getJobChains() {
        return this.jobChains;
    }

    public ArrayList<ElementTimerJob> getJobs() {
        return this.jobs;
    }

    public ElementTimerScript getMinimum() {
        return this.minimum;
    }

    public ElementTimerScript getMaximum() {
        return this.maximum;
    }

    public TimerResult getTimerResult() {
        return this.result;
    }

    public void createTimerResult() {
        this.result = new TimerResult();
    }

    public void resetTimerResult() {
        this.result = null;
    }

    public class TimerResult {
        private Double minimum = null;
        private Double maximum = null;
        private StringBuffer resultIds = null;
        private boolean readDbResults = false;
        private String lastErrorMessage = null;
        Date startTime = null;
        Date endTime = null;
        EStartTimeType startTimeType = null;
        EEndTimeType endTimeType = null;

        public Double getMinimum() {
            return this.minimum;
        }

        public void setMinimum(Double val) {
            this.minimum = val;
        }

        public Double getMaximum() {
            return this.maximum;
        }

        public void setMaximum(Double val) {
            this.maximum = val;
        }

        public StringBuffer getResultIds() {
            return this.resultIds;
        }

        public void setResultIds(StringBuffer val) {
            this.resultIds = val;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date val) {
            this.startTime = val;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date val) {
            this.endTime = val;
        }

        public EStartTimeType getStartTimeType() {
            return this.startTimeType;
        }

        public void setStartTimeType(EStartTimeType val) {
            this.startTimeType = val;
        }

        public EEndTimeType getEndTimeType() {
            return this.endTimeType;
        }

        public void setEndTimeType(EEndTimeType val) {
            this.endTimeType = val;
        }

        public Long getTimeDifferenceInSeconds() {
            if (this.startTime == null || this.endTime == null) {
                return new Long(-1L);
            }
            return this.endTime.getTime() / 1000L - this.startTime.getTime() / 1000L;
        }

        public boolean getReadDbResults() {
            return this.readDbResults;
        }

        public void setReadDbResults(boolean val) {
            this.readDbResults = val;
        }

        public String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        public void setLastErrorMessage(String val) {
            this.lastErrorMessage = val;
        }
    }
}

