/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.model.history;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.db.DBLayerSchedulerMon;
import com.sos.jitl.notification.helper.NotificationReportExecution;
import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.counters.CounterCheckHistory;
import com.sos.jitl.notification.helper.elements.timer.ElementTimer;
import com.sos.jitl.notification.helper.elements.timer.ElementTimerJob;
import com.sos.jitl.notification.helper.elements.timer.ElementTimerJobChain;
import com.sos.jitl.notification.jobs.history.CheckHistoryJobOptions;
import com.sos.jitl.notification.model.INotificationModel;
import com.sos.jitl.notification.model.NotificationModel;
import com.sos.jitl.notification.plugins.history.CheckHistoryTimerPlugin;
import com.sos.jitl.notification.plugins.history.ICheckHistoryPlugin;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public class CheckHistoryModel
extends NotificationModel
implements INotificationModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckHistoryModel.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final boolean isTraceEnabled = LOGGER.isTraceEnabled();
    private CheckHistoryJobOptions options;
    private LinkedHashMap<String, ElementTimer> timers = null;
    private LinkedHashMap<String, ArrayList<String>> jobChains = null;
    private LinkedHashMap<String, ArrayList<String>> jobs = null;
    private boolean checkInsertJobChainNotifications = true;
    private boolean checkInsertJobNotifications = true;
    private List<ICheckHistoryPlugin> plugins = null;
    private boolean executeChecks = false;
    private CounterCheckHistory counter;

    public CheckHistoryModel(SOSHibernateSession session, CheckHistoryJobOptions opt) throws Exception {
        super(session);
        this.options = opt;
    }

    public void init() throws Exception {
        this.initConfig();
        this.registerPlugins();
        this.pluginsOnInit(this.timers, this.options, this.getDbLayer());
    }

    private void initCounters() {
        this.counter = new CounterCheckHistory();
    }

    public void initConfig() throws Exception {
        this.plugins = new ArrayList<ICheckHistoryPlugin>();
        this.timers = new LinkedHashMap();
        this.jobChains = new LinkedHashMap();
        this.jobs = new LinkedHashMap();
        this.readConfigFiles();
    }

    private void readConfigFiles() throws Exception {
        String method = "readConfigFiles";
        this.jobChains = new LinkedHashMap();
        this.jobs = new LinkedHashMap();
        this.timers = new LinkedHashMap();
        this.checkInsertJobChainNotifications = true;
        this.checkInsertJobNotifications = true;
        List<File> files = this.getAllConfigFiles(Paths.get(this.options.configuration_dir.getValue(), new String[0]));
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]found %s file(s)", method, files.size()));
        }
        int counter = 0;
        for (int i = 0; i < files.size(); ++i) {
            this.setConfigFromFile(++counter, files.get(i));
        }
        if (this.jobChains.isEmpty() && this.jobs.isEmpty() && this.timers.isEmpty()) {
            this.executeChecks = false;
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][skip]Job, JobChain, TimerRef elements are not defined", method));
            }
        } else {
            this.executeChecks = true;
        }
    }

    private void setConfigFromFile(int counter, File f) throws Exception {
        String method = "setConfigFromFile";
        String cp = f.getCanonicalPath();
        LOGGER.info(String.format("[%s][%s]%s", method, counter, cp));
        SOSXMLXPath xpath = null;
        try {
            xpath = new SOSXMLXPath(cp);
        }
        catch (Exception e) {
            throw new Exception(String.format("[%s][%s][SOSXMLXPath][%s]%s", method, counter, CheckHistoryModel.normalizePath(f), e.toString()), e);
        }
        this.setConfigAllJobChains(xpath);
        this.setConfigAllJobs(xpath);
        this.setConfigTimers(xpath);
    }

    private void setConfigTimers(SOSXMLXPath xpath) throws Exception {
        NodeList nlTimers = NotificationXmlHelper.selectTimerDefinitions(xpath);
        for (int j = 0; j < nlTimers.getLength(); ++j) {
            Node n = nlTimers.item(j);
            String name = NotificationXmlHelper.getTimerName((Element)n);
            if (name == null || this.timers.containsKey(name)) continue;
            this.timers.put(name, new ElementTimer(n));
        }
    }

    private void setConfigAllJobs(SOSXMLXPath xpath) throws Exception {
        if (!this.checkInsertJobNotifications) {
            return;
        }
        NodeList notificationJobs = NotificationXmlHelper.selectNotificationJobDefinitions(xpath);
        this.setConfigJobs(xpath, notificationJobs);
        if (this.checkInsertJobNotifications) {
            NodeList timerJobs = NotificationXmlHelper.selectTimerJobDefinitions(xpath);
            this.setConfigJobs(xpath, timerJobs);
        }
    }

    private void setConfigJobs(SOSXMLXPath xpath, NodeList nlJobs) throws Exception {
        for (int j = 0; j < nlJobs.getLength(); ++j) {
            Element job = (Element)nlJobs.item(j);
            String schedulerId = NotificationXmlHelper.getSchedulerId(job);
            String name = NotificationXmlHelper.getJobName(job);
            schedulerId = SOSString.isEmpty((String)schedulerId) ? "*" : schedulerId;
            name = SOSString.isEmpty((String)name) ? "*" : name;
            ArrayList<String> al = new ArrayList<String>();
            if (schedulerId.equals("*") && name.equals("*")) {
                this.jobs = new LinkedHashMap();
                al.add(name);
                this.jobs.put(schedulerId, al);
                this.checkInsertJobNotifications = false;
                return;
            }
            if (this.jobs.containsKey(schedulerId)) {
                al = this.jobs.get(schedulerId);
            }
            if (!al.contains(name)) {
                al.add(name);
            }
            this.jobs.put(schedulerId, al);
        }
    }

    private void setConfigAllJobChains(SOSXMLXPath xpath) throws Exception {
        NodeList notificationJobChains = NotificationXmlHelper.selectNotificationJobChainDefinitions(xpath);
        this.setConfigJobChains(xpath, notificationJobChains);
        if (this.checkInsertJobChainNotifications) {
            NodeList timerJobChains = NotificationXmlHelper.selectTimerJobChainDefinitions(xpath);
            this.setConfigJobChains(xpath, timerJobChains);
        }
    }

    private void setConfigJobChains(SOSXMLXPath xpath, NodeList nlJobChains) throws Exception {
        for (int j = 0; j < nlJobChains.getLength(); ++j) {
            Element jobChain = (Element)nlJobChains.item(j);
            String schedulerId = NotificationXmlHelper.getSchedulerId(jobChain);
            String name = NotificationXmlHelper.getJobChainName(jobChain);
            schedulerId = SOSString.isEmpty((String)schedulerId) ? "*" : schedulerId;
            name = SOSString.isEmpty((String)name) ? "*" : name;
            ArrayList<String> al = new ArrayList<String>();
            if (schedulerId.equals("*") && name.equals("*")) {
                this.jobChains = new LinkedHashMap();
                al.add(name);
                this.jobChains.put(schedulerId, al);
                this.checkInsertJobChainNotifications = false;
                return;
            }
            if (this.jobChains.containsKey(schedulerId)) {
                al = this.jobChains.get(schedulerId);
            }
            if (!al.contains(name)) {
                al.add(name);
            }
            this.jobChains.put(schedulerId, al);
        }
    }

    private boolean checkDoInsert(CounterCheckHistory counter, NotificationReportExecution execution, boolean checkJobChains, boolean checkJobs) throws Exception {
        int i;
        String schedulerId;
        Set<Map.Entry<String, ArrayList<String>>> set;
        String method = "[" + counter.getTotal() + "][checkDoInsert]";
        if ((this.jobs == null || this.jobs.isEmpty()) && (this.jobChains == null || this.jobChains.isEmpty())) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]missing jobs and job chain definitions", method));
            }
            return false;
        }
        if (checkJobChains) {
            if (!this.checkInsertJobChainNotifications) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[skip]checkInsertJobChainNotifications=false", method));
                }
                return true;
            }
            set = this.jobChains.entrySet();
            for (Map.Entry<String, ArrayList<String>> jc : set) {
                schedulerId = jc.getKey();
                ArrayList<String> jobChainsFromSet = jc.getValue();
                boolean doCheckJobChains = true;
                if (!schedulerId.equals("*")) {
                    try {
                        if (!execution.getSchedulerId().matches(schedulerId)) {
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("%s[jobChains][checkJobChains=%s][schedulerId not match][%s][%s]", method, checkJobChains, execution.getSchedulerId(), schedulerId));
                            }
                            doCheckJobChains = false;
                        }
                    }
                    catch (Exception ex) {
                        throw new Exception(String.format("%s[jobChains][check with configured scheduler_id=%s]%s", method, schedulerId, ex));
                    }
                }
                if (!doCheckJobChains) continue;
                for (i = 0; i < jobChainsFromSet.size(); ++i) {
                    String jobChainName = jobChainsFromSet.get(i);
                    if (jobChainName.equals("*")) {
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s[jobChains][match][%s][%s][%s][%s]", method, execution.getSchedulerId(), schedulerId, execution.getJobChainName(), jobChainName));
                        }
                        return true;
                    }
                    try {
                        jobChainName = CheckHistoryModel.normalizeRegex(jobChainName);
                        if (execution.getJobChainName().matches(jobChainName)) {
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("%s[jobChains][match][%s][%s][%s][%s]", method, execution.getSchedulerId(), schedulerId, execution.getJobChainName(), jobChainName));
                            }
                            return true;
                        }
                        if (!isDebugEnabled) continue;
                        LOGGER.debug(String.format("%s[jobChains][not match][%s][%s]", method, execution.getJobChainName(), jobChainName));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new Exception(String.format("%s[jobChains][check with configured scheduler_id=%s, name=%s]%s", method, schedulerId, jobChainName, ex));
                    }
                }
            }
        }
        if (checkJobs) {
            if (!this.checkInsertJobNotifications) {
                LOGGER.debug(String.format("%s[skip]checkInsertJobNotifications=false", method, counter.getTotal()));
                return true;
            }
            set = this.jobs.entrySet();
            for (Map.Entry<String, ArrayList<String>> jc : set) {
                schedulerId = jc.getKey();
                ArrayList<String> jobsFromSet = jc.getValue();
                boolean doCheckJobs = true;
                if (!schedulerId.equals("*")) {
                    try {
                        if (!execution.getSchedulerId().matches(schedulerId)) {
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("%s[jobs][checkJobs=%s][schedulerId not match][%s][%s]", method, checkJobs, execution.getSchedulerId(), schedulerId));
                            }
                            doCheckJobs = false;
                        }
                    }
                    catch (Exception ex) {
                        throw new Exception(String.format("%s[jobs][check with configured scheduler_id=%s]%s", method, schedulerId, ex));
                    }
                }
                if (!doCheckJobs) continue;
                for (i = 0; i < jobsFromSet.size(); ++i) {
                    String job = jobsFromSet.get(i);
                    if (job.equals("*")) {
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s[jobs][match][%s][%s][%s][%s]", method, execution.getSchedulerId(), schedulerId, execution.getJobName(), job));
                        }
                        return true;
                    }
                    try {
                        job = CheckHistoryModel.normalizeRegex(job);
                        if (execution.getJobName().matches(job)) {
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("%s[jobs][match][%s][%s][%s][%s]", method, execution.getSchedulerId(), schedulerId, execution.getJobName(), job));
                            }
                            return true;
                        }
                        if (!isDebugEnabled) continue;
                        LOGGER.debug(String.format("%s[jobs][not match][%s][%s]", method, execution.getJobName(), job));
                        continue;
                    }
                    catch (Exception ex) {
                        throw new Exception(String.format("%s[jobs][check with configured scheduler_id=%s, name=%s]%s", method, schedulerId, job, ex));
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void process() throws Exception {
    }

    public void process(NotificationReportExecution item, boolean checkJobChains, boolean checkJobs) throws Exception {
        String method = "process";
        if (!this.executeChecks) {
            return;
        }
        this.initCounters();
        boolean success = true;
        if (!this.checkDoInsert(this.counter, item, checkJobChains, checkJobs)) {
            this.counter.addSkip();
            return;
        }
        List<DBItemSchedulerMonChecks> checks = null;
        try {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s]%s", method, this.counter.getTotal(), item.getStandalone() ? "standalone" : "order", NotificationModel.toString(item)));
            }
            List<DBItemSchedulerMonNotifications> dbItems = this.getDbLayer().getNotificationsWithDummyStep(item.getSchedulerId(), item.getStandalone(), item.getTaskId(), item.getStep(), item.getOrderHistoryId());
            DBItemSchedulerMonNotifications dbItem = null;
            boolean hasStepError = item.getError();
            if (dbItems == null || dbItems.size() == 0) {
                dbItem = this.getDbLayer().createNotification(item.getSchedulerId(), item.getStandalone(), item.getTaskId(), item.getStep(), item.getOrderHistoryId(), item.getJobChainName(), item.getJobChainTitle(), item.getOrderId(), item.getOrderTitle(), item.getOrderStartTime(), item.getOrderEndTime(), item.getOrderStepState(), item.getOrderStepStartTime(), item.getOrderStepEndTime(), item.getJobName(), item.getJobTitle(), item.getTaskStartTime(), item.getTaskEndTime(), false, new Long(item.getReturnCode() == null ? 0L : item.getReturnCode()), item.getAgentUrl(), item.getClusterMemberId(), item.getCriticality(), hasStepError, item.getErrorCode(), item.getErrorText());
                this.getDbLayer().getSession().save((Object)dbItem);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][insert]%s", method, this.counter.getTotal(), NotificationModel.toString(dbItem)));
                }
                this.counter.addInsert();
            } else {
                if (dbItems.size() == 2) {
                    DBItemSchedulerMonNotifications toDeleteDbItem = null;
                    for (int i = 0; i < dbItems.size(); ++i) {
                        DBItemSchedulerMonNotifications tmpDbItem = dbItems.get(i);
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][%s][update][before][%s]%s", method, this.counter.getTotal(), i, NotificationModel.toString(tmpDbItem)));
                        }
                        if (tmpDbItem.getStep().equals(DBLayer.NOTIFICATION_DUMMY_MAX_STEP)) {
                            toDeleteDbItem = tmpDbItem;
                            continue;
                        }
                        if (!tmpDbItem.getStep().equals(item.getStep())) continue;
                        dbItem = tmpDbItem;
                    }
                    if (dbItem == null) {
                        dbItem = this.getDbLayer().getNotification(item.getSchedulerId(), item.getStandalone(), item.getTaskId(), item.getStep(), item.getOrderHistoryId());
                    }
                    if (toDeleteDbItem != null) {
                        if (dbItem != null) {
                            try {
                                this.getDbLayer().updateNotificationResults(dbItem.getId(), toDeleteDbItem.getId());
                            }
                            catch (Exception e) {
                                LOGGER.warn(String.format("[%s][%s][update results]%s", method, this.counter.getTotal(), e.toString()), (Throwable)e);
                            }
                        }
                        this.getDbLayer().removeNotification(toDeleteDbItem);
                    }
                } else {
                    dbItem = dbItems.get(0);
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][update][before]%s", method, this.counter.getTotal(), NotificationModel.toString(dbItem)));
                    }
                }
                if (dbItem == null) {
                    LOGGER.warn(String.format("[%s][%s][update][not found notification]%s", method, this.counter.getTotal(), NotificationModel.toString(item)));
                    return;
                }
                dbItem.setJobChainName(item.getJobChainName());
                dbItem.setJobChainTitle(item.getJobChainTitle());
                dbItem.setOrderId(item.getOrderId());
                dbItem.setOrderTitle(item.getOrderTitle());
                dbItem.setOrderStartTime(item.getOrderStartTime());
                dbItem.setOrderEndTime(item.getOrderEndTime());
                dbItem.setStep(item.getStep());
                dbItem.setOrderStepState(item.getOrderStepState());
                dbItem.setOrderStepStartTime(item.getOrderStepStartTime());
                dbItem.setOrderStepEndTime(item.getOrderStepEndTime());
                dbItem.setJobName(item.getJobName());
                dbItem.setJobTitle(item.getJobTitle());
                dbItem.setTaskStartTime(item.getTaskStartTime());
                dbItem.setTaskEndTime(item.getTaskEndTime());
                dbItem.setReturnCode(new Long(item.getReturnCode() == null ? 0L : item.getReturnCode()));
                dbItem.setAgentUrl(item.getAgentUrl());
                dbItem.setClusterMemberId(item.getClusterMemberId());
                dbItem.setJobCriticality(item.getCriticality());
                dbItem.setRecovered(dbItem.getError() && !hasStepError);
                dbItem.setError(hasStepError);
                dbItem.setErrorCode(item.getErrorCode());
                dbItem.setErrorText(item.getErrorText());
                dbItem.setModified(DBLayer.getCurrentDateTime());
                this.getDbLayer().getSession().update((Object)dbItem);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][update][after]%s", method, this.counter.getTotal(), NotificationModel.toString(dbItem)));
                }
                this.counter.addUpdate();
            }
            if (dbItem != null && dbItem.getOrderEndTime() != null && dbItem.getOrderHistoryId() > 0L) {
                int hits = this.getDbLayer().setNotificationsOrderEndTime(dbItem.getSchedulerId(), dbItem.getOrderHistoryId(), dbItem.getOrderEndTime());
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][update][after][setOrderEndTime][schedulerId=%s][orderHistoryId=%s][orderEndTime=%s]%s updated", method, this.counter.getTotal(), dbItem.getSchedulerId(), dbItem.getOrderHistoryId(), dbItem.getOrderEndTime(), hits));
                }
            }
            checks = this.createTimers(dbItem);
        }
        catch (Exception ex) {
            success = false;
            throw new Exception(String.format("[%s]%s", method, ex.toString()), ex);
        }
        if (success) {
            this.pluginsOnProcess(this.timers, checks, this.options, this.getDbLayer(), null, null);
        }
    }

    private void createJobTimers(List<DBItemSchedulerMonChecks> checks, DBItemSchedulerMonNotifications dbItem, String timerName, ArrayList<ElementTimerJob> timerJobs) throws Exception {
        String method = "  [" + this.counter.getTotal() + "][createJobTimers]";
        for (int i = 0; i < timerJobs.size(); ++i) {
            ElementTimerJob job = timerJobs.get(i);
            String schedulerId = job.getSchedulerId();
            String jobName = job.getName();
            boolean insert = true;
            if (!schedulerId.equals("*") && !dbItem.getSchedulerId().matches(schedulerId)) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s][schedulerId not match][%s][%s]", method, timerName, dbItem.getSchedulerId(), schedulerId));
                }
                insert = false;
            }
            jobName = CheckHistoryModel.normalizeRegex(jobName);
            if (insert && !jobName.equals("*") && !dbItem.getJobName().matches(jobName)) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s][jobName not match][%s][%s]", method, timerName, dbItem.getJobName(), jobName));
                }
                insert = false;
            }
            if (!insert) continue;
            this.counter.addInsertTimer();
            DBItemSchedulerMonChecks item = null;
            item = dbItem.getStandalone() ? this.createCheck(timerName, dbItem, "*", "*", dbItem.getTaskStartTime(), dbItem.getTaskEndTime(), DBLayer.NOTIFICATION_OBJECT_TYPE_JOB) : this.createCheck(timerName, dbItem, "*", "*", dbItem.getOrderStepStartTime(), dbItem.getOrderStepEndTime(), DBLayer.NOTIFICATION_OBJECT_TYPE_JOB);
            checks.add(item);
            LOGGER.debug(String.format("%s[%s][createCheck]%s", method, timerName, NotificationModel.toString(item)));
        }
    }

    public DBItemSchedulerMonChecks createCheck(String name, DBItemSchedulerMonNotifications notification, String stepFrom, String stepTo, Date stepFromStartTime, Date stepToEndTime, Long objectType) throws SOSHibernateException {
        Long notificationId = notification.getId();
        DBItemSchedulerMonChecks item = null;
        if (notificationId == null || notificationId.equals(new Long(0L))) {
            item = new DBItemSchedulerMonChecks();
            item.setName(name);
            notificationId = new Long(0L);
            item.setResultIds(notification.getSchedulerId() + ";" + (notification.getStandalone() ? "true" : "false") + ";" + notification.getTaskId() + ";" + notification.getStep() + ";" + notification.getOrderHistoryId());
            item.setNotificationId(notificationId);
            item.setStepFrom(stepFrom);
            item.setStepTo(stepTo);
            item.setStepFromStartTime(stepFromStartTime);
            item.setStepToEndTime(stepToEndTime);
            item.setChecked(false);
            item.setObjectType(objectType);
            item.setCreated(DBLayer.getCurrentDateTime());
            item.setModified(DBLayer.getCurrentDateTime());
        } else {
            item = new DBItemSchedulerMonChecks();
            item.setName(name);
            item.setNotificationId(notificationId);
            item.setStepFrom(stepFrom);
            item.setStepTo(stepTo);
            item.setStepFromStartTime(stepFromStartTime);
            item.setStepToEndTime(stepToEndTime);
            item.setChecked(false);
            item.setObjectType(objectType);
            item.setCreated(DBLayer.getCurrentDateTime());
            item.setModified(DBLayer.getCurrentDateTime());
        }
        return item;
    }

    private void createJobChainTimers(List<DBItemSchedulerMonChecks> checks, DBItemSchedulerMonNotifications dbItem, String timerName, ArrayList<ElementTimerJobChain> timerJobChains) throws Exception {
        String method = "  [" + this.counter.getTotal() + "][createJobChainTimers]";
        for (int i = 0; i < timerJobChains.size(); ++i) {
            ElementTimerJobChain jobChain = timerJobChains.get(i);
            String schedulerId = jobChain.getSchedulerId();
            String jobChainName = jobChain.getName();
            boolean insert = true;
            if (!schedulerId.equals("*") && !dbItem.getSchedulerId().matches(schedulerId)) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s][schedulerId not match][%s][%s]", method, timerName, dbItem.getSchedulerId(), schedulerId));
                }
                insert = false;
            }
            jobChainName = CheckHistoryModel.normalizeRegex(jobChainName);
            if (insert && !jobChainName.equals("*") && !dbItem.getJobChainName().matches(jobChainName)) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s][jobChainName not match][%s][%s]", method, timerName, dbItem.getJobChainName(), jobChainName));
                }
                insert = false;
            }
            if (!insert) continue;
            this.counter.addInsertTimer();
            DBItemSchedulerMonChecks item = this.createCheck(timerName, dbItem, jobChain.getStepFrom(), jobChain.getStepTo(), dbItem.getOrderStartTime(), dbItem.getOrderEndTime(), DBLayer.NOTIFICATION_OBJECT_TYPE_JOB_CHAIN);
            checks.add(item);
            LOGGER.debug(String.format("%s[%s][createCheck]%s", method, timerName, NotificationModel.toString(item)));
        }
    }

    private List<DBItemSchedulerMonChecks> createTimers(DBItemSchedulerMonNotifications dbItem) throws Exception {
        String method = "  [" + this.counter.getTotal() + "][createTimers]";
        if (this.timers == null || this.timers.isEmpty()) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]timers is null or empty", method));
            }
            return null;
        }
        ArrayList<DBItemSchedulerMonChecks> checks = new ArrayList<DBItemSchedulerMonChecks>();
        Set<Map.Entry<String, ElementTimer>> set = this.timers.entrySet();
        for (Map.Entry<String, ElementTimer> me : set) {
            String timerName = me.getKey();
            ElementTimer timer = me.getValue();
            ArrayList<ElementTimerJob> timerJobs = timer.getJobs();
            ArrayList<ElementTimerJobChain> timerJobChains = timer.getJobChains();
            if (timerJobs.isEmpty() && timerJobChains.isEmpty()) {
                LOGGER.warn(String.format("%s[timer=%s]not found configured JobChains or Jobs", method, timerName));
                continue;
            }
            if (!timerJobs.isEmpty()) {
                this.createJobTimers(checks, dbItem, timerName, timerJobs);
            }
            if (dbItem.getStandalone() || timerJobChains.isEmpty()) continue;
            this.createJobChainTimers(checks, dbItem, timerName, timerJobChains);
        }
        return checks;
    }

    private void pluginsOnInit(LinkedHashMap<String, ElementTimer> timers, CheckHistoryJobOptions options, DBLayerSchedulerMon dbLayer) {
        for (ICheckHistoryPlugin plugin : this.plugins) {
            try {
                plugin.onInit(timers, options, dbLayer);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[pluginsOnInit]%s", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void pluginsOnExit(LinkedHashMap<String, ElementTimer> timers, CheckHistoryJobOptions options, DBLayerSchedulerMon dbLayer) {
        for (ICheckHistoryPlugin plugin : this.plugins) {
            try {
                plugin.onExit(timers, options, dbLayer);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[pluginsOnExit]%s", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void pluginsOnProcess(LinkedHashMap<String, ElementTimer> timers, List<DBItemSchedulerMonChecks> checks, CheckHistoryJobOptions options, DBLayerSchedulerMon dbLayer, Date dateFrom, Date dateTo) {
        for (ICheckHistoryPlugin plugin : this.plugins) {
            try {
                plugin.onProcess(timers, checks, options, dbLayer, dateFrom, dateTo);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[pluginsOnProcess]%s", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private void registerPlugins() throws Exception {
        String method = "registerPlugins";
        this.plugins = new ArrayList<ICheckHistoryPlugin>();
        this.options.plugins.setValue(CheckHistoryTimerPlugin.class.getName());
        String[] arr = this.options.plugins.getValue().trim().split(";");
        for (int i = 0; i < arr.length; ++i) {
            try {
                Class<?> c = Class.forName(arr[i].trim());
                this.addPlugin((ICheckHistoryPlugin)c.newInstance());
                if (!isTraceEnabled) continue;
                LOGGER.trace(String.format("[%s][registered]%s", method, arr[i]));
                continue;
            }
            catch (Exception ex) {
                LOGGER.error(String.format("[%s][cannot be registered][%s]%s", method, arr[i], ex.getMessage()), (Throwable)ex);
            }
        }
        if (isTraceEnabled) {
            LOGGER.trace(String.format("[%s]registered=%s", method, this.plugins.size()));
        }
    }

    public static String normalizePath(String val) {
        if (val != null && val.startsWith("/")) {
            val = val.substring(1);
        }
        return val;
    }

    public static String normalizeRegex(String val) {
        if (val != null) {
            if (val.startsWith("/")) {
                val = val.substring(1);
            } else if (val.startsWith("^/")) {
                val = val.substring(0, 1) + val.substring(2);
            } else if (val.startsWith("^(/")) {
                val = val.substring(0, 2) + val.substring(3);
            }
        }
        return val;
    }

    public void addPlugin(ICheckHistoryPlugin handler) {
        this.plugins.add(handler);
    }

    public void resetPlugins() {
        this.plugins = new ArrayList<ICheckHistoryPlugin>();
    }

    public boolean executeChecks() {
        return this.executeChecks;
    }
}

