/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.plugins.notifier;

import com.sos.JSHelper.Options.JSMailOptions;
import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.NotificationMail;
import com.sos.jitl.notification.helper.elements.monitor.mail.ElementNotificationMail;
import com.sos.jitl.notification.plugins.notifier.SystemNotifierCustomPlugin;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.settings.SOSProfileSettings;
import sos.util.SOSString;

public class SystemNotifierSendMailPlugin
extends SystemNotifierCustomPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemNotifierSendMailPlugin.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private ElementNotificationMail config = null;
    private SOSMail mail = null;
    private boolean queueMailOnError = false;

    @Override
    public void onInit() throws Exception {
        this.config = (ElementNotificationMail)this.getNotificationMonitor().getMonitorInterface();
        if (this.config == null) {
            throw new Exception(String.format("[init]%s element is missing (not configured)", "NotificationMail"));
        }
        JSMailOptions mailOptions = this.getSchedulerMailOptions();
        this.mail = NotificationMail.createMail(mailOptions, this.queueMailOnError);
        this.setMailHeaders(this.config, mailOptions);
    }

    @Override
    public void onNotifySystem(DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix) throws Exception {
        String url = "";
        try {
            url = (String)this.getOptions().scheduler_mail_settings.value().getSettings().get("joc.url");
        }
        catch (Exception e) {
            LOGGER.warn(String.format("[%s]exception on get link url: %s", systemNotification.getServiceName(), e.toString()), (Throwable)e);
        }
        String jocHrefJobChain = this.getJocHref4JobChain(url, notification);
        String jocHrefOrder = this.getJocHref4Order(url, notification);
        String jocHrefJob = this.getJocHref4Job(url, notification);
        this.mail.setSubject(this.resolveVars(this.config.getSubject(), systemNotification, notification, check, status, prefix, jocHrefJobChain, jocHrefOrder, jocHrefJob));
        this.mail.setBody(this.resolveVars(this.config.getBody(), systemNotification, notification, check, status, prefix, jocHrefJobChain, jocHrefOrder, jocHrefJob));
        if (!this.mail.send() && !this.queueMailOnError) {
            throw new Exception(String.format("[%s]can't send mail", systemNotification.getServiceName()));
        }
    }

    @Override
    public void onClose() {
    }

    private void setMailHeaders(ElementNotificationMail config, JSMailOptions mailOptions) throws Exception {
        if (!SOSString.isEmpty((String)config.getContentType())) {
            this.mail.setContentType(config.getContentType());
        }
        if (!SOSString.isEmpty((String)config.getCharset())) {
            this.mail.setCharset(config.getCharset());
        }
        if (!SOSString.isEmpty((String)config.getEncoding())) {
            this.mail.setEncoding(config.getEncoding());
        }
        if (!SOSString.isEmpty((String)config.getPriority())) {
            this.setMailPriority(config);
        }
        if (!SOSString.isEmpty((String)config.getFrom())) {
            this.mail.setFrom(config.getFrom());
        }
        if (!SOSString.isEmpty((String)config.getTo())) {
            this.setMailRecipients(config);
        } else if (!SOSString.isEmpty((String)config.getCC())) {
            this.setMailCCBCC(config, mailOptions);
        } else if (!SOSString.isEmpty((String)config.getBCC())) {
            this.setMailBCC(config, mailOptions);
        }
    }

    private void setMailPriority(ElementNotificationMail config) throws MessagingException {
        switch (config.getPriority().toUpperCase()) {
            case "HIGHEST": {
                this.mail.setPriorityHighest();
                break;
            }
            case "HIGH": {
                this.mail.setPriorityHigh();
                break;
            }
            case "LOW": {
                this.mail.setPriorityLow();
                break;
            }
            case "LOWEST": {
                this.mail.setPriorityLowest();
            }
        }
    }

    private void setMailRecipients(ElementNotificationMail config) throws Exception {
        this.mail.clearRecipients();
        this.mail.addRecipient(config.getTo());
        if (!SOSString.isEmpty((String)config.getCC())) {
            this.mail.addCC(config.getCC());
        }
        if (!SOSString.isEmpty((String)config.getBCC())) {
            this.mail.addBCC(config.getBCC());
        }
    }

    private void setMailCCBCC(ElementNotificationMail config, JSMailOptions mailOptions) throws Exception {
        this.mail.clearRecipients();
        if (mailOptions.getSettings().containsKey("mail.to")) {
            this.mail.addRecipient((String)mailOptions.getSettings().get("mail.to"));
        }
        this.mail.addCC(config.getCC());
        if (!SOSString.isEmpty((String)config.getBCC())) {
            this.mail.addBCC(config.getBCC());
        }
    }

    private void setMailBCC(ElementNotificationMail config, JSMailOptions mailOptions) throws Exception {
        this.mail.clearRecipients();
        if (mailOptions.getSettings().containsKey("mail.to")) {
            this.mail.addRecipient((String)mailOptions.getSettings().get("mail.to"));
        }
        if (mailOptions.getSettings().containsKey("mail.cc")) {
            this.mail.addCC((String)mailOptions.getSettings().get("mail.cc"));
        }
        this.mail.addBCC(config.getBCC());
    }

    private JSMailOptions getSchedulerMailOptions() throws Exception {
        JSMailOptions mailOptions = this.getOptions().scheduler_mail_settings.value();
        if (!mailOptions.getSettings().containsKey("mail.smtp.port")) {
            SOSProfileSettings settings;
            Properties smtp;
            String host = (String)mailOptions.getSettings().get("mail_smtp_host");
            if (SOSString.isEmpty((String)host) || host.toLowerCase().equals("-queue")) {
                throw new Exception(String.format("smtp host not configured to send mails. settings=%s", mailOptions.getSettings()));
            }
            String ini = (String)mailOptions.getSettings().get("scheduler_ini_path");
            if (SOSString.isEmpty((String)ini)) {
                throw new Exception(String.format("scheduler factory.ini file not founded. settings=%s", mailOptions.getSettings()));
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("read %s", ini));
            }
            if ((smtp = (settings = new SOSProfileSettings(ini)).getSection("smtp")) != null) {
                mailOptions.loadProperties(smtp);
            }
            mailOptions.getSettings().put("joc.url", this.getJocUrl(ini));
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("mailOptions.settings=%s", mailOptions.getSettings()));
        }
        return mailOptions;
    }

    private String getJocUrl(String factoryIni) {
        String jocUrl = "";
        Path privateConf = Paths.get(factoryIni, new String[0]).getParent().resolve("private").resolve("private.conf");
        try {
            if (privateConf.toFile().exists()) {
                Optional<String> entry = Files.lines(privateConf).map(s -> s.trim()).filter(s -> s.startsWith("joc.url")).map(s -> s.split("=")).map(arr -> arr[((String[])arr).length - 1].trim().replaceAll("\"", "")).findFirst();
                if (entry.isPresent()) {
                    jocUrl = entry.get();
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s]%s=%s", privateConf, "joc.url", jocUrl));
                    }
                } else if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s]not found %s entry", privateConf, "joc.url"));
                }
            } else if (isDebugEnabled) {
                LOGGER.debug(String.format("not found configuration file %s", privateConf));
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("[%s]exception on read configuration file: %s", privateConf, e.toString()), (Throwable)e);
        }
        return jocUrl;
    }

    private String getJocHref4JobChain(String url, DBItemSchedulerMonNotifications notification) {
        String href = "";
        if (!SOSString.isEmpty((String)url)) {
            href = url + "/joc/#!/job_chain?path=" + this.normalizeNameForLink(notification.getJobChainName()) + "&scheduler_id=" + notification.getSchedulerId();
        }
        return href;
    }

    private String getJocHref4Order(String url, DBItemSchedulerMonNotifications notification) {
        String href = "";
        if (!SOSString.isEmpty((String)url)) {
            href = url + "/joc/#!/order?path=" + this.normalizeNameForLink(notification.getJobChainName()) + "," + notification.getOrderId() + "&scheduler_id=" + notification.getSchedulerId();
        }
        return href;
    }

    private String getJocHref4Job(String url, DBItemSchedulerMonNotifications notification) {
        String href = "";
        if (!SOSString.isEmpty((String)url)) {
            href = url + "/joc/#!/job?path=" + this.normalizeNameForLink(notification.getJobName()) + "&scheduler_id=" + notification.getSchedulerId();
        }
        return href;
    }

    private String normalizeNameForLink(String name) {
        if (name == null) {
            return "/";
        }
        return name.startsWith("/") ? name : "/" + name;
    }

    private String resolveVars(String txt, DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix, String jocHrefJobChain, String jocHrefOrder, String jocHrefJob) throws Exception {
        if (SOSString.isEmpty((String)txt)) {
            return "";
        }
        txt = this.resolveAllVars(systemNotification, notification, check, status, prefix, txt);
        txt = this.resolveJocLinkJobChain(txt, jocHrefJobChain);
        txt = this.resolveJocLinkOrder(txt, jocHrefOrder);
        txt = this.resolveJocLinkJob(txt, jocHrefJob);
        return txt.trim();
    }
}

