/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.plugins.notifier;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.builders.MessagePayloadBuilder;
import com.googlecode.jsendnsca.builders.NagiosSettingsBuilder;
import com.googlecode.jsendnsca.encryption.Encryption;
import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.db.DBLayerSchedulerMon;
import com.sos.jitl.notification.exceptions.SOSSystemNotifierSendException;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationInterface;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.plugins.notifier.SystemNotifierPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;
import sos.util.SOSString;

public class SystemNotifierSendNscaPlugin
extends SystemNotifierPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemNotifierSendNscaPlugin.class);
    private ElementNotificationInterface config = null;
    private NagiosSettings settings = null;

    @Override
    public void init(ElementNotificationMonitor monitor, SystemNotifierJobOptions opt) throws Exception {
        super.init(monitor, opt);
        this.config = (ElementNotificationInterface)this.getNotificationMonitor().getMonitorInterface();
        if (this.config == null) {
            throw new Exception(String.format("[init]%s element is missing (not configured)", "NotificationInterface"));
        }
        NagiosSettingsBuilder nb = new NagiosSettingsBuilder().withNagiosHost(this.config.getMonitorHost());
        if (this.config.getMonitorPort() > -1) {
            nb.withPort(this.config.getMonitorPort());
        }
        if (this.config.getMonitorConnectionTimeout() > -1) {
            nb.withConnectionTimeout(this.config.getMonitorConnectionTimeout());
        }
        if (this.config.getMonitorResponseTimeout() > -1) {
            nb.withResponseTimeout(this.config.getMonitorResponseTimeout());
        }
        if (this.config.getMonitorPort() > -1) {
            nb.withPort(this.config.getMonitorPort());
        }
        if (!SOSString.isEmpty((String)this.config.getMonitorEncryption())) {
            nb.withEncryption(Encryption.valueOf((String)this.config.getMonitorEncryption()));
        }
        if (!SOSString.isEmpty((String)this.config.getMonitorPassword())) {
            nb.withPassword(this.config.getMonitorPassword());
        }
        this.settings = nb.create();
    }

    private Level resolveServiceStatus(String status) {
        Level l = null;
        if (status != null) {
            if (status.equals("0")) {
                l = Level.OK;
            } else if (status.equals("1")) {
                l = Level.WARNING;
            } else if (status.equals("2")) {
                l = Level.CRITICAL;
            } else if (status.equals("3")) {
                l = Level.UNKNOWN;
            }
        }
        return l;
    }

    @Override
    public int notifySystem(Spooler spooler, SystemNotifierJobOptions options, DBLayerSchedulerMon dbLayer, DBItemSchedulerMonNotifications notification, DBItemSchedulerMonSystemNotifications systemNotification, DBItemSchedulerMonChecks check, EServiceStatus status, EServiceMessagePrefix prefix) throws SOSSystemNotifierSendException {
        String method = "notifySystem";
        try {
            this.setCommand(this.config.getCommand());
            String serviceStatus = this.getServiceStatusValue(status);
            String servicePrefix = prefix == null ? "" : prefix.name();
            this.setTableFields(notification, systemNotification, check);
            this.resolveCommandAllTableFieldVars();
            this.resolveCommandServiceNameVar(systemNotification.getServiceName());
            this.resolveCommandServiceStatusVar(serviceStatus);
            this.resolveCommandServiceMessagePrefixVar(servicePrefix);
            this.resolveCommandAllEnvVars();
            this.setCommandPrefix(prefix);
            MessagePayload payload = new MessagePayloadBuilder().withHostname(this.config.getServiceHost()).withLevel(this.getLevel(status)).withServiceName(systemNotification.getServiceName()).withMessage(this.getCommand()).create();
            LOGGER.info(String.format("[send][monitor host=%s:%s][service host=%s][level=%s]%s", this.settings.getNagiosHost(), this.settings.getPort(), payload.getHostname(), payload.getLevel(), payload.getMessage()));
            NagiosPassiveCheckSender sender = new NagiosPassiveCheckSender(this.settings);
            sender.send(payload);
            return 0;
        }
        catch (Throwable e) {
            throw new SOSSystemNotifierSendException(String.format("[%s]%s", method, e.toString()), e);
        }
    }

    @Override
    public int notifySystemReset(String serviceName, EServiceStatus status, EServiceMessagePrefix prefix, String message) throws Exception {
        Level level = status.equals((Object)EServiceStatus.OK) ? Level.OK : Level.CRITICAL;
        MessagePayload payload = new MessagePayloadBuilder().withHostname(this.config.getServiceHost()).withLevel(level).withServiceName(serviceName).withMessage(message).create();
        LOGGER.info(String.format("[send][monitor host=%s:%s][service host=%s][service name=%s][level=%s]%s", this.settings.getNagiosHost(), this.settings.getPort(), payload.getHostname(), payload.getServiceName(), payload.getLevel(), payload.getMessage()));
        NagiosPassiveCheckSender sender = new NagiosPassiveCheckSender(this.settings);
        sender.send(payload);
        return 0;
    }

    private Level getLevel(EServiceStatus status) {
        Level level = null;
        if (status.equals((Object)EServiceStatus.OK)) {
            level = this.resolveServiceStatus(this.getNotificationMonitor().getServiceStatusOnSuccess());
            if (level == null) {
                level = Level.OK;
            }
        } else {
            level = this.resolveServiceStatus(this.getNotificationMonitor().getServiceStatusOnError());
            if (level == null) {
                level = Level.CRITICAL;
            }
        }
        return level;
    }

    private void setCommandPrefix(EServiceMessagePrefix prefix) {
        String prefixName;
        String command;
        if (this.getCommand() == null) {
            return;
        }
        if (prefix == null) {
            return;
        }
        if (!prefix.equals((Object)EServiceMessagePrefix.SUCCESS) && !(command = this.getCommand().trim().toLowerCase()).startsWith(prefixName = prefix.name().trim().toLowerCase())) {
            this.setCommand(prefix.name() + " " + this.getCommand());
        }
    }
}

