/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.operations.criticalpath.model;

import com.sos.jitl.operations.criticalpath.job.UncriticalJobNodesJobOptions;
import com.sos.jitl.operations.criticalpath.model.EJobChainState;
import com.sos.jitl.operations.criticalpath.model.EUncriticalJobNodesOperation;
import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.spooler.Spooler;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public class UncriticalJobNodesModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UncriticalJobNodesModel.class);
    private UncriticalJobNodesJobOptions options;
    private EUncriticalJobNodesOperation operation;
    private String criticalPathNegativeProcessingPrefix = "-";
    private String criticalPathPositiveProcessingPrefix = "+";
    private String criticalPathProcessingMode = "-";
    private String[] includePrefixedJobChains;
    private String[] excludePrefixedJobChains;
    private int numberOfModifiedJobs = 0;
    private Spooler spooler;
    private SOSSchedulerCommand schedulerCommand;

    public UncriticalJobNodesModel(UncriticalJobNodesJobOptions opt) throws Exception {
        this.options = opt;
        String o = this.options.operation.getValue().trim();
        if (o.equalsIgnoreCase(EUncriticalJobNodesOperation.SKIP.name())) {
            this.operation = EUncriticalJobNodesOperation.SKIP;
        } else if (o.equalsIgnoreCase(EUncriticalJobNodesOperation.UNSKIP.name())) {
            this.operation = EUncriticalJobNodesOperation.UNSKIP;
        } else {
            throw new Exception(String.format("unsupported operation = %s (supported operations %s)", o, Arrays.toString((Object[])EUncriticalJobNodesOperation.values()).toLowerCase()));
        }
    }

    public void process() throws Exception {
        String method = "process";
        try {
            this.initSender();
            LOGGER.info(String.format("%s: operation = %s (scheduler %s:%s)", method, this.operation.name().toLowerCase(), this.options.target_scheduler_host.getValue(), this.options.target_scheduler_port.value()));
            this.initProperties();
            if (this.operation.equals((Object)EUncriticalJobNodesOperation.SKIP)) {
                this.execute(true);
            } else if (this.operation.equals((Object)EUncriticalJobNodesOperation.UNSKIP)) {
                this.execute(false);
            }
            LOGGER.info(String.format("%s: numberOfModifiedJobs = %s ", method, this.numberOfModifiedJobs));
        }
        catch (Exception ex) {
            throw new Exception(String.format("%s: %s", method, ex.toString()));
        }
    }

    private void initProperties() throws Exception {
        String method = "initProperties";
        try {
            LOGGER.info(String.format("%s: using parameter \"processing_recursive\" = %s", method, this.options.processing_recursive.getValue()));
            if (!SOSString.isEmpty((String)this.options.processing_prefix.getValue())) {
                LOGGER.info(String.format("%s: using parameter \"processing_prefix\" = %s", method, this.options.processing_prefix.getValue()));
                if (this.options.processing_prefix.getValue().startsWith(this.criticalPathNegativeProcessingPrefix)) {
                    this.criticalPathNegativeProcessingPrefix = this.options.processing_prefix.getValue();
                    this.criticalPathProcessingMode = this.criticalPathNegativeProcessingPrefix.substring(0, 1);
                } else if (this.options.processing_prefix.getValue().startsWith(this.criticalPathPositiveProcessingPrefix)) {
                    this.criticalPathPositiveProcessingPrefix = this.options.processing_prefix.getValue();
                    this.criticalPathProcessingMode = this.criticalPathPositiveProcessingPrefix.substring(0, 1);
                } else {
                    throw new Exception(String.format("%s: illegal value of parameter \"processing_prefix\" = %s", method, this.options.processing_prefix.getValue()));
                }
            }
            if (!SOSString.isEmpty((String)this.options.include_job_chains.getValue())) {
                LOGGER.info(String.format("%s: using parameter \"include_job_chains\" = %s", method, this.options.include_job_chains.getValue()));
                this.includePrefixedJobChains = this.options.include_job_chains.getValue().split(";");
            }
            if (!SOSString.isEmpty((String)this.options.exclude_job_chains.getValue())) {
                LOGGER.info(String.format("%s: using parameter \"exclude_job_chains\" = %s", method, this.options.exclude_job_chains.getValue()));
                this.excludePrefixedJobChains = this.options.exclude_job_chains.getValue().split(";");
            }
            LOGGER.info(String.format("%s: criticalPathProcessingMode = %s", method, this.criticalPathProcessingMode));
        }
        catch (Exception ex) {
            throw new Exception(String.format("%s: %s", method, ex.toString()));
        }
    }

    private SOSXMLXPath executeXml(String command) throws Exception {
        String method = "executeXml";
        LOGGER.debug(String.format("%s: command = %s", method, command));
        String response = null;
        if (this.schedulerCommand != null) {
            this.schedulerCommand.sendRequest(command);
            response = this.schedulerCommand.getResponse();
        } else if (this.spooler != null) {
            response = this.spooler.execute_xml(command);
        } else {
            throw new Exception(String.format("%s: schedulerCommand and spooler are NULL", method));
        }
        LOGGER.debug(String.format("%s: response = %s", method, response));
        SOSXMLXPath xpath = new SOSXMLXPath(new StringBuffer(response));
        if (xpath.getRoot() == null) {
            throw new Exception(String.format("xpath root missing", new Object[0]));
        }
        Element error = (Element)xpath.selectSingleNode("/" + xpath.getRoot().getNodeName() + "/answer/ERROR");
        if (error != null) {
            String errorCode = error.getAttribute("code");
            String errorText = error.getAttribute("text");
            throw new Exception(String.format("scheduler answer[%s]: %s", errorCode, errorText));
        }
        return xpath;
    }

    private void execute(boolean skip) throws Exception {
        String method = "execute";
        this.numberOfModifiedJobs = 0;
        String logIndent = "    ";
        String command = "<show_state what=\"job_chains\"/>";
        try {
            this.connect();
            SOSXMLXPath xpath = this.executeXml(command);
            NodeList jobChains = xpath.selectNodeList("/" + xpath.getRoot().getNodeName() + "/answer/state/job_chains/job_chain");
            LOGGER.info(String.format("%s: found %s job chains ", method, jobChains.getLength()));
            int countJobChains = 0;
            for (int i = 0; i < jobChains.getLength(); ++i) {
                ++countJobChains;
                Element jobChain = (Element)jobChains.item(i);
                String state = jobChain.getAttribute("state");
                String path = jobChain.getAttribute("path");
                if (!state.equalsIgnoreCase(EJobChainState.RUNNING.name())) {
                    LOGGER.info(String.format("%s: %s) do not process job chain [%s] due to state: %s", method, countJobChains, state, path));
                    continue;
                }
                int numberOfRecursiveFolders = 1;
                boolean doSkipJobChain = false;
                if (this.includePrefixedJobChains != null && this.includePrefixedJobChains.length > 0) {
                    doSkipJobChain = true;
                    for (String prefix : this.includePrefixedJobChains) {
                        LOGGER.debug(String.format("%s: %s) path = %s include = %s", method, countJobChains, path, prefix));
                        if (path.indexOf(prefix) != 0) continue;
                        int prefixLen = prefix.split("/").length;
                        numberOfRecursiveFolders = prefix.startsWith("/") ? prefixLen - 1 : prefixLen;
                        int pathNumberOfRecursiveFolders = path.split("/").length - 1;
                        doSkipJobChain = !this.options.processing_recursive.value() && pathNumberOfRecursiveFolders > numberOfRecursiveFolders;
                        break;
                    }
                    if (doSkipJobChain) {
                        LOGGER.info(String.format("%s: %s) do not process job chain [%s] due to inclusion rule = %s", method, countJobChains, path, this.join(this.includePrefixedJobChains)));
                    }
                } else {
                    int pathNumberOfRecursiveFolders = path.split("/").length - 1;
                    boolean bl = doSkipJobChain = !this.options.processing_recursive.value() && pathNumberOfRecursiveFolders > numberOfRecursiveFolders;
                }
                if (!doSkipJobChain && this.excludePrefixedJobChains != null) {
                    for (String prefix : this.excludePrefixedJobChains) {
                        LOGGER.debug(String.format("%s: %s) path = %s exclude = %s", method, countJobChains, path, prefix));
                        if (path.indexOf(prefix) != 0) continue;
                        LOGGER.info(String.format("%s: %s) do not process job chain [%s] due to exclusion rule = %s", method, countJobChains, path, prefix));
                        doSkipJobChain = true;
                    }
                }
                if (doSkipJobChain) continue;
                LOGGER.info(String.format("%s: %s) processing job chain = %s", method, countJobChains, path));
                NodeList jobChainNodes = xpath.selectNodeList((Node)jobChain, "job_chain_node[@job and string-length(@job)!=0]");
                for (int j = 0; j < jobChainNodes.getLength(); ++j) {
                    Element jobChainNode = (Element)jobChainNodes.item(j);
                    String nodeJob = jobChainNode.getAttribute("job");
                    String nodeState = jobChainNode.getAttribute("state");
                    if (SOSString.isEmpty((String)nodeJob)) continue;
                    if (nodeJob.toLowerCase().startsWith("/scheduler_file_order")) {
                        LOGGER.debug(String.format("%s: %s) %s continue processing, file order element found = %s", method, countJobChains, logIndent, nodeJob));
                        continue;
                    }
                    LOGGER.debug(String.format("%s: %s) %s job node [%s] found with state = %s", method, countJobChains, logIndent, nodeJob, nodeState));
                    boolean doSkip = false;
                    boolean doUnskip = false;
                    String criticalPathProcessingPrefix = nodeState.substring(0, "-".equals(this.criticalPathProcessingMode) ? this.criticalPathNegativeProcessingPrefix.length() : this.criticalPathPositiveProcessingPrefix.length());
                    LOGGER.debug(String.format("%s: %s) %s criticalPathProcessingPrefix=%s criticalPathProcessingMode=%s criticalPathNegativeProcessingPrefix=%s criticalPathPositiveProcessingPrefix=%s", method, countJobChains, logIndent, criticalPathProcessingPrefix, this.criticalPathProcessingMode, this.criticalPathNegativeProcessingPrefix, this.criticalPathPositiveProcessingPrefix));
                    if (skip) {
                        if (this.criticalPathProcessingMode.equals(this.criticalPathNegativeProcessingPrefix.substring(0, 1)) && criticalPathProcessingPrefix.equals(this.criticalPathNegativeProcessingPrefix)) {
                            doSkip = true;
                        }
                        if (this.criticalPathProcessingMode.equals(this.criticalPathPositiveProcessingPrefix.substring(0, 1)) && !criticalPathProcessingPrefix.equals(this.criticalPathPositiveProcessingPrefix)) {
                            doSkip = true;
                        }
                        if (doSkip) {
                            LOGGER.info(String.format("%s: %s) %s skipping job node: job_chain='%s' state='%s'", method, countJobChains, logIndent, path, nodeState));
                            command = String.format("<job_chain_node.modify job_chain='%s' state='%s' action='next_state'/>", path, nodeState);
                            this.executeXml(command);
                            ++this.numberOfModifiedJobs;
                            continue;
                        }
                        LOGGER.debug(String.format("%s: %s) %s do not skipping job node: job_chain='%s' state='%s'", method, countJobChains, logIndent, path, nodeState));
                        continue;
                    }
                    if (this.criticalPathProcessingMode.equals(this.criticalPathNegativeProcessingPrefix) && criticalPathProcessingPrefix.equals(this.criticalPathNegativeProcessingPrefix)) {
                        doUnskip = true;
                    }
                    if (this.criticalPathProcessingMode.equals(this.criticalPathPositiveProcessingPrefix.substring(0, 1)) && !criticalPathProcessingPrefix.equals(this.criticalPathPositiveProcessingPrefix)) {
                        doUnskip = true;
                    }
                    if (this.criticalPathProcessingMode.equals(this.criticalPathPositiveProcessingPrefix.substring(0, 1)) && criticalPathProcessingPrefix.equals(this.criticalPathPositiveProcessingPrefix)) {
                        doUnskip = true;
                    }
                    if (doUnskip) {
                        LOGGER.info(String.format("%s: %s) %s unskipping job node: job_chain='%s' state='%s'", method, countJobChains, logIndent, path, nodeState));
                        command = String.format("<job_chain_node.modify job_chain='%s' state='%s' action='process'/>", path, nodeState);
                        this.executeXml(command);
                        ++this.numberOfModifiedJobs;
                        continue;
                    }
                    LOGGER.debug(String.format("%s: %s) %s do not unskipping job node: job_chain='%s' state='%s'", method, countJobChains, logIndent, path, nodeState));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(String.format("%s:[scheduler %s:%s] %s", method, this.options.target_scheduler_host.getValue(), this.options.target_scheduler_port.value(), ex.toString()));
        }
        finally {
            this.disconnect();
        }
    }

    private void initSender() {
        boolean createSchedulerCommand = true;
        this.schedulerCommand = null;
        if (this.spooler != null) {
            int httpPort;
            if (SOSString.isEmpty((String)this.options.target_scheduler_host.getValue())) {
                this.options.target_scheduler_host.setValue(this.spooler.hostname());
                createSchedulerCommand = false;
            } else if (this.options.target_scheduler_host.getValue().equalsIgnoreCase(this.spooler.hostname())) {
                createSchedulerCommand = false;
            }
            if (SOSString.isEmpty((String)this.options.target_scheduler_port.getValue()) && (httpPort = SOSSchedulerCommand.getHTTPPortFromScheduler((Spooler)this.spooler)) > 0) {
                this.options.target_scheduler_port.value(httpPort);
            }
        }
        if (createSchedulerCommand) {
            this.schedulerCommand = new SOSSchedulerCommand();
        }
    }

    private void connect() throws Exception {
        String method = "connect";
        if (this.schedulerCommand != null) {
            LOGGER.info(String.format("%s: connect to scheduler %s:%s", method, this.options.target_scheduler_host.getValue(), this.options.target_scheduler_port.value()));
            this.schedulerCommand.connect(this.options.target_scheduler_host.getValue(), this.options.target_scheduler_port.value());
            if (this.options.target_scheduler_timeout.value() > 0) {
                this.schedulerCommand.setTimeout(this.options.target_scheduler_timeout.value());
            }
        }
    }

    private void disconnect() {
        String method = "disconnect";
        if (this.schedulerCommand != null) {
            try {
                LOGGER.info(String.format("%s: disconnect from scheduler %s:%s", method, this.options.target_scheduler_host.getValue(), this.options.target_scheduler_port.value()));
                this.schedulerCommand.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String join(String[] arr) {
        return Arrays.toString(arr);
    }

    public void setSpooler(Spooler sp) {
        this.spooler = sp;
    }
}

