/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.reporting.db.DBLayer;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@Table(name="INVENTORY_INSTANCES")
@SequenceGenerator(name="REPORTING_II_ID_SEQ", sequenceName="REPORTING_II_ID_SEQ", allocationSize=1)
public class DBItemInventoryInstance
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String schedulerId;
    private String hostname;
    private Integer port;
    private String liveDirectory;
    private Date created;
    private Date modified;
    private String commandUrl;
    private String url;
    private String clusterType;
    private Integer precedence;
    private String dbmsName;
    private String dbmsVersion;
    private Long supervisorId;
    private Date startedAt;
    private String version;
    private String timeZone;
    private String auth;
    private String origUrl;
    private Long osId;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_II_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_II_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long val) {
        this.id = val;
    }

    @Column(name="[SCHEDULER_ID]", nullable=false)
    public void setSchedulerId(String val) {
        this.schedulerId = val;
    }

    @Column(name="[SCHEDULER_ID]", nullable=false)
    public String getSchedulerId() {
        return this.schedulerId;
    }

    @Column(name="[HOSTNAME]", nullable=false)
    public void setHostname(String val) {
        this.hostname = val;
    }

    @Column(name="[HOSTNAME]", nullable=false)
    public String getHostname() {
        return this.hostname;
    }

    @Column(name="[PORT]", nullable=false)
    public Integer getPort() {
        return this.port;
    }

    @Column(name="[PORT]", nullable=false)
    public void setPort(Integer val) {
        this.port = val;
    }

    @Column(name="[LIVE_DIRECTORY]", nullable=false)
    public void setLiveDirectory(String val) {
        this.liveDirectory = val;
    }

    @Column(name="[LIVE_DIRECTORY]", nullable=false)
    public String getLiveDirectory() {
        return this.liveDirectory;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date val) {
        this.created = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date val) {
        this.modified = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[STARTED_AT]", nullable=false)
    public Date getStartedAt() {
        return this.startedAt;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[STARTED_AT]", nullable=false)
    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    @Column(name="[URL]", nullable=false)
    public String getUrl() {
        return this.url;
    }

    @Column(name="[URL]", nullable=false)
    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name="[COMMAND_URL]", nullable=false)
    public String getCommandUrl() {
        return this.commandUrl;
    }

    @Column(name="[COMMAND_URL]", nullable=false)
    public void setCommandUrl(String commandUrl) {
        this.commandUrl = commandUrl;
    }

    @Column(name="[DBMS_NAME]", nullable=false)
    public String getDbmsName() {
        return this.dbmsName;
    }

    @Column(name="[DBMS_NAME]", nullable=false)
    public void setDbmsName(String dbmsName) {
        this.dbmsName = dbmsName;
    }

    @Column(name="[DBMS_VERSION]", nullable=true)
    public String getDbmsVersion() {
        return this.dbmsVersion;
    }

    @Column(name="[DBMS_VERSION]", nullable=true)
    public void setDbmsVersion(String dbmsVersion) {
        this.dbmsVersion = dbmsVersion;
    }

    @Column(name="[OS_ID]", nullable=false)
    public Long getOsId() {
        return this.osId;
    }

    @Column(name="[OS_ID]", nullable=false)
    public void setOsId(Long osId) {
        if (osId == null) {
            osId = DBLayer.DEFAULT_ID;
        }
        this.osId = osId;
    }

    @Column(name="[VERSION]", nullable=false)
    public String getVersion() {
        return this.version;
    }

    @Column(name="[VERSION]", nullable=false)
    public void setVersion(String version) {
        this.version = version;
    }

    @Column(name="[PRECEDENCE]", nullable=true)
    public Integer getPrecedence() {
        return this.precedence;
    }

    @Column(name="[PRECEDENCE]", nullable=true)
    public void setPrecedence(Integer precedence) {
        this.precedence = precedence;
    }

    @Column(name="[CLUSTER_TYPE]", nullable=false)
    public String getClusterType() {
        return this.clusterType;
    }

    @Column(name="[CLUSTER_TYPE]", nullable=false)
    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    @Column(name="[SUPERVISOR_ID]", nullable=false)
    public Long getSupervisorId() {
        return this.supervisorId;
    }

    @Column(name="[SUPERVISOR_ID]", nullable=false)
    public void setSupervisorId(Long supervisorId) {
        if (supervisorId == null) {
            supervisorId = DBLayer.DEFAULT_ID;
        }
        this.supervisorId = supervisorId;
    }

    @Column(name="[TIMEZONE]", nullable=false)
    public String getTimeZone() {
        return this.timeZone;
    }

    @Column(name="[TIMEZONE]", nullable=false)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Column(name="[AUTH]", nullable=true)
    public String getAuth() {
        return this.auth;
    }

    @Column(name="[AUTH]", nullable=true)
    public void setAuth(String auth) {
        this.auth = auth;
    }

    @Transient
    public String originalUrl() {
        return this.origUrl;
    }

    @Transient
    public void setOriginalUrl(String origUrl) {
        this.origUrl = origUrl;
    }

    @Transient
    public String toDebugString() {
        StringBuilder strb = new StringBuilder();
        strb.append("ID:").append(this.getId()).append("|");
        strb.append("SCHEDULER_ID:").append(this.getSchedulerId()).append("|");
        strb.append("HOSTNAME:").append(this.getHostname()).append("|");
        strb.append("PORT:").append(this.getPort()).append("|");
        strb.append("OS_ID:").append(this.getOsId()).append("|");
        strb.append("LIVE_DIRECTORY:").append(this.getLiveDirectory()).append("|");
        strb.append("VERSION:").append(this.getVersion()).append("|");
        strb.append("COMMAND_URL:").append(this.getCommandUrl()).append("|");
        strb.append("URL:").append(this.getUrl()).append("|");
        strb.append("AUTH:").append("***").append("|");
        strb.append("TIMEZONE:").append(this.getTimeZone()).append("|");
        strb.append("CLUSTER_TYPE:").append(this.getClusterType()).append("|");
        strb.append("PRECEDENCE:").append(this.getPrecedence()).append("|");
        strb.append("DBMS_NAME:").append(this.getDbmsName()).append("|");
        strb.append("DBMS_VERSION:").append(this.getDbmsVersion()).append("|");
        strb.append("STARTED_AT:").append(this.getStartedAt()).append("|");
        strb.append("SUPERVISOR_ID:").append(this.getSupervisorId()).append("|");
        strb.append("CREATED:").append(this.getCreated()).append("|");
        strb.append("MODIFIED:").append(this.getModified());
        return strb.toString();
    }

    @Transient
    public String clusterMemberId() {
        if (this.origUrl != null) {
            return String.format("%s/%s:%s", this.schedulerId, this.hostname, this.origUrl.replaceFirst(".*:(\\d+)$", "$1"));
        }
        return String.format("%s/%s:%s", this.schedulerId, this.hostname, this.url.replaceFirst(".*:(\\d+)$", "$1"));
    }

    @Transient
    public boolean standalone() {
        return "standalone".equals(this.getClusterType());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.schedulerId).append((Object)this.hostname).append((Object)this.port).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemInventoryInstance)) {
            return false;
        }
        DBItemInventoryInstance rhs = (DBItemInventoryInstance)other;
        return new EqualsBuilder().append((Object)this.schedulerId, (Object)rhs.schedulerId).append((Object)this.hostname, (Object)rhs.hostname).append((Object)this.port, (Object)rhs.port).isEquals();
    }
}

