/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.reporting.db.DBLayer;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Type;
import sos.util.SOSString;

@Entity
@Table(name="INVENTORY_ORDERS")
@SequenceGenerator(name="REPORTING_IO_ID_SEQ", sequenceName="REPORTING_IO_ID_SEQ", allocationSize=1)
public class DBItemInventoryOrder
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TITLE_MAX_LENGTH = 255;
    private Long id;
    private Long instanceId;
    private Long fileId;
    private String jobChainName;
    private String name;
    private String baseName;
    private String orderId;
    private String title;
    private boolean isRuntimeDefined;
    private Date created;
    private Date modified;
    private Long jobChainId;
    private String initialState;
    private String endState;
    private Integer priority;
    private String schedule;
    private String scheduleName;
    private Long scheduleId;
    private Boolean runTimeIsTemporary;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IO_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="REPORTING_IO_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long val) {
        this.id = val;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public Long getInstanceId() {
        return this.instanceId;
    }

    @Column(name="[INSTANCE_ID]", nullable=false)
    public void setInstanceId(Long val) {
        if (this.instanceId == null) {
            this.instanceId = DBLayer.DEFAULT_ID;
        }
        this.instanceId = val;
    }

    @Column(name="[FILE_ID]", nullable=false)
    public Long getFileId() {
        return this.fileId;
    }

    @Column(name="[FILE_ID]", nullable=false)
    public void setFileId(Long val) {
        if (this.fileId == null) {
            this.fileId = DBLayer.DEFAULT_ID;
        }
        this.fileId = val;
    }

    @Column(name="[JOB_CHAIN_NAME]", nullable=false)
    public void setJobChainName(String val) {
        if (val == null || val.isEmpty()) {
            val = ".";
        }
        this.jobChainName = val;
    }

    @Column(name="[JOB_CHAIN_NAME]", nullable=false)
    public String getJobChainName() {
        return this.jobChainName;
    }

    @Column(name="[NAME]", nullable=false)
    public void setName(String val) {
        this.name = val;
    }

    @Column(name="[NAME]", nullable=false)
    public String getName() {
        return this.name;
    }

    @Column(name="[BASENAME]", nullable=false)
    public void setBaseName(String val) {
        this.baseName = val;
    }

    @Column(name="[BASENAME]", nullable=false)
    public String getBaseName() {
        return this.baseName;
    }

    @Column(name="[ORDER_ID]", nullable=false)
    public void setOrderId(String val) {
        this.orderId = val;
    }

    @Column(name="[ORDER_ID]", nullable=false)
    public String getOrderId() {
        return this.orderId;
    }

    @Column(name="[TITLE]", nullable=true)
    public void setTitle(String val) {
        if (SOSString.isEmpty((String)val)) {
            val = null;
        } else if (val.length() > 255) {
            val = val.substring(0, 255);
        }
        this.title = val;
    }

    @Column(name="[TITLE]", nullable=true)
    public String getTitle() {
        return this.title;
    }

    @Column(name="[IS_RUNTIME_DEFINED]", nullable=false)
    @Type(type="numeric_boolean")
    public void setIsRuntimeDefined(boolean val) {
        this.isRuntimeDefined = val;
    }

    @Column(name="[IS_RUNTIME_DEFINED]", nullable=false)
    @Type(type="numeric_boolean")
    public boolean getIsRuntimeDefined() {
        return this.isRuntimeDefined;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date val) {
        this.created = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date val) {
        this.modified = val;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    @Column(name="[JOB_CHAIN_ID]", nullable=false)
    public Long getJobChainId() {
        return this.jobChainId;
    }

    @Column(name="[JOB_CHAIN_ID]", nullable=false)
    public void setJobChainId(Long jobChainId) {
        if (jobChainId == null) {
            jobChainId = DBLayer.DEFAULT_ID;
        }
        this.jobChainId = jobChainId;
    }

    @Column(name="[INITIAL_STATE]", nullable=true)
    public String getInitialState() {
        return this.initialState;
    }

    @Column(name="[INITIAL_STATE]", nullable=true)
    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    @Column(name="[END_STATE]", nullable=true)
    public String getEndState() {
        return this.endState;
    }

    @Column(name="[END_STATE]", nullable=true)
    public void setEndState(String endState) {
        this.endState = endState;
    }

    @Column(name="[PRIORITY]", nullable=true)
    public Integer getPriority() {
        return this.priority;
    }

    @Column(name="[PRIORITY]", nullable=true)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Column(name="[SCHEDULE]", nullable=true)
    public String getSchedule() {
        return this.schedule;
    }

    @Column(name="[SCHEDULE]", nullable=true)
    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Column(name="[SCHEDULE_NAME]", nullable=false)
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Column(name="[SCHEDULE_NAME]", nullable=false)
    public void setScheduleName(String scheduleName) {
        if (scheduleName == null || scheduleName.isEmpty()) {
            scheduleName = ".";
        }
        this.scheduleName = scheduleName;
    }

    @Column(name="[SCHEDULE_ID]", nullable=false)
    public Long getScheduleId() {
        return this.scheduleId;
    }

    @Column(name="[SCHEDULE_ID]", nullable=false)
    public void setScheduleId(Long scheduleId) {
        if (scheduleId == null) {
            scheduleId = DBLayer.DEFAULT_ID;
        }
        this.scheduleId = scheduleId;
    }

    @Column(name="[RUN_TIME_IS_TEMPORARY]", nullable=true)
    @Type(type="numeric_boolean")
    public Boolean getRunTimeIsTemporary() {
        return this.runTimeIsTemporary;
    }

    @Column(name="[RUN_TIME_IS_TEMPORARY]", nullable=true)
    @Type(type="numeric_boolean")
    public void setRunTimeIsTemporary(Boolean runTimeIsTemporary) {
        this.runTimeIsTemporary = runTimeIsTemporary;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.instanceId).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemInventoryOrder)) {
            return false;
        }
        DBItemInventoryOrder rhs = (DBItemInventoryOrder)other;
        return new EqualsBuilder().append((Object)this.instanceId, (Object)rhs.instanceId).append((Object)this.name, (Object)rhs.name).isEquals();
    }
}

