/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.db.filter;

import com.sos.hibernate.classes.SOSHibernateIntervalFilter;
import com.sos.joc.model.common.Folder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportHistoryFilter
extends SOSHibernateIntervalFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportHistoryFilter.class);
    private Set<Long> historyIds;
    private ArrayList<String> listOfJobchains;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private Date executedFrom;
    private Date executedTo;
    private Date startTime;
    private Date endTime;
    private String schedulerId = "";
    private String orderId;
    private String jobChain;
    private Set<Folder> listOfFolders;

    public void setListOfFolders(Set<Folder> listOfFolders) {
        this.listOfFolders = listOfFolders;
    }

    public Set<Folder> getListOfFolders() {
        return this.listOfFolders;
    }

    public void addFolderPaths(Set<Folder> folders) {
        if (this.listOfFolders == null) {
            this.listOfFolders = new HashSet<Folder>();
        }
        if (folders != null) {
            this.listOfFolders.addAll(folders);
        }
    }

    public void addFolderPath(Folder folder) {
        if (this.listOfFolders == null) {
            this.listOfFolders = new HashSet<Folder>();
        }
        if (folder != null) {
            this.listOfFolders.add(folder);
        }
    }

    public void addFolderPath(String folder, boolean recursive) {
        if (this.listOfFolders == null) {
            this.listOfFolders = new HashSet<Folder>();
        }
        Folder filterFolder = new Folder();
        filterFolder.setFolder(folder);
        filterFolder.setRecursive(Boolean.valueOf(recursive));
        this.listOfFolders.add(filterFolder);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setExecutedFrom(String executedFrom, String parseDateFormat) throws ParseException {
        if ("".equals(executedFrom)) {
            this.executedFrom = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateFormat);
            this.setExecutedFrom(formatter.parse(executedFrom));
        }
    }

    public Date getExecutedFrom() {
        return this.executedFrom;
    }

    public Date getExecutedTo() {
        return this.executedTo;
    }

    public void setExecutedTo(String executedTo, String parseDateFormat) throws ParseException {
        if ("".equals(executedTo)) {
            this.executedTo = null;
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat(parseDateFormat);
            this.setExecutedTo(formatter.parse(executedTo));
        }
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    public void setExecutedFrom(Date from) {
        this.executedFrom = from;
    }

    public void setExecutedTo(Date to) {
        this.executedTo = to;
    }

    public void setStartTime(Date start) {
        this.startTime = start;
    }

    public void setEndTime(Date end) {
        this.endTime = end;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setIntervalFromDate(Date d) {
        this.executedFrom = d;
    }

    public void setIntervalToDate(Date d) {
        this.executedTo = d;
    }

    public void setIntervalFromDateIso(String s) {
    }

    public void setIntervalToDateIso(String s) {
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }

    public Set<Long> getHistoryIds() {
        return this.historyIds;
    }

    public void setHistoryIds(Set<Long> historyIds) {
        this.historyIds = historyIds;
    }

    public void setHistoryIds(List<Long> historyIds) {
        this.historyIds = new HashSet<Long>(historyIds);
    }

    public ArrayList<String> getListOfJobchains() {
        return this.listOfJobchains;
    }

    public void addJobChainPath(String jobChain) {
        if (this.listOfJobchains == null) {
            this.listOfJobchains = new ArrayList();
        }
        this.listOfJobchains.add(jobChain);
    }
}

