/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.job.inventory;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.inventory.model.InventoryModel;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.job.inventory.InventoryJobOptions;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryJob
extends JSJobUtilitiesClass<InventoryJobOptions> {
    private final String className = InventoryJob.class.getSimpleName();
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryJob.class);
    private SOSHibernateSession sosHibernateSession;
    SOSHibernateFactory factory;
    private String answerXml;

    public InventoryJob() {
        super((Object)new InventoryJobOptions());
    }

    public void init() throws Exception {
        try {
            this.factory = new SOSHibernateFactory(this.getOptions().hibernate_configuration_file.getValue());
            this.factory.setAutoCommit(this.getOptions().connection_autocommit.value());
            this.factory.setTransactionIsolation(this.getOptions().connection_transaction_isolation.value());
            this.factory.addClassMapping(DBLayer.getInventoryClassMapping());
            this.factory.addClassMapping(DBLayer.getJobStreamClassMapping());
            this.factory.build();
            this.sosHibernateSession = this.factory.openSession();
        }
        catch (Exception ex) {
            throw new Exception(String.format("init connection: %s", ex.toString()));
        }
    }

    public void exit() {
        if (this.factory != null) {
            this.factory.close();
        }
        if (this.sosHibernateSession != null) {
            this.sosHibernateSession.close();
        }
    }

    public InventoryJob execute() throws Exception {
        String methodName = this.className + "::execute";
        LOGGER.debug(methodName);
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            InventoryModel model = new InventoryModel(this.factory, null, Paths.get(this.getOptions().getcurrent_scheduler_configuration_directory() + "scheduler.xml", new String[0]));
            model.setAnswerXml(this.answerXml);
            model.process();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s: %s", methodName, e.toString()));
            throw e;
        }
        return this;
    }

    public InventoryJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new InventoryJobOptions();
        }
        return (InventoryJobOptions)((Object)this.objOptions);
    }

    public void setAnswerXml(String answerXml) {
        this.answerXml = answerXml;
    }
}

