/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.restclient;

import com.sos.exception.SOSException;
import com.sos.jitl.restclient.ApiAccessToken;
import com.sos.jitl.restclient.JobSchedulerCredentialStoreJOCParameters;
import com.sos.jitl.restclient.WebserviceCredentials;
import com.sos.keepass.SOSKeePassResolver;
import com.typesafe.config.ConfigException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;
import sos.util.SOSPrivateConf;

public class AccessTokenProvider {
    private static final String DEFAULT_PRIVATE_CONF_FILENAME = "config/private/private.conf";
    private static final String JOC_URL = "joc_url";
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenProvider.class);
    private static final String X_ACCESS_TOKEN = "X-Access-Token";
    private static final int MAX_WAIT_TIME_FOR_ACCESS_TOKEN = 30;
    private WebserviceCredentials webserviceCredentials;
    private String profileFileName;
    private JobSchedulerCredentialStoreJOCParameters jobSchedulerCredentialStoreParameters;

    public AccessTokenProvider(JobSchedulerCredentialStoreJOCParameters options) {
        this.profileFileName = DEFAULT_PRIVATE_CONF_FILENAME;
        this.jobSchedulerCredentialStoreParameters = options;
    }

    public AccessTokenProvider(JobSchedulerCredentialStoreJOCParameters options, String profileName) {
        this.profileFileName = profileName;
        this.jobSchedulerCredentialStoreParameters = options;
    }

    private void setSpoolerVariable(Spooler spooler, String name, String value) {
        LOGGER.debug("Setting:" + name + "=" + value);
        if (spooler != null) {
            spooler.variables().set_value(name, value);
        } else {
            LOGGER.debug("spooler is null " + name + "=" + value + " not set");
        }
    }

    private String getSpoolerVariable(Spooler spooler, String name) {
        if (spooler != null) {
            return spooler.variables().value(name);
        }
        return "";
    }

    public WebserviceCredentials getAccessToken(Spooler spooler) throws SOSException, URISyntaxException, InterruptedException, UnsupportedEncodingException {
        String schedulerId = "";
        this.webserviceCredentials = this.getWebServiceVCredentials();
        LOGGER.debug("User:" + this.webserviceCredentials.getUser());
        String xAccessToken = this.webserviceCredentials.getUser() != null && !this.webserviceCredentials.getUser().isEmpty() ? this.getSpoolerVariable(spooler, this.webserviceCredentials.getUser() + "_" + X_ACCESS_TOKEN) : "";
        if (this.webserviceCredentials.getJocUrl() == null) {
            this.webserviceCredentials.setJocUrl("");
        }
        if (spooler != null && this.webserviceCredentials.getJocUrl().isEmpty()) {
            this.webserviceCredentials.setJocUrl(this.getSpoolerVariable(spooler, JOC_URL));
        }
        ApiAccessToken apiAccessToken = new ApiAccessToken(this.webserviceCredentials.getJocUrl());
        LOGGER.debug("Check whether accessToken " + xAccessToken + " is valid");
        if (xAccessToken.isEmpty() || !apiAccessToken.isValidAccessToken(xAccessToken, this.webserviceCredentials)) {
            LOGGER.debug("---> not valid. Execute login");
            xAccessToken = this.executeLogin();
            apiAccessToken.setJocUrl(this.webserviceCredentials.getJocUrl());
            if (xAccessToken != null && !xAccessToken.isEmpty()) {
                LOGGER.debug("... set accessToken:" + xAccessToken);
                this.setSpoolerVariable(spooler, this.webserviceCredentials.getUser() + "_" + X_ACCESS_TOKEN, xAccessToken);
                this.setSpoolerVariable(spooler, JOC_URL, this.webserviceCredentials.getJocUrl());
            } else {
                LOGGER.debug("AccessToken " + xAccessToken + " is not valid. Trying to renew it...");
                Thread.sleep(1000L);
            }
        }
        if (!apiAccessToken.isValidAccessToken(xAccessToken, this.webserviceCredentials)) {
            return null;
        }
        schedulerId = spooler != null ? spooler.id() : "test";
        this.webserviceCredentials.setSchedulerId(schedulerId);
        this.webserviceCredentials.setAccessToken(xAccessToken);
        return this.webserviceCredentials;
    }

    public String getJocUrl() {
        return this.webserviceCredentials.getJocUrl();
    }

    private WebserviceCredentials getWebServiceVCredentials() throws SOSException, UnsupportedEncodingException {
        String[] account;
        String userDecodedAccount = "";
        String jocApiUser = "";
        String jocApiPassword = "";
        String jocUrl = "";
        String keyStorePath = "";
        String keyStorePassword = "";
        String keyPassword = "";
        String keyStoreType = "";
        String trustStorePath = "";
        String trustStorePassword = "";
        String trustStoreType = "";
        WebserviceCredentials webserviceCredentials = new WebserviceCredentials();
        if (this.jobSchedulerCredentialStoreParameters != null && this.jobSchedulerCredentialStoreParameters.getCredentialStoreFile() != null && !this.jobSchedulerCredentialStoreParameters.getCredentialStoreFile().isEmpty()) {
            SOSKeePassResolver r = new SOSKeePassResolver(this.jobSchedulerCredentialStoreParameters.getCredentialStoreFile(), this.jobSchedulerCredentialStoreParameters.getCredentialStoreKeyFile(), this.jobSchedulerCredentialStoreParameters.getCredentialStorePassword());
            r.setEntryPath(this.jobSchedulerCredentialStoreParameters.getCredentialStoreEntryPath());
            try {
                jocUrl = r.resolve(this.jobSchedulerCredentialStoreParameters.getJocUrl());
                jocApiUser = r.resolve(this.jobSchedulerCredentialStoreParameters.getUser());
                jocApiPassword = r.resolve(this.jobSchedulerCredentialStoreParameters.getPassword());
                keyStorePath = r.resolve(this.jobSchedulerCredentialStoreParameters.getKeyStorePath());
                keyPassword = r.resolve(this.jobSchedulerCredentialStoreParameters.getKeyPassword());
                keyStorePassword = r.resolve(this.jobSchedulerCredentialStoreParameters.getKeyStorePassword());
                keyStoreType = r.resolve(this.jobSchedulerCredentialStoreParameters.getKeyStoreType());
                trustStorePath = r.resolve(this.jobSchedulerCredentialStoreParameters.getTrustStorePath());
                trustStorePassword = r.resolve(this.jobSchedulerCredentialStoreParameters.getTrustStorePassword());
                trustStoreType = r.resolve(this.jobSchedulerCredentialStoreParameters.getKeyStoreType());
            }
            catch (Exception e) {
                throw new SOSException((Throwable)e);
            }
            LOGGER.debug(this.jobSchedulerCredentialStoreParameters.getCredentialStoreFile());
            LOGGER.debug(this.jobSchedulerCredentialStoreParameters.getCredentialStoreKeyFile());
            LOGGER.debug(this.jobSchedulerCredentialStoreParameters.getCredentialStoreEntryPath());
            LOGGER.debug("JOCUrl: " + jocUrl);
            LOGGER.debug("KeyStorePath: " + keyStorePath);
            LOGGER.debug("KeyStoreType: " + keyStoreType);
            LOGGER.debug("KeyStorePasswort: ********");
            LOGGER.debug("KeyPassword: ********");
            LOGGER.debug("TrustStorePath: " + trustStorePath);
            LOGGER.debug("TrustStoreType: " + trustStoreType);
            LOGGER.debug("TrustStorePasswort: ********");
            LOGGER.debug("User: " + jocApiUser);
            LOGGER.debug("Password: ********");
        } else if (this.jobSchedulerCredentialStoreParameters != null) {
            jocUrl = this.jobSchedulerCredentialStoreParameters.getJocUrl();
            jocApiUser = this.jobSchedulerCredentialStoreParameters.getUser();
            jocApiPassword = this.jobSchedulerCredentialStoreParameters.getPassword();
            keyStorePath = this.jobSchedulerCredentialStoreParameters.getKeyStorePath();
            keyStorePassword = this.jobSchedulerCredentialStoreParameters.getKeyStorePassword();
            keyPassword = this.jobSchedulerCredentialStoreParameters.getKeyStorePassword();
            keyStoreType = this.jobSchedulerCredentialStoreParameters.getKeyStoreType();
            trustStorePath = this.jobSchedulerCredentialStoreParameters.getTrustStorePath();
            trustStorePassword = this.jobSchedulerCredentialStoreParameters.getTrustStorePassword();
            trustStoreType = this.jobSchedulerCredentialStoreParameters.getKeyStoreType();
        }
        if (jocApiUser != null && jocApiPassword != null && !jocApiUser.isEmpty() && !jocApiPassword.isEmpty()) {
            userDecodedAccount = jocApiUser + ":" + jocApiPassword;
        }
        SOSPrivateConf sosPrivateConf = new SOSPrivateConf(this.profileFileName);
        if (jocUrl == null || jocUrl.isEmpty()) {
            try {
                jocUrl = sosPrivateConf.getValue("joc.webservice.jitl", "joc.url");
            }
            catch (ConfigException.Missing e) {
                jocUrl = sosPrivateConf.getValue("joc.url");
            }
        }
        if (userDecodedAccount.isEmpty() && (userDecodedAccount = sosPrivateConf.getDecodedValue("joc.webservice.jitl", "joc.account")) == null) {
            userDecodedAccount = sosPrivateConf.getDecodedValue("joc.account");
        }
        if (userDecodedAccount != null && (account = userDecodedAccount.split(":")).length > 0) {
            if (jocApiUser.isEmpty()) {
                jocApiUser = account[0];
            }
            if (jocApiPassword.isEmpty() && account.length > 1) {
                jocApiPassword = userDecodedAccount.split(":")[1];
            }
        }
        if (keyStorePath.isEmpty()) {
            try {
                keyStorePath = sosPrivateConf.getValue("joc.webservice.jitl", "joc.keystorepath");
            }
            catch (ConfigException.Missing e) {
                keyStorePath = sosPrivateConf.getValueDefaultEmpty("joc.keystorepath");
            }
        }
        if (keyStorePassword.isEmpty()) {
            try {
                keyStorePassword = sosPrivateConf.getValue("joc.webservice.jitl", "joc.keystorepassword");
            }
            catch (ConfigException.Missing e) {
                keyStorePassword = sosPrivateConf.getValueDefaultEmpty("joc.keystorepassword");
            }
        }
        if (keyPassword.isEmpty()) {
            try {
                keyPassword = sosPrivateConf.getValue("joc.webservice.jitl", "joc.keypassword");
            }
            catch (ConfigException.Missing e) {
                keyPassword = sosPrivateConf.getValueDefaultEmpty("joc.keypassword");
            }
        }
        if (keyStoreType.isEmpty()) {
            try {
                keyStoreType = sosPrivateConf.getValue("joc.webservice.jitl", "joc.keystoretype");
            }
            catch (ConfigException.Missing e) {
                keyStoreType = sosPrivateConf.getValueDefaultEmpty("joc.keystoretype");
            }
        }
        if (trustStorePath.isEmpty()) {
            try {
                trustStorePath = sosPrivateConf.getValue("joc.webservice.jitl", "joc.truststorepath");
            }
            catch (ConfigException.Missing e) {
                trustStorePath = sosPrivateConf.getValueDefaultEmpty("joc.truststorepath");
            }
        }
        if (trustStorePassword.isEmpty()) {
            try {
                trustStorePassword = sosPrivateConf.getValue("joc.webservice.jitl", "joc.truststorepassword");
            }
            catch (ConfigException.Missing e) {
                trustStorePassword = sosPrivateConf.getValueDefaultEmpty("joc.truststorepassword");
            }
        }
        if (trustStoreType.isEmpty()) {
            try {
                trustStoreType = sosPrivateConf.getValue("joc.webservice.jitl", "joc.truststoretype");
            }
            catch (ConfigException.Missing e) {
                trustStoreType = sosPrivateConf.getValueDefaultEmpty("joc.truststoretype");
            }
        }
        webserviceCredentials.setJocUrl(jocUrl + "/joc/api");
        webserviceCredentials.setPassword(jocApiPassword);
        webserviceCredentials.setUser(jocApiUser);
        webserviceCredentials.setUserDecodedAccount(userDecodedAccount);
        webserviceCredentials.setKeyStorePassword(keyStorePassword);
        webserviceCredentials.setKeyPassword(keyPassword);
        webserviceCredentials.setKeyStorePath(keyStorePath);
        webserviceCredentials.setKeyStoreType(keyStoreType);
        webserviceCredentials.setTrustStorePassword(trustStorePassword);
        webserviceCredentials.setTrustStorePath(trustStorePath);
        webserviceCredentials.setTrustStoreType(trustStoreType);
        return webserviceCredentials;
    }

    private String executeLogin() throws SOSException, URISyntaxException, UnsupportedEncodingException {
        String userDecodedAccount = this.webserviceCredentials.getUserDecodedAccount();
        String jocUrl = this.webserviceCredentials.getJocUrl();
        LOGGER.debug("jocUrl: " + jocUrl);
        ApiAccessToken apiAccessToken = new ApiAccessToken(jocUrl);
        boolean sessionIsValid = false;
        String xAccessToken = "";
        int cnt = 0;
        while (cnt < 30 && !sessionIsValid) {
            LOGGER.debug("check session");
            try {
                sessionIsValid = apiAccessToken.isValidAccessToken(xAccessToken, this.webserviceCredentials);
            }
            catch (Exception e) {
                sessionIsValid = false;
            }
            if (sessionIsValid && !xAccessToken.isEmpty()) continue;
            LOGGER.debug("... execute login");
            try {
                xAccessToken = apiAccessToken.login(this.webserviceCredentials);
            }
            catch (Exception e) {
                LOGGER.warn("... login failed with " + this.webserviceCredentials.getUserEncodedAccount() + " at " + jocUrl);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++cnt;
        }
        if (cnt == 30) {
            LOGGER.warn("Could not get the access token from JOC Server:" + jocUrl);
        }
        return xAccessToken;
    }
}

