/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.jitl.schedulerhistory.db.SchedulerHistoryLogDBItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="SCHEDULER_ORDER_HISTORY")
public class SchedulerOrderHistoryDBItem
extends SchedulerHistoryLogDBItem {
    private Long historyId;
    private String spoolerId;
    private String orderId;
    private String jobChain;
    private Date startTime;
    private Date endTime;
    private String title;
    private String state;
    private String stateText;
    private boolean assignToDaysScheduler = false;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="[HISTORY_ID]", nullable=false)
    public Long getHistoryId() {
        return this.historyId;
    }

    @Column(name="[HISTORY_ID]", nullable=false)
    public void setHistoryId(Long id) {
        this.historyId = id;
    }

    @Column(name="[SPOOLER_ID]", nullable=false)
    public String getSpoolerId() {
        return this.spoolerId;
    }

    @Column(name="[SPOOLER_ID]", nullable=false)
    public void setSpoolerId(String spoolerId) {
        this.spoolerId = spoolerId;
    }

    @Column(name="[ORDER_ID]", nullable=false)
    public String getOrderId() {
        return this.orderId;
    }

    @Column(name="[ORDER_ID]", nullable=false)
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Column(name="[JOB_CHAIN]", nullable=false)
    public String getJobChain() {
        return this.jobChain;
    }

    @Column(name="[JOB_CHAIN]", nullable=false)
    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }

    @Column(name="[START_TIME]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getStartTime() {
        return this.startTime;
    }

    @Column(name="[START_TIME]", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Column(name="[END_TIME]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getEndTime() {
        return this.endTime;
    }

    @Column(name="[END_TIME]", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Column(name="[TITLE]", nullable=true)
    public String getCause() {
        return this.title;
    }

    @Column(name="[TITLE]", nullable=true)
    public void setCause(String title) {
        this.title = title;
    }

    @Column(name="[STATE]", nullable=true)
    public String getState() {
        return this.state;
    }

    @Column(name="[STATE]", nullable=true)
    public void setState(String state) {
        this.state = state;
    }

    @Transient
    public String getStartTimeIso() {
        if (this.getStartTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getStartTime());
    }

    @Transient
    public String getEndTimeIso() {
        if (this.getEndTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getEndTime());
    }

    @Column(name="[STATE_TEXT]", nullable=true)
    public String getStateText() {
        return this.stateText;
    }

    @Column(name="[STATE_TEXT]", nullable=true)
    public void setStateText(String stateText) {
        this.stateText = stateText;
    }

    public String readStartTimeIso() {
        if (this.getStartTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getStartTime());
    }

    public String readEndTimeIso() {
        if (this.getEndTime() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(this.getEndTime());
    }

    @Transient
    public String getStartTimeFormated() {
        return this.getDateFormatted(this.getStartTime());
    }

    @Transient
    public String getEndTimeFormated() {
        return this.getDateFormatted(this.getEndTime());
    }

    @Transient
    public String getDurationFormated() {
        return this.getDateDiff(this.getStartTime(), this.getEndTime());
    }

    @Transient
    public boolean isAssignToDaysScheduler() {
        return this.assignToDaysScheduler;
    }

    @Transient
    public String getJobOrJobchain() {
        return this.null2Blank(String.format("%s(%s)", this.getJobChain(), this.getOrderId()));
    }

    @Transient
    public void setAssignToDaysScheduler(boolean assignToDaysScheduler) {
        this.assignToDaysScheduler = assignToDaysScheduler;
    }

    @Transient
    public Long getLogId() {
        return this.getHistoryId();
    }

    @Transient
    public String getIdentifier() {
        return this.getJobChain() + "/" + this.getOrderId();
    }

    @Transient
    public boolean isStandalone() {
        return false;
    }

    @Transient
    public String getSchedulerId() {
        return this.getSpoolerId();
    }

    @Transient
    public String getTitle() {
        return this.jobChain + "/" + this.orderId;
    }

    @Transient
    public String getExecResult() {
        return this.getState();
    }

    @Transient
    public boolean haveError() {
        if (this.getState() == null) {
            return false;
        }
        return this.getState().toLowerCase().contains("error") || this.getState().toLowerCase().contains("fehler") || this.getState().startsWith("!") || this.getState().toLowerCase().contains("fault");
    }

    @Transient
    public boolean equals(Object h) {
        return ((SchedulerOrderHistoryDBItem)((Object)h)).getJobChain().equals(this.getJobChain()) && ((SchedulerOrderHistoryDBItem)((Object)h)).getOrderId().equals(this.getOrderId());
    }

    @Transient
    public int hashCode() {
        return this.historyId.intValue();
    }

    @Transient
    public boolean isOrderJob() {
        return true;
    }
}

