/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateIntervalDBLayer;
import com.sos.jitl.schedulerhistory.SchedulerTaskHistoryFilter;
import com.sos.jitl.schedulerhistory.db.SchedulerTaskHistoryDBItem;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.TemporalType;
import org.hibernate.query.Query;

public class SchedulerTaskHistoryDBLayer
extends SOSHibernateIntervalDBLayer<SchedulerTaskHistoryDBItem> {
    protected SchedulerTaskHistoryFilter filter = null;
    private String lastQuery = "";

    public SchedulerTaskHistoryDBLayer(File configurationFile_) throws SOSHibernateException {
        this.setConfigurationFileName(configurationFile_.getAbsolutePath());
        this.createStatelessConnection(configurationFile_.getAbsolutePath());
        this.resetFilter();
    }

    public SchedulerTaskHistoryDBLayer(SOSHibernateSession session) {
        this.setConfigurationFileName(((Path)session.getFactory().getConfigFile().get()).toFile().getAbsolutePath());
        this.sosHibernateSession = session;
        this.resetFilter();
    }

    public SchedulerTaskHistoryDBItem get(Long id) {
        SchedulerTaskHistoryDBItem schedulerHistoryDBItem = null;
        try {
            schedulerHistoryDBItem = (SchedulerTaskHistoryDBItem)((Object)this.getSession().get(SchedulerTaskHistoryDBItem.class, (Serializable)id));
            return schedulerHistoryDBItem;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void resetFilter() {
        this.filter = new SchedulerTaskHistoryFilter();
        this.filter.setDateFormat("yyyy-MM-dd HH:mm:ss");
        this.filter.setOrderCriteria("startTime");
        this.filter.setSortMode("desc");
    }

    public SchedulerTaskHistoryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SchedulerTaskHistoryFilter filter_) {
        this.filter = filter_;
    }

    protected String getWhere() {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " spoolerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getJobname() != null && !"".equals(this.filter.getJobname())) {
            where = where + and + " jobName=:jobName";
            and = " and ";
        }
        if (this.filter.getSeverity() != null && this.filter.getSeverity().hasValue()) {
            where = where + and + " error=:severity";
            and = " and ";
        }
        if (this.filter.getStartTime() != null) {
            where = where + and + " startTime>= :startTime";
            and = " and ";
        }
        if (this.filter.getEndTime() != null) {
            where = where + and + " endTime <= :endTime ";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    protected String getWhereFromTo() {
        return this.getWhereFromToStart();
    }

    protected String getWhereFromToStart() {
        return this.getWhereFromTo("startTime");
    }

    protected String getWhereFromToEnd() {
        return this.getWhereFromTo("endTime");
    }

    protected String getWhereFromTo(String fieldname_date_field) {
        String where = "";
        String and = "";
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            where = where + and + " spoolerId=:schedulerId";
            and = " and ";
        }
        if (this.filter.getJobname() != null && !"".equals(this.filter.getJobname())) {
            where = this.filter.getJobname().contains("%") ? where + and + " jobName like :jobName" : where + and + " jobName=:jobName";
            and = " and ";
        }
        if (this.filter.getExecutedUtcFrom() != null) {
            where = where + and + fieldname_date_field + " >= :startTimeFrom";
            and = " and ";
        }
        if (this.filter.getExecutedUtcTo() != null) {
            where = where + and + fieldname_date_field + " <= :startTimeTo ";
            and = " and ";
        }
        if (!this.filter.isShowJobs()) {
            where = where + and + " 1=0";
            and = " and ";
        }
        if (this.filter.isShowSuccessfull()) {
            where = where + and + " exitCode=0";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = "where " + where;
        }
        return where;
    }

    public long deleteInterval() throws SOSHibernateException {
        String hql = "delete from SchedulerTaskHistoryDBItem " + this.getWhereFromTo();
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getExecutedUtcFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedUtcFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedUtcTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedUtcTo(), TemporalType.TIMESTAMP);
        }
        return this.sosHibernateSession.executeUpdate(query);
    }

    public int delete() throws SOSHibernateException {
        String hql = "delete from SchedulerTaskHistoryDBItem " + this.getWhereFromTo();
        Query query = this.sosHibernateSession.createQuery(hql);
        if (this.filter.getSchedulerId() != null && !"".equalsIgnoreCase(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getSeverity() != null) {
            query.setParameter("severity", (Object)this.filter.getSeverity().getIntValue());
        }
        if (this.filter.getJobname() != null && !"".equalsIgnoreCase(this.filter.getJobname())) {
            query.setParameter("jobName", (Object)this.filter.getJobname());
        }
        if (this.filter.getExecutedUtcFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedUtcFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedUtcTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedUtcTo(), TemporalType.TIMESTAMP);
        }
        return this.sosHibernateSession.executeUpdate(query);
    }

    private List<SchedulerTaskHistoryDBItem> executeQuery(Query<SchedulerTaskHistoryDBItem> query, int limit) throws SOSHibernateException {
        this.lastQuery = query.getQueryString();
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getSeverity() != null) {
            query.setParameter("severity", (Object)this.filter.getSeverity().getIntValue());
        }
        if (this.filter.getJobname() != null && !"".equals(this.filter.getJobname())) {
            query.setParameter("jobName", (Object)this.filter.getJobname());
        }
        if (this.filter.getExecutedUtcFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedUtcFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedUtcTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedUtcTo(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public List<SchedulerTaskHistoryDBItem> getSchedulerHistoryListFromTo() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from SchedulerTaskHistoryDBItem " + this.getWhereFromTo() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        return this.executeQuery((Query<SchedulerTaskHistoryDBItem>)query, limit);
    }

    public List<SchedulerTaskHistoryDBItem> getUnassignedSchedulerHistoryListFromTo() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from SchedulerTaskHistoryDBItem " + this.getWhereFromTo() + " and id NOT IN (select schedulerHistoryId from DailyScheduleDBItem where not schedulerHistoryId is null and  status=1 and schedulerId=:schedulerId) " + this.filter.getOrderCriteria() + this.filter.getSortMode());
        return this.executeQuery((Query<SchedulerTaskHistoryDBItem>)query, limit);
    }

    public List<SchedulerTaskHistoryDBItem> getSchedulerHistoryListFromToStart() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from SchedulerTaskHistoryDBItem " + this.getWhereFromToStart() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        return this.executeQuery((Query<SchedulerTaskHistoryDBItem>)query, limit);
    }

    public List<SchedulerTaskHistoryDBItem> getSchedulerHistoryListFromToEnd() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from SchedulerTaskHistoryDBItem " + this.getWhereFromToStart() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        return this.executeQuery((Query<SchedulerTaskHistoryDBItem>)query, limit);
    }

    public List<SchedulerTaskHistoryDBItem> getSchedulerHistoryListSchedulersFromTo() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        String q = "from SchedulerTaskHistoryDBItem e where e.spoolerId IN (select distinct e.spoolerId from SchedulerTaskHistoryDBItem " + this.getWhereFromTo() + ")";
        Query query = this.sosHibernateSession.createQuery(q);
        return this.executeQuery((Query<SchedulerTaskHistoryDBItem>)query, limit);
    }

    public List<SchedulerTaskHistoryDBItem> getHistoryItems() throws SOSHibernateException {
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from SchedulerTaskHistoryDBItem " + this.getWhere() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        if (this.filter.getSchedulerId() != null && !"".equalsIgnoreCase(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getSeverity() != null) {
            query.setParameter("severity", (Object)this.filter.getSeverity().getIntValue());
        }
        if (this.filter.getJobname() != null && !"".equalsIgnoreCase(this.filter.getJobname())) {
            query.setParameter("jobName", (Object)this.filter.getJobname());
        }
        if (this.filter.getStartTime() != null) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null && !"".equals(this.filter.getEndTime())) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public SchedulerTaskHistoryDBItem getHistoryItem() throws SOSHibernateException {
        List historyList;
        this.filter.setLimit(1);
        Query query = this.sosHibernateSession.createQuery("from SchedulerTaskHistoryDBItem " + this.getWhere() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        if (this.filter.getSchedulerId() != null && !"".equalsIgnoreCase(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getSeverity() != null) {
            query.setParameter("severity", (Object)this.filter.getSeverity().getIntValue());
        }
        if (this.filter.getJobname() != null && !"".equalsIgnoreCase(this.filter.getJobname())) {
            query.setParameter("jobName", (Object)this.filter.getJobname());
        }
        if (this.filter.getStartTime() != null) {
            query.setParameter("startTime", this.filter.getStartTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getEndTime() != null && !"".equals(this.filter.getEndTime())) {
            query.setParameter("endTime", this.filter.getEndTime(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getLimit() > 0) {
            query.setMaxResults(this.filter.getLimit());
        }
        if ((historyList = this.sosHibernateSession.getResultList(query)) != null && !historyList.isEmpty()) {
            return (SchedulerTaskHistoryDBItem)((Object)historyList.get(0));
        }
        return null;
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public void onAfterDeleting(SchedulerTaskHistoryDBItem h) {
    }

    public List<SchedulerTaskHistoryDBItem> getListOfItemsToDelete() throws SOSHibernateException {
        TimeZone.setDefault(TimeZone.getTimeZone("Etc/UTC"));
        int limit = this.getFilter().getLimit();
        Query query = this.sosHibernateSession.createQuery("from SchedulerTaskHistoryDBItem " + this.getWhereFromTo() + this.filter.getOrderCriteria() + this.filter.getSortMode());
        if (this.filter.getSchedulerId() != null && !"".equals(this.filter.getSchedulerId())) {
            query.setParameter("schedulerId", (Object)this.filter.getSchedulerId());
        }
        if (this.filter.getSeverity() != null) {
            query.setParameter("severity", (Object)this.filter.getSeverity().getIntValue());
        }
        if (this.filter.getJobname() != null && !"".equals(this.filter.getJobname())) {
            query.setParameter("jobName", (Object)this.filter.getJobname());
        }
        if (this.filter.getExecutedUtcFrom() != null) {
            query.setParameter("startTimeFrom", this.filter.getExecutedUtcFrom(), TemporalType.TIMESTAMP);
        }
        if (this.filter.getExecutedUtcTo() != null) {
            query.setParameter("startTimeTo", this.filter.getExecutedUtcTo(), TemporalType.TIMESTAMP);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }
}

