/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.schedulerhistory.classes.SOSStreamUnzip;
import java.io.IOException;
import java.nio.file.Path;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="SCHEDULER_HISTORY")
public class SchedulerTaskHistoryLogDBItemPostgres
extends DbItem {
    private Long id;
    private String spoolerId;
    private String jobName;
    private String clusterMemberId;
    private byte[] log;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="[ID]")
    public Long getId() {
        return this.id;
    }

    @Column(name="[ID]")
    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="[SPOOLER_ID]", nullable=false)
    public String getSpoolerId() {
        return this.spoolerId;
    }

    @Column(name="[SPOOLER_ID]", nullable=false)
    public void setSpoolerId(String spoolerId) {
        this.spoolerId = spoolerId;
    }

    @Column(name="[JOB_NAME]", nullable=false)
    public String getJobName() {
        return this.jobName;
    }

    @Column(name="[JOB_NAME]", nullable=false)
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Column(name="[CLUSTER_MEMBER_ID]", nullable=true)
    public String getClusterMemberId() {
        return this.clusterMemberId;
    }

    @Column(name="[CLUSTER_MEMBER_ID]", nullable=true)
    public void setClusterMemberId(String clusterMemberId) {
        this.clusterMemberId = clusterMemberId;
    }

    @Column(name="[LOG]", nullable=true)
    public byte[] getLog() {
        return this.log;
    }

    @Column(name="[LOG]", nullable=true)
    public void setLog(byte[] log) {
        this.log = log;
    }

    @Transient
    public String getLogAsString() throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzip2String(this.log);
    }

    @Transient
    public byte[] getLogAsByteArray() throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzip(this.log);
    }

    @Transient
    public Path writeLogFile(String prefix) throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzipToFile(this.log, prefix);
    }

    @Transient
    public Path writeGzipLogFile(String prefix) throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.zippedToFile(this.log, prefix);
    }

    @Transient
    public String getSchedulerId() {
        return this.getSpoolerId();
    }
}

