/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionFileName;
import com.sos.JSHelper.Options.SOSOptionFileSize;
import com.sos.JSHelper.Options.SOSOptionInteger;
import com.sos.JSHelper.Options.SOSOptionRegExp;
import com.sos.JSHelper.Options.SOSOptionTime;
import com.sos.JSHelper.io.Files.JSTextFile;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.scheduler.messages.JSMessages;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.file.JSExistsFileOptions;
import sos.util.SOSFilelistFilter;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JSFileOperationBase
extends JSToolBox
implements JSJobUtilities {
    protected static final String PARAMETER_WARNING_FILE_LIMIT = "warning_file_limit";
    protected static final String PARAMETER_FILE_AGE = "file_age";
    protected static final String PARAMETER_FILE_SPEC = "file_spec";
    protected static final String PARAMETER_FILE_SPECIFICATION = "file_specification";
    protected static final String PARAMETER_FILE_PATH = "file_path";
    protected static final String PARAMETER_MAX_FILE_SIZE = "max_file_size";
    protected static final String PARAMETER_MIN_FILE_SIZE = "min_file_size";
    protected static final String PARAMETER_MAX_FILE_AGE = "max_file_age";
    protected static final String PARAMETER_MIN_FILE_AGE = "min_file_age";
    protected static final String PARAMETER_TARGET_FILE = "target_file";
    protected static final String PARAMETER_FILE = "file";
    protected static final String PARAMETER_SOURCE_FILE = "source_file";
    protected static final String PARAMETER_ON_EMPTY_RESULT_SET = "on_empty_result_set";
    protected static final String PARAMETER_SKIP_LAST_FILES = "skip_last_files";
    protected static final String PARAMETER_SKIP_FIRST_FILES = "skip_first_files";
    protected static final String PARAMETER_OVERWRITE = "overwrite";
    protected static final String PARAMETER_COUNT_FILES = "count_files";
    protected static final String PARAMETER_REPLACEMENT = "replacement";
    protected static final String PARAMETER_REPLACING = "replacing";
    protected static final String PARAMETER_RAISE_ERROR_IF_RESULT_SET_IS = "Raise_Error_If_Result_Set_Is";
    protected static final String PARAMETER_EXPECTED_SIZE_OF_RESULT_SET = "Expected_Size_Of_Result_Set";
    protected Logger logger = LoggerFactory.getLogger(JSFileOperationBase.class);
    protected static final String PARAMETER_RESULT_LIST_FILE = "Result_List_File";
    protected static final String PARAMETER_RECURSIVE = "recursive";
    protected static final String PARAMETER_CREATE_DIR = "create_dir";
    protected static final String CLASS_NAME = "JobSchedulerFileOperationBase";
    protected static final String VALUE_YES = "yes";
    protected static final String PROPERTY_JAVA_IO_TMPDIR = "java.io.tmpdir";
    protected JSExistsFileOptions objOptions = null;
    protected String filePath = System.getProperty("java.io.tmpdir");
    protected long lngFileAge = 86400000L;
    protected int warningFileLimit = 0;
    protected boolean flgOperationWasSuccessful = false;
    protected String name = null;
    protected String file = null;
    protected String fileSpec = ".*";
    protected String minFileAge = "0";
    protected String maxFileAge = "0";
    protected String minFileSize = "-1";
    protected String maxFileSize = "-1";
    protected int skipFirstFiles = 0;
    protected int skipLastFiles = 0;
    protected String strGracious = "false";
    protected final int isCaseInsensitive = 2;
    protected String strOnEmptyResultSet = null;
    protected String strResultList2File = null;
    protected int intExpectedSizeOfResultSet = 0;
    protected String strRaiseErrorIfResultSetIs = null;
    protected Vector<File> lstResultList = null;
    protected boolean flgCreateOrder = false;
    protected boolean flgCreateOrders4AllFiles = false;
    protected String strOrderJobChainName = null;
    protected String strNextState = null;
    private JSJobUtilities objJSJobUtilities = this;
    private final String strFileSpecDefault = ".*";
    public static final String conParameterGRACIOUS = "gracious";
    public int intNoOfHitsInResultSet = 0;
    String source = null;
    String target = null;
    int flags = 0;
    String replacing = null;
    String replacement = null;
    boolean count_files = false;

    public JSFileOperationBase() {
        super("com_sos_scheduler_messages");
    }

    protected void initialize() {
        this.lstResultList = new Vector();
        this.intExpectedSizeOfResultSet = this.getOptions().expected_size_of_result_set.value();
        this.strRaiseErrorIfResultSetIs = this.getOptions().raise_error_if_result_set_is.getValue();
        this.strResultList2File = this.getOptions().result_list_file.getValue();
        this.strOnEmptyResultSet = this.getOptions().on_empty_result_set.getValue();
        this.file = this.getOptions().file.getValue();
        this.fileSpec = ".*";
        this.fileSpec = this.getOptions().file_spec.getValue();
        this.minFileAge = this.getOptions().min_file_age.getValue();
        this.maxFileAge = this.getOptions().max_file_age.getValue();
        this.minFileSize = this.getOptions().min_file_size.getValue();
        this.maxFileSize = this.getOptions().min_file_size.getValue();
        this.strGracious = this.getOptions().gracious.getValue();
        this.skipFirstFiles = this.getOptions().skip_first_files.value();
        this.skipLastFiles = this.getOptions().skip_last_files.value();
        this.flags = 0;
        if (this.getOptions().gracious.value()) {
            this.flags |= 2;
        }
        String strM = JSMessages.JSJ_E_0110.get(new Object[]{PARAMETER_REPLACEMENT, PARAMETER_REPLACING});
        if (this.isNotNull(this.replacing) && this.isNull(this.replacement)) {
            throw new JobSchedulerException(strM);
        }
        if (this.isNull(this.replacing) && this.isNotNull(this.replacement)) {
            throw new JobSchedulerException(strM);
        }
    }

    public JSExistsFileOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new JSExistsFileOptions();
        }
        return this.objOptions;
    }

    public JSExistsFileOptions getOptions(JSExistsFileOptions pobjOptions) {
        this.objOptions = pobjOptions;
        return this.objOptions;
    }

    public Vector<File> getResultList() {
        return this.lstResultList;
    }

    public boolean createResultListParam(boolean pflgResult) {
        boolean flgR;
        String strT = "";
        this.intNoOfHitsInResultSet = this.lstResultList.size();
        if (this.isNotNull(this.lstResultList) && !this.lstResultList.isEmpty()) {
            this.intNoOfHitsInResultSet = this.lstResultList.size();
            for (File objFile : this.lstResultList) {
                strT = strT + objFile.getAbsolutePath() + ";";
            }
        }
        if (this.isNotEmpty(this.strResultList2File) && this.isNotEmpty(strT)) {
            JSTextFile objResultListFile = new JSTextFile(this.strResultList2File);
            try {
                if (!objResultListFile.canWrite()) {
                    throw new JobSchedulerException(JSMessages.JSJ_F_0090.get(new Object[]{PARAMETER_RESULT_LIST_FILE, this.strResultList2File}));
                }
                objResultListFile.write(strT);
                objResultListFile.close();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                JSMessages.JSJ_F_0080.toLog(new Object[]{this.strResultList2File, PARAMETER_RESULT_LIST_FILE});
            }
        }
        if (this.isNotEmpty(this.strRaiseErrorIfResultSetIs) && (flgR = this.getOptions().raise_error_if_result_set_is.compareIntValues(this.intNoOfHitsInResultSet, this.intExpectedSizeOfResultSet))) {
            this.logger.info(JSMessages.JSJ_E_0040.get(new Object[]{this.intNoOfHitsInResultSet, this.strRaiseErrorIfResultSetIs, this.intExpectedSizeOfResultSet}));
            return false;
        }
        return pflgResult;
    }

    public void checkMandatoryFile() {
        if (this.isNull(this.file)) {
            throw new JobSchedulerException(JSMessages.JSJ_E_0020.get(new Object[]{PARAMETER_FILE}));
        }
    }

    public void checkMandatorySource() {
        if (this.isNull(this.source)) {
            throw new JobSchedulerException(JSMessages.JSJ_E_0020.get(new Object[]{PARAMETER_SOURCE_FILE}));
        }
    }

    public void checkMandatoryTarget() {
        if (this.isNull(this.source)) {
            throw new JobSchedulerException(JSMessages.JSJ_E_0020.get(new Object[]{PARAMETER_TARGET_FILE}));
        }
    }

    public String replaceSchedulerVars(String pstrString2Modify) {
        this.logger.debug("replaceSchedulerVars as Dummy-call executed. No Instance of JobUtilites specified.");
        return pstrString2Modify;
    }

    public void setJSParam(String pstrKey, String pstrValue) {
    }

    public void setJSParam(String pstrKey, StringBuilder pstrValue) {
    }

    public void setJSJobUtilites(JSJobUtilities pobjJSJobUtilities) {
        this.objJSJobUtilities = pobjJSJobUtilities == null ? this : pobjJSJobUtilities;
        this.logger.debug("objJSJobUtilities = " + this.objJSJobUtilities.getClass().getName());
    }

    public boolean existsFile(SOSOptionFileName objFile, SOSOptionRegExp fileSpec1, SOSOptionTime minFileAge1, SOSOptionTime maxFileAge1, SOSOptionFileSize minFileSize1, SOSOptionFileSize maxFileSize1, SOSOptionInteger skipFirstFiles1, SOSOptionInteger skipLastFiles1, int minNumOfFiles, int maxNumOfFiles) throws IOException, Exception {
        File fleFile;
        long minAge = 0L;
        long maxAge = 0L;
        long minSize = -1L;
        long maxSize = -1L;
        minAge = minFileAge1.calculateFileAge();
        maxAge = maxFileAge1.calculateFileAge();
        minSize = minFileSize1.getFileSize();
        maxSize = maxFileSize1.getFileSize();
        if (skipFirstFiles1.value() < 0) {
            throw new JobSchedulerException(JSMessages.JFO_F_0100.get(new Object[]{skipFirstFiles1.value(), "skipFirstFiles"}));
        }
        if (skipLastFiles1.value() < 0) {
            throw new JobSchedulerException(JSMessages.JFO_F_0100.get(new Object[]{skipLastFiles1.value(), "skipLastFiles"}));
        }
        if (skipFirstFiles1.value() > 0 && skipLastFiles1.value() > 0) {
            JSMessages.JFO_F_0101.toLog();
        }
        if ((skipFirstFiles1.value() > 0 || skipLastFiles1.value() > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
            JSMessages.JFO_F_0103.toLog();
        }
        String filename = objFile.substituteAllDate();
        Matcher m = Pattern.compile("\\[[^]]*\\]").matcher(filename);
        if (m.find()) {
            JSMessages.JFO_F_0102.toLog(new Object[]{m.group()});
        }
        if (!(fleFile = new File(filename)).exists()) {
            this.logger.debug(JSMessages.JFO_I_0105.get(new Object[]{fleFile.getCanonicalPath()}));
            return false;
        }
        if (!fleFile.isDirectory()) {
            long interval;
            JSMessages.JFO_I_0106.toLog(new Object[]{fleFile.getCanonicalPath()});
            long currentTime = System.currentTimeMillis();
            if (minAge > 0L) {
                interval = currentTime - fleFile.lastModified();
                if (interval < 0L) {
                    throw new Exception("Cannot filter by file age. File [" + fleFile.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval < minAge) {
                    this.log("checking file age " + fleFile.lastModified() + ": minimum age required is " + minAge);
                    return false;
                }
            }
            if (maxAge > 0L) {
                interval = currentTime - fleFile.lastModified();
                if (interval < 0L) {
                    throw new JobSchedulerException("Cannot filter by file age. File [" + fleFile.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval > maxAge) {
                    this.log("checking file age " + fleFile.lastModified() + ": maximum age required is " + maxAge);
                    return false;
                }
            }
            if (minSize > -1L && minSize > fleFile.length()) {
                this.log("checking file size " + fleFile.length() + ": minimum size required is " + minFileSize1);
                return false;
            }
            if (maxSize > -1L && maxSize < fleFile.length()) {
                this.log("checking file size " + fleFile.length() + ": maximum size required is " + maxFileSize1);
                return false;
            }
            if (skipFirstFiles1.value() > 0 || skipLastFiles1.value() > 0) {
                this.log("file skipped");
                return false;
            }
            return true;
        }
        if (fileSpec1.IsEmpty()) {
            this.log("checking file " + fleFile.getCanonicalPath() + ": directory exists");
            return true;
        }
        Vector<File> fileList = this.getFilelist(fleFile.getPath(), fileSpec1, false, minAge, maxAge, minSize, maxSize, skipFirstFiles1.value(), skipLastFiles1.value());
        if (fileList.isEmpty()) {
            this.log("checking file " + fleFile.getCanonicalPath() + ": directory contains no files matching " + fileSpec1);
            return false;
        }
        this.log("checking file " + fleFile.getCanonicalPath() + ": directory contains " + fileList.size() + " file(s) matching " + fileSpec1);
        for (int i = 0; i < fileList.size(); ++i) {
            File checkFile = fileList.get(i);
            this.log("found " + checkFile.getCanonicalPath());
        }
        if (minNumOfFiles >= 0 && fileList.size() < minNumOfFiles) {
            this.log("found " + fileList.size() + " files, minimum expected " + minNumOfFiles + " files");
            return false;
        }
        if (maxNumOfFiles >= 0 && fileList.size() > maxNumOfFiles) {
            this.log("found " + fileList.size() + " files, maximum expected " + maxNumOfFiles + " files");
            return false;
        }
        this.lstResultList.addAll(fileList);
        return true;
    }

    private Vector<File> getFilelist(String folder, SOSOptionRegExp regexp, boolean withSubFolder, long minFileAge1, long maxFileAge1, long minFileSize1, long maxFileSize1, int skipFirstFiles1, int skipLastFiles1) throws Exception {
        Vector<File> filelist = new Vector<File>();
        Vector<File> temp = new Vector();
        File objFile = null;
        File[] subDir = null;
        objFile = new File(folder);
        subDir = objFile.listFiles();
        temp = this.getFilelist(folder, regexp);
        temp = this.filelistFilterAge(temp, minFileAge1, maxFileAge1);
        temp = this.filelistFilterSize(temp, minFileSize1, maxFileSize1);
        if ((minFileSize1 != -1L || minFileSize1 != -1L) && minFileAge1 == 0L && maxFileAge1 == 0L) {
            temp = this.filelistSkipFiles(temp, skipFirstFiles1, skipLastFiles1, "sort_size");
        } else if (minFileAge1 != 0L || maxFileAge1 != 0L) {
            temp = this.filelistSkipFiles(temp, skipFirstFiles1, skipLastFiles1, "sort_age");
        }
        filelist.addAll(temp);
        if (withSubFolder) {
            for (File element : subDir) {
                if (!element.isDirectory()) continue;
                filelist.addAll(this.getFilelist(element.getPath(), regexp, true, minFileAge1, maxFileAge1, minFileSize1, maxFileSize1, skipFirstFiles1, skipLastFiles1));
            }
        }
        return filelist;
    }

    public Vector<File> getFilelist(String folder, SOSOptionRegExp regexp) throws Exception {
        File[] files;
        Vector<File> filelist = new Vector<File>();
        if (folder == null || folder.isEmpty()) {
            throw new JobSchedulerException("a null value for param 'directory' is not allowed");
        }
        File f = new File(folder);
        if (!f.exists()) {
            String strM = JSMessages.JFO_I_0105.get(new Object[]{folder});
            this.logger.error(strM);
            throw new JobSchedulerException(strM);
        }
        filelist = new Vector();
        for (File file2 : files = f.listFiles((FilenameFilter)new SOSFilelistFilter(regexp.getValue(), regexp.getRegExpFlags()))) {
            if (!file2.isFile()) continue;
            filelist.add(file2);
        }
        return filelist;
    }

    private Vector<File> filelistFilterAge(Vector<File> filelist, long minAge, long maxAge) throws Exception {
        long interval;
        File file1;
        int i;
        Vector<File> newlist;
        long currentTime = System.currentTimeMillis();
        if (minAge != 0L) {
            newlist = new Vector<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file1 = filelist.get(i);
                interval = currentTime - file1.lastModified();
                if (interval < 0L) {
                    throw new JobSchedulerException("Cannot filter by file age. File [" + file1.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval < minAge) continue;
                newlist.add(file1);
            }
            filelist = newlist;
        }
        if (maxAge != 0L) {
            newlist = new Vector();
            for (i = 0; i < filelist.size(); ++i) {
                file1 = filelist.get(i);
                interval = currentTime - file1.lastModified();
                if (interval < 0L) {
                    throw new JobSchedulerException("Cannot filter by file age. File [" + file1.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval > maxAge) continue;
                newlist.add(file1);
            }
            filelist = newlist;
        }
        return filelist;
    }

    private Vector<File> filelistFilterSize(Vector<File> filelist, long minSize, long maxSize) throws Exception {
        File file1;
        int i;
        Vector<File> newlist;
        if (minSize > -1L) {
            newlist = new Vector<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file1 = filelist.get(i);
                if (file1.length() < minSize) continue;
                newlist.add(file1);
            }
            filelist = newlist;
        }
        if (maxSize > -1L) {
            newlist = new Vector();
            for (i = 0; i < filelist.size(); ++i) {
                file1 = filelist.get(i);
                if (file1.length() > maxSize) continue;
                newlist.add(file1);
            }
            filelist = newlist;
        }
        return filelist;
    }

    private Vector<File> filelistSkipFiles(Vector<File> filelist, int skipFirstFiles1, int skipLastFiles1, String sorting) throws Exception {
        File[] oArr = filelist.toArray(new File[filelist.size()]);
        if ("sort_size".equals(sorting)) {
            class SizeComparator
            implements Comparator<File> {
                SizeComparator() {
                }

                @Override
                public int compare(File o1, File o2) {
                    long val2;
                    int ret = 0;
                    long val1 = o1.length();
                    if (val1 < (val2 = o2.length())) {
                        ret = -1;
                    } else if (val1 == val2) {
                        ret = 0;
                    } else if (val1 > val2) {
                        ret = 1;
                    }
                    return ret;
                }
            }
            Arrays.sort(oArr, new SizeComparator());
        } else if ("sort_age".equals(sorting)) {
            class AgeComparator
            implements Comparator<File> {
                AgeComparator() {
                }

                @Override
                public int compare(File o1, File o2) {
                    long val2;
                    int ret = 0;
                    long val1 = o1.lastModified();
                    if (val1 > (val2 = o2.lastModified())) {
                        ret = -1;
                    } else if (val1 == val2) {
                        ret = 0;
                    } else if (val1 < val2) {
                        ret = 1;
                    }
                    return ret;
                }
            }
            Arrays.sort(oArr, new AgeComparator());
        }
        filelist = new Vector();
        for (int i = 0 + skipFirstFiles1; i < oArr.length - skipLastFiles1; ++i) {
            filelist.add(oArr[i]);
        }
        return filelist;
    }

    private void log(String msg) {
        try {
            this.logger.info(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStateText(String pstrStateText) {
    }

    public void setExitCode(int pintCC) {
    }

    public void setNextNodeState(String pstrNodeName) {
    }
}

