/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.i18n.annotation.I18NResourceBundle;
import java.io.File;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.file.JSFileOperationBase;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JSFolderSync
extends JSFileOperationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSFolderSync.class);
    private String JFO_I_0010 = "JFO_I_0010";
    private String JFO_I_0011 = "JFO_I_0011";
    private String JFO_I_0012 = "JFO_I_0012";
    private String JFO_I_0013 = "JFO_I_0013";

    public boolean Execute() {
        String methodName = "JSFolderSync::Execute";
        LOGGER.debug(String.format(this.Messages.getMsg("JSJ-I-110"), "JSFolderSync::Execute"));
        try {
            this.initialize();
            this.getOptions().file.checkMandatory();
            this.getOptions().target.checkMandatory();
            this.getOptions().file_spec.setRegExpFlags(2);
            this.flgOperationWasSuccessful = this.existsFile(this.getOptions().file, this.getOptions().file_spec, this.getOptions().min_file_age, this.getOptions().max_file_age, this.getOptions().min_file_size, this.getOptions().max_file_size, this.getOptions().skip_first_files, this.getOptions().skip_last_files, -1, -1);
            Vector vecSourceList = new Vector();
            vecSourceList.addAll(this.lstResultList);
            this.lstResultList = new Vector();
            this.flgOperationWasSuccessful = this.existsFile(this.getOptions().target, this.getOptions().file_spec, this.getOptions().min_file_age, this.getOptions().max_file_age, this.getOptions().min_file_size, this.getOptions().max_file_size, this.getOptions().skip_first_files, this.getOptions().skip_last_files, -1, -1);
            Vector vecTargetList = new Vector();
            vecTargetList.addAll(this.lstResultList);
            Vector<File> vecSyncList = new Vector<File>();
            for (File objSourceFile : vecSourceList) {
                String strSourceFileName = objSourceFile.getName();
                long lngLastModifiedSource = objSourceFile.lastModified();
                boolean flgFileIsOnTarget = false;
                boolean flgIsNewerOnSource = false;
                for (File objTargetFile : vecTargetList) {
                    if (!strSourceFileName.equalsIgnoreCase(objTargetFile.getName())) continue;
                    flgFileIsOnTarget = true;
                    if (lngLastModifiedSource > objTargetFile.lastModified()) {
                        flgIsNewerOnSource = true;
                    }
                    LOGGER.info(this.Messages.getMsg(this.JFO_I_0010, new Object[]{objSourceFile.getAbsoluteFile(), flgIsNewerOnSource}));
                    break;
                }
                if (!flgFileIsOnTarget) {
                    LOGGER.debug(this.Messages.getMsg(this.JFO_I_0011, new Object[]{objSourceFile.getName()}));
                    vecSyncList.add(objSourceFile);
                }
                if (!flgIsNewerOnSource) continue;
                LOGGER.debug(this.Messages.getMsg(this.JFO_I_0012, new Object[]{objSourceFile.getName()}));
                vecSyncList.add(objSourceFile);
            }
            LOGGER.info(this.Messages.getMsg(this.JFO_I_0013, new Object[]{vecSyncList.size()}));
            for (File objFile2Copy : vecSyncList) {
                String strFileName = objFile2Copy.getAbsolutePath();
                JSFile objF = new JSFile(strFileName);
                String strTargetFileName = this.getOptions().target.getValue() + objFile2Copy.getName();
                JSFile objTarget = new JSFile(strTargetFileName);
                objTarget.setLastModified(objFile2Copy.lastModified());
            }
            if (!vecSyncList.isEmpty()) {
                this.flgOperationWasSuccessful = true;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String strM = this.Messages.getMsg("JSJ-F-107", new Object[]{"JSFolderSync::Execute"});
            LOGGER.error(strM);
            throw new JobSchedulerException(strM);
        }
        LOGGER.debug(this.Messages.getMsg("JSJ-I-111", new Object[]{"JSFolderSync::Execute"}));
        return this.flgOperationWasSuccessful;
    }
}

