/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SOSSchedulerTextProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSchedulerTextProcessor.class);
    private String command;
    private HashMap commands;
    private File file;
    private String param = "";

    public SOSSchedulerTextProcessor(File file_, String command_) throws Exception {
        this.command = command_.trim().toLowerCase().replaceAll("\\s{2,}", " ");
        this.file = file_;
        this.param = this.command.replaceFirst("^[^\\s]+\\s*(.*)$", "$1");
        this.command = this.command.replaceFirst("^([^\\s]+)\\s*.*$", "$1");
        this.commands = new HashMap();
        this.commands.put("count", "1");
        this.commands.put("countCaseSensitive", "2");
        this.commands.put("add", "3");
        this.commands.put("read", "4");
        this.commands.put("insert", "5");
    }

    public String exexute() throws Exception {
        return this.go();
    }

    public String exexute(String command_) throws Exception {
        this.param = command_.replaceFirst("^[^\\s]+\\s*(.*)$", "$1");
        this.command = command_.replaceFirst("^([^\\s]+)\\s*.*$", "$1");
        return this.go();
    }

    public String exexute(String command_, String param_) throws Exception {
        this.command = command_;
        this.param = param_;
        return this.go();
    }

    private String count(boolean ignoreCase) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String rec = null;
        String s = this.param;
        if (ignoreCase) {
            s = s.toLowerCase();
        }
        int i = 0;
        while ((rec = reader.readLine()) != null) {
            if (ignoreCase) {
                rec = rec.toLowerCase();
            }
            while (rec.indexOf(s) >= 0) {
                ++i;
                rec = rec.replaceFirst(s, "");
            }
        }
        reader.close();
        return String.valueOf(i);
    }

    private String add() throws IOException {
        FileOutputStream f = new FileOutputStream(this.file, true);
        String s = "\n" + this.param;
        f.write(s.getBytes(), 0, s.length());
        return this.param;
    }

    private String insert() throws Exception {
        String line = this.param.replaceFirst("^[^\\s]+\\s*(.*).*$", "$1");
        String c = line.replaceFirst("^.*\\{char:\\s*([0-9]+)\\s*\\}.*$", "$1");
        if (!c.equals(line)) {
            int intVal = 0;
            try {
                intVal = Integer.parseInt(c, 10);
            }
            catch (NumberFormatException e) {
                LOGGER.warn(c + " is not a valid number. 0 assumed");
                intVal = 0;
            }
            char charVal = (char)intVal;
            String s = String.valueOf(charVal);
            line = line.replaceFirst("\\{char:\\s*" + c + "\\s*\\}", s);
        }
        line = line + "\n";
        this.param = this.param.replaceFirst("^([^\\s]+)\\s*.*$", "$1");
        if ("last".equals(this.param)) {
            this.add();
        } else {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String rec = "";
            int i = 0;
            if ("first".equals(this.param)) {
                i = 1;
            } else {
                try {
                    i = Integer.parseInt(this.param);
                }
                catch (NumberFormatException e) {
                    LOGGER.error(this.param + " is not a valid line number: 0 assumed");
                    i = 0;
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            --i;
            while ((rec = reader.readLine()) != null && i > 0) {
                rec = rec + "\n";
                baos.write(rec.getBytes());
                --i;
            }
            baos.write(line.getBytes());
            if (rec != null) {
                rec = rec + "\n";
                baos.write(rec.getBytes());
            }
            while ((rec = reader.readLine()) != null) {
                rec = rec + "\n";
                baos.write(rec.getBytes());
            }
            reader.close();
            FileOutputStream f = new FileOutputStream(this.file, false);
            f.write(baos.toByteArray());
            f.close();
        }
        return this.param;
    }

    private String read() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String rec = "";
        String erg = "";
        int i = 0;
        if ("first".equals(this.param)) {
            i = 1;
        } else if (!"last".equals(this.param)) {
            try {
                i = Integer.parseInt(this.param);
            }
            catch (NumberFormatException e) {
                LOGGER.error(this.param + " is not a valid line number: 0 assumed");
                i = 0;
            }
        }
        while ((rec = reader.readLine()) != null && ("last".equals(this.param) || i > 0)) {
            erg = rec;
            --i;
        }
        if (!"last".equals(this.param) && rec == null && i > 0) {
            erg = "(eof)";
        }
        reader.close();
        return erg;
    }

    private String go() throws Exception {
        String erg = "";
        if ("".equals(this.param)) {
            throw new Exception("Param missing in: " + this.command);
        }
        int command_id = this.getCommandId();
        switch (command_id) {
            case 1: {
                return this.count(true);
            }
            case 2: {
                return this.count(false);
            }
            case 3: {
                return this.add();
            }
            case 4: {
                return this.read();
            }
            case 5: {
                return this.insert();
            }
        }
        return erg;
    }

    private int getCommandId() throws Exception {
        if (this.commands.get(this.command) == null) {
            throw new Exception("Unknown command: (not in count, add, read) " + this.command);
        }
        String s = this.commands.get(this.command).toString();
        int commandId = 0;
        if (s != null) {
            commandId = Integer.parseInt(s);
        }
        return commandId;
    }

    public String getCommand() {
        return this.command;
    }

    public String getParam() {
        return this.param;
    }
}

