/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSCsvFile;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Supervisor_client;
import sos.xml.SOSXMLXPath;

public class JobSchedulerDequeueEventsJob
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerDequeueEventsJob.class);
    private String eventFilename = "";
    private String eventFilenamePrefix = "";
    private String eventAction = "";
    private String eventSupervisorSchedulerHost = "";
    private int eventSupervisorSchedulerPort = 0;
    private int eventSupervisorSchedulerTimeout = 0;
    private String eventSupervisorSchedulerJobChainName = "";
    private HashMap<String, String> parameters = null;
    public final String conSVNVersion = "$Id$";

    public boolean spooler_process() {
        boolean rc = true;
        int eventCount = 0;
        int eventMinFieldCount = 10;
        int eventMaxFieldCount = 11;
        File eventFile = null;
        try {
            this.setParameters(new HashMap<String, String>());
            Supervisor_client supervisor = null;
            try {
                supervisor = this.spooler.supervisor_client();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                HashMap taskParams = this.getTaskParams(this.spooler_task.params());
                if (taskParams != null) {
                    this.getParameters().putAll(taskParams);
                }
                if (this.spooler_job.order_queue() != null) {
                    this.getParameters().putAll(this.convertVariableSet2HashMap(this.spooler_task.order().params()));
                }
                if (this.isNotEmpty(this.getParameters().get("event_file"))) {
                    this.setEventFilename(this.getParameters().get("event_file"));
                    LOGGER.debug(".. parameter [event_file]: " + this.getEventFilename());
                } else {
                    this.setEventFilename(this.spooler.log_dir() + "/scheduler.events");
                }
                if (this.isNotEmpty(this.getParameters().get("supervisor_host"))) {
                    this.setEventSupervisorSchedulerHost(this.getParameters().get("supervisor_host"));
                    LOGGER.debug(".. parameter [supervisor_host]: " + this.getEventSupervisorSchedulerHost());
                } else if (supervisor != null && this.isNotEmpty(supervisor.hostname())) {
                    this.setEventSupervisorSchedulerHost(supervisor.hostname());
                } else {
                    this.setEventSupervisorSchedulerHost(this.spooler.hostname());
                }
                if (this.isNotEmpty(this.getParameters().get("supervisor_port"))) {
                    try {
                        this.setEventSupervisorSchedulerPort(Integer.parseInt(this.getParameters().get("supervisor_port")));
                        LOGGER.debug(".. parameter [supervisor_port]: " + this.getEventSupervisorSchedulerPort());
                    }
                    catch (Exception ex) {
                        throw new JobSchedulerException("illegal non-numeric value for Supervisor Job Scheduler port specified: " + this.getParameters().get("supervisor_port"), (Throwable)ex);
                    }
                } else if (supervisor != null && this.isNotEmpty(supervisor.hostname())) {
                    this.setEventSupervisorSchedulerPort(supervisor.tcp_port());
                } else {
                    this.setEventSupervisorSchedulerPort(this.spooler.tcp_port());
                }
                if (this.isNotEmpty(this.getParameters().get("supervisor_timeout"))) {
                    try {
                        this.setEventSupervisorSchedulerTimeout(Integer.parseInt(this.getParameters().get("supervisor_timeout")));
                        LOGGER.debug(".. parameter [supervisor_timeout]: " + this.getEventSupervisorSchedulerTimeout());
                    }
                    catch (Exception ex) {
                        throw new JobSchedulerException("illegal non-numeric value for Supervisor Job Scheduler timeout specified: " + this.getParameters().get("supervisor_timeout"), (Throwable)ex);
                    }
                } else {
                    this.setEventSupervisorSchedulerTimeout(15);
                }
                if (this.isNotEmpty(this.getParameters().get("supervisor_job_chain"))) {
                    this.setEventSupervisorSchedulerJobChainName(this.getParameters().get("supervisor_job_chain"));
                    LOGGER.debug(".. parameter [supervisor_job_chain]: " + this.getEventSupervisorSchedulerJobChainName());
                } else {
                    this.setEventSupervisorSchedulerJobChainName("/sos/events/scheduler_event_service");
                }
            }
            catch (Exception e) {
                throw new JobSchedulerException("error occurred processing parameters: " + e.getMessage(), (Throwable)e);
            }
            try {
                eventFile = new File(this.getEventFilename());
                if (!eventFile.exists()) {
                    LOGGER.info("event file does not exist: " + eventFile.getCanonicalPath());
                } else if (!eventFile.canWrite()) {
                    throw new JobSchedulerException("required write permission for event file is missing: " + eventFile.getCanonicalPath());
                }
                JSCsvFile hwFile = new JSCsvFile(this.getEventFilename() + "~");
                if (!hwFile.exists()) {
                    if (!eventFile.renameTo((File)hwFile)) {
                        throw new JobSchedulerException(String.format("could not create working copy of event file: renaming %1$s to %2$s", eventFile.getCanonicalPath(), hwFile.getCanonicalPath()));
                    }
                } else {
                    LOGGER.info("working copy of event file found - starting to process this file: " + hwFile.getCanonicalPath());
                    if (!hwFile.canWrite()) {
                        throw new JobSchedulerException(String.format("required write permission for event file working copy is missing: %1$s", hwFile.getCanonicalPath()));
                    }
                }
                SOSSchedulerCommand schedulerCommand = new SOSSchedulerCommand();
                schedulerCommand.setHost(this.getEventSupervisorSchedulerHost());
                schedulerCommand.setPort(this.getEventSupervisorSchedulerPort());
                schedulerCommand.setTimeout(this.getEventSupervisorSchedulerTimeout());
                schedulerCommand.connect();
                String[] strValues = null;
                hwFile.setColumnDelimiter("\t");
                while ((strValues = hwFile.readCSVLine()) != null) {
                    LOGGER.info("--->" + this.csvLineToSting(strValues));
                    if (strValues.length < eventMinFieldCount) {
                        throw new JobSchedulerException(String.format("number of fields in event file [%1$s] is too small: %2$s", eventFile.getCanonicalPath(), strValues.length));
                    }
                    ++eventCount;
                    LOGGER.info("... will be processed");
                    LOGGER.info(strValues[0] + " event");
                    String command = "<add_order title=\"dequeued event\" job_chain=\"" + this.getEventSupervisorSchedulerJobChainName() + "\">";
                    command = command + "<params>";
                    command = command + "<param name=\"action\"          value=\"" + this.getValue(strValues[0]) + "\"/>";
                    command = command + "<param name=\"scheduler_host\"  value=\"" + this.getValue(strValues[1]) + "\"/>";
                    command = command + "<param name=\"scheduler_port\"  value=\"" + this.getValue(strValues[2]) + "\"/>";
                    command = command + "<param name=\"job_chain\"       value=\"" + this.getValue(strValues[3]) + "\"/>";
                    command = command + "<param name=\"order_id\"        value=\"" + this.getValue(strValues[4]) + "\"/>";
                    command = command + "<param name=\"job_name\"        value=\"" + this.getValue(strValues[5]) + "\"/>";
                    command = command + "<param name=\"event_class\"     value=\"" + this.getValue(strValues[6]) + "\"/>";
                    command = command + "<param name=\"event_id\"        value=\"" + this.getValue(strValues[7]) + "\"/>";
                    command = command + "<param name=\"exit_code\"       value=\"" + this.getValue(strValues[8]) + "\"/>";
                    command = command + "<param name=\"created\"         value=\"" + this.getValue(strValues[9]) + "\"/>";
                    int expiration_column = 1;
                    if (strValues.length > eventMinFieldCount && strValues[10].indexOf("=") == -1) {
                        if (this.isNotEmpty(strValues[10])) {
                            command = command + "<param name=\"expires\"        value=\"" + strValues[10] + "\"/>";
                        }
                        expiration_column = 0;
                    }
                    for (int i = eventMaxFieldCount - expiration_column; i < strValues.length; ++i) {
                        int posFound = strValues[i].indexOf("=");
                        if (posFound == -1) continue;
                        command = command + "<param name=\"" + strValues[i].substring(0, posFound) + "\"        value=\"" + strValues[i].substring(posFound + 1) + "\"/>";
                    }
                    command = command + "</params></add_order>";
                    LOGGER.info(String.format(".. sending command to remote Job Scheduler [%1$s:%2$s]: %3$s", this.getEventSupervisorSchedulerHost(), this.getEventSupervisorSchedulerPort(), command));
                    schedulerCommand.sendRequest(command);
                    SOSXMLXPath answer = new SOSXMLXPath(new StringBuffer(schedulerCommand.getResponse()));
                    String errorText = answer.selectSingleNodeValue("//ERROR/@text");
                    if (!this.isNotEmpty(errorText)) continue;
                    throw new JobSchedulerException(String.format("could not send command to Supervisor Job Scheduler [%1$s:%2$s]: %3$s", this.getEventSupervisorSchedulerHost(), this.getEventSupervisorSchedulerPort(), errorText));
                }
                schedulerCommand.disconnect();
                hwFile.close();
                if (!hwFile.delete()) {
                    LOGGER.info("could not delete temporary working copy of event file, re-trying later");
                    hwFile.deleteOnExit();
                }
            }
            catch (Exception e) {
                throw new JobSchedulerException("error occurred forwarding events to Supervisor Job Scheduler [" + this.getEventSupervisorSchedulerHost() + ":" + this.getEventSupervisorSchedulerPort() + "]: " + e.getMessage(), (Throwable)e);
            }
            if (eventCount > 0) {
                LOGGER.info(eventCount + " events dequeued to Supervisor Job Scheduler [" + this.getEventSupervisorSchedulerHost() + ":" + this.getEventSupervisorSchedulerPort() + "] from event file: " + eventFile.getCanonicalPath());
            }
            return this.spooler_job.order_queue() != null ? rc : false;
        }
        catch (Exception e) {
            this.spooler_log.warn("error occurred dequeueing events: " + e.getMessage());
            return false;
        }
    }

    private String csvLineToSting(String[] strValues) {
        String str = "";
        for (String strValue : strValues) {
            str = str + ";" + strValue;
        }
        if (!str.isEmpty()) {
            str = str.substring(1);
        }
        return str;
    }

    private String getValue(String s) {
        if (s == null || "null".equals(s)) {
            return "";
        }
        return s;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getEventFilename() {
        return this.eventFilename;
    }

    public void setEventFilename(String eventFilename) {
        this.eventFilename = eventFilename;
    }

    public String getEventSupervisorSchedulerHost() {
        return this.eventSupervisorSchedulerHost;
    }

    public void setEventSupervisorSchedulerHost(String eventSupervisorSchedulerHost) {
        this.eventSupervisorSchedulerHost = eventSupervisorSchedulerHost;
    }

    public int getEventSupervisorSchedulerPort() {
        return this.eventSupervisorSchedulerPort;
    }

    public void setEventSupervisorSchedulerPort(int eventSupervisorSchedulerPort) {
        this.eventSupervisorSchedulerPort = eventSupervisorSchedulerPort;
    }

    public String getEventFilenamePrefix() {
        return this.eventFilenamePrefix;
    }

    public void setEventFilenamePrefix(String eventFilenamePrefix) {
        this.eventFilenamePrefix = eventFilenamePrefix;
    }

    public String getEventSupervisorSchedulerJobChainName() {
        return this.eventSupervisorSchedulerJobChainName;
    }

    public void setEventSupervisorSchedulerJobChainName(String eventSupervisorSchedulerJobChainName) {
        this.eventSupervisorSchedulerJobChainName = eventSupervisorSchedulerJobChainName;
    }

    public String getEventAction() {
        return this.eventAction;
    }

    public void setEventAction(String eventAction) {
        this.eventAction = eventAction;
    }

    public int getEventSupervisorSchedulerTimeout() {
        return this.eventSupervisorSchedulerTimeout;
    }

    public void setEventSupervisorSchedulerTimeout(int eventSupervisorSchedulerTimeout) {
        this.eventSupervisorSchedulerTimeout = eventSupervisorSchedulerTimeout;
    }
}

