/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.managed;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.scheduler.managed.JobSchedulerManagedJob;
import sos.scheduler.managed.JobSchedulerManagedObject;
import sos.scheduler.managed.db.JobSchedulerManagedDBReportJobOptions;
import sos.spooler.Job_impl;
import sos.spooler.Order;
import sos.util.SOSArguments;

public class JobSchedulerManagedDatabaseJob
extends JobSchedulerManagedJob {
    protected boolean flgColumn_names_case_sensitivity = false;
    protected boolean flgAdjust_column_names = false;
    protected JobSchedulerManagedDBReportJobOptions objOptions = null;
    private static final String PARAMETER_NAME_VALUE = "name_value";
    private static final String PARAMETER_SCHEDULER_ORDER_SCHEMA = "scheduler_order_schema";
    private static final String PARAMETER_SCHEDULER_ORDER_USER_NAME = "scheduler_order_user_name";
    private static final String PARAMETER_AUTO_COMMIT = "auto_commit";
    private static final String PARAMETER_RESULTSET_AS_PARAMETERS = "resultset_as_parameters";
    private static final String PARAMETER_RESULTSET_AS_WARNING = "resultset_as_warning";
    private static final String PARAMETER_SCHEDULER_ORDER_IS_USER_JOB = "scheduler_order_is_user_job";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerManagedDatabaseJob.class);
    private final Random rand = new Random();
    private boolean userJob = false;
    private String ip = null;
    private String revokeUser = "";
    private String revokeUserQuoted = "";
    private boolean autoCommit = false;

    public boolean spooler_init() {
        return super.spooler_init();
    }

    protected boolean getBoolParam(String pstrParamName, boolean pflgDefaultValue) {
        String strValue;
        boolean flgRet = pflgDefaultValue;
        if (this.orderPayload != null && (strValue = this.orderPayload.var(pstrParamName)) != null && ("1".equals(strValue) || "true".equalsIgnoreCase(strValue))) {
            flgRet = true;
        }
        return flgRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean spooler_process() {
        hasWarningsOrErrors = false;
        localConnection = null;
        try {
            this.objOptions = new JobSchedulerManagedDBReportJobOptions();
        }
        catch (Exception e2) {
            throw new JobSchedulerException((Throwable)e2);
        }
        order = null;
        command = "";
        this.orderPayload = null;
        realOrderParams = null;
        rc = true;
        resultsetAsWarning = false;
        resultsetAsParameters = false;
        resultsetNameValue = false;
        execReturnsResultSet = false;
        this.flgAdjust_column_names = true;
        this.flgColumn_names_case_sensitivity = false;
        this.autoCommit = false;
        try {
            super.prepareParams();
            this.flgAdjust_column_names = this.objOptions.Adjust_column_names.value();
            this.flgColumn_names_case_sensitivity = this.objOptions.Column_names_case_sensitivity.value();
            if (this.orderPayload != null && this.orderPayload.var("scheduler_order_is_user_job") != null && "1".equals(this.orderPayload.var("scheduler_order_is_user_job"))) {
                this.userJob = true;
            }
            if (this.orderPayload != null && this.orderPayload.var("resultset_as_warning") != null && ("1".equals(this.orderPayload.var("resultset_as_warning")) || "true".equalsIgnoreCase(this.orderPayload.var("resultset_as_warning")))) {
                resultsetAsWarning = true;
            }
            execReturnsResultSet = this.objOptions.exec_returns_resultset.value();
            if (this.orderPayload != null && this.orderPayload.var("resultset_as_parameters") != null && ("1".equals(this.orderPayload.var("resultset_as_parameters")) || "true".equalsIgnoreCase(this.orderPayload.var("resultset_as_parameters")) || "name_value".equalsIgnoreCase(this.orderPayload.var("resultset_as_parameters")))) {
                resultsetAsParameters = true;
                if ("name_value".equalsIgnoreCase(this.orderPayload.var("resultset_as_parameters"))) {
                    resultsetNameValue = true;
                }
            }
            if (this.orderPayload != null && this.orderPayload.var("auto_commit") != null && ("1".equals(this.orderPayload.var("auto_commit")) || "true".equalsIgnoreCase(this.orderPayload.var("auto_commit")))) {
                this.autoCommit = true;
            }
            try {
                if (this.userJob) {
                    this.checkOldTempUsers();
                    localConnection = this.getUserConnection(this.orderPayload.var("scheduler_order_user_name"), this.orderPayload.var("scheduler_order_schema"));
                } else {
                    localConnection = JobSchedulerManagedObject.getOrderConnection((Job_impl)this);
                    localConnection.connect();
                }
            }
            catch (Exception e) {
                throw new JobSchedulerException("error occurred establishing database connection: " + e.getMessage(), (Throwable)e);
            }
            localConnection.setExecReturnsResultSet(execReturnsResultSet);
            try {
                commandScript = this.getJobScript();
                this.spooler_log.debug9("setting 'command_script' value from script tag of job: " + commandScript);
                if (this.orderJob) {
                    command = JobSchedulerManagedObject.getOrderCommand((Job_impl)this, commandScript);
                }
                if (command == null || command.isEmpty()) {
                    command = JobSchedulerManagedObject.getJobCommand((Job_impl)this);
                }
                if (command == null) throw new JobSchedulerException("command is empty");
                if (command.isEmpty()) {
                    throw new JobSchedulerException("command is empty");
                }
            }
            catch (Exception e) {
                throw new JobSchedulerException("no database command found: " + e.getMessage(), (Throwable)e);
            }
            command = command.replaceAll("(\\$|\u00a7)\\{scheduler_order_job_name\\}", this.getJobName());
            command = command.replaceAll("(\\$|\u00a7)\\{scheduler_order_job_id\\}", Integer.toString(this.getJobId()));
            command = command.replaceAll("(\\$|\u00a7)\\{scheduler_id\\}", this.spooler.id());
            if (this.orderPayload != null) {
                command = JobSchedulerManagedObject.replaceVariablesInCommand(command, this.orderPayload);
            }
            if (this.orderJob) {
                order = this.spooler_task.order();
                realOrderParams = order.params();
                command = command.replaceAll("(\\$|\u00a7)\\{scheduler_order_id\\}", order.id());
                command = command.replaceAll("(\\$|\u00a7)\\{scheduler_order_managed_id\\}", "0");
                this.spooler_log.info("executing database statement(s) for managed order [" + order.id() + "]: " + command);
            } else {
                this.spooler_log.info("executing database statement(s): " + command);
            }
            this.executeStatements(localConnection, command);
            this.spooler_log.info("database statement(s) executed.");
            if (!resultsetAsWarning && !resultsetAsParameters || localConnection.getResultSet() == null) ** GOTO lbl89
            warning = "";
            rowCount = 0;
            result = null;
            resultsetTrueReady = false;
            block25: while (true) {
                if (!(result = localConnection.get()).isEmpty() && !resultsetTrueReady) {
                    orderParamKey = "";
                    ++rowCount;
                } else {
                    if (warning != null && !warning.isEmpty() && resultsetAsWarning) {
                        rc = false;
                        this.spooler_log.warn(warning);
                        hasWarningsOrErrors = true;
                    }
lbl89:
                    // 4 sources

                    if (hasWarningsOrErrors) {
                        this.spooler_task.end();
                    }
                    warning = rc != false && this.orderJob != false;
                    try {
                        if (localConnection != null && !this.userJob) {
                            localConnection.disconnect();
                        }
                    }
                    catch (Exception rowCount) {
                        // empty catch block
                    }
                    if (this.userJob == false) return warning;
                    this.closeUserConnection(localConnection);
                    JobSchedulerManagedDatabaseJob.updateRunTime(order, this.getConnection());
                    try {
                        this.getConnection().commit();
                        return warning;
                    }
                    catch (Exception rowCount) {
                        // empty catch block
                    }
                    return warning;
                }
                columnCount = 0;
                warning = "execution terminated with warning:";
                resultsetNameValueReady = false;
                var18_29 = result.keySet().iterator();
                while (true) {
                    if (!var18_29.hasNext()) continue block25;
                    key = (String)var18_29.next();
                    ++columnCount;
                    if (key == null || key.isEmpty()) continue;
                    value = (String)result.get(key);
                    warning = warning + " " + key + "=" + value;
                    if (!resultsetAsParameters || order == null || resultsetNameValueReady) continue;
                    if (resultsetNameValue) {
                        if (columnCount == 1) {
                            orderParamKey = value;
                            continue;
                        }
                        if (columnCount != 2) continue;
                        realOrderParams.set_var(orderParamKey, value);
                        resultsetNameValueReady = true;
                        if (resultsetAsWarning) continue;
                        continue block25;
                    }
                    if (rowCount != 1) continue;
                    realOrderParams.set_var(key, value);
                    resultsetTrueReady = true;
                }
                break;
            }
        }
        catch (Exception e) {
            this.spooler_log.warn("error occurred processing managed order [" + (order != null ? "Job Chain: " + order.job_chain().name() + ", ID:" + order.id() : "(none)") + "] : " + e);
            if (this.userJob) {
                try {
                    this.writeError(e, order);
                }
                catch (Exception e1) {
                    JobSchedulerManagedDatabaseJob.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            this.spooler_task.end();
            var12_21 = false;
            return var12_21;
        }
        finally {
            try {
                if (localConnection != null && !this.userJob) {
                    localConnection.disconnect();
                }
            }
            catch (Exception var13_23) {}
            if (this.userJob) {
                this.closeUserConnection(localConnection);
                JobSchedulerManagedDatabaseJob.updateRunTime(order, this.getConnection());
                try {
                    this.getConnection().commit();
                }
                catch (Exception var13_24) {}
            }
        }
    }

    public static void updateRunTime(Order order, SOSConnection conn) {
        block7: {
            try {
                String id = order.id();
                String nextStart = conn.getSingleValue("SELECT \"NEXT_START\" FROM " + JobSchedulerManagedObject.getTableManagedUserJobs() + " WHERE \"ID\"=" + id);
                if (nextStart == null || nextStart.isEmpty()) {
                    try {
                        LOGGER.debug("No next start for order " + id + ". Deleting order.");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    conn.execute("DELETE FROM " + JobSchedulerManagedObject.getTableManagedUserJobs() + " WHERE  \"ID\"=" + id);
                    conn.commit();
                    break block7;
                }
                String nextTime = conn.getSingleValue("SELECT " + nextStart);
                LOGGER.debug("next Start for this order: " + nextTime);
                String jobRunTime = "CONCAT('<run_time let_run = \"yes\"><date date=\"',DATE('" + nextTime + "'),'\"><period single_start=\"', TIME('" + nextTime + "'), '\"/></date></run_time>')";
                conn.execute("UPDATE " + JobSchedulerManagedObject.getTableManagedUserJobs() + " SET \"RUN_TIME\"=" + jobRunTime + ", \"NEXT_TIME\"='" + nextTime + "', UPDATED=1 WHERE  \"ID\"=" + id);
            }
            catch (Exception e) {
                try {
                    LOGGER.warn("Error occured setting next runtime: " + e);
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void writeError(Exception e, Order order) throws Exception {
        try {
            String currentErrorText = e.getMessage();
            int errCode = 0;
            for (Throwable thr = e.getCause(); thr != null; thr = thr.getCause()) {
                if (!(thr instanceof SQLException)) continue;
                SQLException sqlEx = (SQLException)thr;
                currentErrorText = sqlEx.getMessage();
                errCode = sqlEx.getErrorCode();
                break;
            }
            if (currentErrorText != null && currentErrorText.length() > 250) {
                currentErrorText = currentErrorText.substring(currentErrorText.length() - 250);
            }
            this.getConnection().execute("UPDATE " + JobSchedulerManagedObject.getTableManagedUserJobs() + " SET \"ERROR\"=1, \"ERROR_TEXT\"='" + currentErrorText.replaceAll("'", "''") + "', \"ERROR_CODE\"='" + errCode + "' WHERE  \"ID\"='" + order.id() + "'");
            this.getConnection().commit();
        }
        catch (Exception ex) {
            try {
                this.spooler_log.warn("Error occured writing error: " + ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected SOSConnection getUserConnection(String user, String schema) throws Exception {
        SOSConnection userConnection;
        if (this.ip == null) {
            try {
                this.ip = this.getConnection().getSingleValue("SELECT CONVERT(SUBSTRING_INDEX(CURRENT_USER(),_utf8'@',-1) USING latin1)");
            }
            catch (Exception e) {
                this.spooler_log.debug1("Could not optain ip Address for this host. Generated database users will be for all hosts.");
                this.ip = "%";
            }
        }
        String userLeft = user.split("@")[0];
        String userRight = user.split("@")[1];
        String query = "SHOW GRANTS FOR '" + userLeft + "'@'" + userRight + "'";
        List grants = this.getConnection().getArray(query);
        this.getConnection().commit();
        String newUserName = this.createRandomString();
        String password = this.createRandomString();
        this.revokeUser = "'" + newUserName + "'@'" + this.ip + "'";
        this.revokeUserQuoted = "\\'" + newUserName + "\\'@\\'" + this.ip + "\\'";
        String[] newGrants = new String[grants.size()];
        int grantCounter = 0;
        for (String[] map : grants) {
            String grant = (String)map.values().iterator().next();
            String newGrant = grant.replaceAll("TO '" + userLeft + "'@", "TO '" + newUserName + "'@");
            newGrant = newGrant.replaceAll("@'" + userRight + "'", "@'" + this.ip + "'");
            newGrant = newGrant.replaceAll("BY PASSWORD '.*'", "BY '" + password + "'");
            this.spooler_log.debug6("Original GRANT statement: " + grant);
            this.spooler_log.debug6("New GRANT statement: " + newGrant);
            newGrants[grantCounter] = newGrant;
            ++grantCounter;
        }
        try {
            this.getConnection().execute("INSERT INTO " + JobSchedulerManagedObject.getTableManagedTempUsers() + "(\"NAME\", \"STATUS\", \"MODIFIED\") VALUES ('" + this.revokeUserQuoted + "', 'BEFORE_CREATION', %now)");
            this.getConnection().commit();
        }
        catch (Exception map) {
            // empty catch block
        }
        this.spooler_log.debug3("executing new GRANT statements... ");
        for (String newGrant : newGrants) {
            this.getConnection().execute(newGrant);
        }
        try {
            this.getConnection().execute("UPDATE " + JobSchedulerManagedObject.getTableManagedTempUsers() + " SET \"STATUS\"='CREATED', \"MODIFIED\"= %now WHERE \"NAME\"='" + this.revokeUserQuoted + "'");
        }
        catch (Exception map) {
            // empty catch block
        }
        this.getConnection().commit();
        Properties spoolerProp = this.getJobSettings().getSection("spooler");
        String dbProperty = spoolerProp.getProperty("db").replaceAll("jdbc:", "-url=jdbc:");
        dbProperty = dbProperty.substring(dbProperty.indexOf(45));
        SOSArguments arguments = new SOSArguments(dbProperty);
        try {
            this.spooler_log.debug6("..creating user connection object");
            userConnection = SOSConnection.createInstance((String)spoolerProp.getProperty("db_class"), (String)arguments.asString("-class=", ""), (String)arguments.asString("-url=", ""), (String)newUserName, (String)password);
        }
        catch (Exception e) {
            throw new JobSchedulerException("error occurred establishing database connection: " + e.getMessage());
        }
        userConnection.connect();
        if (schema != null && !schema.isEmpty()) {
            userConnection.execute("use " + schema);
        }
        userConnection.commit();
        return userConnection;
    }

    private String createRandomString() {
        String random = Long.toString(Math.abs(this.rand.nextLong()), 36);
        if (random.length() > 16) {
            return random.substring(0, 16);
        }
        if (random.length() < 8) {
            return this.createRandomString();
        }
        return random;
    }

    protected void closeUserConnection(SOSConnection conn) {
        try {
            if (conn != null) {
                conn.disconnect();
            }
            this.spooler_log.debug3("executing revoke statements to delete temporary user...");
            try {
                this.getConnection().execute("UPDATE " + JobSchedulerManagedObject.getTableManagedTempUsers() + " SET \"STATUS\"='BEFORE_DELETION', \"MODIFIED\"= %now WHERE \"NAME\"='" + this.revokeUserQuoted + "'");
                this.getConnection().commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deleteUser(this.revokeUser);
            this.getConnection().execute("DELETE FROM " + JobSchedulerManagedObject.getTableManagedTempUsers() + " WHERE \"NAME\"='" + this.revokeUserQuoted + "'");
        }
        catch (Exception e) {
            this.spooler_log.warn("Error occurred removing user: " + e);
        }
    }

    private void deleteUser(String userName) throws Exception {
        String query = "SHOW GRANTS FOR " + userName;
        List grants = this.getConnection().getArray(query);
        this.getConnection().commit();
        String[] revokes = new String[grants.size()];
        int counter = grants.size() - 1;
        for (Map map : grants) {
            String grant = ((String)map.values().iterator().next()).toString();
            String revoke = grant.replaceAll(" WITH GRANT OPTION", " ");
            revoke = revoke.replaceAll("GRANT ", "REVOKE ");
            revokes[counter] = revoke = revoke.replaceAll(" TO ", " FROM ");
            --counter;
        }
        for (String revoke : revokes) {
            if (revoke == null || revoke.isEmpty()) continue;
            this.getConnection().execute(revoke);
        }
        this.getConnection().execute("REVOKE ALL PRIVILEGES ON *.* FROM " + userName);
        this.getConnection().execute("REVOKE GRANT OPTION ON *.* FROM " + userName);
        this.getConnection().execute("DROP USER " + userName);
    }

    private void checkOldTempUsers() {
        try {
            List users = this.getConnection().getArray("SELECT \"NAME\", \"STATUS\" FROM " + JobSchedulerManagedObject.getTableManagedTempUsers() + " WHERE DATEDIFF(%now,\"MODIFIED\")>1");
            this.getConnection().commit();
            for (Map user : users) {
                try {
                    this.spooler_log.debug3("User " + (String)user.get("name") + " has not been properly deleted and was left with status " + (String)user.get("status") + ". Trying to delete him now...");
                    this.deleteUser((String)user.get("name"));
                }
                catch (Exception e) {
                    this.spooler_log.warn("Error occured deleting old temporary user " + (String)user.get("name") + " : " + e);
                }
            }
        }
        catch (Exception e) {
            this.spooler_log.warn("Error occured deleting old temporary users: " + e);
        }
    }

    protected void executeStatements(SOSConnection conn, String command) throws Exception {
        try {
            conn.setAutoCommit(this.autoCommit);
            conn.executeStatements(command);
        }
        catch (Exception e) {
            throw new JobSchedulerException((Throwable)e);
        }
        finally {
            conn.setAutoCommit(false);
        }
    }
}

