/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.managed;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sos.connection.SOSMySQLConnection;
import sos.scheduler.managed.JobSchedulerManagedDatabaseJob;
import sos.scheduler.managed.JobSchedulerManagedJob;
import sos.scheduler.managed.JobSchedulerManagedObject;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Variable_set;
import sos.util.SOSDate;

public class JobSchedulerManagedUserJob
extends JobSchedulerManagedJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerManagedUserJob.class);
    private int maxOrderCount = 1000;
    private List<Map<String, String>> orders = new ArrayList<Map<String, String>>();
    private Iterator<Map<String, String>> orderIterator = null;
    private String jobChainName = "user_database_statements";

    public boolean spooler_init() {
        if (!super.spooler_init()) {
            return false;
        }
        try {
            if (!(this.getConnection() instanceof SOSMySQLConnection)) {
                this.spooler_log.warn("This Job only works with MySQL databases.");
                return false;
            }
            List hostPort = this.getConnection().getArray("SELECT \"NAME\", \"WERT\" FROM " + JobSchedulerManagedObject.getTableManagedUserVariables() + " WHERE \"NAME\"='scheduler_managed_user_job.port' OR \"NAME\"='scheduler_managed_user_job.host'");
            this.getConnection().commit();
            boolean correctSettings = true;
            if (hostPort.size() < 2) {
                correctSettings = false;
            }
            String schedUdp = "";
            String schedHost = "";
            for (Map line : hostPort) {
                String name = (String)line.get("name");
                String wert = (String)line.get("wert");
                if (name != null && "scheduler_managed_user_job.port".equals(name)) {
                    schedUdp = wert;
                }
                if (name == null || !"scheduler_managed_user_job.host".equals(name)) continue;
                schedHost = wert;
            }
            String udp = "" + this.spooler.udp_port();
            if (!schedUdp.equals(udp) || !schedHost.equals(this.spooler.hostname())) {
                correctSettings = false;
            }
            if (!correctSettings) {
                this.getConnection().execute("DELETE FROM " + JobSchedulerManagedObject.getTableManagedUserVariables() + " WHERE \"NAME\"='scheduler_managed_user_job.port'");
                this.getConnection().execute("DELETE FROM " + JobSchedulerManagedObject.getTableManagedUserVariables() + " WHERE \"NAME\"='scheduler_managed_user_job.host'");
                this.getConnection().execute("INSERT INTO " + JobSchedulerManagedObject.getTableManagedUserVariables() + " (\"NAME\", \"WERT\") VALUES ('scheduler_managed_user_job.port','" + udp + "')");
                this.getConnection().execute("INSERT INTO " + JobSchedulerManagedObject.getTableManagedUserVariables() + " (\"NAME\", \"WERT\") VALUES ('scheduler_managed_user_job.host','" + this.spooler.hostname() + "')");
                this.getConnection().commit();
            }
        }
        catch (Exception e) {
            try {
                this.spooler_log.warn("Could not register scheduler host and port in database. SCHEDULER_JOB_RUN will not succeed. " + e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.spooler.job_chain_exists(this.jobChainName)) {
                return true;
            }
            this.spooler_log.debug3("Creating jobchain user_database_statements.");
            Job_chain jobChain = this.spooler.create_job_chain();
            jobChain.set_name(this.jobChainName);
            this.spooler_log.debug3("Adding job scheduler_managed_user_database_statement to job_chain.");
            jobChain.add_job("scheduler_managed_user_database_statement", "0", "100", "1100");
            jobChain.add_end_state("100");
            jobChain.add_end_state("1100");
            this.spooler.add_job_chain(jobChain);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create jobchain " + this.jobChainName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean spooler_open() {
        try {
            String query = new String("SELECT \"ID\", \"SPOOLER_ID\", \"JOB_CHAIN\", \"PRIORITY\", \"TITLE\", \"JOB_TYPE\", \"SCHEMA\", \"USER_NAME\", \"ACTION\", \"PARAMS\", \"RUN_TIME\", \"NEXT_START\", \"NEXT_TIME\", \"TIMEOUT\", \"DELETED\", \"SUSPENDED\" FROM " + JobSchedulerManagedObject.getTableManagedUserJobs() + " WHERE (\"UPDATED\"=1 OR \"NEXT_TIME\"< %now )   AND (\"SPOOLER_ID\" IS NULL OR \"SPOOLER_ID\"='" + this.spooler.id() + "') ORDER BY \"NEXT_TIME\" ASC");
            this.spooler_log.debug3(".. query: " + query.toString());
            this.setOrders(this.getConnection().getArray(query));
            this.getConnection().rollback();
            this.setOrderIterator(this.getOrders().iterator());
        }
        catch (Exception e) {
            this.spooler_log.error("spooler_open(): fatal error occurred: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.getConnection() != null) {
                try {
                    this.getConnection().rollback();
                }
                catch (Exception exception) {}
            }
        }
        return !this.getOrders().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean spooler_process() {
        Order order = null;
        Map<Object, Object> orderAttributes = new HashMap();
        boolean rc = false;
        try {
            String sSuspended;
            if (!this.getOrderIterator().hasNext()) {
                this.spooler_log.info("no more orders found in queue");
                boolean bl = false;
                return bl;
            }
            orderAttributes = this.getOrderIterator().next();
            if (orderAttributes.isEmpty()) {
                this.spooler_log.warn("no order attributes found in queue");
                boolean bl = false;
                return bl;
            }
            if (orderAttributes.get("job_chain") == null || ((String)orderAttributes.get("job_chain")).isEmpty()) {
                orderAttributes.put("job_chain", this.jobChainName);
            }
            if (!this.spooler.job_chain_exists((String)orderAttributes.get("job_chain"))) {
                this.spooler_log.warn("no job chain found for this order: " + (String)orderAttributes.get("job_chain"));
            }
            boolean deleted = false;
            if (orderAttributes.get("deleted") != null) {
                String sDeleted = (String)orderAttributes.get("deleted");
                deleted = !"0".equals(sDeleted.trim());
            }
            boolean suspended = false;
            if (orderAttributes.get("suspended") != null) {
                sSuspended = (String)orderAttributes.get("suspended");
                boolean bl = suspended = !"0".equals(sSuspended.trim());
            }
            if (deleted) {
                this.spooler_log.debug6("deleted=1, deleting order...");
                this.getConnection().execute("DELETE FROM " + JobSchedulerManagedObject.getTableManagedUserJobs() + " WHERE \"ID\"=" + (String)orderAttributes.get("id"));
                this.getConnection().commit();
                sSuspended = this.spooler.execute_xml("<remove_order job_chain=\"" + (String)orderAttributes.get("job_chain") + "\" order=\"" + (String)orderAttributes.get("id") + "\" />");
            } else {
                String paramsXml2;
                if (suspended) {
                    this.spooler_log.debug6("suspended=1, deactivating order...");
                    String answer = this.spooler.execute_xml("<remove_order job_chain=\"" + (String)orderAttributes.get("job_chain") + "\" order=\"" + ((String)orderAttributes.get("id")).toString() + "\" />");
                    this.getConnection().executeUpdate("UPDATE " + JobSchedulerManagedObject.getTableManagedUserJobs() + " SET \"UPDATED\"=0 WHERE \"ID\"=" + (String)orderAttributes.get("id"));
                    this.getConnection().commit();
                    boolean bl = this.orderIterator.hasNext();
                    return bl;
                }
                if (this.getMaxOrderCount() > 0 && this.spooler.job_chain((String)orderAttributes.get("job_chain")).order_count() >= this.getMaxOrderCount()) {
                    this.spooler_log.info(".. current order [" + (String)orderAttributes.get("id") + "] skipped: order queue length [" + this.spooler.job_chain((String)orderAttributes.get("job_chain")).order_count() + "] exceeds maximum size [" + this.getMaxOrderCount() + "]");
                    boolean answer = this.orderIterator.hasNext();
                    return answer;
                }
                String command = (String)orderAttributes.get("action");
                String runTime = (String)orderAttributes.get("run_time");
                String hexCommand = JobSchedulerManagedObject.toHexString(command.getBytes("US-ASCII"));
                order = this.spooler.create_order();
                order.set_id((String)orderAttributes.get("id"));
                order.set_state("0");
                order.set_priority(Integer.parseInt((String)orderAttributes.get("priority")));
                if (orderAttributes.get("title") != null) {
                    order.set_title((String)orderAttributes.get("title"));
                }
                Variable_set orderData = this.spooler.create_variable_set();
                orderData.set_var("command", hexCommand);
                orderData.set_var("scheduler_order_schema", (String)orderAttributes.get("schema"));
                orderData.set_var("scheduler_order_user_name", (String)orderAttributes.get("user_name"));
                orderData.set_var("scheduler_order_is_user_job", "1");
                if (orderAttributes.get("params") != null && !(paramsXml2 = (String)orderAttributes.get("params")).isEmpty()) {
                    Variable_set paramsSet = this.spooler.create_variable_set();
                    paramsSet.set_xml(paramsXml2);
                    orderData.merge(paramsSet);
                }
                order.set_payload((Object)orderData);
                if (runTime != null && !runTime.isEmpty()) {
                    if (this.isOver(runTime)) {
                        try {
                            this.spooler_log.debug3("Order " + order.id() + " was not executed at specified runtime. Calculating new runtime.");
                        }
                        catch (Exception paramsXml2) {
                            // empty catch block
                        }
                        JobSchedulerManagedDatabaseJob.updateRunTime(order, this.getConnection());
                        runTime = this.getConnection().getSingleValue("SELECT \"RUN_TIME\" FROM " + JobSchedulerManagedObject.getTableManagedUserJobs() + " WHERE \"ID\"=" + order.id());
                        if (runTime == null || runTime.isEmpty()) {
                            boolean paramsXml2 = this.orderIterator.hasNext();
                            return paramsXml2;
                        }
                    }
                    this.spooler_log.debug3("Setting order run_time:" + runTime);
                    order.run_time().set_xml(runTime);
                }
                rc = this.spooler_task.job().order_queue() != null;
                try {
                    this.spooler.job_chain((String)orderAttributes.get("job_chain")).add_or_replace_order(order);
                }
                catch (Exception e) {
                    this.spooler_log.debug6("an ignorable error occurred while removing and adding order: " + e.getMessage());
                    this.spooler_log.debug6("will try to add order on next run.");
                    boolean bl = this.orderIterator.hasNext();
                    try {
                        if (this.getConnection() == null) return bl;
                        this.getConnection().rollback();
                        return bl;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
                this.getConnection().executeUpdate("UPDATE " + JobSchedulerManagedObject.getTableManagedUserJobs() + " SET \"UPDATED\"=0 WHERE \"ID\"=" + (String)orderAttributes.get("id"));
                this.getConnection().commit();
                this.spooler_log.info("order [" + (String)orderAttributes.get("id") + "] added to job chain [" + (String)orderAttributes.get("job_chain") + "]: " + order.title());
            }
            boolean bl = this.orderIterator.hasNext();
            return bl;
        }
        catch (Exception e) {
            this.spooler_log.warn("error occurred processing managed user job" + (order != null ? " [" + order.id() + "]" : "") + ": " + e.getMessage());
            this.spooler_task.end();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.getConnection() != null) {
                    this.getConnection().rollback();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Iterator<Map<String, String>> getOrderIterator() {
        return this.orderIterator;
    }

    public void setOrderIterator(Iterator<Map<String, String>> orderIterator) {
        this.orderIterator = orderIterator;
    }

    public List<Map<String, String>> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Map<String, String>> orders) {
        this.orders = orders;
    }

    public int getMaxOrderCount() {
        return this.maxOrderCount;
    }

    public void setMaxOrderCount(int maxOrderCount) {
        this.maxOrderCount = maxOrderCount;
    }

    private boolean isOver(String runTime) {
        try {
            Node node;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document payloadDocument = docBuilder.parse(new ByteArrayInputStream(runTime.getBytes()));
            for (node = payloadDocument.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            if (node == null) {
                return false;
            }
            Element runtimeElement = (Element)node;
            if (!"run_time".equalsIgnoreCase(runtimeElement.getNodeName())) {
                return false;
            }
            for (node = runtimeElement.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            Element dateElement = (Element)node;
            if (!"date".equalsIgnoreCase(dateElement.getNodeName())) {
                return false;
            }
            String date = dateElement.getAttribute("date");
            for (node = dateElement.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            if (node == null) {
                return false;
            }
            Element periodElement = (Element)node;
            String time = periodElement.getAttribute("single_start");
            if (date == null || time == null) {
                return false;
            }
            Date scheduledRuntime = SOSDate.getTime((String)(date + " " + time));
            Date now = SOSDate.getTime();
            return now.after(scheduledRuntime);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

