/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model;

import com.sos.JSHelper.interfaces.ISOSComboItem;
import com.sos.scheduler.model.LanguageDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LanguageDescriptorList {
    public static final String JAVAX_SCRIPT_RHINO = "javax.script:rhino";
    public static final String JAVAX_SCRIPT_ECMASCRIPT = "javax.script:ecmascript";
    public static final String JAVAX_JAVASCRIPT = "java:javascript";
    public static final String PL_SQL = "plsql";
    public static final String PERL_SCRIPT = "perlScript";
    public static final String VB_SCRIPT = "VBScript";
    public static final String VB_SCRIPT_CONTROL = "scriptcontrol:vbscript";
    public static final String JAVASCRIPT = "javascript";
    public static final String SHELL = "shell";
    public static final String JAVA = "java";
    public static final String DOTNET = "dotnet";
    public static final String SQL_PLUS = "sql*plus";
    public static final String SSH = "ssh";
    public static final String POWERSHELL = "powershell";
    private static List<LanguageDescriptor> lstLanguages = Arrays.asList(new LanguageDescriptor("shell", 0, false, "shell", "", "", true, false), new LanguageDescriptor("java", 1, false, "java", "", "", true, true), new LanguageDescriptor("dotnet", 2, false, "dotnet", "", "", true, true), new LanguageDescriptor("java:javascript", 3, false, "java:javascript", "", "", true, true), new LanguageDescriptor("perlScript", 4, false, "perlScript", "", "", true, true), new LanguageDescriptor("powershell", 5, false, "powershell", "", "", true, true), new LanguageDescriptor("VBScript", 6, false, "VBScript", "", "", true, true), new LanguageDescriptor("scriptcontrol:vbscript", 7, false, "scriptcontrol:vbscript", "", "", true, true), new LanguageDescriptor("javax.script:rhino", 8, false, "javax.script:rhino", "", "", true, true), new LanguageDescriptor("javax.script:ecmascript", 9, false, "javax.script:ecmascript", "", "", true, true), new LanguageDescriptor("javascript", 10, false, "javascript", "", "", true, true));

    public static String[] getLanguages4APIJobs() {
        ArrayList<String> lstL = new ArrayList<String>();
        for (LanguageDescriptor objL : lstLanguages) {
            if (!objL.isIsAPIL()) continue;
            lstL.add(objL.getLanguageName());
        }
        return lstL.toArray(new String[lstL.size()]);
    }

    public static String[] getLanguages4Monitor() {
        ArrayList<String> lstL = new ArrayList<String>();
        for (LanguageDescriptor objL : lstLanguages) {
            if (!objL.isIsMonitorL()) continue;
            lstL.add(objL.getLanguageName());
        }
        return lstL.toArray(new String[lstL.size()]);
    }

    public static ArrayList<ISOSComboItem> getComboItems4APIJobs() {
        ArrayList<ISOSComboItem> lstL = new ArrayList<ISOSComboItem>();
        for (LanguageDescriptor objL : lstLanguages) {
            if (!objL.isIsAPIL()) continue;
            lstL.add(objL);
        }
        return lstL;
    }

    public static LanguageDescriptor getLanguageDescriptor(int pintLang) {
        for (LanguageDescriptor objL : lstLanguages) {
            if (objL.getLanguageNumber() != pintLang) continue;
            return objL;
        }
        return null;
    }

    public static LanguageDescriptor getLanguageDescriptor4Class(String pstrClassName) {
        if (pstrClassName != null && !pstrClassName.isEmpty()) {
            for (LanguageDescriptor objL : lstLanguages) {
                if (!objL.getClassName().equalsIgnoreCase(pstrClassName)) continue;
                return objL;
            }
        }
        return null;
    }

    public static LanguageDescriptor getDefaultLanguage() {
        return lstLanguages.get(0);
    }

    public static LanguageDescriptor getDefaultLanguage4Monitor() {
        return lstLanguages.get(2);
    }

    public static LanguageDescriptor getLanguageDescriptor(String pstrLanguage) {
        if (pstrLanguage != null && !pstrLanguage.isEmpty()) {
            for (LanguageDescriptor objL : lstLanguages) {
                if (!objL.getLanguageName().equalsIgnoreCase(pstrLanguage.toLowerCase())) continue;
                return objL;
            }
        }
        return null;
    }

    public static String getJavaClassName4HiddenJob(int pintLang) {
        String strR = "";
        LanguageDescriptor objL = LanguageDescriptorList.getLanguageDescriptor(pintLang);
        if (objL != null) {
            strR = objL.getClassName();
        }
        return strR;
    }

    public static boolean isHiddenJobLanguage(int pintLang) {
        LanguageDescriptor objL = LanguageDescriptorList.getLanguageDescriptor(pintLang);
        return objL.isHiddenL();
    }
}

