/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model;

import com.sos.scheduler.model.SchedulerHotFolder;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.JSObjJob;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.JSObjLock;
import com.sos.scheduler.model.objects.JSObjOrder;
import com.sos.scheduler.model.objects.JSObjParams;
import com.sos.scheduler.model.objects.JSObjProcessClass;
import com.sos.scheduler.model.objects.JSObjSchedule;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerHotFolderFileList {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerHotFolderFileList.class);
    private List<JSObjBase> fileList = new ArrayList<JSObjBase>();
    private ISOSProviderFile hotFolderSrc = null;

    public List<JSObjBase> getFileList() {
        return this.fileList;
    }

    public List<JSObjBase> getSortedFileList() {
        Collections.sort(this.fileList, new GroupFolderAndSortByName());
        return this.fileList;
    }

    public List<JSObjBase> getSortedFileList(Comparator<JSObjBase> comp) {
        Collections.sort(this.fileList, comp);
        return this.fileList;
    }

    public void add(JSObjBase pObjHotFolderElement) {
        this.fileList.add(pObjHotFolderElement);
    }

    public void addAll(SchedulerHotFolderFileList pFileList) {
        this.fileList.addAll(pFileList.getFileList());
    }

    public List<SchedulerHotFolder> getFolderList() {
        ArrayList<SchedulerHotFolder> folders = new ArrayList<SchedulerHotFolder>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof SchedulerHotFolder)) continue;
            folders.add((SchedulerHotFolder)fileListItem);
        }
        if (this.getHotFolderSrc() != null) {
            LOGGER.debug(String.format("%1$s folders found in %2$s", folders.size(), this.getHotFolderSrc().getName()));
        }
        return folders;
    }

    public List<JSObjJob> getJobList() {
        ArrayList<JSObjJob> jobs = new ArrayList<JSObjJob>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof JSObjJob)) continue;
            jobs.add((JSObjJob)fileListItem);
        }
        if (this.getHotFolderSrc() != null) {
            LOGGER.debug(String.format("%1$s jobs found in %2$s", jobs.size(), this.getHotFolderSrc().getName()));
        }
        return jobs;
    }

    public List<JSObjJobChain> getJobChainList() {
        ArrayList<JSObjJobChain> jobChains = new ArrayList<JSObjJobChain>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof JSObjJobChain)) continue;
            jobChains.add((JSObjJobChain)fileListItem);
        }
        LOGGER.debug(String.format("%1$s job chains found in %2$s", jobChains.size(), this.getHotFolderSrc().getName()));
        return jobChains;
    }

    public List<JSObjOrder> getOrderList() {
        ArrayList<JSObjOrder> orders = new ArrayList<JSObjOrder>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof JSObjOrder)) continue;
            orders.add((JSObjOrder)fileListItem);
        }
        LOGGER.debug(String.format("%1$s orders found in %2$s", orders.size(), this.getHotFolderSrc().getName()));
        return orders;
    }

    public List<ISOSProviderFile> getOrderList(String filter) {
        Pattern pattern = Pattern.compile(filter);
        List<JSObjOrder> orders = this.getOrderList();
        ArrayList<ISOSProviderFile> result = new ArrayList<ISOSProviderFile>();
        for (JSObjOrder object : orders) {
            File f = new File(object.getHotFolderSrc().getName());
            Matcher m = pattern.matcher(f.getName());
            if (!m.matches()) continue;
            result.add(object.getHotFolderSrc());
        }
        return result;
    }

    public List<JSObjProcessClass> getProcessClassList() {
        ArrayList<JSObjProcessClass> processClasses = new ArrayList<JSObjProcessClass>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof JSObjProcessClass)) continue;
            processClasses.add((JSObjProcessClass)fileListItem);
        }
        LOGGER.debug(String.format("%1$s process classes found in %2$s", processClasses.size(), this.getHotFolderSrc().getName()));
        return processClasses;
    }

    public List<JSObjLock> getLockList() {
        ArrayList<JSObjLock> locks = new ArrayList<JSObjLock>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof JSObjLock)) continue;
            locks.add((JSObjLock)fileListItem);
        }
        LOGGER.debug(String.format("%1$s locks found in %2$s", locks.size(), this.getHotFolderSrc().getName()));
        return locks;
    }

    public List<JSObjSchedule> getScheduleList() {
        ArrayList<JSObjSchedule> schedules = new ArrayList<JSObjSchedule>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof JSObjSchedule)) continue;
            schedules.add((JSObjSchedule)fileListItem);
        }
        LOGGER.debug(String.format("%1$s schedules found in %2$s", schedules.size(), this.getHotFolderSrc().getName()));
        return schedules;
    }

    public List<JSObjParams> getParamsList() {
        ArrayList<JSObjParams> params = new ArrayList<JSObjParams>();
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(fileListItem instanceof JSObjParams)) continue;
            params.add((JSObjParams)fileListItem);
        }
        LOGGER.debug(String.format("%1$s params found in %2$s", params.size(), this.getHotFolderSrc().getName()));
        return params;
    }

    public List<JSObjBase> getFileList(HotFolderObject ... hotFolderObject) {
        ArrayList<JSObjBase> filteredFileList = new ArrayList<JSObjBase>();
        List<HotFolderObject> hotFolderObjectList = Arrays.asList(hotFolderObject);
        for (JSObjBase fileListItem : this.getFileList()) {
            if (!(hotFolderObjectList.contains((Object)HotFolderObject.folder) && fileListItem instanceof SchedulerHotFolder || hotFolderObjectList.contains((Object)HotFolderObject.job) && fileListItem instanceof JSObjJob || hotFolderObjectList.contains((Object)HotFolderObject.job_chain) && fileListItem instanceof JSObjJobChain || hotFolderObjectList.contains((Object)HotFolderObject.order) && fileListItem instanceof JSObjOrder || hotFolderObjectList.contains((Object)HotFolderObject.lock) && fileListItem instanceof JSObjLock || hotFolderObjectList.contains((Object)HotFolderObject.process_class) && fileListItem instanceof JSObjProcessClass || hotFolderObjectList.contains((Object)HotFolderObject.schedule) && fileListItem instanceof JSObjSchedule) && (!hotFolderObjectList.contains((Object)HotFolderObject.params) || !(fileListItem instanceof JSObjParams))) continue;
            filteredFileList.add(fileListItem);
        }
        LOGGER.debug(String.format("%1$s objects found in %2$s", filteredFileList.size(), this.getHotFolderSrc().getName()));
        return filteredFileList;
    }

    public void setHotFolderSrc(ISOSProviderFile hotFolderSrc) {
        this.hotFolderSrc = hotFolderSrc;
    }

    public ISOSProviderFile getHotFolderSrc() {
        return this.hotFolderSrc;
    }

    public class GroupFolderAndSortByName
    implements Comparator<JSObjBase> {
        @Override
        public int compare(JSObjBase jsObjBase0, JSObjBase jsObjBase1) {
            int compareRet = 0;
            boolean jsObjBase0IsFolder = jsObjBase0 instanceof SchedulerHotFolder;
            boolean jsObjBase1IsFolder = jsObjBase1 instanceof SchedulerHotFolder;
            if (jsObjBase0IsFolder && !jsObjBase1IsFolder) {
                compareRet = -1;
            } else if (!jsObjBase0IsFolder && jsObjBase1IsFolder) {
                compareRet = 1;
            } else if (jsObjBase0.getHotFolderSrc() == null) {
                compareRet = 1;
            } else if (jsObjBase1.getHotFolderSrc() == null) {
                compareRet = -1;
            } else {
                String hotFolderSrcName0 = jsObjBase0.getHotFolderSrc().getName().toLowerCase();
                String hotFolderSrcName1 = jsObjBase1.getHotFolderSrc().getName().toLowerCase();
                compareRet = hotFolderSrcName0.compareTo(hotFolderSrcName1);
            }
            return compareRet;
        }
    }

    public static enum HotFolderObject {
        folder,
        job,
        job_chain,
        order,
        lock,
        process_class,
        schedule,
        params;

    }
}

