/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.JSHelper.DataElements.JSDataElementDate;
import com.sos.JSHelper.DataElements.JSDateFormat;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.Holiday;
import com.sos.scheduler.model.objects.Holidays;
import com.sos.scheduler.model.objects.Include;
import com.sos.scheduler.model.objects.JSObjHoliday;
import com.sos.scheduler.model.objects.JSObjHolidaysWeekdays;
import com.sos.scheduler.model.objects.JSObjInclude;
import com.sos.scheduler.model.objects.JodaTools;
import com.sos.scheduler.model.tools.RunTimeElement;
import com.sos.scheduler.model.tools.RunTimeElements;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjHolidays
extends Holidays {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjHolidays.class);
    private List<JSObjInclude> includes = null;

    public JSObjHolidays(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    public JSObjHolidays(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile pobjVirtualFile) {
        this(schedulerObjectFactory);
        Holidays objHolidays = (Holidays)this.unMarshal(pobjVirtualFile);
        this.setObjectFieldsFrom(objHolidays);
        this.setHotFolderSrc(pobjVirtualFile);
    }

    public boolean isAHoliday(Calendar pobjCalendar) {
        return this.isAHoliday(pobjCalendar.getTime());
    }

    public boolean isAHoliday(Date pobjDate) {
        boolean flgIsAHoliday = false;
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(pobjDate);
        int intDayOfWeek = cal.get(7);
        if (--intDayOfWeek == 0) {
            intDayOfWeek = 7;
        }
        for (Object objO : this.getWeekdaysOrHolidayOrInclude()) {
            if (!(objO instanceof Holidays.Weekdays)) continue;
            Holidays.Weekdays objW = (Holidays.Weekdays)objO;
            for (Holidays.Weekdays.Day objDay : objW.day) {
                for (String strD : objDay.day) {
                    if (intDayOfWeek != new Integer(strD)) continue;
                    flgIsAHoliday = true;
                    return flgIsAHoliday;
                }
            }
        }
        for (Object objO : this.getWeekdaysOrHolidayOrInclude()) {
            Holiday objH;
            String strD;
            Date objD;
            if (!(objO instanceof Holiday) || !(objD = new JSDataElementDate(strD = (objH = (Holiday)objO).getDate(), JSDateFormat.dfDATE_SHORT).getDateObject()).equals(pobjDate)) continue;
            flgIsAHoliday = true;
            return flgIsAHoliday;
        }
        return flgIsAHoliday;
    }

    public boolean isHoliday(DateTime date) {
        DateTime from = JodaTools.getStartOfDay(date);
        List<DateTime> result = this.getHolidays(new Interval((ReadableInstant)from, (ReadableInstant)from.plusDays(1)));
        return !result.isEmpty();
    }

    public List<DateTime> getHolidays(Interval timeRange) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        result.addAll(this.getDtHoliday(timeRange));
        result.addAll(this.getDtWeekdays(timeRange));
        result.addAll(this.getDtInclude(timeRange));
        return result;
    }

    public DateTime getNextNonHoliday(DateTime date) {
        DateTime result = date;
        while (this.isHoliday(result)) {
            result = result.plusDays(1);
        }
        return result;
    }

    public DateTime getPreviousNonHoliday(DateTime date) {
        DateTime result = date;
        while (this.isHoliday(result)) {
            result = result.minusDays(1);
        }
        return result;
    }

    private List<DateTime> getDtWeekdays(Interval timeRange) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        for (Object o : this.getWeekdaysOrHolidayOrInclude()) {
            if (!(o instanceof Holidays.Weekdays)) continue;
            Holidays.Weekdays w = (Holidays.Weekdays)o;
            JSObjHolidaysWeekdays weekdays = new JSObjHolidaysWeekdays(this.objFactory);
            weekdays.setObjectFieldsFrom(w);
            result.addAll(weekdays.getDtHolidays(timeRange));
        }
        return result;
    }

    private List<DateTime> getDtHoliday(Interval timeRange) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        for (Object o : this.getWeekdaysOrHolidayOrInclude()) {
            if (!(o instanceof Holiday)) continue;
            Holiday h = (Holiday)o;
            JSObjHoliday holiday = new JSObjHoliday(this.objFactory);
            holiday.setObjectFieldsFrom(h);
            DateTime d = holiday.getDtHoliday();
            if (!timeRange.contains((ReadableInstant)d)) continue;
            result.add(d);
        }
        return result;
    }

    private List<DateTime> getDtInclude(Interval timeRange) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        for (Object o : this.getWeekdaysOrHolidayOrInclude()) {
            if (!(o instanceof Include)) continue;
            Include i = (Include)o;
            LOGGER.warn("the <include> element is not parsed yet.");
            LOGGER.debug(i.getLiveFile());
            LOGGER.debug(i.getHotFolderSrc().toString());
            LOGGER.debug(this.getHotFolderSrc().toString());
        }
        return result;
    }

    public List<DateTime> getStartDatesAwareHolidays(RunTimeElements runTimes) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        Interval timeRange = runTimes.getTimeRange();
        if (this.getHolidays(timeRange).isEmpty()) {
            return runTimes.getStartTimes();
        }
        for (RunTimeElement runTime : runTimes.values()) {
            if (!this.isHoliday(runTime.getStartDate())) continue;
            switch (runTime.getWhenHoliday()) {
                case SUPPRESS: {
                    break;
                }
                case IGNORE_HOLIDAY: {
                    if (result.contains(runTime.getStartDate())) break;
                    result.add(runTime.getStartDate());
                    break;
                }
                case NEXT_NON_HOLIDAY: {
                    DateTime nextStart = this.getNextNonHoliday(runTime.getStartDate());
                    if (!timeRange.contains((ReadableInstant)nextStart) || result.contains(nextStart)) break;
                    result.add(nextStart);
                    break;
                }
                case PREVIOUS_NON_HOLIDAY: {
                    DateTime previousStart = this.getPreviousNonHoliday(runTime.getStartDate());
                    if (!timeRange.contains((ReadableInstant)previousStart) || result.contains(previousStart)) break;
                    result.add(previousStart);
                }
            }
        }
        return result;
    }

    public List<JSObjInclude> getJsObjInclude() {
        if (this.includes == null) {
            this.includes = new ArrayList<JSObjInclude>();
            for (Object o : this.getWeekdaysOrHolidayOrInclude()) {
                if (!(o instanceof Include)) continue;
                Include i = (Include)o;
                JSObjInclude include = new JSObjInclude(this.objFactory);
                include.setObjectFieldsFrom(i);
                include.setHotFolderSrc(this.getHotFolderSrc());
                this.includes.add(include);
            }
        }
        return this.includes;
    }

    public void resolveIncludes() {
        List<JSObjInclude> list = this.getJsObjInclude();
        for (JSObjInclude include : list) {
            JSObjHolidays includeHolidays = new JSObjHolidays(this.objFactory, include.getHotFolderSrc());
            this.weekdaysOrHolidayOrInclude.addAll(includeHolidays.getWeekdaysOrHolidayOrInclude());
        }
        for (int i = this.getWeekdaysOrHolidayOrInclude().size() - 1; i >= 0; --i) {
            Object o = this.getWeekdaysOrHolidayOrInclude().get(i);
            if (!(o instanceof Include)) continue;
            this.weekdaysOrHolidayOrInclude.remove(o);
        }
    }
}

