/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.ProcessClass;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.File;
import java.math.BigInteger;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjProcessClass
extends ProcessClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjProcessClass.class);
    public static final String fileNameExtension = ".process_class.xml";

    public JSObjProcessClass(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
        this.strFileNameExtension = fileNameExtension;
    }

    public JSObjProcessClass(SchedulerObjectFactory schedulerObjectFactory, ProcessClass origOrder) {
        this.strFileNameExtension = fileNameExtension;
        this.objFactory = schedulerObjectFactory;
        this.setObjectFieldsFrom(origOrder);
    }

    public JSObjProcessClass(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile pobjVirtualFile) {
        this.objFactory = schedulerObjectFactory;
        this.objJAXBElement = (JAXBElement)this.unMarshal(pobjVirtualFile);
        this.setObjectFieldsFrom((JSObjBase)this.objJAXBElement.getValue());
        this.setHotFolderSrc(pobjVirtualFile);
    }

    public void setSpoolerIdIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            super.setSpoolerId(value);
        }
    }

    public void setNameIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            super.setName(value);
        }
    }

    public void setRemoteSchedulerIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            super.setSpoolerId(value);
        }
    }

    public void setReplaceIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            super.setReplace(value);
        }
    }

    public void setMaxProcessesIfNotEmpty(String value) {
        if (!this.isEmpty(value)) {
            try {
                super.setMaxProcesses(new BigInteger(value));
            }
            catch (NumberFormatException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getObjectName() {
        String name = this.getHotFolderSrc().getName();
        int i = name.indexOf(fileNameExtension);
        if (i != -1) {
            name = name.substring(0, name.indexOf(fileNameExtension));
        }
        name = new File(name).getName();
        return name;
    }

    public void setMaxProcesses(int value) {
        this.maxProcesses = this.int2BigInteger(value);
    }
}

