/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjAt;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.JSObjDate;
import com.sos.scheduler.model.objects.JSObjHolidays;
import com.sos.scheduler.model.objects.JSObjMonthdays;
import com.sos.scheduler.model.objects.JSObjPeriod;
import com.sos.scheduler.model.objects.JSObjUltimos;
import com.sos.scheduler.model.objects.JSObjWeekdays;
import com.sos.scheduler.model.objects.Monthdays;
import com.sos.scheduler.model.objects.Period;
import com.sos.scheduler.model.objects.RunTime;
import com.sos.scheduler.model.objects.WhenHoliday;
import com.sos.scheduler.model.tools.RunTimeElement;
import com.sos.scheduler.model.tools.RunTimeElements;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class JSObjRunTime
extends RunTime {
    private final JSObjPeriod period;
    private boolean useDefaultPeriod = false;

    public JSObjRunTime(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
        this.period = this.getPeriodObject();
    }

    public JSObjRunTime(SchedulerObjectFactory schedulerObjectFactory, String xmlContent) {
        this.objFactory = schedulerObjectFactory;
        this.objJAXBElement = (JAXBElement)this.unMarshal(xmlContent);
        this.setObjectFieldsFrom((JSObjBase)this.objJAXBElement.getValue());
        this.period = this.getPeriodObject();
    }

    public JSObjRunTime(SchedulerObjectFactory schedulerObjectFactory, RunTime pobjRunTime) {
        this.objFactory = schedulerObjectFactory;
        this.setObjectFieldsFrom(pobjRunTime);
        this.period = this.getPeriodObject();
    }

    private JSObjPeriod getPeriodObject() {
        JSObjPeriod period = new JSObjPeriod(this.objFactory);
        period.setBegin(this.getBegin());
        period.setEnd(this.getEnd());
        period.setRepeat(this.getRepeat());
        period.setLetRun(this.getLetRun());
        period.setSingleStart(this.getSingleStart());
        period.setWhenHoliday(this.getWhenHoliday());
        return period;
    }

    public JSObjPeriod getRunTimePeriod() {
        return this.period;
    }

    @Override
    public String getBegin() {
        return JSObjPeriod.normalizeTime(super.getBegin());
    }

    @Override
    public String getEnd() {
        return JSObjPeriod.normalizeTime(super.getEnd());
    }

    public boolean hasPeriod() {
        return !this.getPeriod().isEmpty();
    }

    public boolean hasAt() {
        return !this.getAt().isEmpty();
    }

    public boolean hasDate() {
        return !this.getDate().isEmpty();
    }

    public boolean hasWeekdays() {
        return this.getWeekdays() != null;
    }

    public boolean hasMonth() {
        return !this.getMonth().isEmpty();
    }

    public boolean hasMonthdays() {
        return this.getMonthdays() != null && !this.getMonthdays().getDayOrWeekday().isEmpty();
    }

    public boolean hasUltimos() {
        return this.getUltimos() != null;
    }

    public boolean hasHolidays() {
        return this.getHolidays() != null;
    }

    public boolean hasSubsequentRunTimes() {
        return this.hasPeriod() || this.hasAt() || this.hasDate() || this.hasWeekdays() || this.hasMonth() || this.hasMonthdays() || this.hasUltimos();
    }

    public List<DateTime> getDtSingleStarts(Interval timeRange) {
        Interval extendedTimeRange = new Interval((ReadableInstant)timeRange.getStart().minusDays(1), (ReadableInstant)timeRange.getEnd().plusDays(1));
        RunTimeElements runTimes = new RunTimeElements(timeRange);
        runTimes.putAll(this.getDtWeekdays(extendedTimeRange));
        runTimes.putAll(this.getDtPeriod(extendedTimeRange));
        runTimes.putAll(this.getDtAt(extendedTimeRange));
        runTimes.putAll(this.getDtDate(extendedTimeRange));
        runTimes.putAll(this.getDtMonthdays(extendedTimeRange));
        runTimes.putAll(this.getDtUltimos(extendedTimeRange));
        if (runTimes.isEmpty()) {
            RunTimeElements periodStartTimes = this.period.getRunTimeElements(extendedTimeRange);
            runTimes.putAll(periodStartTimes);
        }
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        for (DateTime d : this.getJsObjHolidays().getStartDatesAwareHolidays(runTimes)) {
            if (!timeRange.contains((ReadableInstant)d)) continue;
            result.add(d);
        }
        return result;
    }

    public RunTimeElements getDtAt(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        for (JSObjAt at : this.getJsObjAt()) {
            for (RunTimeElement e : at.getRunTimeElements(timeRange).values()) {
                result.add(e);
            }
        }
        return result;
    }

    public RunTimeElements getDtDate(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        for (JSObjDate date : this.getJsObjDate()) {
            for (RunTimeElement e : date.getRunTimeElements(timeRange).values()) {
                result.add(e);
            }
        }
        return result;
    }

    public RunTimeElements getDtMonthdays(Interval timeRange) {
        return this.getJsObjMonthdays().getRunTimeElements(timeRange);
    }

    public RunTimeElements getDtUltimos(Interval timeRange) {
        return this.getJsObjUltimos().getRunTimeElements(timeRange);
    }

    public RunTimeElements getDtPeriod(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        for (JSObjPeriod period : this.getJsObjPeriod()) {
            for (RunTimeElement e : period.getRunTimeElements(timeRange).values()) {
                result.add(e);
            }
        }
        return result;
    }

    public RunTimeElements getDtWeekdays(Interval timeRange) {
        return this.getJsObjWeekdays().getRunTimeElements(timeRange);
    }

    public JSObjWeekdays getJsObjWeekdays() {
        JSObjWeekdays weekdays = new JSObjWeekdays(this.objFactory);
        if (this.hasWeekdays()) {
            weekdays.setObjectFieldsFrom(this.getWeekdays());
            weekdays.setHotFolderSrc(this.getHotFolderSrc());
        }
        return weekdays;
    }

    public JSObjMonthdays getJsObjMonthdays() {
        JSObjMonthdays monthdays = new JSObjMonthdays(this.objFactory);
        if (this.hasMonthdays()) {
            monthdays.setObjectFieldsFrom(this.getMonthdays());
            monthdays.setHotFolderSrc(this.getHotFolderSrc());
        }
        return monthdays;
    }

    public JSObjUltimos getJsObjUltimos() {
        JSObjUltimos ultimos = new JSObjUltimos(this.objFactory);
        if (this.hasUltimos()) {
            ultimos.setObjectFieldsFrom(this.getUltimos());
            ultimos.setHotFolderSrc(this.getHotFolderSrc());
        }
        return ultimos;
    }

    public List<JSObjDate> getJsObjDate() {
        ArrayList<JSObjDate> result = new ArrayList<JSObjDate>();
        if (this.hasDate()) {
            for (RunTime.Date d : this.getDate()) {
                JSObjDate date = new JSObjDate(this.objFactory);
                date.setObjectFieldsFrom(d);
                date.setHotFolderSrc(this.getHotFolderSrc());
                result.add(date);
            }
        }
        return result;
    }

    public List<JSObjAt> getJsObjAt() {
        ArrayList<JSObjAt> result = new ArrayList<JSObjAt>();
        if (this.hasAt()) {
            for (RunTime.At d : this.getAt()) {
                JSObjAt date = new JSObjAt(this.objFactory);
                date.setObjectFieldsFrom(d);
                date.setHotFolderSrc(this.getHotFolderSrc());
                result.add(date);
            }
        }
        return result;
    }

    public JSObjHolidays getJsObjHolidays() {
        return this.getJsObjHolidays(true);
    }

    public JSObjHolidays getJsObjHolidays(boolean resolveIncludes) {
        JSObjHolidays result = new JSObjHolidays(this.objFactory);
        if (this.hasHolidays()) {
            result.setObjectFieldsFrom(this.getHolidays());
            result.setHotFolderSrc(this.getHotFolderSrc());
            if (resolveIncludes) {
                result.resolveIncludes();
            }
        }
        return result;
    }

    public List<JSObjPeriod> getJsObjPeriod() {
        ArrayList<JSObjPeriod> result = new ArrayList<JSObjPeriod>();
        if (this.hasPeriod()) {
            for (Period p : this.getPeriod()) {
                JSObjPeriod period = new JSObjPeriod(this.objFactory);
                period.setObjectFieldsFrom(p);
                period.setHotFolderSrc(this.getHotFolderSrc());
                result.add(period);
            }
        }
        return result;
    }

    public static List<Period> getDefaultPeriod(SchedulerObjectFactory factory, WhenHoliday h) {
        ArrayList<Period> result = new ArrayList<Period>();
        Period period = factory.createPeriod();
        period.setBegin(null);
        period.setEnd(null);
        period.setRepeat(null);
        period.setLetRun("no");
        period.setSingleStart("23:59:59");
        period.setWhenHoliday(h);
        result.add(period);
        return result;
    }

    public boolean useDefaultPeriod() {
        return this.useDefaultPeriod;
    }

    protected void setUseDefaultPeriod(boolean useDefaultPeriod) {
        this.useDefaultPeriod = useDefaultPeriod;
    }

    @Override
    public Monthdays getMonthdays() {
        Monthdays objM = super.getMonthdays();
        if (objM == null) {
            super.setMonthdays(new Monthdays());
        }
        return super.getMonthdays();
    }

    public boolean hasSingleStart() {
        return !this.getSingleStart().isEmpty();
    }

    public void setSingleStart(boolean pflgValue) {
        if (pflgValue) {
            this.setSingleStart("yes");
        } else {
            this.setSingleStart("");
        }
    }

    public void setOnce(boolean pflgValue) {
        if (pflgValue) {
            this.setOnce("yes");
        } else {
            this.setOnce("no");
        }
    }

    public boolean isOnce() {
        return this.getOnce().equalsIgnoreCase("yes");
    }

    public boolean isLetRun() {
        return this.getLetRun().equalsIgnoreCase("yes");
    }

    public void setLetRun(boolean pflgValue) {
        if (pflgValue) {
            this.setLetRun("yes");
        } else {
            this.setLetRun("no");
        }
    }
}

