/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.SchedulerScript;
import com.sos.scheduler.model.objects.Spooler;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.util.ArrayList;
import java.util.List;

public class JSObjSpooler
extends Spooler {
    private final String conClassName = "JSObjSpooler";

    public JSObjSpooler(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    public JSObjSpooler(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile pobjVirtualFile) {
        this.objFactory = schedulerObjectFactory;
        Spooler objSpooler = (Spooler)this.unMarshal(pobjVirtualFile);
        this.setObjectFieldsFrom(objSpooler);
        this.setHotFolderSrc(pobjVirtualFile);
        this.afterUnmarshal();
    }

    private void afterUnmarshal() {
        String conMethodName = "JSObjSpooler::afterUnmarchal";
        Spooler.Config objConfig = this.getConfig().get(0);
        if (objConfig.getSchedulerScript() != null) {
            for (SchedulerScript objSchedulerScript : objConfig.getSchedulerScript()) {
                if (objSchedulerScript.getScript() == null) continue;
                this.removeEmptyContentsFrom(objSchedulerScript.getScript().getContent());
            }
        }
        if (objConfig.getScript() != null) {
            this.removeEmptyContentsFrom(objConfig.getScript().getContent());
        }
    }

    private void removeEmptyContentsFrom(List<Object> objList) {
        String conMethodName = "JSObjSpooler::removeEmptyContentsFrom";
        ArrayList<String> emptyContents = new ArrayList<String>();
        for (Object listItem : objList) {
            if (!(listItem instanceof String) || ((String)listItem).trim().length() != 0) continue;
            emptyContents.add((String)listItem);
        }
        objList.removeAll(emptyContents);
    }
}

