/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.ISOSJsObjStartTimes;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjPeriod;
import com.sos.scheduler.model.objects.JSObjRunTime;
import com.sos.scheduler.model.objects.JSObjWeekdays;
import com.sos.scheduler.model.objects.Period;
import com.sos.scheduler.model.objects.Weekdays;
import com.sos.scheduler.model.objects.WhenHoliday;
import com.sos.scheduler.model.tools.JodaTools;
import com.sos.scheduler.model.tools.RunTimeElement;
import com.sos.scheduler.model.tools.RunTimeElements;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjWeekdaysDay
extends Weekdays.Day
implements ISOSJsObjStartTimes {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjWeekdays.class);

    public JSObjWeekdaysDay(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    @Override
    public RunTimeElements getRunTimeElements(Interval timeRange) {
        RunTimeElements result = new RunTimeElements(timeRange);
        RunTimeElements work = this.getNextSingleStarts(timeRange.getStart());
        for (RunTimeElement runtime : work.values()) {
            DateTime date = runtime.getStartDate();
            if (!timeRange.contains((ReadableInstant)date)) continue;
            while (timeRange.contains((ReadableInstant)date)) {
                result.add(new RunTimeElement(date, runtime.getWhenHoliday()));
                date = date.plusWeeks(1);
            }
        }
        return result;
    }

    private RunTimeElements getNextSingleStarts(DateTime baseDate) {
        DateTimeFormatter fmtDate = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTimeFormatter fmtDateTime = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        RunTimeElements result = new RunTimeElements(baseDate);
        LOGGER.debug(this.getDay().size() + " day elements detected.");
        for (String dayString : this.getDay()) {
            LOGGER.debug("parsing day string " + dayString);
            List<Integer> days = JodaTools.getJodaWeekdays(dayString);
            for (int i = 0; i < days.size(); ++i) {
                DateTime nextWeekDay = JodaTools.getNextWeekday(baseDate, days.get(i));
                LOGGER.debug("calculated date " + fmtDate.print((ReadableInstant)nextWeekDay));
                List<Period> periods = this.getPeriod();
                Iterator<Period> itP = periods.iterator();
                LOGGER.debug(periods.size() + " periods found.");
                while (itP.hasNext()) {
                    Period p = itP.next();
                    JSObjPeriod period = new JSObjPeriod(this.objFactory);
                    period.setObjectFieldsFrom(p);
                    DateTime start = period.getDtSingleStartOrNull(nextWeekDay);
                    if (start == null) continue;
                    LOGGER.debug("start from period " + fmtDateTime.print((ReadableInstant)start));
                    if (start.isBefore((ReadableInstant)baseDate)) {
                        start = start.plusWeeks(1);
                        LOGGER.debug("start is corrected to " + fmtDateTime.print((ReadableInstant)start));
                    }
                    result.add(new RunTimeElement(start, period.getWhenHoliday()));
                }
            }
        }
        return result;
    }

    @Override
    public List<Period> getPeriod() {
        List<Period> list = super.getPeriod();
        WhenHoliday h = list != null && !list.isEmpty() ? list.get(0).getWhenHoliday() : WhenHoliday.SUPPRESS;
        return this.objFactory.useDefaultPeriod() ? JSObjRunTime.getDefaultPeriod(this.objFactory, h) : list;
    }
}

