/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.tools;

import com.sos.scheduler.model.tools.JodaTools;
import com.sos.scheduler.model.tools.RunTimeElement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class RunTimeElements
extends TreeMap<DateTime, RunTimeElement> {
    private static final long serialVersionUID = -183103162185073046L;
    private final Interval timeRange;

    public RunTimeElements(Interval timeRange) {
        super(DateTimeComparator.getInstance());
        this.timeRange = timeRange;
    }

    public RunTimeElements(DateTime baseDate) {
        super(DateTimeComparator.getInstance());
        DateTime from = JodaTools.getStartOfDay(baseDate);
        this.timeRange = new Interval((ReadableInstant)from, (ReadableInstant)from.plusDays(1));
    }

    public void add(RunTimeElement runtime) {
        this.put(runtime.getStartDate(), runtime);
    }

    public List<DateTime> getStartTimes() {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        for (RunTimeElement e : this.values()) {
            result.add(e.getStartDate());
        }
        return result;
    }

    public Interval getTimeRange() {
        return this.timeRange;
    }
}

