@echo off

rem #  ------------------------------------------------------------
rem #  Company: Software- und Organisations-Service GmbH
rem #  Purpose: Start script for JS7 Agent
rem #  ------------------------------------------------------------

SETLOCAL

rem ### SETTINGS ##############################################

rem # This variable has to point to the installation path of 
rem # the JS7 Agent.
rem # If this variable not defined then the parent directory 
rem # of this start script is used.
  
rem set JS7_AGENT_HOME=


rem # The default port of the JS7 Agent 

set /a JS7_AGENT_DEFAULT_HTTP_PORT=4445


rem # Sets the http port for the JS7 Agent.
rem # Without this setting the default port 4445 is used.
rem # If just a port is specified then the JS7 Agent listens to all
rem # available network interfaces. This corresponds to 0.0.0.0:<port>.
rem # Use the form <ip address or hostname>:<port> to indicate
rem # a specific network interface the JS7 Agent should listen to.
rem # The command line option --http-port beats the environment
rem # variable JS7_AGENT_HTTP_PORT.

rem set JS7_AGENT_HTTP_PORT=


rem # In addition to the http port an https port for the
rem # JS7 Agent can be specified. If just a port is specified
rem # then the JS7 Agent listens to all available network interfaces.
rem # This corresponds to using 0.0.0.0:<port>.
rem # Use the form <ip address or hostname>:<port> to indicate
rem # a specific network interface the JS7 Agent should listen to.
rem # The command line option --https-port beats the environment
rem # variable JS7_AGENT_HTTPS_PORT.

rem set JS7_AGENT_HTTPS_PORT=


rem # Sets the directory used by the JS7 Agent for configuration
rem # files, log files, journal files and temporary files.
rem # This directory has to be unique for any instances of the
rem # JS7 Agent. The default value is
rem # JS7_AGENT_HOME/var_<JS7_AGENT_HTTP_PORT>
rem # Check that the JS7 Agent user account has read/write
rem # permissions for this directory.

rem set JS7_AGENT_DATA=


rem # Sets the directory used by the JS7 Agent for configuration
rem # files. The default value is JS7_AGENT_DATA\config
rem # The command line option --config-directory beats the
rem # environment variable JS7_AGENT_CONFIG_DIR
rem # Check that the JS7 Agent user account has read/write
rem # permissions for this directory.

rem set JS7_AGENT_CONFIG_DIR=


rem # Sets the directory to which the JS7 Agent stores log files.
rem # The default value is JS7_AGENT_DATA\logs
rem # Check that the JS7 Agent user account has read/write
rem # permissions for this directory.

rem set JS7_AGENT_LOGS=


rem # Sets the directory to which the JS7 Agent stores its PID file.
rem # The default value is JS7_AGENT_LOGS
rem # Check that the JS7 Agent user account has read/write
rem # permissions for this directory.

rem set JS7_AGENT_PID_FILE_DIR=


rem # The working directory for the JS7 Agent is JS7_AGENT_DATA
rem # Sets the working directory for jobs.
rem # The default value is JS7_AGENT_DATA

rem set JS7_AGENT_WORK_DIR=


rem # Specifies the Java Runtime Environment to be used by the
rem # JS7 Agent. If JAVA_HOME is not set then Java is used from 
rem # the PATH.

rem set JAVA_HOME=


rem # With Java 1.8 initial memory allocation has changed,
rem # for details see https://kb.sos-berlin.com/x/aIC9
rem # As a result on start-up of the JS7 Agent the amount of
rem # virtual memory assigned by Java depends on the physical
rem # memory and in most cases is by far too high.
rem # The environment variables JAVA_OPTIONS can be used to apply
rem # memory settings.
rem # The default value for JAVA_OPTIONS is -Xms100m -Dfile.encoding=UTF-8

rem set JAVA_OPTIONS=

rem ###########################################################


rem ##########################
rem # internal global vars
set JS7_AGENT_APPNAME=agent
set /a CREATE_PID_FILE_TRIAL=0
set /a RESTART_AGENT=0
set JS7_AGENT_COMMAND=%~1
set JS7_AGENT_STARTSCRIPT=%~dpnx0
if defined JS7_AGENT_INSTANCESCRIPT set JS7_AGENT_STARTSCRIPT=%JS7_AGENT_INSTANCESCRIPT%
set JS7_AGENT_SIGNAL=SIGTERM
set JS7_AGENT_LOG_BRIDGE=log4j
set /a LOOP_COUNTER=0
set /a LOOP_SESSION=0
set WEBSERVICES=
set JS7_AGENT_PORT=


rem ##########################
rem # set and check home
if not defined JS7_AGENT_HOME set JS7_AGENT_HOME=%~dp0..
call :normalize_home "%JS7_AGENT_HOME%\dummy"
if not exist "%JS7_AGENT_HOME%\lib" (
  echo ...the directory "%JS7_AGENT_HOME%\lib" is missing!
  echo did you move the startscript?
  echo please set the JS7_AGENT_HOME variable.
  call :more_info
  exit /b 3
)


rem ##########################
rem # read command line options
set JS7_AGENT_KILL_SCRIPT=
set HTTPS_PORT_OPTION=
set /A JS7_AGENT_STOP_TIMEOUT=-2
set WITH_FAILOVER=0
set WITH_CURL=0
:read_command_line_options
shift
if "%~1" == "-f" ( 
  set WITH_FAILOVER=1
  goto read_command_line_options
)
if "%~1" == "--fail-over" ( 
  set WITH_FAILOVER=1
  goto read_command_line_options
)
if "%~1" == "-c" ( 
  set WITH_CURL=1
  goto read_command_line_options
)
if "%~1" == "--curl" ( 
  set WITH_CURL=1
  goto read_command_line_options
)
set "OPTION_VALUE=%~2"
set "OPTION_VALUE=%OPTION_VALUE:--http-port=%"
set "OPTION_VALUE=%OPTION_VALUE:--https-port=%"
set "OPTION_VALUE=%OPTION_VALUE:--data-directory=%"
set "OPTION_VALUE=%OPTION_VALUE:--config-directory=%"
set "OPTION_VALUE=%OPTION_VALUE:--kill-script=%"
set "OPTION_VALUE=%OPTION_VALUE:--timeout=%"
set "OPTION_VALUE=%OPTION_VALUE:--java-options=%"
if "%~1" == "" goto read_command_line_options_end
if "%~1" == "--http-port" (
  if "%OPTION_VALUE%" == "" goto read_command_line_options
  set JS7_AGENT_HTTP_PORT=%~2
)
if "%~1" == "--https-port" (
  if "%OPTION_VALUE%" == "" goto read_command_line_options
  set JS7_AGENT_HTTPS_PORT=%~2
)
if "%~1" == "--data-directory" (
  if "%OPTION_VALUE%" == "" goto read_command_line_options
  set "JS7_AGENT_DATA=%~2"
)
if "%~1" == "--config-directory" (
  if "%OPTION_VALUE%" == "" goto read_command_line_options
  set "JS7_AGENT_CONFIG_DIR=%~2"
)
if "%~1" == "--kill-script" (
  if "%OPTION_VALUE%" == "" goto read_command_line_options
  set "JS7_AGENT_KILL_SCRIPT=%~2"
)
if "%~1" == "--timeout" (
  if "%OPTION_VALUE%" == "" goto read_command_line_options
  if "%OPTION_VALUE%" == "never" (
    set /A JS7_AGENT_STOP_TIMEOUT=-1
  ) else (
    set /A JS7_AGENT_STOP_TIMEOUT=%~2
  )
)
if "%~1" == "--java-options" (
  if "%OPTION_VALUE%" == "" goto read_command_line_options
  set "JS7_AGENT_JAVA_OPTIONS=%~2"
)
goto read_command_line_options
:read_command_line_options_end

if not defined JS7_AGENT_HTTP_PORT set JS7_AGENT_HTTP_PORT=%JS7_AGENT_DEFAULT_HTTP_PORT%
call :extract_port %JS7_AGENT_HTTP_PORT%
set SERVICE_NAME=js7_agent_%JS7_AGENT_PORT%
if defined JS7_AGENT_HTTPS_PORT set HTTPS_PORT_OPTION=--https-port=%JS7_AGENT_HTTPS_PORT%


rem ##########################
rem # set environment and create directories
if not defined JS7_AGENT_DATA set JS7_AGENT_DATA=%JS7_AGENT_HOME%\var_%JS7_AGENT_PORT%
if not defined JS7_AGENT_LOGS set JS7_AGENT_LOGS=%JS7_AGENT_DATA%\logs
if not defined JS7_AGENT_CONFIG_DIR set JS7_AGENT_CONFIG_DIR=%JS7_AGENT_DATA%\config
rem TODO mkdir config/private
if not exist "%JS7_AGENT_LOGS%" mkdir "%JS7_AGENT_LOGS%"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_LOGS%"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not defined JS7_AGENT_PID_FILE_DIR set JS7_AGENT_PID_FILE_DIR=%JS7_AGENT_LOGS%
if not exist "%JS7_AGENT_PID_FILE_DIR%" mkdir "%JS7_AGENT_PID_FILE_DIR%"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_PID_FILE_DIR%"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not defined JS7_AGENT_PID_FILE_NAME set JS7_AGENT_PID_FILE_NAME=agent.pid
if not exist "%JS7_AGENT_DATA%\state" mkdir "%JS7_AGENT_DATA%\state"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_DATA%\state"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\executables" mkdir "%JS7_AGENT_CONFIG_DIR%\executables"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\executables"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\license" mkdir "%JS7_AGENT_CONFIG_DIR%\license"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\license"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\lib" mkdir "%JS7_AGENT_CONFIG_DIR%\lib"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\lib"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\patches" mkdir "%JS7_AGENT_CONFIG_DIR%\patches"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\patches"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\private\trusted-x509-keys" mkdir "%JS7_AGENT_CONFIG_DIR%\private\trusted-x509-keys"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\private\trusted-x509-keys"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\private\trusted-pgp-keys" mkdir "%JS7_AGENT_CONFIG_DIR%\private\trusted-pgp-keys"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\private\trusted-pgp-keys"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\agent.conf" (
  if exist "%JS7_AGENT_HOME%\var\config\agent.conf-example" copy "%JS7_AGENT_HOME%\var\config\agent.conf-example" "%JS7_AGENT_CONFIG_DIR%\agent.conf" 2>nul
)
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\agent.conf"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\private\private.conf" (
  if exist "%JS7_AGENT_HOME%\var\config\private\private.conf-example" copy "%JS7_AGENT_HOME%\var\config\private\private.conf-example" "%JS7_AGENT_CONFIG_DIR%\private\private.conf" 2>nul
)
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\private\private.conf"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\private\trusted-x509-keys\sos.intermediate-ca.pem" (
  if exist "%JS7_AGENT_HOME%\var\config\private\trusted-x509-keys\sos.intermediate-ca.pem" (
    dir /a-d "%JS7_AGENT_CONFIG_DIR%\private\trusted-x509-keys\*" >nul 2>nul || copy "%JS7_AGENT_HOME%\var\config\private\trusted-x509-keys\sos.intermediate-ca.pem" "%JS7_AGENT_CONFIG_DIR%\private\trusted-x509-keys\sos.intermediate-ca.pem" 2>nul
  )
)
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\private\trusted-x509-keys\sos.intermediate-ca.pem"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
if not exist "%JS7_AGENT_CONFIG_DIR%\log4j.xml-example" (
  if exist "%JS7_AGENT_HOME%\var\config\log4j.xml-example" copy "%JS7_AGENT_HOME%\var\config\log4j.xml-example" "%JS7_AGENT_CONFIG_DIR%\log4j.xml-example" 2>nul
)
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_CONFIG_DIR%\log4j.xml-example"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
set JS7_AGENT_PID_FILE=%JS7_AGENT_PID_FILE_DIR%\%JS7_AGENT_PID_FILE_NAME%

set JS7_YADE_HOME=%JS7_AGENT_HOME%\yade
set JS7_YADE_BIN=%JS7_YADE_HOME%\bin\yade.cmd
set JS7_YADE_DMZ_BIN=%JS7_YADE_HOME%\bin\yade4dmz.cmd
set JS7_YADE_CONFIG_DIR=%JS7_AGENT_CONFIG_DIR%


rem ##########################
rem # set working directory
if not defined JS7_AGENT_WORK_DIR set JS7_AGENT_WORK_DIR=%JS7_AGENT_DATA%


rem ##########################
rem # set crash file location
set JS7_AGENT_CRASH_FILE=%JS7_AGENT_DATA%\work\crashpidfile


rem ##########################
rem # set java options
if not defined JS7_AGENT_JAVA_OPTIONS set JS7_AGENT_JAVA_OPTIONS=%JAVA_OPTIONS%
echo.%JS7_AGENT_JAVA_OPTIONS% | findstr /I /C:-Xms >nul
if ERRORLEVEL 1 set JS7_AGENT_JAVA_OPTIONS=%JS7_AGENT_JAVA_OPTIONS% -Xms100m
echo.%JS7_AGENT_JAVA_OPTIONS% | findstr /I /C:-Dfile.encoding >nul
if ERRORLEVEL 1 set JS7_AGENT_JAVA_OPTIONS=%JS7_AGENT_JAVA_OPTIONS% -Dfile.encoding=UTF-8


rem ##########################
rem # set and check java
set JAVABIN=java.exe
if exist "%JAVA_HOME%\bin\java.exe" set JAVABIN=%JAVA_HOME%\bin\java.exe


rem ##########################
rem # ... and action
:action
if "%JS7_AGENT_COMMAND%"=="start"   goto do_start
if "%JS7_AGENT_COMMAND%"=="stop"    goto do_stop
if "%JS7_AGENT_COMMAND%"=="abort"   goto do_abort
if "%JS7_AGENT_COMMAND%"=="restart" goto do_restart
if "%JS7_AGENT_COMMAND%"=="status"  goto do_status
if "%JS7_AGENT_COMMAND%"=="switch-over" goto do_switch_over
if "%JS7_AGENT_COMMAND%"=="switch_over" goto do_switch_over
if "%JS7_AGENT_COMMAND%"=="cancel"  goto do_cancel
if "%JS7_AGENT_COMMAND%"=="kill"    goto do_cancel
if "%JS7_AGENT_COMMAND%"=="cert"    goto do_cert
if "%JS7_AGENT_COMMAND%"=="install-service" goto do_install_service
if "%JS7_AGENT_COMMAND%"=="install_service" goto do_install_service
if "%JS7_AGENT_COMMAND%"=="install" goto do_install_service
if "%JS7_AGENT_COMMAND%"=="remove-service"  goto do_remove_service
if "%JS7_AGENT_COMMAND%"=="remove_service"  goto do_remove_service
if "%JS7_AGENT_COMMAND%"=="remove"  goto do_remove_service
if "%JS7_AGENT_COMMAND%"=="start-service"   goto do_start_service
if "%JS7_AGENT_COMMAND%"=="start_service"   goto do_start_service
rem is called only at the end of the installer
if "%JS7_AGENT_COMMAND%"=="setup_start_service" goto do_setup_start_service
if "%JS7_AGENT_COMMAND%"=="setup-start-service" goto do_setup_start_service
if "%JS7_AGENT_COMMAND%"=="show_env" goto do_show_env
if "%JS7_AGENT_COMMAND%"=="show-env" goto do_show_env
goto usage


:usage
echo Usage: %JS7_AGENT_STARTSCRIPT% command [options]
echo   command:
echo     start           [options]
echo     stop            [options]
echo     restart         [options]
echo     status          [options]
echo     cancel          [options]
echo     switch-over     [options]
echo     start-service   [options]
echo     install-service [options]
echo     remove-service  [options]
echo     cert            [cert-options]         ^| see https://kb.sos-berlin.com/x/jLbAAw
echo   options:
echo     --http-port=^<[interface:]number^>       ^| http network interface and port, default: %JS7_AGENT_HTTP_PORT%
echo     --https-port=^<[interface:]number^>      ^| https network interface and port, default: %JS7_AGENT_HTTPS_PORT%
echo     --data-directory=^<directory^>           ^| default: %JS7_AGENT_DATA%
echo     --config-directory=^<directory^>         ^| default: %JS7_AGENT_CONFIG_DIR%
echo     --timeout=^<seconds^>                    ^| timeout for terminating jobs on Agent stop
echo     --java-options=^<java options^>          ^| default: %JS7_AGENT_JAVA_OPTIONS%; see https://kb.sos-berlin.com/x/uYo7B
echo   switches:
echo     -f ^| --fail-over                       ^| fail-over active role on stop and restart
echo     -c ^| --curl                            ^| use curl instead of Java http client
echo.
call :more_info
exit /b 0


:more_info
echo see https://kb.sos-berlin.com/x/ZqrAAw for more information.
goto final


:set_class_path
set JS7_AGENT_LIBDIR=%JS7_AGENT_HOME:\=/%/lib
if not defined JS7_AGENT_TZ (
  if exist "%JS7_AGENT_HOME%\lib\classes\DefaultTimeZone.class" (
    for /f "usebackq" %%i in (`java -classpath "%JS7_AGENT_LIBDIR%/classes" DefaultTimeZone 2^>nul`) do set JS7_AGENT_TZ=%%i
  )
)
if not defined JS7_AGENT_TZ set JS7_AGENT_TZ=Etc/UTC
set JS7_AGENT_CLASSPATH=%JS7_AGENT_CONFIG_DIR:\=/%/patches/*;%JS7_AGENT_CONFIG_DIR:\=/%/lib/*;%JS7_AGENT_LIBDIR%/patches/*;%JS7_AGENT_LIBDIR%/user_lib/*;%JS7_AGENT_LIBDIR%/sos/*;%JS7_AGENT_LIBDIR%/3rd-party/*;%JS7_AGENT_LIBDIR%/jdbc/*
if exist "%JS7_AGENT_CONFIG_DIR%\log4j2.xml" (
  set "JS7_AGENT_CLASSPATH=%JS7_AGENT_CONFIG_DIR:\=/%;%JS7_AGENT_CLASSPATH%"
) else (
  set "JS7_AGENT_CLASSPATH=%JS7_AGENT_LIBDIR%;%JS7_AGENT_CLASSPATH%"
)
goto final


:do_start
call :running
if %JS7_AGENT_IS_RUNNING% equ 1 (
  call :message "...JS7 Agent(%JS7_AGENT_PORT%) already running"
  exit /b 0 
)
call :cleanup_workdir
call :set_class_path
start "JS7AgentW" /B "%COMSPEC%" /C "%JS7_AGENT_HOME%\bin\agent_watchdog.cmd" -%JS7_AGENT_PORT%
if ERRORLEVEL 1 (
  exit /b %ERRORLEVEL%
) else (
  goto create_pid_file
)
goto finally


:do_stop
call :running
if %JS7_AGENT_IS_RUNNING% equ 0 (
  echo ...not started!
  goto finally
)
set /a RESTART_AGENT=%RESTART_AGENT%+%JS7_AGENT_RUNNING_AS_SERVICE%
if %WITH_FAILOVER% equ 1 (
  call :call_emergency_stop
) else (
  call :call_shutdown
)
if %RESTART_AGENT% equ 3 goto do_start_service
if %RESTART_AGENT% equ 2 goto do_start
goto finally


:call_shutdown
call :message "...try to terminate the JS7 Agent(%JS7_AGENT_PORT%)"
call :wait_for_session_token
if %JS7_AGENT_STOP_TIMEOUT% equ -2 (
  call :command POST "{\"TYPE\": \"ShutDown\", \"processSignal\": \"SIGKILL\"}"
) else (
  call :command POST "{\"TYPE\": \"ShutDown\"}"
)
if ERRORLEVEL 1 (
  call :message "...could not terminate the JS7 Agent(%JS7_AGENT_PORT%)"
  exit /b 3
) else (
  call :sleep 2
  call :wait_for_termination
  if not ERRORLEVEL 1 echo ...terminated!
  call :remove_pid_file
)
goto final


:do_abort
call :running
if %JS7_AGENT_IS_RUNNING% equ 0 (
  echo ...not started!
  goto finally
)
call :call_emergency_stop
goto finally


:call_emergency_stop
call :message "...try to terminate forcibly the JS7 Agent(%JS7_AGENT_PORT%)"
call :wait_for_session_token
call :command POST "{\"TYPE\": \"EmergencyStop\"}" 2>null
call :sleep 2
call :running
if %JS7_AGENT_IS_RUNNING% equ 1 (
  call :message "...could not terminate the JS7 Agent(%JS7_AGENT_PORT%)"
  exit /b 3
) else (
  echo ...forcibly terminated!
  call :remove_pid_file
)
goto final


:do_cancel
call :running
if %JS7_AGENT_IS_RUNNING% equ 0 (
  echo ...not started!
  goto finally
)
if x%JS7_AGENT_PID%==x (
  echo ...the pid of the JS7 Agent^(%JS7_AGENT_PORT%^) process couldn't determine!
  exit /b 3
)
call :message "...try to cancel the JS7 Agent(%JS7_AGENT_PORT%)"
call :no_mercy
goto finally


:do_switch_over
call :running
if %JS7_AGENT_IS_RUNNING% equ 0 (
  echo ...not started!
  goto finally
)
call :message "...try to switch over the Agent cluster of JS7 Agent(%JS7_AGENT_PORT%)"
call :command POST "{\"TYPE\": \"ClusterSwitchOver\"}"
goto finally


:no_mercy
set /a JS7_AGENT_STOP_TIMEOUT=-2
taskkill /F /PID %JS7_AGENT_PID% > nul
if ERRORLEVEL 1 (
  call :message "...could not cancel the JS7 Agent(%JS7_AGENT_PORT%)"
  exit /b 3
) else (
  echo ...canceled!
  call :remove_pid_file
) 
goto finally


:do_restart
set /a RESTART_AGENT=2
goto do_stop


:do_status
call :command GET "?"
if ERRORLEVEL 1 (
  echo ...JS7 Agent^(%JS7_AGENT_PORT%^) not started?
  exit /b 3
)
goto finally


:do_install_service
if not exist "%JS7_AGENT_HOME%\service\install_agent_windows_service.cmd" (
  echo ...service install script "..\service\install_agent_windows_service.cmd" is missing.
  exit /b 2
)
call "%JS7_AGENT_HOME%\service\install_agent_windows_service.cmd" "%JS7_AGENT_HTTP_PORT%" ^
  "%JS7_AGENT_DATA%" "%JS7_AGENT_LOGS%" "%JS7_AGENT_HTTPS_PORT%" "" "" "%JS7_AGENT_HOME%"
goto finally


:do_remove_service
if not exist "%JS7_AGENT_HOME%\service\uninstall_agent_windows_service.cmd" (
  echo ...service remove script "..\service\uninstall_agent_windows_service.cmd" is missing.
  exit /b 2
)
call "%JS7_AGENT_HOME%\service\uninstall_agent_windows_service.cmd" ^
  "%JS7_AGENT_PORT%" "%JS7_AGENT_DATA%" "%JS7_AGENT_LOGS%" "%JS7_AGENT_HOME%"
goto finally


:do_start_service
call :running
if %JS7_AGENT_IS_RUNNING% equ 1 (
  call :message "...JS7 Agent(%JS7_AGENT_PORT%) already running"
  exit /b 0 
)
if %RESTART_AGENT% equ 0 sc.exe query %SERVICE_NAME%
if ERRORLEVEL 1 goto finally
"%JS7_AGENT_HOME%\service\%SERVICE_NAME%.exe" //ES/%SERVICE_NAME%
if ERRORLEVEL 1 (
  echo Failed to start JS7 Agent^(%JS7_AGENT_PORT%^) service. Refer to log in "%JS7_AGENT_LOGS%"
  exit /b 2
)
sc.exe query %SERVICE_NAME%
echo ...JS7 Agent^(%JS7_AGENT_PORT%^) service has been started.
goto finally


:do_setup_start_service
call :do_start_service
if ERRORLEVEL 1 exit /b 0
echo.
echo ...check connection in 20 seconds
call :sleep 20
echo.
call :do_status
exit /b 0


:do_show_env
set JS7_AGENT_
set JAVA_
exit /b 0


:do_cert
set JS7_AGENT_LIBDIR=%JS7_AGENT_HOME:\=/%/lib
call "%JAVABIN%" -Xmx50m -Djs7.config-directory="%JS7_AGENT_CONFIG_DIR%" ^
  -classpath "%JS7_AGENT_LIBDIR%/http-client;%JS7_AGENT_LIBDIR%/patches;%JS7_AGENT_CONFIG_DIR:\=/%/patches/*;%JS7_AGENT_CONFIG_DIR:\=/%/lib/*;%JS7_AGENT_LIBDIR%/patches/*;%JS7_AGENT_LIBDIR%/sos/*;%JS7_AGENT_LIBDIR%/3rd-party/*" ^
  com.sos.cli.ExecuteRollOut %*
exit /b %ERRORLEVEL%
goto finally


:with_curl
where curl 1>nul 2>nul
if ERRORLEVEL 1 set WITH_CURL=0
if not exist "%JS7_AGENT_DATA%\work\session-token" set WITH_CURL=0
goto final


:command
call :with_curl
if %WITH_CURL% equ 1 (
  call :command_with_curl "%~1" "%~2"
) else (
  call :command_with_agent_client "%~2"
)
goto final


:command_with_agent_client
set JS7_AGENT_LIBDIR=%JS7_AGENT_HOME:\=/%/lib
call :set_url
call "%JAVABIN%" -Xmx50m -classpath "%JS7_AGENT_LIBDIR%/http-client;%JS7_AGENT_LIBDIR%/sos/*;%JS7_AGENT_LIBDIR%/3rd-party/*" ^
  js7.agent.client.main.AgentClientMain %JS7_AGENT_URL% --data-directory="%JS7_AGENT_DATA%" --config-directory="%JS7_AGENT_CONFIG_DIR%" %*
exit /b %ERRORLEVEL%
goto final


:command_with_curl
for /f "usebackq tokens=1" %%i in (`type "%JS7_AGENT_DATA%\work\session-token"`) do set TOKEN=%%i
call :set_url
if x%~1==xPOST (
  curl --fail -L -X POST -d "%~2" -H "X-JS7-Session: %TOKEN%" -H "Content-Type: application/json" "%JS7_AGENT_URL%/subagent/api/command"
) else (
  curl --fail -L -H "X-JS7-Session: %TOKEN%" "%JS7_AGENT_URL%/subagent/api%~2"
)
echo.
exit /b %ERRORLEVEL%
goto final


:running
set /a JS7_AGENT_IS_RUNNING=0
set JS7_AGENT_PID=
set JS7_AGENT_PID_FROMWMIC=
if not exist "%JS7_AGENT_PID_FILE%" goto running2
for /f "usebackq tokens=1" %%i in (`type "%JS7_AGENT_PID_FILE%"`) do set JS7_AGENT_PID=%%i
if x%JS7_AGENT_PID%==x goto running2
rem check if process exist with pid from pidfile
for /f "usebackq tokens=2 delims==" %%i in (`wmic process where "processid=%JS7_AGENT_PID%" get processid /format:value 2^>nul`) do set JS7_AGENT_PID_FROMWMIC=%%i
if x%JS7_AGENT_PID_FROMWMIC% == x%JS7_AGENT_PID% set /a JS7_AGENT_IS_RUNNING=1
goto running3
:running2
if not exist "%JS7_AGENT_DATA%\work\session-token" goto running3
call :command GET "?" >nul 2>nul
if %ERRORLEVEL% equ 0 set /a JS7_AGENT_IS_RUNNING=1
:running3
call :running_as_service
if %JS7_AGENT_IS_RUNNING% equ 0 goto remove_pid_file
goto final


:running_as_service
set /a JS7_AGENT_RUNNING_AS_SERVICE=0
for /F "usebackq tokens=3 delims=: " %%i in (`sc.exe query %SERVICE_NAME% ^| findstr /I "STATE"`) do (
  if /I x%%i==xRUNNING set /a JS7_AGENT_RUNNING_AS_SERVICE=1
)
goto final


:message
echo|set /p="%~1 "
if %JS7_AGENT_RUNNING_AS_SERVICE% equ 1 echo|set /p="as service "
if x%JS7_AGENT_PID%==x (
  echo !
) else (
  echo with pid=%JS7_AGENT_PID%!
)
goto final


:wait_for_termination
call :sleep 2
call :running
if %JS7_AGENT_IS_RUNNING% equ 0 goto final
set /a LOOP_COUNTER=%LOOP_COUNTER%+2
if %LOOP_COUNTER% equ 2 echo|set /p=...waiting for termination
if %JS7_AGENT_STOP_TIMEOUT% gtr -1 (
  if %LOOP_COUNTER% geq %JS7_AGENT_STOP_TIMEOUT% (
    echo ..timeout reached
    call :message "...try to cancel the JS7 Agent(%JS7_AGENT_PORT%)"
    call :no_mercy
    if not ERRORLEVEL 1 goto finally
  )
)  
echo|set /p=..
goto wait_for_termination


:wait_for_session_token
set /a LOOP_SESSION=%LOOP_SESSION%+2
if not exist "%JS7_AGENT_DATA%\work\session-token" (
  if %LOOP_SESSION% geq 10 (
	echo "%JS7_AGENT_DATA%\work\session-token" doesn't exist: command cannot be sent
	goto finally
  )
  echo "%JS7_AGENT_DATA%\work\session-token" doesn't exist: ...waiting  
  call :sleep 2
  goto wait_for_session_token
)
goto finally


:normalize_home
set JS7_AGENT_HOME=%~dp1
set JS7_AGENT_HOME=%JS7_AGENT_HOME:~0,-1%
goto final


:sleep
waitfor SomethingThatNeverHappens /t %1 >nul 2>nul
exit /B 0
goto final


:create_pid_file
set /a CREATE_PID_FILE_TRIAL=%CREATE_PID_FILE_TRIAL%+1
set JS7_AGENT_PID_FROMWMIC=
if %CREATE_PID_FILE_TRIAL% geq 3 (
  echo ...the pid of the JS7 Agent^(%JS7_AGENT_PORT%^) process couldn't determine!
  exit /b 3
)
for /f "usebackq tokens=2 delims==" %%i in (`wmic process where "commandline like '%%js7.agent.main.AgentMain%%-http-port=%JS7_AGENT_HTTP_PORT%%%' and caption like '%%java%%'" get processid /format:value 2^>nul`) do set JS7_AGENT_PID_FROMWMIC=%%i
if x%JS7_AGENT_PID_FROMWMIC% == x (
  call :sleep 2
  goto create_pid_file
) else (
  echo %JS7_AGENT_PID_FROMWMIC% > "%JS7_AGENT_PID_FILE%"
)
if exist "%JS7_AGENT_PID_FILE%" (
  echo ...JS7 Agent^(%JS7_AGENT_PORT%^) started with pid=%JS7_AGENT_PID_FROMWMIC%!
  echo ...see log file "%JS7_AGENT_LOGS%\agent.log"
  exit /b %ERRORLEVEL%
) else (
  echo ...pid file "%JS7_AGENT_PID_FILE%" could not created!
  echo ...please check the permissions in "%JS7_AGENT_PID_FILE_DIR%".
  call :more_info
  rem taskkill /F /PID %JS7_AGENT_PID_FROMWMIC% > nul
  exit /b 3
)
goto finally


:remove_pid_file
if exist "%JS7_AGENT_PID_FILE%" del "%JS7_AGENT_PID_FILE%"
goto final


:cleanup_workdir
if exist "%JS7_AGENT_CRASH_FILE%" del "%JS7_AGENT_CRASH_FILE%"
rem if exist "%JS7_AGENT_DATA%\work" rmdir /S /Q "%JS7_AGENT_DATA%\work"
if not exist "%JS7_AGENT_DATA%\work" mkdir "%JS7_AGENT_DATA%\work"
if ERRORLEVEL 1 (
  echo ...could not create "%JS7_AGENT_DATA%\work"
  echo ...please check the permissions
  call :more_info
  exit /b %ERRORLEVEL%
)
goto final


:add_ip_address
set NEW_IP_ADDRESS=%~2
if defined NEW_IP_ADDRESS set NEW_IP_ADDRESS=%NEW_IP_ADDRESS%:
for /F "tokens=1,2 delims=:" %%i in ("%~1") do (
  if x%%j==x (
    call :set_url_schema %NEW_IP_ADDRESS%%%i
    goto final
  )
  if x%%i==x0.0.0.0 (
    call :set_url_schema %NEW_IP_ADDRESS%%%j
    goto final
  )
  call :set_url_schema %~1
  goto final
)


:set_url
set JS7_AGENT_URL=
if exist "%JS7_AGENT_DATA%\work\http-uri" (
  for /F "usebackq tokens=1,2 delims=/" %%i in (`type "%JS7_AGENT_DATA%\work\http-uri"`) do set JS7_AGENT_URL=%%i//%%j
)
if not defined JS7_AGENT_URL call :set_agent_default_http_url
goto final


:extract_port
for /F "tokens=1,2 delims=:" %%i in ("%~1") do (
  if x%%j==x (
    call :set_port %%i
    goto final
  )
  call :set_port %%j
  goto final
)


:set_url_schema
set JS7_AGENT_URL_SCHEMA=%~1
goto final


:set_agent_default_http_url
call :add_ip_address %JS7_AGENT_HTTP_PORT% 127.0.0.1
set JS7_AGENT_URL=http://%JS7_AGENT_URL_SCHEMA%
goto final


:set_port
set JS7_AGENT_PORT=%~1
goto final


:finally
exit /b %ERRORLEVEL%

ENDLOCAL
:final