@echo off

rem #  ------------------------------------------------------------
rem #  Company: Software- und Organisations-Service GmbH
rem #  Purpose: Watchdog script for JS7 Agent
rem #  ------------------------------------------------------------

echo "%JAVABIN%" ^
 -DJS7.Agent=%JS7_AGENT_PORT% %JS7_AGENT_JAVA_OPTIONS% ^
 -classpath "%JS7_AGENT_CLASSPATH%" js7.agent.main.AgentMain ^
 --http-port=%JS7_AGENT_HTTP_PORT% %HTTPS_PORT_OPTION% ^
 --config-directory="%JS7_AGENT_CONFIG_DIR%" ^
 --data-directory="%JS7_AGENT_DATA%" ^
 --job-working-directory="%JS7_AGENT_WORK_DIR%" >"%JS7_AGENT_LOGS%\watchdog.log"
 
if defined JS7_AGENT_KILL_SCRIPT echo --kill-script option is not longer supported >>"%JS7_AGENT_LOGS%\watchdog.log"
 
start "JS7Agent" /D "%JS7_AGENT_DATA%" /B /WAIT "%JAVABIN%" ^
 -DJS7.Agent=%JS7_AGENT_PORT% %JS7_AGENT_JAVA_OPTIONS% ^
 -classpath "%JS7_AGENT_CLASSPATH%" js7.agent.main.AgentMain ^
 --http-port=%JS7_AGENT_HTTP_PORT% %HTTPS_PORT_OPTION% ^
 --config-directory="%JS7_AGENT_CONFIG_DIR%" ^
 --data-directory="%JS7_AGENT_DATA%" ^
 --job-working-directory="%JS7_AGENT_WORK_DIR%" >>"%JS7_AGENT_LOGS%\watchdog.log" 2>&1
 
set /a JS7_AGENT_EXIT=%ERRORLEVEL%

echo ...JS7 Agent terminates with exit code %JS7_AGENT_EXIT% >> "%JS7_AGENT_LOGS%\watchdog.log"

if exist "%JS7_AGENT_PID_FILE%" del "%JS7_AGENT_PID_FILE%"
rem if %JS7_AGENT_EXIT% equ 0 goto finally

if exist "%JS7_AGENT_CRASH_FILE%" (
  call :call_crash_pid_file_killer "%JS7_AGENT_CRASH_FILE%"
)
goto restart

:call_crash_pid_file_killer
set /a JS7_AGENT_CRASH_FILE_SIZE=%~z1
rem "%JS7_AGENT_DATA%\state\lock" must exist
if not exist "%JS7_AGENT_DATA%\state\lock" goto final
rem "%JS7_AGENT_CRASH_FILE%" must exist and not empty
if %JS7_AGENT_CRASH_FILE_SIZE% equ 0 goto final
set PID_IN_LOCK=0
for /f "usebackq tokens=1" %%i in (`type "%JS7_AGENT_DATA%\state\lock" 2^>nul`) do set PID_IN_LOCK=%%~i
rem lock file has to be readable
if not defined PID_IN_LOCK goto final
if x%PID_IN_LOCK% == x0 goto final

"%JAVABIN%" -Xmx100m -classpath "%JS7_AGENT_CLASSPATH%" ^
js7.launcher.crashpidfile.CrashPidFileKiller --data-directory="%JS7_AGENT_DATA%" >>"%JS7_AGENT_LOGS%\watchdog.log" 2>&1
goto final

:restart
rem abort and restart
if %JS7_AGENT_EXIT% equ 98 (
  if exist "%JS7_AGENT_INSTANCESCRIPT%" call "%JS7_AGENT_INSTANCESCRIPT%" start
)
rem terminate and restart
if %JS7_AGENT_EXIT% equ 97 (
  if exist "%JS7_AGENT_INSTANCESCRIPT%" call "%JS7_AGENT_INSTANCESCRIPT%" start
)

:finally
exit %JS7_AGENT_EXIT%

:final
