/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.checklog.classes;

import com.sos.commons.exception.SOSMissingDataException;
import com.sos.inventory.model.instruction.CaseWhen;
import com.sos.inventory.model.instruction.ConsumeNotices;
import com.sos.inventory.model.instruction.Cycle;
import com.sos.inventory.model.instruction.ForkJoin;
import com.sos.inventory.model.instruction.ForkList;
import com.sos.inventory.model.instruction.IfElse;
import com.sos.inventory.model.instruction.Instruction;
import com.sos.inventory.model.instruction.Lock;
import com.sos.inventory.model.instruction.NamedJob;
import com.sos.inventory.model.instruction.Options;
import com.sos.inventory.model.instruction.RetryCatch;
import com.sos.inventory.model.instruction.StickySubagent;
import com.sos.inventory.model.instruction.TryCatch;
import com.sos.inventory.model.instruction.When;
import com.sos.inventory.model.workflow.Branch;
import com.sos.jitl.jobs.checklog.CheckLogJobArguments;
import com.sos.jitl.jobs.checklog.classes.CheckLogWebserviceExecuter;
import com.sos.joc.model.job.JobsFilter;
import com.sos.joc.model.job.RunningTaskLogFilter;
import com.sos.joc.model.job.TaskHistory;
import com.sos.joc.model.job.TaskHistoryItem;
import com.sos.joc.model.order.OrderFilter;
import com.sos.joc.model.order.OrderV;
import com.sos.joc.model.workflow.Workflow;
import com.sos.joc.model.workflow.WorkflowFilter;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckLog {
    private OrderProcessStepLogger logger;
    private CheckLogJobArguments args;
    OrderProcessStep<CheckLogJobArguments> step;
    private long checkLogMatchCount = 0L;
    private long checkLogGroupCount = 0L;
    private long checkLogGroupsMatchesCount = 0L;
    private String checkLogMatches = "";
    private String checkLogMatchedGroups = "";
    private boolean matchFound = false;

    public CheckLog(OrderProcessStep<CheckLogJobArguments> step) {
        this.args = (CheckLogJobArguments)step.getDeclaredArguments();
        this.logger = step.getLogger();
        this.step = step;
    }

    private String handleInstruction(List<Instruction> instructions, Map<String, Integer> jobCount, Map<String, String> label2Job) {
        String returnValue = "";
        String s = "";
        block13: for (Instruction instruction : instructions) {
            switch (instruction.getTYPE()) {
                case EXECUTE_NAMED: {
                    NamedJob namedJob = (NamedJob)instruction;
                    int count = jobCount.getOrDefault(namedJob.getJobName(), 0);
                    jobCount.put(namedJob.getJobName(), count + 1);
                    label2Job.put(instruction.getLabel(), namedJob.getJobName());
                    if (!namedJob.getJobName().equals(this.args.getJob())) break;
                    returnValue = instruction.getLabel();
                    break;
                }
                case TRY: {
                    if (!instruction.isRetry().booleanValue()) {
                        TryCatch tryCatch = (TryCatch)instruction;
                        s = this.handleInstruction(tryCatch.getTry().getInstructions(), jobCount, label2Job);
                        if (s == null || s.isEmpty()) continue block13;
                        returnValue = s;
                        break;
                    }
                    RetryCatch retryCatch = (RetryCatch)instruction;
                    s = this.handleInstruction(retryCatch.getTry().getInstructions(), jobCount, label2Job);
                    if (s == null || s.isEmpty()) continue block13;
                    returnValue = s;
                    break;
                }
                case IF: {
                    IfElse ifElse = (IfElse)instruction;
                    if (ifElse.getThen() != null && (s = this.handleInstruction(ifElse.getThen().getInstructions(), jobCount, label2Job)) != null && !s.isEmpty()) {
                        returnValue = s;
                    }
                    if (ifElse.getElse() == null || (s = this.handleInstruction(ifElse.getElse().getInstructions(), jobCount, label2Job)) == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
                case CASE_WHEN: {
                    CaseWhen caseWhen = (CaseWhen)instruction;
                    if (caseWhen.getCases() != null) {
                        for (When when : caseWhen.getCases()) {
                            s = this.handleInstruction(when.getThen().getInstructions(), jobCount, label2Job);
                            if (s == null || s.isEmpty()) continue;
                            returnValue = s;
                        }
                    }
                    if (caseWhen.getElse() == null || (s = this.handleInstruction(caseWhen.getElse().getInstructions(), jobCount, label2Job)) == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
                case FORK: {
                    When when;
                    ForkJoin forkJoin = (ForkJoin)instruction;
                    when = forkJoin.getBranches().iterator();
                    while (when.hasNext()) {
                        Branch branch = (Branch)when.next();
                        s = this.handleInstruction(branch.getWorkflow().getInstructions(), jobCount, label2Job);
                        if (s == null || s.isEmpty()) continue;
                        returnValue = s;
                    }
                    continue block13;
                }
                case FORKLIST: {
                    ForkList forkList = (ForkList)instruction;
                    s = this.handleInstruction(forkList.getWorkflow().getInstructions(), jobCount, label2Job);
                    if (s == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
                case LOCK: {
                    Lock lock = (Lock)instruction;
                    s = this.handleInstruction(lock.getLockedWorkflow().getInstructions(), jobCount, label2Job);
                    if (s == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
                case STICKY_SUBAGENT: {
                    StickySubagent stickySubagent = (StickySubagent)instruction;
                    s = this.handleInstruction(stickySubagent.getSubworkflow().getInstructions(), jobCount, label2Job);
                    if (s == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
                case CYCLE: {
                    Cycle cycle = (Cycle)instruction;
                    s = this.handleInstruction(cycle.getCycleWorkflow().getInstructions(), jobCount, label2Job);
                    if (s == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
                case OPTIONS: {
                    Options options = (Options)instruction;
                    s = this.handleInstruction(options.getBlock().getInstructions(), jobCount, label2Job);
                    if (s == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
                case CONSUME_NOTICES: {
                    ConsumeNotices consumeNotices = (ConsumeNotices)instruction;
                    s = this.handleInstruction(consumeNotices.getSubworkflow().getInstructions(), jobCount, label2Job);
                    if (s == null || s.isEmpty()) break;
                    returnValue = s;
                    break;
                }
            }
        }
        return returnValue;
    }

    private Long checkJob2LabelAssignment(String accessToken, CheckLogWebserviceExecuter orderStateWebserviceExecuter) throws Exception {
        OrderFilter orderFilter = new OrderFilter();
        orderFilter.setControllerId(this.step.getControllerId());
        orderFilter.setOrderId(this.step.getOrderId());
        orderFilter.setWithoutWorkflowTags(Boolean.valueOf(true));
        OrderV order = null;
        Integer t = this.args.getTimeout();
        while (t > 0) {
            try {
                order = orderStateWebserviceExecuter.getOrder(orderFilter, accessToken);
                t = 0;
            }
            catch (SOSMissingDataException e) {
                this.logger.info((Object)"... waiting for order information");
                Thread.sleep(3000L);
                t = t - 3;
            }
        }
        WorkflowFilter workflowFilter = new WorkflowFilter();
        workflowFilter.setCompact(Boolean.valueOf(false));
        workflowFilter.setControllerId(this.step.getControllerId());
        workflowFilter.setWorkflowId(order.getWorkflowId());
        Workflow workflow = orderStateWebserviceExecuter.getWorkflow(workflowFilter, accessToken);
        JobsFilter jobsFilter = new JobsFilter();
        jobsFilter.setControllerId(this.step.getControllerId());
        jobsFilter.setOrderId(this.step.getOrderId() + "*");
        jobsFilter.setJobName(this.args.getJob());
        jobsFilter.setWorkflowName(this.step.getWorkflowName());
        jobsFilter.setWithoutWorkflowTags(Boolean.valueOf(true));
        String label = this.args.getLabel();
        String defaultLabel = "";
        Long taskId = 0L;
        if (workflow != null) {
            HashMap<String, Integer> jobCount = new HashMap<String, Integer>();
            HashMap<String, String> label2Job = new HashMap<String, String>();
            defaultLabel = this.handleInstruction(workflow.getWorkflow().getInstructions(), jobCount, label2Job);
            if (jobCount.get(this.args.getJob()) == null) {
                throw new Exception("could not find job '" + this.args.getJob() + " in workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller '" + workflowFilter.getControllerId() + "'");
            }
            if ((Integer)jobCount.get(this.args.getJob()) > 1) {
                if (this.args.getLabel() == null) {
                    throw new Exception("value for <label> not specified, job '" + this.args.getJob() + " occurs " + jobCount.get(this.args.getJob()) + " times in workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller '" + workflowFilter.getControllerId() + "'");
                }
                if (label2Job.get(this.args.getLabel()) == null) {
                    throw new Exception("could not find label '" + this.args.getLabel() + "', job '" + this.args.getJob() + " occurs " + jobCount.get(this.args.getJob()) + " times in workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller '" + workflowFilter.getControllerId() + "'");
                }
            } else {
                label = defaultLabel;
            }
            if (this.args.getLabel() != null) {
                if (label2Job.get(this.args.getLabel()) == null) {
                    throw new Exception("could not find job configured with label '" + this.args.getLabel() + " in workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller '" + workflowFilter.getControllerId() + "'");
                }
                if (!((String)label2Job.get(this.args.getLabel())).equals(this.args.getJob())) {
                    throw new Exception("the label '" + this.args.getLabel() + "' is assigned to the job '" + (String)label2Job.get(this.args.getLabel()) + "' and not to the job '" + this.args.getJob() + "' in workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller '" + workflowFilter.getControllerId() + "'");
                }
            }
            t = this.args.getTimeout();
            TaskHistory taskHistory = null;
            HashMap<String, Long> label2TaskId = new HashMap<String, Long>();
            while (t > 0) {
                taskHistory = orderStateWebserviceExecuter.getTaskHistory(jobsFilter, accessToken);
                jobCount.clear();
                label2Job.clear();
                label2TaskId.clear();
                try {
                    for (TaskHistoryItem taskHistoryItem : taskHistory.getHistory()) {
                        if (taskHistoryItem.getTaskId() == null) continue;
                        int count = jobCount.getOrDefault(taskHistoryItem.getJob(), 0);
                        jobCount.put(taskHistoryItem.getJob(), count + 1);
                        label2Job.put(taskHistoryItem.getLabel(), taskHistoryItem.getJob());
                        if (label2TaskId.get(taskHistoryItem.getLabel()) != null) continue;
                        label2TaskId.put(taskHistoryItem.getLabel(), taskHistoryItem.getTaskId());
                    }
                    if (jobCount.get(this.args.getJob()) == null) {
                        throw new Exception("job '" + this.args.getJob() + "' was not executed in workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller " + workflowFilter.getControllerId() + "'");
                    }
                    if ((Integer)jobCount.get(this.args.getJob()) > 1) {
                        if (this.args.getLabel() == null) {
                            throw new Exception("value for <label> not specified, job '" + this.args.getJob() + "' occurs " + jobCount.get(this.args.getJob()) + " times in workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller '" + workflowFilter.getControllerId() + "'");
                        }
                        if (label2Job.get(this.args.getLabel()) == null) {
                            throw new Exception("job with label '" + this.args.getLabel() + "' was not executed, job '" + this.args.getJob() + "' occurs " + jobCount.get(this.args.getJob()) + " times in the history for the workflow '" + workflowFilter.getWorkflowId().getPath() + "' version '" + workflowFilter.getWorkflowId().getVersionId() + "' on Controller " + workflowFilter.getControllerId() + "'");
                        }
                    }
                    t = 0;
                }
                catch (Exception e) {
                    t = t - 3;
                    if (t <= 0) {
                        throw e;
                    }
                    this.logger.info((Object)"... waiting for task history");
                    Thread.sleep(3000L);
                }
            }
            taskId = (Long)label2TaskId.get(label);
        }
        return taskId;
    }

    private void matchLog(String log) {
        int options = 0;
        if (this.args.getCaseInsensitive().booleanValue()) {
            this.logger.debug((Object)"CASE_INSITIVE");
            options += 2;
        }
        if (this.args.getMultiline().booleanValue()) {
            this.logger.debug((Object)"MULTILINE");
            options += 8;
        }
        if (this.args.getUnixLines().booleanValue()) {
            this.logger.debug((Object)"UNIX_LINES");
            ++options;
        }
        Pattern pattern = Pattern.compile(this.args.getPattern(), options);
        Matcher matcher = pattern.matcher(log);
        this.checkLogMatchCount = matcher.results().count();
        this.matchFound = this.checkLogMatchCount > 0L;
        matcher.reset();
        while (matcher.find()) {
            this.checkLogMatches = this.checkLogMatches + this.args.getSeparator() + matcher.group(0);
            this.logger.debug((Object)("match: " + matcher.group(0)));
        }
        matcher.reset();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                this.logger.debug((Object)("Group" + i + ":" + matcher.group(i)));
                ++this.checkLogGroupsMatchesCount;
                this.checkLogMatchedGroups = this.checkLogMatchedGroups + this.args.getSeparator() + matcher.group(i);
            }
        }
        if (this.checkLogMatchedGroups.startsWith(this.args.getSeparator())) {
            this.checkLogMatchedGroups = this.checkLogMatchedGroups.substring(1);
        }
        if (this.checkLogMatches.startsWith(this.args.getSeparator())) {
            this.checkLogMatches = this.checkLogMatches.substring(1);
        }
        this.checkLogGroupCount = matcher.groupCount();
        this.logger.debug((Object)(this.checkLogMatchCount + " matches"));
        this.logger.debug((Object)("matched:" + this.matchFound));
        this.logger.debug((Object)this.checkLogMatches);
        this.logger.debug((Object)("groupCount:" + matcher.groupCount()));
        this.logger.debug((Object)this.checkLogMatchedGroups);
    }

    public void execute() throws Exception {
        ApiExecutor apiExecutor = new ApiExecutor(this.logger);
        String accessToken = null;
        try {
            ApiResponse apiResponse = apiExecutor.login();
            accessToken = apiResponse.getAccessToken();
            CheckLogWebserviceExecuter orderStateWebserviceExecuter = new CheckLogWebserviceExecuter(this.logger, apiExecutor);
            Long taskId = this.checkJob2LabelAssignment(accessToken, orderStateWebserviceExecuter);
            RunningTaskLogFilter runningTaskLogFilter = new RunningTaskLogFilter();
            runningTaskLogFilter.setControllerId(this.step.getControllerId());
            runningTaskLogFilter.setTaskId(taskId);
            String taskLog = orderStateWebserviceExecuter.getTaskLog(runningTaskLogFilter, accessToken);
            this.matchLog(taskLog);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (accessToken != null) {
                apiExecutor.logout(accessToken);
            }
            apiExecutor.close();
        }
    }

    public long getCheckLogMatchCount() {
        return this.checkLogMatchCount;
    }

    public String getCheckLogMatches() {
        return this.checkLogMatches;
    }

    public String getCheckLogMatchedGroups() {
        return this.checkLogMatchedGroups;
    }

    public boolean isMatchFound() {
        return this.matchFound;
    }

    public long getCheckLogGroupCount() {
        return this.checkLogGroupCount;
    }

    public long getCheckLogGroupsMatchesCount() {
        return this.checkLogGroupsMatchesCount;
    }
}

