/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.file.common;

import com.sos.commons.util.SOSDate;
import com.sos.jitl.jobs.file.common.FileComparatorAge;
import com.sos.jitl.jobs.file.common.FileComparatorName;
import com.sos.jitl.jobs.file.common.FileComparatorSize;
import com.sos.jitl.jobs.file.common.FilelistFilter;
import com.sos.jitl.jobs.file.exception.SOSFileOperationsException;
import com.sos.js7.job.OrderProcessStepLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class AFileOperations {
    protected static final int CREATE_DIR = 1;
    protected static final int GRACIOUS = 2;
    protected static final int NOT_OVERWRITE = 4;
    protected static final int RECURSIVE = 8;
    protected static final int REMOVE_DIR = 16;
    protected static final int WIPE = 32;
    private final int BUFF_SIZE = 100000;
    private final byte[] buffer = new byte[100000];
    private final OrderProcessStepLogger logger;
    private List<File> resultList = null;

    public AFileOperations(OrderProcessStepLogger logger) {
        this.logger = logger;
        this.resultList = new ArrayList<File>();
    }

    protected abstract boolean handleOneFile(File var1, File var2, boolean var3, boolean var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWrite(File file, String fileSpec, int fileSpecFlags) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getDebugMain(fileSpecFlags));
        }
        if (!(file = new File(this.substituteAllDate(file.getPath()))).exists()) {
            this.logger.info("[%s]no such file or directory", new Object[]{file.getCanonicalPath()});
            return true;
        }
        if (!file.isDirectory()) {
            this.logger.info("[%s]file exists", new Object[]{file.getCanonicalPath()});
            boolean writable = false;
            try (RandomAccessFile f = null;){
                f = new RandomAccessFile(file.getAbsolutePath(), "rw");
                f.close();
                f = null;
                writable = true;
            }
            if (!writable) {
                this.logger.info("[%s]cannot be written", new Object[]{file.getCanonicalPath()});
                return false;
            }
            return true;
        }
        if (fileSpec == null || fileSpec.isEmpty()) {
            this.logger.info("[%s]directory exists", new Object[]{file.getCanonicalPath()});
            return true;
        }
        List<File> fileList = this.getFilelist(file.getPath(), fileSpec, fileSpecFlags, false, 0L, 0L, -1L, -1L, 0, 0);
        if (fileList.isEmpty()) {
            this.logger.info("[%s]directory contains no files matching %s", new Object[]{file.getCanonicalPath(), fileSpec});
            return false;
        }
        this.logger.info("[%s]directory contains %s file(s) matching %s", new Object[]{file.getCanonicalPath(), fileList.size(), fileSpec});
        for (int i = 0; i < fileList.size(); ++i) {
            File checkFile = fileList.get(i);
            this.logger.info("[%s]found file", new Object[]{checkFile.getCanonicalPath()});
            boolean writable = false;
            try (RandomAccessFile f = null;){
                f = new RandomAccessFile(file.getAbsolutePath(), "rw");
                f.close();
                f = null;
                writable = true;
            }
            if (writable) continue;
            this.logger.info("[%s]cannot be written", new Object[]{checkFile.getCanonicalPath()});
            return false;
        }
        this.resultList.addAll(fileList);
        return true;
    }

    public boolean existsFile(File file, String fileSpec, boolean recursive, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        long minAge = SOSDate.getTimeAsMillis((String)minFileAge);
        long maxAge = SOSDate.getTimeAsMillis((String)maxFileAge);
        long minSize = this.calculateFileSize(minFileSize);
        long maxSize = this.calculateFileSize(maxFileSize);
        if (this.logger.isDebugEnabled()) {
            this.debug(this.getDebugMain(fileSpecFlags), null, minFileAge, maxFileAge, minFileSize, maxFileSize);
        }
        if (skipFirstFiles < 0) {
            throw new SOSFileOperationsException("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
        }
        if (skipLastFiles < 0) {
            throw new SOSFileOperationsException("[" + skipLastFiles + "] is no valid value for skipLastFiles");
        }
        if (skipFirstFiles > 0 && skipLastFiles > 0) {
            throw new SOSFileOperationsException("skip only either first files or last files");
        }
        if ((skipFirstFiles > 0 || skipLastFiles > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
            throw new SOSFileOperationsException("missed constraint for file skipping (minFileAge, maxFileAge, minFileSize, maxFileSize)");
        }
        if (!(file = new File(this.substituteAllDate(file.getPath()))).exists()) {
            this.logger.info("[%s]no such file or directory", new Object[]{file.getCanonicalPath()});
            return false;
        }
        if (!file.isDirectory()) {
            long interval;
            long lastModified;
            long currentTime = System.currentTimeMillis();
            if (minAge > 0L) {
                lastModified = file.lastModified();
                interval = currentTime - lastModified;
                if (interval < 0L) {
                    throw new SOSFileOperationsException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval < minAge) {
                    this.logger.info("[%s][lastModified=%s]minimum age required is %s", new Object[]{file.getCanonicalPath(), this.getDateTime(lastModified), minFileAge});
                    return false;
                }
            }
            if (maxAge > 0L) {
                lastModified = file.lastModified();
                interval = currentTime - lastModified;
                if (interval < 0L) {
                    throw new SOSFileOperationsException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval > maxAge) {
                    this.logger.info("[%s][lastModified=%s]maximum age required is %s", new Object[]{file.getCanonicalPath(), this.getDateTime(lastModified), maxFileAge});
                    return false;
                }
            }
            if (minSize > -1L && minSize > file.length()) {
                this.logger.info("[%s][checking file size][%s]minimum size required is %s", new Object[]{file.getCanonicalPath(), file.length(), minFileSize});
                return false;
            }
            if (maxSize > -1L && maxSize < file.length()) {
                this.logger.info("[%s][checking file size][%s]maximum size required is %s", new Object[]{file.getCanonicalPath(), file.length(), maxFileSize});
                return false;
            }
            if (skipFirstFiles > 0 || skipLastFiles > 0) {
                this.logger.info("[%s]skipped", new Object[]{file.getCanonicalPath()});
                return false;
            }
            this.logger.info((Object)file.getCanonicalPath());
            this.resultList.add(file);
            return true;
        }
        if (fileSpec == null || fileSpec.isEmpty()) {
            this.logger.info("[%s]directory exists", new Object[]{file.getCanonicalPath()});
            return true;
        }
        List<File> fileList = this.getFilelist(file.getPath(), fileSpec, fileSpecFlags, recursive, minAge, maxAge, minSize, maxSize, skipFirstFiles, skipLastFiles);
        if (fileList.isEmpty()) {
            this.logger.info("[%s]directory contains no files matching %s", new Object[]{file.getCanonicalPath(), fileSpec});
            return false;
        }
        this.logger.info("[%s]directory contains %s file(s) matching %s", new Object[]{file.getCanonicalPath(), fileList.size(), fileSpec});
        for (File f : fileList) {
            this.logger.info((Object)f.getCanonicalPath());
        }
        this.resultList.addAll(fileList);
        return true;
    }

    public int removeFileCnt(String file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        return this.removeFileCnt(new File(file), fileSpec, flags, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    private int removeFileCnt(File file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        List<File> fileList;
        int removedFiles = 0;
        int removedDirectories = 0;
        boolean recursive = this.has(flags, 8);
        boolean gracious = this.has(flags, 2);
        boolean wipe = this.has(flags, 32);
        boolean removeDir = this.has(flags, 16);
        long minAge = SOSDate.getTimeAsMillis((String)minFileAge);
        long maxAge = SOSDate.getTimeAsMillis((String)maxFileAge);
        long minSize = this.calculateFileSize(minFileSize);
        long maxSize = this.calculateFileSize(maxFileSize);
        if (this.logger.isDebugEnabled()) {
            this.debug(this.getDebugMain(fileSpecFlags), this.getDebugRemoveFlags(flags), minFileAge, maxFileAge, minFileSize, maxFileSize);
        }
        if (skipFirstFiles < 0) {
            throw new SOSFileOperationsException("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
        }
        if (skipLastFiles < 0) {
            throw new SOSFileOperationsException("[" + skipLastFiles + "] is no valid value for skipLastFiles");
        }
        if (skipFirstFiles > 0 && skipLastFiles > 0) {
            throw new SOSFileOperationsException("skip only either first files or last files");
        }
        if ((skipFirstFiles > 0 || skipLastFiles > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
            throw new SOSFileOperationsException("missed constraint for file skipping (minFileAge, maxFileAge, minFileSize, maxFileSize)");
        }
        if (!file.exists()) {
            if (gracious) {
                this.logger.info("[%s]cannot remove file, file does not exist", new Object[]{file.getCanonicalPath()});
                return 0;
            }
            throw new SOSFileOperationsException("file does not exist: " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            if (!file.canRead()) {
                throw new SOSFileOperationsException("directory is not readable: " + file.getCanonicalPath());
            }
            this.logger.info("[%s]remove [%s] %s", new Object[]{file.getCanonicalPath(), fileSpec, recursive ? " (recursive)" : ""});
            fileList = this.getFilelist(file.getPath(), fileSpec, fileSpecFlags, this.has(flags, 8), minAge, maxAge, minSize, maxSize, 0, 0);
        } else {
            fileList = new ArrayList<File>();
            fileList.add(file);
            fileList = this.filelistFilterAge(fileList, minAge, maxAge);
            fileList = this.filelistFilterSize(fileList, minSize, maxSize);
            if (skipFirstFiles > 0 || skipLastFiles > 0) {
                fileList.clear();
            }
        }
        if (sortCriteria.equalsIgnoreCase("age")) {
            fileList.sort(new FileComparatorAge());
        } else if (sortCriteria.equalsIgnoreCase("size")) {
            fileList.sort(new FileComparatorSize());
        } else {
            fileList.sort(new FileComparatorName());
        }
        for (int i = skipFirstFiles; i < fileList.size() - skipLastFiles; ++i) {
            File currentFile = fileList.get(i);
            this.resultList.add(currentFile);
            this.logger.info("[%s]remove file", new Object[]{currentFile.getCanonicalPath()});
            if (wipe) {
                if (!this.wipe(currentFile)) {
                    throw new SOSFileOperationsException("cannot remove file: " + currentFile.getCanonicalPath());
                }
            } else {
                this.delete(currentFile);
            }
            ++removedFiles;
        }
        if (removeDir) {
            int firstSize = this.listFolders(file.getPath(), ".*", 0, recursive).size();
            if (recursive) {
                this.recDeleteEmptyDir(file, fileSpec, fileSpecFlags);
            } else {
                List<File> list = this.listFolders(file.getPath(), fileSpec, fileSpecFlags);
                for (int i = 0; i < list.size(); ++i) {
                    File f = list.get(i);
                    if (!f.isDirectory()) continue;
                    if (!f.canRead()) {
                        throw new SOSFileOperationsException("directory is not readable: " + f.getCanonicalPath());
                    }
                    if (f.list().length == 0) {
                        this.delete(f);
                        this.logger.info("[%s]remove directory", new Object[]{f.getCanonicalPath()});
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[%s]directory cannot be removed because it is not empty", new Object[]{f.getCanonicalPath()});
                    }
                    Object lst = f.list()[0];
                    for (int n = 1; n < f.list().length; ++n) {
                        lst = (String)lst + ", " + f.list()[n];
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("          contained files " + f.list().length + ": " + (String)lst));
                }
            }
            removedDirectories = firstSize - this.listFolders(file.getPath(), ".*", 0, recursive).size();
        }
        Object msg = "";
        if (removeDir) {
            msg = removedDirectories == 1 ? " + 1 directory removed" : " + " + removedDirectories + " directories removed";
        }
        this.logger.info((Object)(removedFiles + " file(s) removed" + (String)msg));
        return removedFiles + removedDirectories;
    }

    private void delete(File f) throws Exception {
        Path path = FileSystems.getDefault().getPath(f.getAbsolutePath(), new String[0]);
        try {
            Files.delete(path);
        }
        catch (NoSuchFileException x) {
            throw new SOSFileOperationsException(path + "no exists");
        }
        catch (DirectoryNotEmptyException x) {
            throw new SOSFileOperationsException(path + "directory not empty");
        }
        catch (IOException x) {
            throw new SOSFileOperationsException(path + "file permission issue");
        }
    }

    private boolean recDeleteEmptyDir(File dir, String fileSpec, int fileSpecFlags) throws Exception {
        if (dir.isDirectory()) {
            if (!dir.canRead()) {
                throw new SOSFileOperationsException("directory is not readable: " + dir.getCanonicalPath());
            }
        } else {
            return false;
        }
        File[] list = dir.listFiles();
        if (list.length == 0) {
            return true;
        }
        Pattern p = Pattern.compile(fileSpec, fileSpecFlags);
        for (File element : list) {
            File f = element;
            if (this.recDeleteEmptyDir(f, fileSpec, fileSpecFlags)) {
                if (!p.matcher(f.getName()).matches()) continue;
                this.delete(f);
                this.logger.info("[%s]remove directory", new Object[]{f.getCanonicalPath()});
                continue;
            }
            if (!f.isDirectory()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[%s]directory cannot be removed because it is not empty", new Object[]{f.getCanonicalPath()});
            }
            Object lst = f.list()[0];
            for (int n = 1; n < f.list().length; ++n) {
                lst = (String)lst + ", " + f.list()[n];
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("          contained files " + f.list().length + ": " + (String)lst));
        }
        return dir.list().length == 0;
    }

    private List<File> listFolders(String folder, String regexp, int flag, boolean withSubFolder) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(this.listFolders(folder, regexp, flag));
        if (withSubFolder) {
            File[] subDir;
            for (File element : subDir = new File(folder).listFiles()) {
                if (!element.isDirectory()) continue;
                result.addAll(this.listFolders(element.getPath(), regexp, flag, true));
            }
        }
        return result;
    }

    private List<File> listFolders(String folder, String regexp, int flag) throws Exception {
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        File f = new File(folder);
        if (!f.exists()) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        File[] files = f.listFiles(new FilelistFilter(regexp, flag));
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (".".equals(files[i].getName()) || "..".equals(files[i].getName())) continue;
            result.add(files[i]);
        }
        return result;
    }

    private List<File> listFiles(String folder, String regexp, int flag) throws Exception {
        File[] files;
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        File f = new File(folder);
        if (!f.exists()) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files = f.listFiles(new FilelistFilter(regexp, flag))) {
            if (!file.isFile()) continue;
            result.add(file);
        }
        return result;
    }

    private List<File> getFilelist(String folder, String regexp, int flag, boolean withSubFolder, long minFileAge, long maxFileAge, long minFileSize, long maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        List<Object> temp = new ArrayList();
        temp = this.listFiles(folder, regexp, flag);
        temp = this.filelistFilterAge(temp, minFileAge, maxFileAge);
        temp = this.filelistFilterSize(temp, minFileSize, maxFileSize);
        if ((minFileSize != -1L || maxFileSize != -1L) && minFileAge == 0L && maxFileAge == 0L) {
            temp = this.filelistSkipFiles(temp, skipFirstFiles, skipLastFiles, "sort_size");
        } else if (minFileAge != 0L || maxFileAge != 0L) {
            temp = this.filelistSkipFiles(temp, skipFirstFiles, skipLastFiles, "sort_age");
        }
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(temp);
        if (withSubFolder) {
            File[] subDir;
            for (File element : subDir = new File(folder).listFiles()) {
                if (!element.isDirectory()) continue;
                result.addAll(this.getFilelist(element.getPath(), regexp, flag, true, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles));
            }
        }
        return result;
    }

    public int copyFileCnt(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.transferFileCnt(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean copyFile(File source, File dest, boolean append) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(dest, append);
            while (true) {
                byte[] byArray = this.buffer;
                // MONITORENTER : this.buffer
                int amountRead = ((InputStream)in).read(this.buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : byArray
                    boolean bl = true;
                    return bl;
                }
                out.write(this.buffer, 0, amountRead);
                // MONITOREXIT : byArray
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public int renameFileCnt(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.transferFileCnt(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    private int transferFileCnt(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        Object targetFilename;
        if (sortCriteria == null || sortCriteria.isEmpty()) {
            sortCriteria = "name";
        }
        if (sortOrder == null || sortOrder.isEmpty()) {
            sortOrder = "asc";
        }
        boolean replace = false;
        boolean createDir = this.has(flags, 1);
        boolean gracious = this.has(flags, 2);
        boolean overwrite = !this.has(flags, 4);
        long minAge = SOSDate.getTimeAsMillis((String)minFileAge);
        long maxAge = SOSDate.getTimeAsMillis((String)maxFileAge);
        long minSize = this.calculateFileSize(minFileSize);
        long maxSize = this.calculateFileSize(maxFileSize);
        if (this.logger.isDebugEnabled()) {
            this.debug(this.getDebugMain(fileSpecFlags), this.getDebugCopyFlags(flags), minFileAge, maxFileAge, minFileSize, maxFileSize);
        }
        int transferedFiles = 0;
        if (skipFirstFiles < 0) {
            throw new SOSFileOperationsException("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
        }
        if (skipLastFiles < 0) {
            throw new SOSFileOperationsException("[" + skipLastFiles + "] is no valid value for skipLastFiles");
        }
        if (replacing != null || replacement != null) {
            if (replacing == null) {
                throw new SOSFileOperationsException("replacing cannot be null if replacement is set");
            }
            if (replacement == null) {
                throw new SOSFileOperationsException("replacement cannot be null if replacing is set");
            }
            if (!"".equals(replacing)) {
                try {
                    Pattern.compile(replacing);
                }
                catch (PatternSyntaxException pse) {
                    throw new SOSFileOperationsException("invalid pattern '" + replacing + "'");
                }
                replace = true;
            }
        }
        if (!source.exists()) {
            if (gracious) {
                this.logger.info((Object)(transferedFiles + " file(s) renamed"));
                return transferedFiles;
            }
            throw new SOSFileOperationsException("file or directory does not exist: " + source.getCanonicalPath());
        }
        if (!source.canRead()) {
            throw new SOSFileOperationsException("file or directory is not readable: " + source.getCanonicalPath());
        }
        if (target != null) {
            targetFilename = this.substituteAllDate(target.getPath());
            targetFilename = this.substituteAllDirectory((String)targetFilename, source.getPath());
            target = new File((String)targetFilename);
        }
        if (createDir && target != null && !target.exists()) {
            if (target.mkdirs()) {
                this.logger.info("[%s]target directory created", new Object[]{target.getCanonicalPath()});
            } else {
                throw new SOSFileOperationsException("cannot create directory " + target.getCanonicalPath());
            }
        }
        List<File> list = null;
        if (source.isDirectory()) {
            if (target != null) {
                if (!target.exists()) {
                    throw new SOSFileOperationsException("target directory does not exist: " + target.getCanonicalPath());
                }
                if (!target.isDirectory()) {
                    throw new SOSFileOperationsException("target is no directory: " + target.getCanonicalPath());
                }
            }
            list = this.getFilelist(source.getPath(), fileSpec, fileSpecFlags, this.has(flags, 8), minAge, maxAge, minSize, maxSize, 0, 0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[source=%s][fileSpec=%s]found %s files", new Object[]{source.getPath(), fileSpec, list.size()});
            }
        } else {
            list = new ArrayList<File>();
            list.add(source);
            list = this.filelistFilterAge(list, minAge, maxAge);
            list = this.filelistFilterSize(list, minSize, maxSize);
            if (skipFirstFiles > 0 || skipLastFiles > 0) {
                list.clear();
            }
        }
        if (sortCriteria.equalsIgnoreCase("age")) {
            list.sort(new FileComparatorAge());
        } else if (sortCriteria.equalsIgnoreCase("size")) {
            list.sort(new FileComparatorSize());
        } else {
            list.sort(new FileComparatorName());
        }
        if (sortOrder.equalsIgnoreCase("desc")) {
            Collections.reverse(list);
        }
        for (int i = skipFirstFiles; i < list.size() - skipLastFiles; ++i) {
            File sourceFile = list.get(i);
            this.resultList.add(sourceFile);
            if (target != null) {
                if (target.isDirectory()) {
                    root = source.isDirectory() ? source.getPath() : source.getParent();
                    targetFilename = target.getPath() + sourceFile.getPath().substring(root.length());
                } else {
                    targetFilename = target.getPath();
                }
            } else if (source.isDirectory()) {
                root = source.isDirectory() ? source.getPath() : source.getParent();
                targetFilename = source.getPath() + sourceFile.getPath().substring(root.length());
            } else {
                targetFilename = source.getParent() + "/" + sourceFile.getName();
            }
            File targetFile = new File((String)targetFilename);
            try {
                if (replace) {
                    targetFilename = targetFile.getName();
                    targetFilename = this.replaceGroups((String)targetFilename, replacing, replacement);
                    targetFilename = this.substituteAllDate((String)targetFilename);
                    targetFilename = this.substituteAllFilename((String)targetFilename, targetFile.getName());
                    targetFile = new File(targetFile.getParent() + "/" + (String)targetFilename);
                }
            }
            catch (Exception re) {
                throw new SOSFileOperationsException("replacement error in file " + (String)targetFilename + ": " + re.getMessage());
            }
            File dir = new File(targetFile.getParent());
            if (!dir.exists()) {
                if (dir.mkdirs()) {
                    this.logger.info("[%s]create directory", new Object[]{dir.getCanonicalPath()});
                } else {
                    throw new SOSFileOperationsException("cannot create directory " + dir.getCanonicalPath());
                }
            }
            if (!this.handleOneFile(sourceFile, targetFile, overwrite, gracious)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("[skip][sourceFile=%s][targetFile=%s]overwrite=%s,gracious=%s", new Object[]{sourceFile.getPath(), targetFile.getPath(), overwrite, gracious});
                continue;
            }
            ++transferedFiles;
        }
        this.logger.info((Object)(transferedFiles + " file(s)"));
        return transferedFiles;
    }

    private String getDuration(long millis) {
        try {
            return SOSDate.getDuration((Duration)Duration.ofMillis(millis));
        }
        catch (Throwable e) {
            return millis + "ms";
        }
    }

    private String getDateTime(long millis) {
        try {
            return SOSDate.getDateTimeAsString((long)millis);
        }
        catch (Throwable e) {
            return millis + "ms";
        }
    }

    private List<File> filelistFilterAge(List<File> filelist, long minAge, long maxAge) throws Exception {
        long interval;
        long lastModified;
        File file;
        int i;
        ArrayList<File> newlist;
        long currentTime = System.currentTimeMillis();
        if (minAge != 0L) {
            String minAgeDef = this.getDuration(minAge);
            newlist = new ArrayList<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                lastModified = file.lastModified();
                interval = currentTime - lastModified;
                if (interval < 0L) {
                    throw new SOSFileOperationsException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval >= minAge) {
                    newlist.add(file);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)String.format("[%s][lastModified=%s]minimum age required is %s", file.getCanonicalPath(), this.getDateTime(lastModified), minAgeDef));
            }
            filelist = newlist;
        }
        if (maxAge != 0L) {
            String maxAgeDef = this.getDuration(maxAge);
            newlist = new ArrayList();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                lastModified = file.lastModified();
                interval = currentTime - lastModified;
                if (interval < 0L) {
                    throw new SOSFileOperationsException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval <= maxAge) {
                    newlist.add(file);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)String.format("[%s][lastModified=%s]maximum age required is %s", file.getCanonicalPath(), this.getDateTime(lastModified), maxAgeDef));
            }
            filelist = newlist;
        }
        return filelist;
    }

    private List<File> filelistFilterSize(List<File> filelist, long minSize, long maxSize) throws Exception {
        File file;
        int i;
        ArrayList<File> newlist;
        if (minSize > -1L) {
            newlist = new ArrayList<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                if (file.length() < minSize) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        if (maxSize > -1L) {
            newlist = new ArrayList();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                if (file.length() > maxSize) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        return filelist;
    }

    private List<File> filelistSkipFiles(List<File> filelist, int skipFirstFiles, int skipLastFiles, String sorting) throws Exception {
        if ("sort_size".equals(sorting)) {
            filelist.sort(new FileComparatorSize());
        } else if ("sort_age".equals(sorting)) {
            filelist.sort(new FileComparatorAge());
        }
        return filelist;
    }

    private long calculateFileSize(String filesize) throws Exception {
        long size;
        if (filesize == null || filesize.trim().isEmpty()) {
            return -1L;
        }
        if (filesize.matches("-1")) {
            return -1L;
        }
        if (filesize.matches("[\\d]+")) {
            size = Long.parseLong(filesize);
        } else if (filesize.matches("^[\\d]+[kK][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L;
        } else if (filesize.matches("^[\\d]+[mM][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L * 1024L;
        } else if (filesize.matches("^[\\d]+[gG][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L * 1024L * 1024L;
        } else {
            throw new SOSFileOperationsException("[" + filesize + "] is no valid file size");
        }
        return size;
    }

    private String substituteFirstFilename(String targetFilename, String original) throws Exception {
        Matcher matcher = Pattern.compile("\\[filename:([^\\]]*)\\]").matcher(targetFilename);
        if (matcher.find()) {
            if ("".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:\\]", original);
            } else if ("lowercase".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:lowercase\\]", original.toLowerCase());
            } else if ("uppercase".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:uppercase\\]", original.toUpperCase());
            }
        }
        return targetFilename;
    }

    private String substituteAllFilename(String targetFilename, String original) throws Exception {
        String temp = this.substituteFirstFilename(targetFilename, original);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = this.substituteFirstFilename(targetFilename, original);
        }
        return temp;
    }

    private String substituteFirstDate(String targetFilename) throws Exception {
        String conVarName = "[date:";
        try {
            int posEnd;
            int posBegin;
            if (((String)targetFilename).matches("(.*)(\\[date:)([^\\]]*)(\\])(.*)") && (posBegin = ((String)targetFilename).indexOf("[date:")) > -1 && (posEnd = ((String)targetFilename).indexOf("]", posBegin + 6)) > -1) {
                String dateTimeFormat = ((String)targetFilename).substring(posBegin + 6, posEnd);
                if (dateTimeFormat.isEmpty()) {
                    dateTimeFormat = new String(SOSDate.DATETIME_FORMAT);
                }
                String dateTime = SOSDate.format((Date)new Date(), (String)dateTimeFormat);
                String strT = (posBegin > 0 ? ((String)targetFilename).substring(0, posBegin) : "") + dateTime;
                if (((String)targetFilename).length() > posEnd) {
                    strT = strT + ((String)targetFilename).substring(posEnd + 1);
                }
                targetFilename = strT;
            }
            return targetFilename;
        }
        catch (Exception e) {
            throw new SOSFileOperationsException("error substituting [date:]: " + e.getMessage());
        }
    }

    private String substituteAllDate(String targetFilename) throws Exception {
        String temp = this.substituteFirstDate(targetFilename);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = this.substituteFirstDate(targetFilename);
        }
        return temp;
    }

    private String substituteFirstDirectory(String target, String source) throws Exception {
        try {
            File sourceFile = new File(source);
            if (!sourceFile.isDirectory()) {
                source = sourceFile.getParent();
            }
            source = source.replaceAll("\\\\", "/");
            target = target.replaceAll("\\\\", "/");
            Pattern p = Pattern.compile("\\[directory:(-[\\d]+|[\\d]*)\\]");
            Matcher m = p.matcher(target);
            if (m.find()) {
                Object substitute = "";
                if (m.group(1).isEmpty() || "0".equals(m.group(1)) || "-0".equals(m.group(1))) {
                    substitute = source;
                } else {
                    int absDepth;
                    int depth = Integer.valueOf(m.group(1));
                    StringTokenizer st = new StringTokenizer(source, "/");
                    int n = absDepth = depth < 0 ? -depth : depth;
                    if (absDepth >= st.countTokens()) {
                        substitute = source;
                    } else {
                        String[] dirs = new String[st.countTokens()];
                        int n2 = 0;
                        while (st.hasMoreTokens()) {
                            dirs[n2++] = st.nextToken();
                        }
                        if (depth > 0) {
                            while (depth > 0) {
                                substitute = dirs[--depth] + "/" + (String)substitute;
                            }
                        } else if (depth < 0) {
                            while (depth < 0) {
                                substitute = (String)substitute + dirs[dirs.length + depth++] + "/";
                            }
                        }
                    }
                }
                if (((String)substitute).charAt(((String)substitute).length() - 1) == '/') {
                    substitute = ((String)substitute).substring(0, ((String)substitute).length() - 1);
                }
                target = target.replaceFirst("\\[directory:[^\\]]*\\]", (String)substitute);
            }
            return target;
        }
        catch (Exception e) {
            throw new SOSFileOperationsException("error substituting [directory]: " + e.getMessage());
        }
    }

    private String substituteAllDirectory(String target, String source) throws Exception {
        String temp = this.substituteFirstDirectory(target, source);
        while (!target.equals(temp)) {
            target = temp;
            temp = this.substituteFirstDirectory(target, source);
        }
        return temp;
    }

    private String replaceGroups(String input, String replacing, String replacements) throws Exception {
        if (replacements == null) {
            throw new SOSFileOperationsException("replacements missing: 0 replacements defined");
        }
        return this.replaceGroups(input, replacing, replacements.split(";"));
    }

    private String replaceGroups(String source, String replacing, String[] replacements) throws Exception {
        if (replacements == null) {
            throw new SOSFileOperationsException("replacements missing: 0 replacements defined");
        }
        Pattern p = Pattern.compile(replacing);
        Matcher m = p.matcher(source);
        if (!m.find()) {
            return source;
        }
        int groupCount = m.groupCount();
        if (replacements.length < groupCount) {
            throw new SOSFileOperationsException("replacements missing: " + replacements.length + " replacement(s) defined but " + groupCount + " groups found");
        }
        StringBuilder result = new StringBuilder();
        if (groupCount == 0) {
            result.append(source.substring(0, m.start()) + replacements[0] + source.substring(m.end()));
        } else {
            int index = 0;
            for (int i = 1; i <= groupCount; ++i) {
                String repl;
                int start = m.start(i);
                if (start >= 0 && !(repl = replacements[i - 1].trim()).isEmpty()) {
                    if (repl.contains("\\")) {
                        repl = repl.replaceAll("\\\\-", "");
                        for (int j = 1; j <= groupCount; ++j) {
                            repl = repl.replaceAll("\\\\" + j, m.group(j));
                        }
                    }
                    result.append(source.substring(index, start)).append(repl);
                }
                index = m.end(i);
            }
            result.append(source.substring(index));
        }
        return result.toString();
    }

    private boolean has(int flags, int f) {
        return (flags & f) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wipe(File file) {
        RandomAccessFile rwFile = null;
        try {
            rwFile = new RandomAccessFile(file, "rw");
            byte[] bytes = new byte[(int)rwFile.length()];
            int i = 0;
            while ((bytes[i++] = (byte)rwFile.read()) != -1) {
            }
            rwFile.seek(0L);
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(Math.random() * 10.0 % 9.0);
            }
            rwFile.write(bytes);
            rwFile.close();
            boolean rc = file.delete();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[%s][deleting file]%s", new Object[]{file.getCanonicalPath(), rc});
            }
            rwFile = null;
            boolean bl = rc;
            return bl;
        }
        catch (Exception e) {
            this.logger.warn("Failed to wipe file: " + e.toString(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rwFile != null) {
                try {
                    rwFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private StringBuilder getDebugMain(int fileSpecFlags) {
        return this.getDebugFileSpecFlags(fileSpecFlags);
    }

    private StringBuilder getDebugFileSpecFlags(int flags) {
        StringBuilder sb = new StringBuilder("fileSpecFlags=");
        if (this.has(flags, 128)) {
            sb.append("CANON_EQ");
        }
        if (this.has(flags, 2)) {
            sb.append("CASE_INSENSITIVE");
        }
        if (this.has(flags, 4)) {
            sb.append("COMMENTS");
        }
        if (this.has(flags, 32)) {
            sb.append("DOTALL");
        }
        if (this.has(flags, 8)) {
            sb.append("MULTILINE");
        }
        if (this.has(flags, 64)) {
            sb.append("UNICODE_CASE");
        }
        if (this.has(flags, 1)) {
            sb.append("UNIX_LINES");
        }
        return sb;
    }

    private StringBuilder getDebugRemoveFlags(int flags) {
        StringBuilder sb = new StringBuilder("flags=");
        if (this.has(flags, 2)) {
            sb.append("GRACIOUS ");
        }
        if (this.has(flags, 8)) {
            sb.append("RECURSIVE ");
        }
        if (this.has(flags, 16)) {
            sb.append("REMOVE_DIR ");
        }
        if (this.has(flags, 32)) {
            sb.append("WIPE ");
        }
        return sb;
    }

    private StringBuilder getDebugCopyFlags(int flags) {
        StringBuilder sb = new StringBuilder("flags=");
        if (this.has(flags, 1)) {
            sb.append("CREATE_DIR ");
        }
        if (this.has(flags, 2)) {
            sb.append("GRACIOUS ");
        }
        if (this.has(flags, 4)) {
            sb.append("NOT_OVERWRITE ");
        }
        if (this.has(flags, 8)) {
            sb.append("RECURSIVE ");
        }
        return sb;
    }

    private void debug(StringBuilder main, StringBuilder flags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize) {
        StringBuilder sb = new StringBuilder(main);
        if (flags != null) {
            sb.append(",").append((CharSequence)flags);
        }
        sb.append(",").append("minFileAge=").append(minFileAge);
        sb.append(",").append("maxFileAge=").append(maxFileAge);
        sb.append(",").append("minFileSize=").append(minFileSize);
        sb.append(",").append("maxFileSize=").append(maxFileSize);
        this.logger.debug((Object)sb);
    }

    public List<File> getResultList() {
        return this.resultList;
    }

    public OrderProcessStepLogger getLogger() {
        return this.logger;
    }
}

