/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.mail;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.mail.SOSMailReceiver;
import com.sos.commons.util.common.SOSArgument;
import com.sos.jitl.jobs.mail.MailInboxArguments;
import com.sos.jitl.jobs.mail.MailProcessor;
import com.sos.jitl.jobs.mail.MailReceiver;
import com.sos.js7.job.Job;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class MailInboxJob
extends Job<MailInboxArguments> {
    private static final String MAIL_STORE_PROTOCOL_KEY = "mail.store.protocol";

    public MailInboxJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void onStart() throws Exception {
        Set availableProtocols;
        String mailStoreProtocolPropValue = System.getProperty(MAIL_STORE_PROTOCOL_KEY);
        if (mailStoreProtocolPropValue != null && !mailStoreProtocolPropValue.isEmpty() && (availableProtocols = EnumSet.allOf(SOSMailReceiver.Protocol.class).stream().map(Enum::name).collect(Collectors.toSet())).contains(mailStoreProtocolPropValue) && this.getJobEnvironment().getDeclaredArguments() != null) {
            JobArgument<SOSMailReceiver.Protocol> mailStoreProtocol = ((MailInboxArguments)this.getJobEnvironment().getDeclaredArguments()).getMailProtocol();
            mailStoreProtocol.setDefaultValue((Object)SOSMailReceiver.Protocol.valueOf((String)mailStoreProtocolPropValue));
            mailStoreProtocol.setRequired(false);
        }
    }

    public void processOrder(OrderProcessStep<MailInboxArguments> step) throws Exception {
        this.process(step, (MailInboxArguments)step.getDeclaredArguments());
    }

    private void process(OrderProcessStep<MailInboxArguments> step, MailInboxArguments args) throws Exception {
        if (((List)args.getAction().getValue()).contains((Object)MailInboxArguments.ActionProcess.dump)) {
            args.getMailDirectoryName().setRequired(true);
        }
        if (((List)args.getAction().getValue()).contains((Object)MailInboxArguments.ActionProcess.dump_attachments)) {
            args.getAttachmentDirectoryName().setRequired(true);
        }
        switch ((MailInboxArguments.ActionAfterProcess)((Object)args.getAfterProcessMail().getValue())) {
            case move: 
            case copy: {
                args.getAfterProcessMailDirectoryName().setRequired(true);
            }
        }
        if (!args.getMailProtocol().isEmpty()) {
            this.checkRequiredArguments(Arrays.asList(args.getMailDirectoryName(), args.getAttachmentDirectoryName(), args.getAfterProcessMailDirectoryName()));
        }
        MailReceiver receiver = null;
        try {
            SOSMailReceiver.Protocol protocol;
            JobArgument port;
            Map allCurrent = step.getAllArguments();
            Map<String, Object> variables = step.getAllArgumentsAsNameValueMap();
            CredentialStoreArguments csArgs = (CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class);
            if (csArgs.getFile().getValue() != null) {
                CredentialStoreArguments.CredentialStoreResolver r = csArgs.newResolver();
                args.getMailUser().setValue((Object)r.resolve((String)args.getMailUser().getValue()));
                args.getMailPassword().setValue((Object)r.resolve((String)args.getMailPassword().getValue()));
                args.getMailHost().setValue((Object)r.resolve((String)args.getMailHost().getValue()));
            }
            if ((port = allCurrent.getOrDefault("mail." + (protocol = (SOSMailReceiver.Protocol)args.getMailProtocol().getValue()).name() + ".port", (JobArgument)allCurrent.get("mail.port"))) == null || port.getValue() == null) {
                args.setDefaultMailPort();
                step.getLogger().info("Port is undefined. Default port %d is used.", new Object[]{args.getMailPort().getDefaultValue()});
                variables.put("mail." + protocol.name() + ".port", args.getMailPort().getDefaultValue());
            }
            variables = variables.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("mail.")).filter(e -> !((String)e.getKey()).startsWith("mail.smtp.")).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            receiver = new MailReceiver((SOSMailReceiver.Protocol)args.getMailProtocol().getValue(), variables, step.getLogger());
            receiver.connect();
            MailProcessor processor = new MailProcessor(args, step.getLogger());
            for (String folder : (List)args.getMailMessageFolder().getValue()) {
                if (folder.trim().isEmpty()) continue;
                processor.performMessagesInFolder(receiver, folder.trim());
            }
        }
        catch (Exception e2) {
            throw e2;
        }
        finally {
            if (receiver != null) {
                receiver.disconnect();
            }
        }
    }

    private void checkRequiredArguments(List<JobArgument<?>> args) throws Exception {
        Optional<String> arg = args.stream().filter(SOSArgument::isRequired).filter(SOSArgument::isEmpty).findAny().map(SOSArgument::getName);
        if (arg.isPresent()) {
            throw new JobRequiredArgumentMissingException(String.format("'%s' is missing but required", arg.get()));
        }
    }
}

