/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.mail;

import com.sos.commons.exception.SOSInvalidDataException;
import com.sos.commons.mail.SOSMailReceiver;
import com.sos.commons.mail.SOSMimeMessage;
import com.sos.commons.util.SOSDate;
import com.sos.jitl.jobs.mail.MailInboxArguments;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailProcessor.class);
    private final MailInboxArguments args;
    private final OrderProcessStepLogger jobLogger;
    private Folder inFolder;
    private Folder targetFolder;
    private Date dateMinAge = null;

    public MailProcessor(MailInboxArguments args, OrderProcessStepLogger logger) {
        this.args = args;
        this.jobLogger = logger;
        this.setMinAgeDate();
    }

    private void setMinAgeDate() {
        long minAge;
        if (this.args.getMinMailAge().isDirty() && (minAge = SOSDate.getTimeAsSeconds((String)((String)this.args.getMinMailAge().getValue()))) > 0L) {
            Instant now = Instant.now();
            this.dateMinAge = Date.from(now.minusSeconds(minAge));
            this.logDebug("Min. Age defined: %1$s", this.dateMinAge.toString());
        }
    }

    private boolean isPerformMessage(SOSMimeMessage sosMimeMessage) throws Exception {
        Date messageDate = sosMimeMessage.getSentDate();
        boolean result = true;
        if (this.dateMinAge != null && messageDate != null && this.dateMinAge.before(messageDate)) {
            this.logDebug("message skipped due to date constraint: %s | %s", sosMimeMessage.getSubject(), messageDate.toString());
            result = false;
        } else {
            this.logInfo("processing: %s | %s", sosMimeMessage.getSubject(), messageDate != null ? messageDate.toString() : "unknown date");
        }
        return result;
    }

    private void executeMessage(SOSMimeMessage sosMimeMessage) throws Exception {
        if (this.isPerformMessage(sosMimeMessage)) {
            this.performAction(sosMimeMessage);
        }
    }

    private void performAction(SOSMimeMessage message) throws IOException, MessagingException, SOSInvalidDataException, JobRequiredArgumentMissingException {
        if (((List)this.args.getAction().getValue()).contains((Object)MailInboxArguments.ActionProcess.dump)) {
            if (this.args.getMailDirectoryName().isEmpty()) {
                throw new JobRequiredArgumentMissingException("No target directory [parameter " + this.args.getMailDirectoryName().getName() + "] specified.");
            }
            this.dumpMessage(message, (String)this.args.getMailDirectoryName().getValue());
        }
        if (((List)this.args.getAction().getValue()).contains((Object)MailInboxArguments.ActionProcess.dump_attachments)) {
            if (this.args.getAttachmentDirectoryName().isEmpty()) {
                throw new JobRequiredArgumentMissingException("No target directory [parameter " + this.args.getAttachmentDirectoryName().getName() + "] specified.");
            }
            this.copyAttachmentsToFile(message);
        }
        this.handleAfterProcessEmail(message);
    }

    private void copyMailToFolder(SOSMimeMessage message) throws MessagingException, IOException, JobRequiredArgumentMissingException {
        if (this.targetFolder == null) {
            throw new JobRequiredArgumentMissingException("Parameter '" + this.args.getAfterProcessMailDirectoryName().getName() + "' is required but missing.");
        }
        ArrayList<MimeMessage> tempList = new ArrayList<MimeMessage>();
        tempList.add(message.getMessage());
        Message[] m = tempList.toArray(new Message[tempList.size()]);
        this.inFolder.copyMessages(m, this.targetFolder);
    }

    private void handleAfterProcessEmail(SOSMimeMessage message) throws MessagingException, IOException, JobRequiredArgumentMissingException {
        switch ((MailInboxArguments.ActionAfterProcess)((Object)this.args.getAfterProcessMail().getValue())) {
            case none: {
                break;
            }
            case mark_as_read: 
            case markAsRead: {
                message.setFlag(Flags.Flag.SEEN, true);
                break;
            }
            case delete: {
                this.deleteMessage(message);
                break;
            }
            case move: {
                if (((String)this.args.getAfterProcessMailDirectoryName().getValue()).isEmpty()) {
                    throw new JobRequiredArgumentMissingException("No target folder [parameter " + this.args.getAfterProcessMailDirectoryName().getName() + "] specified.");
                }
                this.copyMailToFolder(message);
                this.deleteMessage(message);
                break;
            }
            case copy: {
                if (((String)this.args.getAfterProcessMailDirectoryName().getValue()).isEmpty()) {
                    throw new JobRequiredArgumentMissingException("No target folder [parameter " + this.args.getAfterProcessMailDirectoryName().getName() + "] specified.");
                }
                this.copyMailToFolder(message);
            }
        }
    }

    private String getEmailFolderName(JobArgument<String> folder) throws JobRequiredArgumentMissingException {
        switch ((MailInboxArguments.ActionAfterProcess)((Object)this.args.getAfterProcessMail().getValue())) {
            case move: 
            case copy: {
                if (folder.isEmpty()) {
                    throw new JobRequiredArgumentMissingException("Parameter '" + folder.getName() + "' is required but missing.");
                }
                return (String)folder.getValue();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMessagesInFolder(SOSMailReceiver mailReader, String messageFolder) throws MessagingException, JobRequiredArgumentMissingException {
        try {
            this.logDebug("reading " + messageFolder, new Object[0]);
            this.inFolder = mailReader.openFolder(messageFolder, mailReader.READ_WRITE);
            String targetFolderName = this.getEmailFolderName(this.args.getAfterProcessMailDirectoryName());
            if (!targetFolderName.isEmpty()) {
                this.targetFolder = mailReader.openFolder(targetFolderName, mailReader.READ_WRITE);
            }
            int objectsInFolder = this.inFolder.getMessageCount();
            Message[] msgs = null;
            Message[] msgs2 = null;
            int maxMailsToProcess = (Integer)this.args.getMaxMailsToProcess().getValue();
            msgs = objectsInFolder > maxMailsToProcess && maxMailsToProcess > 0 ? this.inFolder.getMessages(objectsInFolder - maxMailsToProcess + 1, objectsInFolder) : this.inFolder.getMessages();
            Pattern subjectPattern = null;
            Pattern bodyPattern = null;
            if (!this.args.getMailSubjectPattern().isEmpty()) {
                subjectPattern = Pattern.compile((String)this.args.getMailSubjectPattern().getValue());
            }
            if (!this.args.getMailBodyPattern().isEmpty()) {
                bodyPattern = Pattern.compile((String)this.args.getMailBodyPattern().getValue());
            }
            if (!this.args.getMailSubjectFilter().isEmpty() && !this.args.getMailFromFilter().isEmpty()) {
                fromTerm = new FromTerm((Address)new InternetAddress((String)this.args.getMailFromFilter().getValue()));
                SubjectTerm subjectTerm = new SubjectTerm((String)this.args.getMailSubjectFilter().getValue());
                AndTerm searchTerm = new AndTerm((SearchTerm)subjectTerm, (SearchTerm)fromTerm);
                this.logDebug("looking for subject=%s and from=%s", this.args.getMailSubjectFilter().getValue(), this.args.getMailFromFilter().getValue());
                msgs2 = this.inFolder.search((SearchTerm)searchTerm, msgs);
                this.logDebug("%d messages found with subject=%s and from=%s", msgs2.length, this.args.getMailSubjectFilter().getValue(), this.args.getMailFromFilter().getValue());
            } else if (!this.args.getMailSubjectFilter().isEmpty()) {
                this.logDebug("looking for subject=%s", this.args.getMailSubjectFilter().getValue());
                SubjectTerm subjectTerm = new SubjectTerm((String)this.args.getMailSubjectFilter().getValue());
                msgs2 = this.inFolder.search((SearchTerm)subjectTerm, msgs);
                this.logDebug("%d messages found with subject=%s", msgs2.length, this.args.getMailSubjectFilter().getValue());
            } else if (!this.args.getMailFromFilter().isEmpty()) {
                fromTerm = new FromTerm((Address)new InternetAddress((String)this.args.getMailFromFilter().getValue()));
                this.logDebug("looking for from=%s", this.args.getMailFromFilter().getValue());
                msgs2 = this.inFolder.search((SearchTerm)fromTerm, msgs);
                this.logDebug("%d messages found with from=%s", msgs2.length, this.args.getMailFromFilter().getValue());
            } else {
                msgs2 = msgs;
                this.logDebug("%d messages found, folder = %s", msgs2.length, messageFolder);
            }
            if (msgs2.length > 0) {
                int notUnreadMails = 0;
                for (Message messageElement : msgs2) {
                    if (((Boolean)this.args.getMailOnlyUnseen().getValue()).booleanValue() && messageElement.isSet(Flags.Flag.SEEN)) {
                        this.logTrace("message skipped, already seen: %s", messageElement.getSubject());
                        ++notUnreadMails;
                        continue;
                    }
                    try {
                        SOSMimeMessage sosMailItem = new SOSMimeMessage(messageElement, Boolean.valueOf(true));
                        if (subjectPattern != null && !subjectPattern.matcher(sosMailItem.getSubject()).find()) {
                            this.logTrace("message skipped, subject does not match [%1$s]: %2$s", this.args.getMailSubjectPattern().getValue(), sosMailItem.getSubject());
                            continue;
                        }
                        if (bodyPattern != null && !bodyPattern.matcher(sosMailItem.getPlainTextBody()).find()) {
                            this.logTrace("message with subject %s skipped, body does not match [%s]", sosMailItem.getSubject(), this.args.getMailBodyPattern().getValue());
                            continue;
                        }
                        sosMailItem.init();
                        this.executeMessage(sosMailItem);
                    }
                    catch (Exception e) {
                        this.logInfo("message '%s' skipped, exception occured: %s", messageElement.getSubject(), e.toString());
                    }
                }
                if (notUnreadMails > 0) {
                    this.logDebug("%d messages skipped because they are already read", notUnreadMails);
                }
            }
        }
        finally {
            mailReader.closeFolder(true);
        }
    }

    private void dumpMessage(SOSMimeMessage message, String directory) throws IOException, MessagingException {
        File messageFile = new File(directory, message.getMessageId());
        this.logDebug("dump message. subject=%s, date=%s, file=%s: ", message.getSubject(), message.getSentDateAsString(), messageFile);
        message.dumpMessageToFile(messageFile, true, false);
    }

    private void deleteMessage(SOSMimeMessage message) throws UnsupportedEncodingException, MessagingException {
        this.logDebug("deleting message. subject=%s, date=%s", message.getSubject(), message.getSentDateAsString());
        message.deleteMessage();
    }

    private void copyAttachmentsToFile(SOSMimeMessage message) throws SOSInvalidDataException, IOException, MessagingException {
        String directory = (String)this.args.getAttachmentDirectoryName().getValue();
        this.logDebug("saving attachments. subject=%s, date=%s, directory=%s: ", message.getSubject(), message.getSentDateAsString(), directory);
        message.saveAttachments(message, (String)this.args.getAttachmentFileNamePattern().getValue(), directory, ((Boolean)this.args.getSaveBodyAsAttachment().getValue()).booleanValue()).forEach(s -> this.logDebug("attachment file [%s] successfully saved.", s));
    }

    private void logInfo(String format, Object ... msg) {
        if (this.jobLogger != null) {
            this.jobLogger.info(format, msg);
        } else if (msg.length == 0) {
            LOGGER.info(format);
        } else {
            LOGGER.info(String.format(format, msg));
        }
    }

    private void logDebug(String format, Object ... msg) {
        if (this.jobLogger != null) {
            this.jobLogger.debug(format, msg);
        } else if (msg.length == 0) {
            LOGGER.debug(format);
        } else {
            LOGGER.debug(String.format(format, msg));
        }
    }

    private void logTrace(String format, Object ... msg) {
        if (this.jobLogger != null) {
            this.jobLogger.trace(format, msg);
        } else if (msg.length == 0) {
            LOGGER.trace(format);
        } else {
            LOGGER.trace(String.format(format, msg));
        }
    }
}

