/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.orderstatustransition.classes;

import com.sos.jitl.jobs.sap.common.Globals;
import com.sos.joc.model.order.ModifyOrders;
import com.sos.joc.model.order.OrdersFilterV;
import com.sos.joc.model.order.OrdersV;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;

public class OrderStateWebserviceExecuter {
    private ApiExecutor apiExecutor;
    private OrderProcessStepLogger logger;

    public OrderStateWebserviceExecuter(OrderProcessStepLogger logger, ApiExecutor apiExecutor) {
        this.apiExecutor = apiExecutor;
        this.logger = logger;
    }

    public OrdersV getOrders(OrdersFilterV ordersFilter, String accessToken) throws Exception {
        String body = Globals.objectMapper.writeValueAsString((Object)ordersFilter);
        ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/orders", body);
        String answer = null;
        if (apiResponse.getStatusCode() != 200) {
            if (apiResponse.getException() != null) {
                throw apiResponse.getException();
            }
            throw new Exception(apiResponse.getResponseBody());
        }
        answer = apiResponse.getResponseBody();
        this.logger.debug((Object)body);
        this.logger.debug((Object)("answer=" + answer));
        OrdersV orderHistory = new OrdersV();
        orderHistory = (OrdersV)Globals.objectMapper.readValue(answer, OrdersV.class);
        if (orderHistory.getOrders().size() == 0) {
            return null;
        }
        return orderHistory;
    }

    public void cancelOrders(ModifyOrders modifyOrders, String accessToken) throws Exception {
        if (modifyOrders.getOrderIds().size() > 0) {
            String body = Globals.objectMapper.writeValueAsString((Object)modifyOrders);
            ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/orders/cancel", body);
            String answer = null;
            if (apiResponse.getStatusCode() != 200) {
                if (apiResponse.getException() != null) {
                    throw apiResponse.getException();
                }
                throw new Exception(apiResponse.getResponseBody());
            }
            answer = apiResponse.getResponseBody();
            this.logger.debug((Object)body);
            this.logger.debug((Object)("answer=" + answer));
        } else {
            this.logger.info((Object)"Nothing to do. No orders found");
        }
    }

    public void resumeOrders(ModifyOrders modifyOrders, String accessToken) throws Exception {
        if (modifyOrders.getOrderIds().size() > 0) {
            String body = Globals.objectMapper.writeValueAsString((Object)modifyOrders);
            ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/orders/resume", body);
            String answer = null;
            if (apiResponse.getStatusCode() != 200) {
                if (apiResponse.getException() != null) {
                    throw apiResponse.getException();
                }
                throw new Exception(apiResponse.getResponseBody());
            }
            answer = apiResponse.getResponseBody();
            this.logger.debug((Object)body);
            this.logger.debug((Object)("answer=" + answer));
        } else {
            this.logger.info((Object)"Nothing to do. No orders found");
        }
    }

    public void suspendOrders(ModifyOrders modifyOrders, String accessToken) throws Exception {
        if (modifyOrders.getOrderIds().size() > 0) {
            String body = Globals.objectMapper.writeValueAsString((Object)modifyOrders);
            ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/orders/suspend", body);
            String answer = null;
            if (apiResponse.getStatusCode() != 200) {
                if (apiResponse.getException() != null) {
                    throw apiResponse.getException();
                }
                throw new Exception(apiResponse.getResponseBody());
            }
            answer = apiResponse.getResponseBody();
            this.logger.debug((Object)body);
            this.logger.debug((Object)("answer=" + answer));
        } else {
            this.logger.info((Object)"Nothing to do. No orders found");
        }
    }

    public void confirmOrders(ModifyOrders modifyOrders, String accessToken) throws Exception {
        if (modifyOrders.getOrderIds().size() > 0) {
            String body = Globals.objectMapper.writeValueAsString((Object)modifyOrders);
            ApiResponse apiResponse = this.apiExecutor.post(accessToken, "/orders/confirm", body);
            String answer = null;
            if (apiResponse.getStatusCode() != 200) {
                if (apiResponse.getException() != null) {
                    throw apiResponse.getException();
                }
                throw new Exception(apiResponse.getResponseBody());
            }
            answer = apiResponse.getResponseBody();
            this.logger.debug((Object)body);
            this.logger.debug((Object)("answer=" + answer));
        } else {
            this.logger.info((Object)"Nothing to do. No orders found");
        }
    }
}

