/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.sap.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.sos.commons.exception.SOSException;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.util.common.SOSArgument;
import com.sos.jitl.jobs.sap.common.CommonJobArguments;
import com.sos.jitl.jobs.sap.common.Globals;
import com.sos.jitl.jobs.sap.common.HttpClient;
import com.sos.jitl.jobs.sap.common.bean.ResponseSchedule;
import com.sos.jitl.jobs.sap.common.bean.RunIds;
import com.sos.jitl.jobs.sap.common.bean.ScheduleDescription;
import com.sos.jitl.jobs.sap.common.bean.ScheduleLog;
import com.sos.js7.job.Job;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.exception.JobProblemException;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import js7.launcher.forjava.internal.BlockingInternalJob;

public abstract class ASAPS4HANAJob
extends Job<CommonJobArguments> {
    public ASAPS4HANAJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public abstract void createInactiveSchedule(OrderProcessStep<CommonJobArguments> var1, CommonJobArguments var2, HttpClient var3, OrderProcessStepLogger var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(OrderProcessStep<CommonJobArguments> step, CommonJobArguments args, RunIds.Scope scope) throws Exception {
        OrderProcessStepLogger logger = step.getLogger();
        args.setIRunScope(scope);
        Path statusFile = Globals.getStatusFileDirectory(args).resolve(this.getStatusFilename(step));
        switch (scope) {
            case JOB: {
                this.checkRequiredArguments(args.setCreateJobArgumentsRequired());
                break;
            }
            case SCHEDULE: {
                this.checkRequiredArguments(args.setCreateScheduleArgumentsRequired());
            }
        }
        HttpClient httpClient = null;
        try {
            httpClient = new HttpClient(args, logger);
            if (Files.exists(statusFile, new LinkOption[0])) {
                RunIds runIds = null;
                try {
                    runIds = (RunIds)Globals.objectMapper.readValue(Files.readAllBytes(statusFile), RunIds.class);
                    args.setIds(runIds);
                    ResponseSchedule respSchedule = httpClient.retrieveSchedule(runIds.getJobId(), runIds.getScheduleId());
                    if (!respSchedule.getActive().booleanValue()) {
                        this.activateSchedule(args.getIds(), httpClient, logger);
                    }
                }
                catch (Exception e) {
                    logger.warn("File '%s' is corrupt: %s", new Object[]{statusFile.getFileName().toString(), e.toString()});
                }
            } else {
                this.createInactiveSchedule(step, args, httpClient, logger);
                this.createStatusFile(statusFile, args, logger);
                this.activateSchedule(args.getIds(), httpClient, logger);
            }
            if (this.pollSchedule(args, httpClient, logger)) {
                Globals.cleanUpSchedule(args.getIds(), httpClient);
                this.deleteStatusFile(statusFile, args, logger);
            }
        }
        finally {
            if (httpClient != null) {
                httpClient.closeHttpClient();
            }
        }
        return true;
    }

    public static String setScheduleDescription(OrderProcessStep<CommonJobArguments> step) throws JobProblemException, JsonProcessingException {
        return Globals.objectMapper.writeValueAsString((Object)new ScheduleDescription(step.getWorkflowName(), step.getJobInstructionLabel(), step.getOrderId(), Instant.now().toEpochMilli()));
    }

    private void checkRequiredArguments(List<JobArgument<?>> args) throws JobRequiredArgumentMissingException {
        Optional<String> arg = args.stream().filter(SOSArgument::isRequired).filter(SOSArgument::isEmpty).findAny().map(SOSArgument::getName);
        if (arg.isPresent()) {
            throw new JobRequiredArgumentMissingException(String.format("'%s' is missing but required", arg.get()));
        }
    }

    private void activateSchedule(RunIds ids, HttpClient httpClient, OrderProcessStepLogger logger) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        httpClient.activateSchedule(ids.getJobId(), ids.getScheduleId());
        logger.info("Schedule jobId=%d scheduleId=%s is activated", new Object[]{ids.getJobId(), ids.getScheduleId()});
    }

    private boolean pollSchedule(CommonJobArguments args, HttpClient httpClient, OrderProcessStepLogger logger) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        Long interval = (Long)args.getCheckInterval().getValue();
        if (interval <= 0L) {
            logger.info("skip checking schedule, interval=%ds", new Object[]{interval});
            return true;
        }
        logger.info("checking schedule completion with %s, interval=%ds", new Object[]{args.idsToString(), interval});
        boolean result = false;
        int step = 0;
        while (!result) {
            result = this.checkSchedule(args, httpClient, ++step == 1, logger);
            logger.info("%d.check: %b", new Object[]{step, result});
            if (result) continue;
            ASAPS4HANAJob.sleep(interval, logger);
        }
        return result;
    }

    private boolean checkSchedule(CommonJobArguments args, HttpClient httpClient, boolean firstStep, OrderProcessStepLogger logger) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        block7: {
            RunIds runIds = args.getIds();
            ScheduleLog scheduleLog = new ScheduleLog().withRunStatus("UNKNOWN");
            try {
                if (firstStep || runIds.getRunId() == null || runIds.getRunId().isEmpty()) {
                    ResponseSchedule respSchedule = httpClient.retrieveSchedule(runIds.getJobId(), runIds.getScheduleId());
                    scheduleLog = respSchedule.getLogs().get(0);
                    args.setIRunId(scheduleLog.getRunId());
                } else {
                    scheduleLog = httpClient.retrieveScheduleLog(runIds.getJobId(), runIds.getScheduleId(), runIds.getRunId());
                }
                if ("COMPLETED".equals(scheduleLog.getRunStatus())) {
                    logger.info((Object)Globals.objectMapperPrettyPrint.writeValueAsString((Object)scheduleLog));
                    return true;
                }
                if ("SCHEDULED".equals(scheduleLog.getRunStatus())) {
                    logger.info("RunStatus '%s': %s", new Object[]{scheduleLog.getRunStatus(), scheduleLog.getAdditionalProperties().get("scheduledTimestamp")});
                } else {
                    logger.info("RunStatus '%s'", new Object[]{scheduleLog.getRunStatus()});
                }
            }
            catch (SOSBadRequestException e) {
                if (404 != e.getHttpCode()) break block7;
                logger.warn("Schedule (%s) is already deleted", new Object[]{args.idsToString()});
                return true;
            }
        }
        return false;
    }

    private static void sleep(Long duration, OrderProcessStepLogger logger) {
        try {
            TimeUnit.SECONDS.sleep(duration);
        }
        catch (InterruptedException e) {
            logger.warn("", (Throwable)e);
        }
    }

    private String getStatusFilename(OrderProcessStep<CommonJobArguments> step) throws JobProblemException {
        return String.format("%s#%s%s.json", step.getWorkflowName(), step.getJobInstructionLabel(), step.getOrderId().replace('|', '!'));
    }

    private void createStatusFile(Path statusfile, CommonJobArguments args, OrderProcessStepLogger logger) throws Exception {
        Files.createDirectories(statusfile.getParent(), new FileAttribute[0]);
        Files.write(statusfile, Globals.objectMapper.writeValueAsBytes((Object)args.getIds()), new OpenOption[0]);
        logger.info("status file '%s' is created with %s", new Object[]{statusfile.toString(), args.idsToString()});
    }

    private void deleteStatusFile(Path statusfile, CommonJobArguments args, OrderProcessStepLogger logger) throws Exception {
        Files.deleteIfExists(statusfile);
        logger.info("status file '%s' is deleted", new Object[]{statusfile.toString()});
    }
}

