/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.sap.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.sos.commons.exception.SOSException;
import com.sos.commons.httpclient.SOSRestApiClient;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.httpclient.exception.SOSSSLException;
import com.sos.commons.sign.keys.keyStore.KeystoreType;
import com.sos.jitl.jobs.sap.common.CommonJobArguments;
import com.sos.jitl.jobs.sap.common.Globals;
import com.sos.jitl.jobs.sap.common.bean.Job;
import com.sos.jitl.jobs.sap.common.bean.ResponseJob;
import com.sos.jitl.jobs.sap.common.bean.ResponseJobs;
import com.sos.jitl.jobs.sap.common.bean.ResponseSchedule;
import com.sos.jitl.jobs.sap.common.bean.Schedule;
import com.sos.jitl.jobs.sap.common.bean.ScheduleLog;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.exception.JobArgumentException;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
extends SOSRestApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final String csrfTokenHeaderKey = "X-CSRF-Token";
    private static final String sapClientQueryKey = "sap-client";
    private final OrderProcessStepLogger processStepLogger;
    private final URI uri;
    private final String sapClient;
    private String csrfToken = null;
    private boolean isDebugEnabled = false;

    public HttpClient(CommonJobArguments jobArgs) throws JobArgumentException, KeyStoreException, NoSuchAlgorithmException, CertificateException, SOSSSLException, IOException {
        this.uri = (URI)jobArgs.getUri().getValue();
        this.sapClient = (String)jobArgs.getMandant().getValue();
        this.processStepLogger = null;
        this.isDebugEnabled = LOGGER.isDebugEnabled();
        this.setProperties(jobArgs);
    }

    public HttpClient(CommonJobArguments jobArgs, OrderProcessStepLogger processStepLogger) throws JobArgumentException, KeyStoreException, NoSuchAlgorithmException, CertificateException, SOSSSLException, IOException {
        this.uri = (URI)jobArgs.getUri().getValue();
        this.sapClient = (String)jobArgs.getMandant().getValue();
        this.processStepLogger = processStepLogger;
        this.isDebugEnabled = processStepLogger == null ? LOGGER.isDebugEnabled() : true;
        this.setProperties(jobArgs);
    }

    public String fetchCSRFToken() throws SocketException, SOSException {
        this.clearHeaders();
        this.addHeader(csrfTokenHeaderKey, "fetch");
        this.addCookieHeader();
        URI uri = this.setUriPath();
        this.logInfo("Fetch token: %s '%s'", SOSRestApiClient.HttpMethod.GET.name(), uri);
        this.logDebug(this.printHttpRequestHeaders(), new Object[0]);
        byte[] response = (byte[])this.getRestService(uri, byte[].class);
        this.logDebug(this.printStatusLine(), new Object[0]);
        this.logDebug(this.printHttpResponseHeaders(), new Object[0]);
        String token = this.getResponseHeader(csrfTokenHeaderKey);
        int httpReplyCode = this.statusCode();
        if (httpReplyCode != 200) {
            String errorMessage = this.getErrorMessage(response);
            this.logWarn("%d %s%s", httpReplyCode, this.getHttpResponse().getStatusLine().getReasonPhrase(), errorMessage.isEmpty() ? "" : ": " + errorMessage);
        }
        if (token != null) {
            this.csrfToken = token;
            return token;
        }
        throw new SOSBadRequestException(this.statusCode(), "Response-Header X-CSRF-Token is missing");
    }

    public ResponseJobs retrieveJobs() throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        return this.retrieveJobs(null, null);
    }

    public ResponseJobs retrieveJobs(Integer pageSize, Integer offset) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        if (pageSize == null) {
            pageSize = 10;
        }
        if (offset == null) {
            offset = 1;
        }
        HashMap<String, Object> queryParameter = new HashMap<String, Object>(2);
        queryParameter.put("pageSize", pageSize);
        queryParameter.put("offset", offset);
        URI url = this.setUriPath("scheduler/jobs", null, queryParameter);
        this.logInfo("Retrieve Jobs: %s '%s'", SOSRestApiClient.HttpMethod.GET.name(), url.toString());
        return this.getJsonObject(SOSRestApiClient.HttpMethod.GET, url, null, ResponseJobs.class);
    }

    public ResponseJob createJob(Job body) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        return this.createJob(Globals.objectMapper.writeValueAsBytes((Object)body));
    }

    public <B> ResponseJob createJob(B body) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        if (body == null) {
            throw new JobArgumentException("Request body is missing");
        }
        URI url = this.setUriPath("scheduler/jobs");
        this.logInfo("Create Job: %s '%s'", SOSRestApiClient.HttpMethod.POST.name(), url.toString());
        return this.getJsonObject(SOSRestApiClient.HttpMethod.POST, url, body, ResponseJob.class);
    }

    public ResponseJob retrieveJob(Long jobId, String jobName) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        URI url = null;
        if (jobId != null) {
            HashMap<String, Object> uriParameter = new HashMap<String, Object>(1);
            uriParameter.put("jobId", jobId);
            HashMap<String, Object> queryParameter = new HashMap<String, Object>(1);
            queryParameter.put("displaySchedules", true);
            url = this.setUriPath("scheduler/jobs/{jobId}", uriParameter, queryParameter);
        } else if (jobName != null && !jobName.isEmpty()) {
            HashMap<String, Object> queryParameter = new HashMap<String, Object>(2);
            queryParameter.put("name", jobName);
            queryParameter.put("displaySchedules", true);
            url = this.setUriPath("scheduler/jobs", null, queryParameter);
        } else {
            throw new JobArgumentException("jobId and jobName are missing");
        }
        this.logInfo("Retrieve Job: %s '%s'", SOSRestApiClient.HttpMethod.GET.name(), url.toString());
        return this.getJsonObject(SOSRestApiClient.HttpMethod.GET, url, null, ResponseJob.class);
    }

    public boolean deleteJob(Long jobId) throws SocketException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(1);
        uriParameter.put("jobId", jobId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}", uriParameter);
        this.logInfo("Delete Job: %s '%s'", SOSRestApiClient.HttpMethod.DELETE.name(), url.toString());
        try {
            this.getJson(SOSRestApiClient.HttpMethod.DELETE, url, null);
        }
        catch (SOSBadRequestException e) {
            if (Arrays.asList(400, 404).contains(e.getHttpCode())) {
                this.logInfo("Job '%d' already deleted", jobId);
                return false;
            }
            throw e;
        }
        return true;
    }

    public ResponseSchedule createSchedule(Long jobId, Schedule body) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        return this.createSchedule(jobId, Globals.objectMapper.writeValueAsBytes((Object)body));
    }

    public <B> ResponseSchedule createSchedule(Long jobId, B body) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (body == null) {
            throw new JobArgumentException("Request body is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(1);
        uriParameter.put("jobId", jobId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules", uriParameter);
        this.logInfo("Create Schedule: %s '%s'", SOSRestApiClient.HttpMethod.POST.name(), url.toString());
        return this.getJsonObject(SOSRestApiClient.HttpMethod.POST, url, body, ResponseSchedule.class);
    }

    public ResponseSchedule retrieveSchedule(Long jobId, String scheduleId) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(2);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        HashMap<String, Object> queryParameter = new HashMap<String, Object>(1);
        queryParameter.put("displayLogs", true);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}", uriParameter, queryParameter);
        this.logInfo("Retrieve Schedule: %s '%s'", SOSRestApiClient.HttpMethod.GET.name(), url.toString());
        return this.getJsonObject(SOSRestApiClient.HttpMethod.GET, url, null, ResponseSchedule.class);
    }

    public ResponseSchedule activateSchedule(Long jobId, String scheduleId) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(2);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}", uriParameter);
        this.logInfo("Activate Schedule: %s '%s'", SOSRestApiClient.HttpMethod.PUT.name(), url.toString());
        return this.getJsonObject(SOSRestApiClient.HttpMethod.PUT, url, Globals.objectMapper.writeValueAsBytes((Object)new Schedule().withActive(true)), ResponseSchedule.class);
    }

    public ScheduleLog retrieveScheduleLog(Long jobId, String scheduleId, String runId) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        if (runId == null) {
            throw new JobArgumentException("runId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(3);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        uriParameter.put("runId", runId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}/runs/{runId}", uriParameter);
        this.logInfo("Retrieve Schedule Run Log: %s '%s'", SOSRestApiClient.HttpMethod.GET.name(), url.toString());
        return this.getJsonObject(SOSRestApiClient.HttpMethod.GET, url, null, ScheduleLog.class);
    }

    public boolean deleteSchedule(Long jobId, String scheduleId) throws SocketException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(2);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}", uriParameter);
        this.logInfo("Delete Schedule: %s '%s'", SOSRestApiClient.HttpMethod.DELETE.name(), url.toString());
        try {
            this.getJson(SOSRestApiClient.HttpMethod.DELETE, url, null);
        }
        catch (SOSBadRequestException e) {
            if (Arrays.asList(400, 404).contains(e.getHttpCode())) {
                this.logInfo("Schedule '%d/%s' already deleted", jobId, scheduleId);
                return false;
            }
            throw e;
        }
        return true;
    }

    private void setProperties(CommonJobArguments jobArgs) throws JobArgumentException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, SOSSSLException {
        this.setAutoCloseHttpClient(false);
        this.setAllowAllHostnameVerifier((Boolean)jobArgs.getHostnameVerification().getValue());
        this.setConnectionTimeout(((Long)jobArgs.getConnectionTimeout().getValue()).intValue() * 1000);
        this.setSocketTimeout(((Long)jobArgs.getSocketTimeout().getValue()).intValue() * 1000);
        this.setSSLContext(null, null, HttpClient.readTruststore(jobArgs));
        this.setBasicAuthorization(HttpClient.getBasicAuthorization(jobArgs));
    }

    private static KeyStore readTruststore(CommonJobArguments jobArgs) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, JobArgumentException {
        if (jobArgs.getTruststorePath().getValue() == null) {
            return null;
        }
        Path truststorePath = (Path)jobArgs.getTruststorePath().getValue();
        if (Files.exists(truststorePath, new LinkOption[0])) {
            KeyStore keyStore;
            block10: {
                KeyStore truststore = KeyStore.getInstance(((KeystoreType)jobArgs.getTruststoreType().getValue()).value());
                InputStream in = Files.newInputStream(truststorePath, new OpenOption[0]);
                try {
                    truststore.load(in, ((String)jobArgs.getTruststorePwd().getValue()).toCharArray());
                    keyStore = truststore;
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return keyStore;
        }
        throw new JobArgumentException(String.format("truststore (%1$s) not found.", truststorePath.toString()));
    }

    private static String getBasicAuthorization(CommonJobArguments jobArgs) {
        return new String(Base64.getEncoder().encode(((String)jobArgs.getUser().getValue() + ":" + (String)jobArgs.getPwd().getValue()).getBytes()));
    }

    private URI setUriPath() {
        return this.setUriPath(null, null, null);
    }

    private URI setUriPath(String path) {
        return this.setUriPath(path, null, null);
    }

    private URI setUriPath(String path, Map<String, Object> uriParameter) {
        return this.setUriPath(path, uriParameter, null);
    }

    private URI setUriPath(String path, Map<String, Object> uriParameter, Map<String, Object> queryParameter) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.uri);
        if (path != null) {
            uriBuilder.path(path);
        }
        if (this.sapClient != null) {
            uriBuilder.queryParam(sapClientQueryKey, new Object[]{this.sapClient});
        }
        if (queryParameter != null) {
            queryParameter.forEach((k, v) -> uriBuilder.queryParam(k, new Object[]{v}));
        }
        if (uriParameter != null) {
            return uriBuilder.buildFromEncodedMap(uriParameter);
        }
        return uriBuilder.build(new Object[0]);
    }

    private <T, B> T getJsonObject(SOSRestApiClient.HttpMethod method, URI uri, B postBody, Class<T> clazz) throws JsonParseException, JsonMappingException, SocketException, IOException, SOSException {
        return this.getJsonObject(this.getJson(method, uri, postBody), clazz);
    }

    private <B> byte[] getJson(SOSRestApiClient.HttpMethod method, URI uri, B postBody) throws SocketException, SOSException {
        this.clearHeaders();
        if (SOSRestApiClient.HttpMethod.POST.equals((Object)method) || SOSRestApiClient.HttpMethod.PUT.equals((Object)method)) {
            this.addHeader("Content-Type", "application/json");
        }
        if (this.csrfToken != null) {
            this.addHeader(csrfTokenHeaderKey, this.csrfToken);
        }
        this.addCookieHeader();
        if (this.isDebugEnabled) {
            this.logDebug(this.printHttpRequestHeaders(), new Object[0]);
            if (postBody != null) {
                if (postBody instanceof String) {
                    this.logDebug("Request Body: %s", (String)postBody);
                } else if (postBody instanceof byte[]) {
                    this.logDebug("Request Body: %s", new String((byte[])postBody, StandardCharsets.UTF_8));
                }
            }
        }
        return this.getJsonFromResponse((byte[])this.executeRestService(method, uri, postBody, byte[].class));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends JsonStructure, B> T getJsonStructure(byte[] jsonStr) {
        if (jsonStr == null) return null;
        try {
            StringReader reader = new StringReader(new String(jsonStr, StandardCharsets.UTF_8));
            try (JsonReader rdr = Json.createReader((Reader)reader);){
                JsonStructure jsonStructure = rdr.read();
                return (T)jsonStructure;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private <T> T getJsonObject(byte[] jsonStr, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        if (jsonStr == null) {
            return null;
        }
        return (T)Globals.objectMapper.readValue(jsonStr, clazz);
    }

    private byte[] getJsonFromResponse(byte[] response) throws SOSBadRequestException {
        if (this.isDebugEnabled) {
            this.logDebug(this.printStatusLine(), new Object[0]);
            this.logDebug(this.printHttpResponseHeaders(), new Object[0]);
        }
        int httpReplyCode = this.statusCode();
        switch (httpReplyCode) {
            case 200: 
            case 201: {
                if (this.isDebugEnabled && response != null) {
                    this.logDebug("Response Body: %s", new String(response, StandardCharsets.UTF_8));
                }
                return response;
            }
        }
        String errorMessage = this.getErrorMessage(response);
        throw new SOSBadRequestException(httpReplyCode, String.format("%d %s%s", httpReplyCode, this.getHttpResponse().getStatusLine().getReasonPhrase(), errorMessage.isEmpty() ? "" : ": " + errorMessage));
    }

    private <T> String getErrorMessage(byte[] response) {
        JsonObject err;
        String contentType = this.getResponseHeader("Content-Type");
        if (contentType != null && contentType.contains("application/json") && (err = (JsonObject)this.getJsonStructure(response)) != null) {
            try {
                return err.getJsonObject("error").getJsonObject("message").getString("value", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private void logInfo(String format, Object ... msg) {
        if (this.processStepLogger != null) {
            this.processStepLogger.info(format, msg);
        } else if (msg.length == 0) {
            LOGGER.info(format);
        } else {
            LOGGER.info(String.format(format, msg));
        }
    }

    private void logDebug(String format, Object ... msg) {
        if (this.processStepLogger != null) {
            this.processStepLogger.info(format, msg);
        } else if (msg.length == 0) {
            LOGGER.debug(format);
        } else {
            LOGGER.debug(String.format(format, msg));
        }
    }

    private void logWarn(String format, Object ... msg) {
        if (this.processStepLogger != null) {
            this.processStepLogger.info(format, msg);
        } else if (msg.length == 0) {
            LOGGER.warn(format);
        } else {
            LOGGER.warn(String.format(format, msg));
        }
    }
}

