/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.common.SOSArgument;
import com.sos.commons.util.common.SOSArgumentHelper;
import com.sos.js7.job.JobArgumentValueIterator;
import com.sos.js7.job.ValueSource;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JobArgument<T>
extends SOSArgument<T> {
    private final List<String> nameAliases;
    private ValueSource valueSource;
    private NotAcceptedValue notAcceptedValue;
    private Type type;
    private ArgumentType argumentType;
    private ArgumentFlatType argumentFlatType;
    private Scope scope;
    private java.lang.reflect.Type clazzType;

    public JobArgument(String name) {
        this(name, false, null, SOSArgumentHelper.DisplayMode.UNMASKED, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required) {
        this(name, required, null, SOSArgumentHelper.DisplayMode.UNMASKED, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, List<String> nameAliases) {
        this(name, required, null, SOSArgumentHelper.DisplayMode.UNMASKED, nameAliases, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue) {
        this(name, required, defaultValue, SOSArgumentHelper.DisplayMode.UNMASKED, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue, List<String> nameAliases) {
        this(name, required, defaultValue, SOSArgumentHelper.DisplayMode.UNMASKED, nameAliases, Scope.ALL);
    }

    public JobArgument(String name, boolean required, SOSArgumentHelper.DisplayMode displayMode) {
        this(name, required, null, displayMode, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, SOSArgumentHelper.DisplayMode displayMode, List<String> nameAliases) {
        this(name, required, null, displayMode, nameAliases, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue, SOSArgumentHelper.DisplayMode displayMode) {
        this(name, required, defaultValue, displayMode, null, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue, SOSArgumentHelper.DisplayMode displayMode, List<String> nameAliases) {
        this(name, required, defaultValue, displayMode, nameAliases, Scope.ALL);
    }

    public JobArgument(String name, boolean required, T defaultValue, SOSArgumentHelper.DisplayMode displayMode, List<String> nameAliases, Scope scope) {
        super(name, required, defaultValue, displayMode);
        this.type = Type.DECLARED;
        this.scope = scope;
        this.valueSource = new ValueSource(ValueSource.ValueSourceType.JAVA);
        this.nameAliases = nameAliases;
    }

    private JobArgument(SOSArgument<T> arg) {
        super(arg.getName(), arg.isRequired(), arg.getDefaultValue(), arg.getDisplayMode());
        this.setValue(arg.getValue());
        this.nameAliases = null;
    }

    private JobArgument(String name, T value) {
        this(name, false, null, SOSArgumentHelper.DisplayMode.UNKNOWN, null, Scope.ALL);
        this.setValue(value);
        this.type = Type.UNDECLARED;
    }

    protected JobArgument(String name, T value, ValueSource valueSource) throws Exception {
        this(name, false, null, SOSArgumentHelper.DisplayMode.UNKNOWN, null, Scope.ALL);
        this.setValue(value);
        this.type = Type.UNDECLARED;
        this.valueSource = valueSource;
        if (value != null) {
            this.setClazzType(value.getClass());
        }
    }

    protected static JobArgument<?> toExecuteJobArgument(String name, Object value) {
        return new JobArgument<Object>(name, value).toExecuteJobArgument();
    }

    protected JobArgument<T> toExecuteJobArgument() {
        return this.toExecuteJobArgument(this);
    }

    private JobArgument<T> toExecuteJobArgument(JobArgument<T> arg) {
        arg.type = Type.UNDECLARED;
        arg.valueSource = new ValueSource(ValueSource.ValueSourceType.EXECUTE_JOB);
        arg.scope = Scope.ALL;
        return arg;
    }

    protected JobArgument(SOSArgument<T> arg, T value, Type type) {
        super(arg);
        this.setValue(value);
        this.type = type;
        this.scope = Scope.ALL;
        this.valueSource = new ValueSource(ValueSource.ValueSourceType.EXECUTE_JOB);
        this.nameAliases = null;
    }

    protected JobArgument(SOSArgument<T> arg, java.lang.reflect.Type clazzType) throws Exception {
        super(arg);
        this.setValue(arg.getValue());
        this.type = Type.DECLARED;
        this.scope = Scope.ALL;
        this.valueSource = new ValueSource(ValueSource.ValueSourceType.JAVA);
        this.nameAliases = null;
        this.setClazzType(clazzType);
    }

    protected void setValueSource(ValueSource val) {
        this.valueSource = val;
    }

    protected void reset() {
        this.setValue(null);
        this.valueSource = new ValueSource(ValueSource.ValueSourceType.JAVA);
        this.setIsDirty(false);
    }

    protected boolean hasValueStartsWith(String prefix) {
        if (this.getValue() == null) {
            return false;
        }
        if (this.isFlat()) {
            return this.getValue().toString().startsWith(prefix);
        }
        if (this.isMap()) {
            return ((Map)this.getValue()).entrySet().parallelStream().anyMatch(e -> e.getValue().toString().startsWith(prefix));
        }
        if (this.isCollection()) {
            return ((Collection)this.getValue()).parallelStream().anyMatch(e -> {
                if (e instanceof Map) {
                    return ((Map)e).entrySet().stream().anyMatch(m -> m.getValue().toString().startsWith(prefix));
                }
                return e.toString().startsWith(prefix);
            });
        }
        return this.getValue().toString().startsWith(prefix);
    }

    public boolean isFlat() {
        return ArgumentType.FLAT.equals((Object)this.argumentType);
    }

    public boolean isMap() {
        return ArgumentType.MAP.equals((Object)this.argumentType);
    }

    public boolean isList() {
        return ArgumentType.LIST.equals((Object)this.argumentType);
    }

    public boolean isSet() {
        return ArgumentType.SET.equals((Object)this.argumentType);
    }

    public boolean isCollection() {
        return this.isList() || this.isSet();
    }

    protected void applyValue(Object val) {
        super.setValue(val);
    }

    public void applyValue(String val) throws Exception {
        super.setValue(JobArgument.convertFlatValue(this, val));
    }

    protected boolean isScopeAll() {
        return this.scope != null && this.scope.equals((Object)Scope.ALL);
    }

    protected boolean isScopeOrderPreparation() {
        return this.scope != null && this.scope.equals((Object)Scope.ORDER_PREPARATION);
    }

    protected void setClazzType(java.lang.reflect.Type val) throws Exception {
        this.clazzType = val;
        try {
            this.setArgumentTypes(this.clazzType);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.argumentType == null) {
            this.argumentType = ArgumentType.FLAT;
        }
        if (this.argumentFlatType == null) {
            this.argumentFlatType = ArgumentFlatType.OBJECT;
        }
    }

    public JobArgumentValueIterator newValueIterator() {
        return this.newValueIterator(null);
    }

    public JobArgumentValueIterator newValueIterator(String prefix) {
        return new JobArgumentValueIterator(this, prefix);
    }

    private void setArgumentTypes(java.lang.reflect.Type type) throws Exception {
        if (type == null || type.equals(String.class)) {
            this.argumentFlatType = ArgumentFlatType.STRING;
        } else if (type.equals(Boolean.class)) {
            this.argumentFlatType = ArgumentFlatType.BOOLEAN;
        } else if (type.equals(Integer.class)) {
            this.argumentFlatType = ArgumentFlatType.INTEGER;
        } else if (type.equals(Long.class)) {
            this.argumentFlatType = ArgumentFlatType.LONG;
        } else if (type.equals(BigDecimal.class)) {
            this.argumentFlatType = ArgumentFlatType.BIGDECIMAL;
        } else if (type.equals(Path.class)) {
            this.argumentFlatType = ArgumentFlatType.PATH;
        } else if (type.equals(File.class)) {
            this.argumentFlatType = ArgumentFlatType.FILE;
        } else if (type.equals(URI.class)) {
            this.argumentFlatType = ArgumentFlatType.URI;
        } else if (type.equals(Charset.class)) {
            this.argumentFlatType = ArgumentFlatType.CHARSET;
        } else if (SOSReflection.isEnum((java.lang.reflect.Type)type)) {
            this.argumentFlatType = ArgumentFlatType.ENUM;
        } else if (SOSReflection.isList((java.lang.reflect.Type)type)) {
            Object o;
            this.argumentType = ArgumentType.LIST;
            this.argumentFlatType = null;
            if (this.getValue() != null && (o = ((List)this.getValue()).get(0)) != null && o instanceof Map) {
                this.argumentFlatType = ArgumentFlatType.LIST_VALUE_SINGLTON_MAP;
            }
            if (this.argumentFlatType == null) {
                this.setArgumentTypes(this.getSubType(type, 0));
            }
        } else if (SOSReflection.isSet((java.lang.reflect.Type)type)) {
            this.argumentType = ArgumentType.SET;
            this.setArgumentTypes(this.getSubType(type, 0));
        } else if (SOSReflection.isMap((java.lang.reflect.Type)type)) {
            if (this.isList()) {
                this.argumentFlatType = ArgumentFlatType.LIST_VALUE_SINGLTON_MAP;
            } else {
                this.argumentType = ArgumentType.MAP;
                this.setArgumentTypes(this.getSubType(type, 1));
            }
        } else {
            this.argumentFlatType = ArgumentFlatType.OBJECT;
        }
    }

    protected static <V> Object convertFlatValue(JobArgument<V> arg, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        switch (arg.getArgumentFlatType()) {
            case STRING: {
                return value.toString();
            }
            case BOOLEAN: {
                return Boolean.valueOf(value.toString());
            }
            case INTEGER: {
                return Integer.valueOf(value.toString());
            }
            case LONG: {
                return Long.valueOf(value.toString());
            }
            case BIGDECIMAL: {
                return new BigDecimal(value.toString());
            }
            case PATH: {
                return Paths.get(value.toString(), new String[0]);
            }
            case FILE: {
                return new File(value.toString());
            }
            case URI: {
                return URI.create(value.toString());
            }
            case CHARSET: {
                return Charset.forName(value.toString());
            }
            case ENUM: {
                try {
                    java.lang.reflect.Type t = arg.isFlat() ? arg.getClazzType() : arg.getSubType(arg.getClazzType(), 0);
                    Enum v = SOSReflection.enumIgnoreCaseValueOf((String)t.getTypeName(), (String)value.toString());
                    if (v == null) {
                        arg.setNotAcceptedValue(value, null);
                        arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
                        return arg.getDefaultValue();
                    }
                    return v;
                }
                catch (ClassNotFoundException e) {
                    arg.setNotAcceptedValue(value, (Throwable)e);
                    arg.getNotAcceptedValue().setUsedValueSource(new ValueSource(ValueSource.ValueSourceType.JAVA));
                    return arg.getDefaultValue();
                }
            }
        }
        return value;
    }

    private java.lang.reflect.Type getSubType(java.lang.reflect.Type type, int paramIndex) {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            try {
                return ((ParameterizedType)type).getActualTypeArguments()[paramIndex];
            }
            catch (Throwable e) {
                return Object.class;
            }
        }
        return Object.class;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public Type getType() {
        return this.type;
    }

    public Scope getScope() {
        return this.scope;
    }

    protected List<String> getNameAliases() {
        return this.nameAliases;
    }

    public java.lang.reflect.Type getClazzType() {
        return this.clazzType;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public ArgumentFlatType getArgumentFlatType() {
        return this.argumentFlatType;
    }

    public void setNotAcceptedValue(JobArgumentValueIterator iterator, Throwable exception) {
        this.setNotAcceptedValue(iterator.current(), exception);
    }

    public void setNotAcceptedValue(Object value, Throwable exception) {
        if (this.notAcceptedValue == null) {
            this.notAcceptedValue = new NotAcceptedValue(value, exception);
        } else {
            this.notAcceptedValue.getValues().add(value);
        }
    }

    protected NotAcceptedValue getNotAcceptedValue() {
        return this.notAcceptedValue;
    }

    protected void resetNotAcceptedValue() {
        this.notAcceptedValue = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("[");
        sb.append("value=").append(this.getDisplayValue());
        if (this.valueSource != null && this.valueSource.getType() != null) {
            sb.append(" source=").append(this.valueSource.getType().name());
            if (this.valueSource.getSource() != null) {
                sb.append("(").append(this.valueSource.getSource()).append(")");
            }
        }
        if (this.isRequired()) {
            sb.append(" required=true");
        }
        sb.append(" modified=").append(this.isDirty());
        if (this.argumentType != null) {
            sb.append(" argumentType=").append((Object)this.argumentType);
        }
        if (this.argumentFlatType != null) {
            sb.append(" argumentFlatType=").append((Object)this.argumentFlatType);
        }
        if (this.clazzType != null) {
            sb.append(" ").append(this.clazzType.getTypeName());
        }
        if (this.getPayload() != null) {
            sb.append(" class=").append(SOSArgumentHelper.getClassName((String)this.getPayload().toString()));
        }
        if (this.notAcceptedValue != null) {
            sb.append("(value=").append(this.notAcceptedValue.getDisplayValue()).append(" ignored");
            if (this.notAcceptedValue.exception != null) {
                sb.append("(").append(this.notAcceptedValue.exception.toString()).append(")");
            }
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum Scope {
        ALL,
        ORDER_PREPARATION;

    }

    public static enum Type {
        DECLARED,
        UNDECLARED;

    }

    public static enum ArgumentType {
        SET,
        MAP,
        LIST,
        FLAT;

    }

    public static enum ArgumentFlatType {
        STRING,
        BOOLEAN,
        INTEGER,
        LONG,
        BIGDECIMAL,
        ENUM,
        URI,
        CHARSET,
        PATH,
        FILE,
        OBJECT,
        LIST_VALUE_SINGLTON_MAP;

    }

    protected class NotAcceptedValue {
        private final List<Object> values = new ArrayList<Object>();
        private final Throwable exception;
        private ValueSource source;
        private ValueSource usedValueSource;

        private NotAcceptedValue(Object value, Throwable exception) {
            this.values.add(value);
            this.exception = exception;
        }

        protected List<Object> getValues() {
            return this.values;
        }

        protected void setSource(ValueSource val) {
            this.source = val;
        }

        protected ValueSource getSource() {
            return this.source;
        }

        protected void setUsedValueSource(ValueSource val) {
            this.usedValueSource = val;
        }

        protected ValueSource getUsedValueSource() {
            return this.usedValueSource;
        }

        protected Throwable getException() {
            return this.exception;
        }

        protected String getDisplayValue() {
            return SOSArgumentHelper.getDisplayValue(this.values, (SOSArgumentHelper.DisplayMode)JobArgument.this.getDisplayMode());
        }
    }
}

