/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.util.SOSShell;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.JobHelper;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import js7.data.value.Value;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class JobEnvironment<A extends JobArguments> {
    private final Map<String, Value> engineArguments;
    private final Charset systemEncoding;
    private final String jobKey;
    private A declaredArguments;
    private Map<String, Object> allArguments;

    protected JobEnvironment(BlockingInternalJob.JobContext jc) {
        if (jc == null) {
            this.engineArguments = null;
            this.systemEncoding = SOSShell.getSystemEncoding();
            this.jobKey = UUID.randomUUID().toString();
        } else {
            this.engineArguments = jc.jobArguments();
            this.systemEncoding = jc.systemEncoding();
            this.jobKey = jc.jobKey().toString();
        }
    }

    protected <AJ extends JobArguments> JobEnvironment(String clazzName, JobEnvironment<AJ> je) {
        this.engineArguments = je.getEngineArguments();
        this.systemEncoding = je.getSystemEncoding();
        this.jobKey = "execute-job-" + clazzName + "-" + UUID.randomUUID().toString();
        this.allArguments = je.allArguments;
    }

    public A getDeclaredArguments() {
        return this.declaredArguments;
    }

    public Map<String, Object> getAllArgumentsAsNameValueMap() {
        if (this.allArguments == null) {
            this.allArguments = JobHelper.asJavaValues(this.engineArguments);
        }
        return this.allArguments;
    }

    public Charset getSystemEncoding() {
        return this.systemEncoding;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    protected Map<String, Value> getEngineArguments() {
        return this.engineArguments;
    }

    protected void setDeclaredArguments(A args) {
        this.declaredArguments = args;
    }
}

