/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.exception.ISOSRequiredArgumentMissingException;
import com.sos.commons.hibernate.SOSHibernateSession;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.ASOSArguments;
import com.sos.commons.util.common.SOSArgumentHelper;
import com.sos.commons.vfs.ssh.SSHProvider;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.Job;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.JobEnvironment;
import com.sos.js7.job.JobHelper;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.OrderProcessStepOutcome;
import com.sos.js7.job.UnitTestJobHelper;
import com.sos.js7.job.ValueSource;
import com.sos.js7.job.exception.JobArgumentException;
import com.sos.js7.job.exception.JobProblemException;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import com.sos.js7.job.resolver.JobArgumentValueResolverCache;
import io.vavr.control.Either;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import js7.data.agent.AgentPath;
import js7.data.job.JobResourcePath;
import js7.data.order.HistoricOutcome;
import js7.data.order.OrderOutcome;
import js7.data.value.NumberValue;
import js7.data.value.Value;
import js7.data.workflow.instructions.executable.WorkflowJob;
import js7.data.workflow.position.Label;
import js7.data_for_java.order.JOutcome;
import js7.launcher.forjava.internal.BlockingInternalJob;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class OrderProcessStep<A extends JobArguments> {
    protected static final String CANCELABLE_RESOURCE_NAME_HIBERNATE = "hibernate";
    protected static final String CANCELABLE_RESOURCE_NAME_SSH_PROVIDER = "ssh_provider";
    protected static final String CANCELABLE_RESOURCE_NAME_SQL_CONNECTION = "sql_connection";
    private static final String INTERNAL_ORDER_PREPARATION_PARAMETER_JS7_WORKFLOW_PATH = "js7Workflow.path";
    private final JobEnvironment<A> jobEnvironment;
    private final BlockingInternalJob.Step internalStep;
    private final OrderProcessStepLogger logger;
    private final OrderProcessStepOutcome outcome;
    private A declaredArguments;
    private List<JobArgument<?>> allDeclaredArguments;
    private java.util.Map<String, JobArgument<?>> allArguments;
    private ExecuteJobBean executeJobBean;
    private java.util.Map<String, OrderProcessStep> cancelableExecuteJobs;
    private java.util.Map<String, java.util.Map<String, DetailValue>> lastOutcomes;
    private java.util.Map<String, DetailValue> jobResourcesValues;
    private java.util.Map<String, Object> unitTestUndeclaredArguments;
    private java.util.Map<String, Object> cancelableResources;
    private Set<String> orderPreparationParameterNames;
    private List<String> resolverPrefixes;
    private String controllerId;
    private String orderId;
    private String agentId;
    private String jobInstructionLabel;
    private String jobName;
    private String workflowPath;
    private String workflowName;
    private String workflowVersionId;
    private String workflowPosition;
    private String stepInfo;

    protected OrderProcessStep(JobEnvironment<A> jobEnvironment, BlockingInternalJob.Step step) {
        this.jobEnvironment = jobEnvironment;
        this.internalStep = step;
        this.logger = new OrderProcessStepLogger(this.internalStep);
        this.outcome = new OrderProcessStepOutcome();
        this.resolverPrefixes = JobArgumentValueResolverCache.getResolverPrefixes();
    }

    private OrderProcessStep(JobEnvironment<A> jobEnvironment, OrderProcessStep<?> step) {
        this.jobEnvironment = jobEnvironment;
        this.internalStep = step.getInternalStep();
        this.logger = step.logger;
        this.outcome = step.outcome;
        this.resolverPrefixes = step.resolverPrefixes;
    }

    public <AJ extends JobArguments> void executeJob(Class<? extends Job<AJ>> clazz) throws Exception {
        this.executeJob(clazz, (java.util.Map)null, false);
    }

    public <AJ extends JobArguments> void executeJob(Class<? extends Job<AJ>> clazz, java.util.Map<String, Object> executeJobArguments) throws Exception {
        HashMap map = null;
        if (executeJobArguments != null && executeJobArguments.size() > 0) {
            map = new HashMap();
            for (Map.Entry<String, Object> e : executeJobArguments.entrySet()) {
                map.put(e.getKey(), JobArgument.toExecuteJobArgument(e.getKey(), e.getValue()));
            }
        }
        this.executeJob(clazz, map, false);
    }

    public <AJ extends JobArguments> void executeJob(Class<? extends Job<AJ>> clazz, JobArgument<?> ... executeJobArguments) throws Exception {
        this.executeJob(clazz, executeJobArguments == null || executeJobArguments.length == 0 ? null : Arrays.asList(executeJobArguments));
    }

    public <AJ extends JobArguments> void executeJob(Class<? extends Job<AJ>> clazz, Collection<JobArgument<?>> executeJobArguments) throws Exception {
        HashMap map = null;
        if (executeJobArguments != null && executeJobArguments.size() > 0) {
            map = new HashMap();
            for (JobArgument<?> arg : executeJobArguments) {
                map.put(arg.getName(), arg.toExecuteJobArgument());
            }
        }
        this.executeJob(clazz, map, true);
    }

    protected <AJ extends JobArguments> AJ onExecuteJobCreateArguments(Job<AJ> job, OrderProcessStep<AJ> step, List<JobArgumentException> exceptions) throws Exception {
        AJ args = job.onCreateJobArguments(exceptions, step);
        return job.createDeclaredJobArguments(exceptions, step, args);
    }

    private <AJ extends JobArguments> void executeJob(Class<? extends Job<AJ>> clazz, java.util.Map<String, JobArgument<?>> executeJobArguments, boolean updateDeclaredArgumentsDefinition) throws Exception {
        Job<AJ> job = null;
        try {
            job = clazz.getDeclaredConstructor(BlockingInternalJob.JobContext.class).newInstance(new Object[]{null});
        }
        catch (Throwable e) {
            job = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        JobEnvironment je = new JobEnvironment(clazz.getSimpleName(), this.jobEnvironment);
        job.setJobEnvironment(je);
        if (this.cancelableExecuteJobs == null) {
            this.cancelableExecuteJobs = new ConcurrentHashMap<String, OrderProcessStep>();
        }
        try {
            OrderProcessStep<AJ> step;
            job.onStart();
            OrderProcessStep<AJ> orderProcessStep = step = new OrderProcessStep<AJ>(je, this);
            Objects.requireNonNull(orderProcessStep);
            step.executeJobBean = orderProcessStep.new ExecuteJobBean(job, executeJobArguments, updateDeclaredArgumentsDefinition);
            ArrayList<JobArgumentException> exceptions = new ArrayList<JobArgumentException>();
            AJ args = this.onExecuteJobCreateArguments(job, step, exceptions);
            step.init(args);
            if (step.getLogger().isDebugEnabled()) {
                step.logJobKey();
                step.logAllArguments(JobArguments.LogLevel.DEBUG);
            }
            this.cancelableExecuteJobs.put(je.getJobKey(), step);
            job.processOrder(step);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            job.onStop();
            this.cancelableExecuteJobs.remove(je.getJobKey());
        }
    }

    protected void cancelExecuteJobs() {
        if (this.cancelableExecuteJobs != null && this.cancelableExecuteJobs.size() > 0) {
            for (Map.Entry<String, OrderProcessStep> e : this.cancelableExecuteJobs.entrySet()) {
                try {
                    e.getValue().getExecuteJobBean().getJob().cancelOrderProcessStep(e.getValue());
                }
                catch (Throwable t) {
                    this.logger.warn("[cancelExecuteJobs][" + e.getKey() + "]" + e.toString(), e);
                }
            }
            this.cancelableExecuteJobs.clear();
        }
        this.cancelableExecuteJobs = null;
    }

    protected void init(A arguments) throws Exception {
        this.declaredArguments = arguments;
        this.logger.init(arguments);
        this.setAllArguments();
    }

    protected void init4unittest(A arguments, java.util.Map<String, Object> unitTestUndeclaredArguments, UnitTestJobHelper.UnitTestStepConfig stepConfig) throws Exception {
        this.unitTestUndeclaredArguments = unitTestUndeclaredArguments;
        if (stepConfig != null) {
            this.controllerId = stepConfig.getControllerId();
            this.orderId = stepConfig.getOrderId();
            this.agentId = stepConfig.getAgentId();
            this.jobInstructionLabel = stepConfig.getJobInstructionLabel();
            this.jobName = stepConfig.getJobName();
            this.workflowPath = stepConfig.getWorkflowPath();
            this.workflowName = stepConfig.getWorkflowName();
            this.workflowVersionId = stepConfig.getWorkflowVersionId();
            this.workflowPosition = stepConfig.getWorkflowPosition();
        }
        this.init(arguments);
    }

    public void addCancelableResource(SOSHibernateSession session) {
        this.addCancelableResource(CANCELABLE_RESOURCE_NAME_HIBERNATE, session);
    }

    public void addCancelableResource(SSHProvider provider) {
        this.addCancelableResource(CANCELABLE_RESOURCE_NAME_SSH_PROVIDER, provider);
    }

    private void addCancelableResource(Connection conn) {
        this.addCancelableResource(CANCELABLE_RESOURCE_NAME_SQL_CONNECTION, conn);
    }

    private void addCancelableResource(String identifier, Object o) {
        if (this.cancelableResources == null) {
            this.cancelableResources = new HashMap<String, Object>();
        }
        this.cancelableResources.put(identifier, o);
    }

    protected java.util.Map<String, Object> getCancelableResources() {
        return this.cancelableResources;
    }

    public OrderProcessStepLogger getLogger() {
        return this.logger;
    }

    public A getDeclaredArguments() {
        return this.declaredArguments;
    }

    public List<JobArgument<?>> getAllDeclaredArguments() {
        return this.allDeclaredArguments;
    }

    public java.util.Map<String, java.util.Map<String, DetailValue>> getLastOutcomes() {
        if (this.lastOutcomes == null) {
            this.lastOutcomes = this.historicOutcomes2map();
        }
        return this.lastOutcomes;
    }

    public java.util.Map<String, DetailValue> getJobResourcesArgumentsAsNameDetailValueMap() {
        if (this.jobResourcesValues == null) {
            this.jobResourcesValues = this.jobResources2map();
        }
        return this.jobResourcesValues;
    }

    public java.util.Map<String, DetailValue> getLastSucceededOutcomes() {
        return this.getLastOutcomes().get(OrderOutcome.Succeeded.class.getSimpleName());
    }

    public java.util.Map<String, DetailValue> getLastFailedOutcomes() {
        return this.getLastOutcomes().get(OrderOutcome.Failed.class.getSimpleName());
    }

    protected BlockingInternalJob.Step getInternalStep() {
        return this.internalStep;
    }

    public JobArgument<?> getDeclaredArgument(String name) {
        if (this.allDeclaredArguments != null) {
            return this.allDeclaredArguments.stream().filter(a -> a.getName() != null && a.getName().equals(name) || a.getNameAliases() != null && a.getNameAliases().contains(name)).findAny().orElse(null);
        }
        return null;
    }

    public Object getDeclaredArgumentValue(String name) {
        JobArgument<?> a = this.getDeclaredArgument(name);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    private String getDisplayValue(String name) {
        JobArgument<?> ar = this.allArguments.get(name);
        if (ar == null) {
            return SOSArgumentHelper.DisplayMode.UNKNOWN.getValue();
        }
        return ar.getDisplayValue();
    }

    private String getDisplayValue(String name, Object originalValue) {
        JobArgument<?> ar = this.allArguments.get(name);
        if (ar == null) {
            return SOSArgumentHelper.DisplayMode.UNKNOWN.getValue();
        }
        return SOSArgumentHelper.getDisplayValue((Object)originalValue, (SOSArgumentHelper.DisplayMode)ar.getDisplayMode());
    }

    private void setAllArguments() throws Exception {
        java.util.Map<String, DetailValue> resources;
        java.util.Map<String, DetailValue> lso;
        this.allArguments = new TreeMap();
        this.setOrderPreparationParameterNames();
        this.setAllDeclaredArguments();
        if (this.allDeclaredArguments != null && this.allDeclaredArguments.size() > 0) {
            this.allDeclaredArguments.stream().forEach(a -> {
                if (!this.allArguments.containsKey(a.getName())) {
                    this.allArguments.put(a.getName(), (JobArgument<?>)((Object)a));
                }
                if (a.getNameAliases() != null) {
                    for (String n : a.getNameAliases()) {
                        if (this.allArguments.containsKey(n)) continue;
                        this.allArguments.put(n, (JobArgument<?>)((Object)a));
                    }
                }
            });
        }
        if (this.hasExecuteJobArguments()) {
            this.executeJobBean.arguments.entrySet().stream().forEach(e -> {
                if (!this.allArguments.containsKey(e.getKey())) {
                    this.allArguments.put((String)e.getKey(), (JobArgument)((Object)((Object)e.getValue())));
                }
            });
        }
        if ((lso = this.getLastSucceededOutcomes()) != null && lso.size() > 0) {
            lso.entrySet().stream().forEach(e -> {
                if (!this.allArguments.containsKey(e.getKey())) {
                    ValueSource vs = new ValueSource(ValueSource.ValueSourceType.LAST_SUCCEEDED_OUTCOME);
                    vs.setSource(((DetailValue)e.getValue()).getSource());
                    try {
                        this.allArguments.put((String)e.getKey(), new JobArgument<Object>((String)e.getKey(), ((DetailValue)e.getValue()).getValue(), vs));
                    }
                    catch (Throwable ex) {
                        this.getLogger().error("[LastSucceededOutcomes][" + (String)e.getKey() + "]" + ex.toString());
                    }
                }
            });
        }
        if (this.internalStep != null) {
            java.util.Map<String, Object> j;
            java.util.Map<String, Object> o = JobHelper.asJavaValues(this.internalStep.order().arguments());
            if (o != null && o.size() > 0) {
                o.entrySet().stream().forEach(e -> {
                    if (!this.allArguments.containsKey(e.getKey())) {
                        try {
                            this.allArguments.put((String)e.getKey(), new JobArgument((String)e.getKey(), e.getValue(), new ValueSource(ValueSource.ValueSourceType.ORDER)));
                        }
                        catch (Throwable ex) {
                            this.getLogger().error("[OrderVariables][" + (String)e.getKey() + "]" + ex.toString());
                        }
                    }
                });
            }
            if ((j = JobHelper.asJavaValues(this.internalStep.arguments())) != null && j.size() > 0) {
                j.entrySet().stream().forEach(e -> {
                    if (!this.allArguments.containsKey(e.getKey())) {
                        try {
                            this.allArguments.put((String)e.getKey(), new JobArgument((String)e.getKey(), e.getValue(), new ValueSource(ValueSource.ValueSourceType.JOB)));
                        }
                        catch (Throwable ex) {
                            this.getLogger().error("[JobArgument][" + (String)e.getKey() + "]" + ex.toString());
                        }
                    }
                });
            }
        }
        if ((resources = this.getJobResourcesArgumentsAsNameDetailValueMap()) != null && resources.size() > 0) {
            resources.entrySet().stream().forEach(e -> {
                String name = (String)e.getKey();
                DetailValue dv = (DetailValue)e.getValue();
                JobArgument<?> aja = this.allArguments.get(name);
                if (aja == null || aja.getValue() == null) {
                    try {
                        ValueSource vs = new ValueSource(ValueSource.ValueSourceType.JOB_RESOURCE);
                        vs.setSource(dv.getSource());
                        JobArgument<Object> ja = new JobArgument<Object>(name, dv.getValue(), vs);
                        this.allArguments.put(name, ja);
                    }
                    catch (Throwable ex) {
                        this.getLogger().error("[JobResources][" + dv.getSource() + "][" + (String)e.getKey() + "]" + ex.toString());
                    }
                }
            });
        }
        this.jobEnvironment.getAllArgumentsAsNameValueMap().entrySet().stream().forEach(e -> {
            if (!this.allArguments.containsKey(e.getKey())) {
                try {
                    ValueSource vs = new ValueSource(ValueSource.ValueSourceType.JOB_ARGUMENT);
                    this.allArguments.put((String)e.getKey(), new JobArgument((String)e.getKey(), e.getValue(), vs));
                }
                catch (Throwable ex) {
                    this.getLogger().error("[JobEnvironment.JobArgument][" + (String)e.getKey() + "]" + ex.toString());
                }
            }
        });
        if (this.orderPreparationParameterNames != null) {
            for (String name : this.orderPreparationParameterNames) {
                if (this.allArguments.containsKey(name)) continue;
                ValueSource vs = new ValueSource(ValueSource.ValueSourceType.ORDER_PREPARATION);
                try {
                    Object o = this.getNamedValue(name);
                    JobArgument<Object> ar = new JobArgument<Object>(name, o, vs);
                    this.allArguments.put(name, ar);
                }
                catch (Throwable e1) {
                    this.getLogger().error("[orderPreparation][" + name + "]" + e1.toString());
                }
            }
        }
        if (this.unitTestUndeclaredArguments != null) {
            this.unitTestUndeclaredArguments.entrySet().stream().forEach(e -> {
                if (!this.allArguments.containsKey(e.getKey())) {
                    try {
                        this.allArguments.put((String)e.getKey(), new JobArgument((String)e.getKey(), e.getValue(), new ValueSource(ValueSource.ValueSourceType.JOB_ARGUMENT)));
                    }
                    catch (Throwable ex) {
                        this.getLogger().error("[unitTestUndeclaredArguments][" + (String)e.getKey() + "]" + ex.toString(), e);
                    }
                }
            });
        }
        this.resolveArgumentValues();
    }

    private void resolveArgumentValues() throws Exception {
        if (this.allArguments != null) {
            java.util.Map groupedArguments = this.allArguments.values().parallelStream().flatMap(arg -> this.getResolverPrefixes().parallelStream().filter(prefix -> arg.hasValueStartsWith((String)prefix)).map(prefix -> new AbstractMap.SimpleEntry<String, JobArgument>((String)prefix, (JobArgument)((Object)arg)))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
            for (Map.Entry entry : groupedArguments.entrySet()) {
                try {
                    JobArgumentValueResolverCache.resolve(entry.getKey(), this.logger, entry.getValue(), this.allArguments);
                }
                catch (Throwable e) {
                    Throwable ex = e.getCause() == null ? e : e.getCause();
                    throw new JobArgumentException(String.format("[%s]%s", JobArgumentValueResolverCache.getResolverClassName(entry.getKey()), ex.toString()), ex);
                }
            }
        }
    }

    public java.util.Map<String, JobArgument<?>> getAllArguments() {
        return this.allArguments;
    }

    public java.util.Map<String, JobArgument<?>> getAllArguments(JobArgument.Type type) {
        return this.allArguments.entrySet().stream().filter(a -> ((JobArgument)((Object)((Object)a.getValue()))).getType().equals((Object)type)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public java.util.Map<String, Object> getAllArgumentsAsNameValueMap() {
        return JobHelper.asNameValueMap(this.allArguments);
    }

    public java.util.Map<String, Object> getUndeclaredArgumentsAsNameValueMap() {
        return JobHelper.asNameValueMap(this.getAllArguments(JobArgument.Type.UNDECLARED));
    }

    public java.util.Map<String, Object> getOrderArgumentsAsNameValueMap() {
        if (this.internalStep == null) {
            return Collections.emptyMap();
        }
        return JobHelper.asJavaValues(this.internalStep.order().arguments());
    }

    private Object getArgumentValue(String name) {
        if (this.allArguments.containsKey(name)) {
            return this.allArguments.get(name).getValue();
        }
        try {
            return this.getNamedValue(name);
        }
        catch (JobProblemException e) {
            return null;
        }
    }

    protected Object getNamedValue(JobArgument<?> arg) throws JobProblemException {
        Object val;
        block2: {
            String name;
            if (this.internalStep == null) {
                return null;
            }
            val = this.getNamedValue(arg.getName());
            if (val != null || arg.getNameAliases() == null) break block2;
            Iterator<String> iterator = arg.getNameAliases().iterator();
            while (iterator.hasNext() && (val = this.getNamedValue(name = iterator.next())) == null) {
            }
        }
        return val;
    }

    private Object getNamedValue(String name) throws JobProblemException {
        Optional opt = this.internalStep.namedValue(name);
        if (opt.isPresent()) {
            return JobHelper.asJavaValue((Value)JobHelper.getFromEither((Either)opt.get()));
        }
        return null;
    }

    private void setAllDeclaredArguments() {
        if (this.declaredArguments == null) {
            this.allDeclaredArguments = null;
            return;
        }
        if (this.allDeclaredArguments == null) {
            List<Field> fields = JobHelper.getJobArgumentFields(this.declaredArguments);
            ArrayList l = new ArrayList();
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    JobArgument arg = (JobArgument)((Object)field.get(this.declaredArguments));
                    if (arg == null || arg.getName() == null) continue;
                    l.add(arg);
                }
                catch (Throwable e) {
                    this.logger.warn2allLoggers(this.getStepInfo(), String.format("[%s.%s][can't read field]%s", this.getClass().getName(), field.getName(), e.toString()), e);
                }
            }
            if (((JobArguments)this.declaredArguments).getIncludedArguments() != null && ((JobArguments)this.declaredArguments).getIncludedArguments().size() > 0) {
                for (Map.Entry entry : ((JobArguments)this.declaredArguments).getIncludedArguments().entrySet()) {
                    for (JobArgument arg : (List)entry.getValue()) {
                        l.add(arg);
                    }
                }
            }
            if (((JobArguments)this.declaredArguments).hasDynamicArgumentFields()) {
                for (JobArgument jobArgument : ((JobArguments)this.declaredArguments).getDynamicArgumentFields()) {
                    l.add(jobArgument);
                }
            }
            this.allDeclaredArguments = l;
        }
    }

    public <T extends ASOSArguments> T getIncludedArguments(Class<T> clazz) throws JobArgumentException {
        try {
            ASOSArguments instance = (ASOSArguments)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (((JobArguments)this.declaredArguments).getIncludedArguments() == null) {
                return (T)instance;
            }
            List args = this.allDeclaredArguments.stream().filter(a -> a.getPayload() != null && a.getPayload().equals(clazz.getName())).map(a -> a).collect(Collectors.toList());
            if (args != null) {
                instance.setArguments(args);
            }
            return (T)instance;
        }
        catch (Throwable e) {
            throw new JobArgumentException(e.toString(), e);
        }
    }

    public ASOSArguments getIncludedArguments(String clazzKey) throws JobArgumentException {
        if (clazzKey == null) {
            return null;
        }
        switch (clazzKey.toUpperCase()) {
            case "CREDENTIAL_STORE": {
                return this.getIncludedArguments(new CredentialStoreArguments().getClass());
            }
            case "SSH_PROVIDER": {
                return this.getIncludedArguments(SSHProviderArguments.class);
            }
        }
        return null;
    }

    private String getStepInfo() {
        if (this.stepInfo == null) {
            try {
                this.stepInfo = String.format("[Order %s][Workflow %s, versionId=%s, pos=%s][Job %s, agent=%s, class=%s]", this.getOrderId(), this.getWorkflowPath(), this.getWorkflowVersionId(), this.getWorkflowPosition(), this.getJobName(), this.getAgentId(), this.getClass().getName());
            }
            catch (JobProblemException e) {
                this.stepInfo = String.format("[Workflow %s, versionId=%s, pos=%s][Job class=%s]", this.getWorkflowPath(), this.getWorkflowVersionId(), this.getWorkflowPosition(), this.getClass().getName());
            }
        }
        return this.stepInfo;
    }

    public String getControllerId() {
        if (this.controllerId == null) {
            if (this.internalStep == null) {
                return null;
            }
            this.controllerId = this.internalStep.controllerId().string();
        }
        return this.controllerId;
    }

    public String getOrderId() {
        if (this.orderId == null) {
            if (this.internalStep == null) {
                return null;
            }
            this.orderId = this.internalStep.order().id().string();
        }
        return this.orderId;
    }

    public String getAgentId() throws JobProblemException {
        if (this.agentId == null) {
            if (this.internalStep == null) {
                return null;
            }
            this.agentId = ((AgentPath)JobHelper.getFromEither(this.internalStep.order().attached())).string();
        }
        return this.agentId;
    }

    public String getJobName() throws JobProblemException {
        if (this.jobName == null) {
            if (this.internalStep == null) {
                return null;
            }
            this.jobName = ((WorkflowJob.Name)JobHelper.getFromEither(this.internalStep.workflow().checkedJobName(this.internalStep.order().workflowPosition().position()))).toString();
        }
        return this.jobName;
    }

    public String getJobInstructionLabel() {
        if (this.jobInstructionLabel == null) {
            if (this.internalStep == null) {
                return null;
            }
            try {
                this.jobInstructionLabel = ((Label)this.internalStep.instructionLabel().get()).string();
            }
            catch (Throwable e) {
                this.getLogger().error(String.format("[getJobInstructionLabel]%s", e.toString()));
            }
        }
        return this.jobInstructionLabel;
    }

    public String getWorkflowPath() {
        if (this.workflowPath == null) {
            if (this.internalStep == null) {
                return null;
            }
            try {
                this.workflowPath = (String)this.getNamedValue(INTERNAL_ORDER_PREPARATION_PARAMETER_JS7_WORKFLOW_PATH);
            }
            catch (Throwable e) {
                this.getLogger().error(String.format("[getWorkflowPath][%s]%s", INTERNAL_ORDER_PREPARATION_PARAMETER_JS7_WORKFLOW_PATH, e.toString()));
            }
        }
        return this.workflowPath;
    }

    public String getWorkflowName() {
        if (this.workflowName == null) {
            if (this.internalStep == null) {
                return null;
            }
            this.workflowName = this.internalStep.order().workflowId().path().name();
        }
        return this.workflowName;
    }

    public String getWorkflowVersionId() {
        if (this.workflowVersionId == null) {
            if (this.internalStep == null) {
                return null;
            }
            this.workflowVersionId = this.internalStep.order().workflowId().versionId().string();
        }
        return this.workflowVersionId;
    }

    public String getWorkflowPosition() {
        if (this.workflowPosition == null) {
            if (this.internalStep == null) {
                return null;
            }
            this.workflowPosition = this.internalStep.order().workflowPosition().position().toString();
        }
        return this.workflowPosition;
    }

    private void setOrderPreparationParameterNames() {
        if (this.orderPreparationParameterNames == null) {
            if (this.internalStep == null) {
                this.orderPreparationParameterNames = new HashSet<String>();
                return;
            }
            this.orderPreparationParameterNames = JavaConverters.asJava((Map)this.internalStep.asScala().workflow().orderPreparation().parameterList().nameToParameter()).entrySet().stream().filter(e -> !((String)e.getKey()).equals(INTERNAL_ORDER_PREPARATION_PARAMETER_JS7_WORKFLOW_PATH)).map(e -> (String)e.getKey()).collect(Collectors.toSet());
        }
    }

    protected JOutcome.Completed processed() {
        return this.outcome.isFailed() ? this.failed() : this.success();
    }

    protected JOutcome.Completed success() {
        return JOutcome.succeeded(this.mapProcessResult(this.getOutcomeVariables(), this.getReturnCodeSucceeded(this.outcome.getReturnCode())));
    }

    private JOutcome.Completed failed() {
        String fm = SOSString.isEmpty((String)this.outcome.getMessage()) ? "" : this.outcome.getMessage();
        this.logger.failed2slf4j(this.getStepInfo(), fm);
        return JOutcome.failed((String)fm, this.mapProcessResult(this.getOutcomeVariables(), this.getReturnCodeFailed(this.outcome.getReturnCode())));
    }

    protected JOutcome.Completed failed(String msg, Throwable e) {
        String fm = SOSString.isEmpty((String)msg) ? "" : msg;
        Throwable ex = this.logger.handleException(e);
        this.logger.failed2slf4j(this.getStepInfo(), e.toString(), ex);
        this.logger.error(this.logger.throwable2String(fm, ex));
        return JOutcome.failed((String)this.getJOutcomeFailed(fm, ex), this.mapProcessResult(this.getOutcomeVariables(), this.getReturnCodeFailed(JobHelper.DEFAULT_RETURN_CODE_FAILED)));
    }

    private String getJOutcomeFailed(String msg, Throwable e) {
        if (e == null) {
            return msg;
        }
        String em = e.getMessage() == null ? e.toString() : e.getMessage();
        return msg + em;
    }

    private java.util.Map<String, Value> getOutcomeVariables() {
        return this.outcome.hasVariables() ? JobHelper.asEngineValues(this.outcome.getVariables()) : null;
    }

    private java.util.Map<String, Value> mapProcessResult(java.util.Map<String, Value> map, Integer returnCode) {
        if (map == null || map.size() == 0) {
            map = Collections.singletonMap("returnCode", NumberValue.of((Integer)returnCode));
        } else {
            map.put("returnCode", (Value)NumberValue.of((Integer)returnCode));
        }
        return map;
    }

    private Integer getReturnCodeSucceeded(Integer returnCode) {
        if (returnCode == null) {
            return JobHelper.DEFAULT_RETURN_CODE_SUCCEEDED;
        }
        return returnCode;
    }

    private Integer getReturnCodeFailed(Integer returnCode) {
        if (returnCode == null) {
            return JobHelper.DEFAULT_RETURN_CODE_FAILED;
        }
        return returnCode;
    }

    public java.util.Map<String, String> getJobResourcesEnv() throws JobProblemException {
        if (this.internalStep == null) {
            return null;
        }
        return ((java.util.Map)JobHelper.getFromEither(this.internalStep.env())).entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((Optional)e.getValue()).get()));
    }

    private List<HistoricOutcome> getEngineHistoricOutcomes() {
        if (this.internalStep == null) {
            return null;
        }
        return JavaConverters.asJava((Seq)this.internalStep.order().asScala().historicOutcomes());
    }

    private java.util.Map<String, java.util.Map<String, DetailValue>> historicOutcomes2map() {
        List<HistoricOutcome> l = this.getEngineHistoricOutcomes();
        if (l == null || l.size() == 0) {
            return Collections.emptyMap();
        }
        TreeMap<String, java.util.Map<String, DetailValue>> resultMap = new TreeMap<String, java.util.Map<String, DetailValue>>();
        for (HistoricOutcome ho : l) {
            OrderOutcome.Completed c;
            OrderOutcome outcome = ho.outcome();
            if (!(outcome instanceof OrderOutcome.Completed) || (c = (OrderOutcome.Completed)outcome).namedValues() == null) continue;
            String key = outcome.getClass().getSimpleName();
            java.util.Map map = new TreeMap();
            map = resultMap.containsKey(key) ? (java.util.Map)resultMap.get(key) : new HashMap();
            java.util.Map<String, Object> m = JobHelper.asJavaValues(JavaConverters.asJava((Map)c.namedValues()));
            if (m != null) {
                for (Map.Entry<String, Object> entry : m.entrySet()) {
                    map.remove(entry.getKey());
                    map.put(entry.getKey(), new DetailValue(ho.position().toString(), entry.getValue()));
                }
            }
            resultMap.put(key, map);
        }
        return resultMap;
    }

    private java.util.Map<String, DetailValue> jobResources2map() {
        TreeMap<String, DetailValue> resultMap = new TreeMap<String, DetailValue>();
        if (this.internalStep == null) {
            return resultMap;
        }
        java.util.Map jobResources = this.internalStep.jobResourceToNameToCheckedValue();
        if (jobResources == null || jobResources.size() == 0) {
            return resultMap;
        }
        jobResources.entrySet().stream().forEach(e -> {
            String resourceName = ((JobResourcePath)e.getKey()).string();
            ((java.util.Map)e.getValue()).entrySet().stream().forEach(ee -> {
                if (!resultMap.containsKey(ee.getKey()) && ((Either)ee.getValue()).isRight()) {
                    resultMap.put((String)ee.getKey(), new DetailValue(resourceName, JobHelper.asJavaValue((Value)((Either)ee.getValue()).get())));
                }
            });
        });
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndLogParameterization(List<JobArgumentException> exceptions, String mockMessage) throws Exception {
        Object ae = null;
        try {
            if (exceptions != null && exceptions.size() > 0) {
                List l = exceptions.stream().filter(e -> e instanceof ISOSRequiredArgumentMissingException).map(e -> ((ISOSRequiredArgumentMissingException)e).getArgumentName()).collect(Collectors.toList());
                ae = l.size() > 0 ? new JobRequiredArgumentMissingException(String.join((CharSequence)", ", l)) : (Exception)((Object)exceptions.get(0));
            }
            JobArguments.LogLevel ll = JobArguments.LogLevel.DEBUG;
            boolean logDetails = this.logger.isDebugEnabled();
            if (ae != null) {
                ll = JobArguments.LogLevel.INFO;
                logDetails = true;
            }
            String header = "Job Parameterization";
            this.logAllDirtyArguments((String)(mockMessage == null ? header : mockMessage + " " + header), logDetails);
            if (logDetails) {
                this.logJobKey();
                this.logArgumentsBySource(ll);
                this.logAllArguments(ll);
            }
        }
        catch (Throwable e2) {
            this.logger.error2allLoggers(this.getStepInfo(), e2.toString(), e2);
        }
        finally {
            if (ae != null) {
                throw ae;
            }
        }
    }

    private void logJobKey() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("JobKEY=" + this.jobEnvironment.getJobKey());
        }
    }

    private void logArgumentsBySource(JobArguments.LogLevel logLevel) throws Exception {
        List<JobArgument<?>> orderOrNode;
        List<JobArgument<?>> orderPreparation;
        this.logOutcomes(logLevel);
        java.util.Map<String, Object> map = null;
        if (this.internalStep != null && (map = JobHelper.asJavaValues(this.internalStep.order().arguments())) != null && map.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.ORDER.getHeader()));
            map.entrySet().stream().forEach(e -> this.logger.log(logLevel, "    %s=%s", e.getKey(), this.getDisplayValue((String)e.getKey(), e.getValue())));
        }
        if ((orderPreparation = this.getOrderPreparationArguments()) != null && orderPreparation.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.ORDER_PREPARATION.getHeader()));
            orderPreparation.stream().forEach(a -> this.logger.log(logLevel, "    " + a.toString()));
        }
        if ((orderOrNode = this.getDeclaredOrderOrNodeArguments()) != null && orderOrNode.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.ORDER_OR_NODE.getHeader()));
            orderOrNode.stream().forEach(a -> this.logger.log(logLevel, "    " + a.toString()));
        }
        if (this.internalStep != null && (map = JobHelper.asJavaValues(this.internalStep.arguments())) != null && map.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.JOB.getHeader()));
            map.entrySet().stream().forEach(e -> this.logger.log(logLevel, "    %s=%s", e.getKey(), this.getDisplayValue((String)e.getKey(), e.getValue())));
        }
        this.logJobEnvironmentArguments(logLevel);
        java.util.Map<String, DetailValue> resources = this.getJobResourcesArgumentsAsNameDetailValueMap();
        if (resources != null && resources.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.JOB_RESOURCE.getHeader()));
            resources.entrySet().stream().forEach(e -> {
                DetailValue v = (DetailValue)e.getValue();
                this.logger.log(logLevel, "    %s=%s (resource=%s)", e.getKey(), this.getDisplayValue((String)e.getKey(), v.getValue()), v.getSource());
            });
        }
    }

    private List<JobArgument<?>> getOrderPreparationArguments() {
        if (this.allArguments == null) {
            return null;
        }
        return this.allArguments.entrySet().stream().filter(e -> ((JobArgument)((Object)((Object)e.getValue()))).getValueSource().isTypeOrderPreparation()).map(e -> (JobArgument)((Object)((Object)e.getValue()))).collect(Collectors.toList());
    }

    private List<JobArgument<?>> getDeclaredOrderOrNodeArguments() {
        if (this.allDeclaredArguments == null) {
            return null;
        }
        return this.allDeclaredArguments.stream().filter(a -> a.getValueSource().isTypeOrderOrNode()).collect(Collectors.toList());
    }

    private void logJobEnvironmentArguments(JobArguments.LogLevel logLevel) {
        java.util.Map<String, Object> map;
        if (this.jobEnvironment != null && (map = this.jobEnvironment.getAllArgumentsAsNameValueMap()) != null && map.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.JOB_ARGUMENT.getHeader()));
            map.entrySet().stream().forEach(e -> this.logger.log(logLevel, "    %s=%s", e.getKey(), this.getDisplayValue((String)e.getKey(), e.getValue())));
        }
    }

    private void logOutcomes(JobArguments.LogLevel logLevel) {
        java.util.Map<String, DetailValue> map = this.getLastSucceededOutcomes();
        if (map != null && map.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.LAST_SUCCEEDED_OUTCOME.getHeader()));
            map.entrySet().stream().forEach(e -> this.logger.log(logLevel, "    %s=%s (pos=%s)", e.getKey(), this.getDisplayValue((String)e.getKey()), ((DetailValue)e.getValue()).getSource()));
        }
        if ((map = this.getLastFailedOutcomes()) != null && map.size() > 0) {
            this.logger.log(logLevel, String.format(" %s:", ValueSource.ValueSourceType.LAST_FAILED_OUTCOME.getHeader()));
            map.entrySet().stream().forEach(e -> this.logger.log(logLevel, "    %s=%s (pos=%s)", e.getKey(), this.getDisplayValue((String)e.getKey()), ((DetailValue)e.getValue()).getSource()));
        }
    }

    private void logAllDirtyArguments(String header, boolean logDetails) throws Exception {
        if (this.allArguments == null || this.allArguments.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (logDetails) {
            this.logger.info(header + ":");
        } else {
            sb.append(header).append(", ");
        }
        sb.append(ValueSource.ValueSourceType.JAVA.getHeader()).append(":");
        String prefix = "";
        for (Map.Entry<String, JobArgument<?>> e : this.allArguments.entrySet()) {
            Object detail;
            JobArgument<?> a = e.getValue();
            if (!a.isDirty() && a.getNotAcceptedValue() == null) continue;
            Object object = detail = a.getValueSource().getSource() == null ? "" : " " + a.getValueSource().getSource();
            if (a.getPayload() != null) {
                String pd = SOSArgumentHelper.getClassName((String)a.getPayload().toString());
                detail = ((String)detail).equals("") ? " " + pd : (String)detail + " " + pd;
            }
            sb.append(prefix).append(" ");
            if (a.getNotAcceptedValue() == null) {
                String vsn = a.getValueSource().getType() == null ? "" : a.getValueSource().getType().name();
                sb.append(a.getName()).append("=").append(a.getDisplayValue());
                sb.append("(").append(vsn).append((String)detail).append(")");
            } else {
                String exception = "";
                if (a.getNotAcceptedValue().getException() != null) {
                    exception = "(" + a.getNotAcceptedValue().getException().toString() + ")";
                }
                String nvsn = a.getNotAcceptedValue().getSource() == null || a.getNotAcceptedValue().getSource().getType() == null ? "" : a.getNotAcceptedValue().getSource().getType().name() + " ";
                sb.append(a.getName()).append("=").append(a.getDisplayValue());
                sb.append("(");
                sb.append(nvsn).append("value=").append(a.getNotAcceptedValue().getDisplayValue());
                sb.append(" ignored").append(exception);
                sb.append((String)detail);
                sb.append(")");
            }
            prefix = ",";
        }
        this.logger.info(sb);
    }

    private void logAllArguments(JobArguments.LogLevel logLevel) throws Exception {
        if (this.allArguments == null || this.allArguments.size() == 0) {
            return;
        }
        this.logger.log(logLevel, String.format(" All %s:", ValueSource.ValueSourceType.JAVA.getHeader()));
        this.allArguments.entrySet().stream().forEach(a -> this.logger.log(logLevel, "    " + ((JobArgument)((Object)((Object)a.getValue()))).toString()));
    }

    protected ExecuteJobBean getExecuteJobBean() {
        return this.executeJobBean;
    }

    protected boolean hasExecuteJobArguments() {
        return this.executeJobBean != null && this.executeJobBean.arguments != null && this.executeJobBean.arguments.size() > 0;
    }

    protected List<String> getResolverPrefixes() {
        if (this.resolverPrefixes == null) {
            this.resolverPrefixes = new ArrayList<String>();
        }
        return this.resolverPrefixes;
    }

    public OrderProcessStepOutcome getOutcome() {
        return this.outcome;
    }

    protected class ExecuteJobBean {
        private final Job<?> job;
        private final java.util.Map<String, JobArgument<?>> arguments;
        private final boolean updateDeclaredArgumentsDefinition;

        private ExecuteJobBean(Job<?> job, java.util.Map<String, JobArgument<?>> arguments, boolean updateDeclaredArgumentsDefinition) {
            this.job = job;
            this.arguments = arguments;
            this.updateDeclaredArgumentsDefinition = updateDeclaredArgumentsDefinition;
        }

        protected Job<?> getJob() {
            return this.job;
        }

        protected java.util.Map<String, JobArgument<?>> getArguments() {
            return this.arguments;
        }

        protected boolean updateDeclaredArgumentsDefinition() {
            return this.updateDeclaredArgumentsDefinition;
        }
    }
}

