/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz.jobchain.datasource.jobscheduler;

import com.sos.graphviz.jobchain.interfaces.IDataSourceFileOrderSources;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.JobChain;
import java.util.ArrayList;

public class DataSourceFileOrderSources
implements IDataSourceFileOrderSources {
    private ArrayList<JobChain.FileOrderSource> listOfFileSources;
    private JSObjJobChain jobChain;
    private int index;

    public DataSourceFileOrderSources(SchedulerObjectFactory schedulerObjectFactory, String xml) {
        this.jobChain = schedulerObjectFactory.createJobChain();
        this.jobChain.loadObject(xml);
        this.listOfFileSources = new ArrayList();
    }

    public DataSourceFileOrderSources(SchedulerObjectFactory schedulerObjectFactory, JSObjJobChain jobChain) {
        this.jobChain = jobChain;
        this.listOfFileSources = new ArrayList();
    }

    @Override
    public void getList() {
        this.index = -1;
        for (Object fileOrderSourceItem : this.jobChain.getFileOrderSourceList()) {
            if (!(fileOrderSourceItem instanceof JobChain.FileOrderSource)) continue;
            JobChain.FileOrderSource fileOrderSource = (JobChain.FileOrderSource)fileOrderSourceItem;
            this.listOfFileSources.add(fileOrderSource);
        }
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.listOfFileSources.size();
    }

    @Override
    public JobChain.FileOrderSource next() {
        ++this.index;
        return this.listOfFileSources.get(this.index);
    }

    @Override
    public void reset() {
        this.index = -1;
    }

    public JSObjJobChain getJobChain() {
        return this.jobChain;
    }
}

