/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz.jobchain.datasource.jobscheduler;

import com.sos.graphviz.jobchain.interfaces.IDataSourceJobChainNodes;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.JobChain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataSourceJobChainNodes
implements IDataSourceJobChainNodes {
    private String firstNode;
    private Map<String, JobChain.JobChainNode> listOfJobChainNodes;
    private Iterator<Map.Entry<String, JobChain.JobChainNode>> entries;
    private JSObjJobChain jobChain;

    public DataSourceJobChainNodes(SchedulerObjectFactory schedulerObjectFactory, String xml) {
        this.jobChain = schedulerObjectFactory.createJobChain();
        this.jobChain.loadObject(xml);
        this.listOfJobChainNodes = new HashMap<String, JobChain.JobChainNode>();
        this.firstNode = null;
    }

    public DataSourceJobChainNodes(SchedulerObjectFactory schedulerObjectFactory, JSObjJobChain jobChain) {
        this.jobChain = jobChain;
        this.listOfJobChainNodes = new HashMap<String, JobChain.JobChainNode>();
    }

    @Override
    public void getList() {
        for (Object jobChainNodeItem : this.jobChain.getJobChainNodeOrFileOrderSinkOrJobChainNodeEnd()) {
            if (!(jobChainNodeItem instanceof JobChain.JobChainNode)) continue;
            JobChain.JobChainNode jobChainNode = (JobChain.JobChainNode)jobChainNodeItem;
            if (this.firstNode == null) {
                this.firstNode = jobChainNode.getState();
            }
            if (this.listOfJobChainNodes.get(jobChainNode.getState()) != null) continue;
            this.listOfJobChainNodes.put(jobChainNode.getState(), jobChainNode);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.entries == null) {
            this.entries = this.listOfJobChainNodes.entrySet().iterator();
        }
        return this.entries.hasNext();
    }

    @Override
    public JobChain.JobChainNode next() {
        return this.entries.next().getValue();
    }

    @Override
    public String getFirstNode() {
        return this.firstNode;
    }

    @Override
    public void reset() {
        this.entries = null;
    }

    @Override
    public JobChain.JobChainNode get(String key) {
        return this.listOfJobChainNodes.get(key);
    }

    @Override
    public int size() {
        return this.listOfJobChainNodes.size();
    }

    public JSObjJobChain getJobChain() {
        return this.jobChain;
    }

    @Override
    public void setFirstNode(String firstNode) {
        this.firstNode = firstNode;
    }
}

