/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz.main;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.graphviz.enums.FileType;
import com.sos.graphviz.jobchain.diagram.JobChainDiagramCreator;
import com.sos.graphviz.main.JSObjects2GraphvizOptions;
import com.sos.scheduler.model.SchedulerHotFolder;
import com.sos.scheduler.model.SchedulerHotFolderFileList;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.messages.JSMessages;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.Spooler;
import com.sos.vfs.common.SOSVFSFactory;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjects2Graphviz
extends JSJobUtilitiesClass<JSObjects2GraphvizOptions> {
    private static final String CLASSNAME = "JSObjects2Graphviz";
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjects2Graphviz.class);
    private ISOSProvider fileSystemHandler = null;
    private SchedulerObjectFactory schedulerObjectFactory = null;
    private SchedulerHotFolderFileList schedulerHotFolderFileList = null;
    private String outputFolderName = "";

    public JSObjects2Graphviz() {
        super((Object)new JSObjects2GraphvizOptions());
    }

    public JSObjects2Graphviz initialize() throws Exception {
        ((JSObjects2GraphvizOptions)((Object)this.getOptions())).checkMandatory();
        LOGGER.debug(((JSObjects2GraphvizOptions)((Object)this.getOptions())).dirtyString());
        String liveFolderName = ((JSObjects2GraphvizOptions)((Object)this.objOptions)).liveFolderName.getValue();
        SOSBaseOptions vfsOptions = new SOSBaseOptions();
        this.fileSystemHandler = SOSVFSFactory.getProvider((String)"local", (SOSOptionString)vfsOptions.ssh_provider, (SOSOptionString)vfsOptions.webdav_provider, (SOSOptionString)vfsOptions.smb_provider);
        this.schedulerObjectFactory = new SchedulerObjectFactory();
        this.schedulerObjectFactory.initMarshaller(Spooler.class);
        ISOSProviderFile hotFolder = this.fileSystemHandler.getFile(liveFolderName);
        SchedulerHotFolder schedulerHotFolder = this.schedulerObjectFactory.createSchedulerHotFolder(hotFolder);
        LOGGER.info(String.format("... load %1$s", liveFolderName));
        this.schedulerHotFolderFileList = schedulerHotFolder.loadRecursive();
        this.outputFolderName = ((JSObjects2GraphvizOptions)((Object)this.objOptions)).outputFolderName.getValue();
        return this;
    }

    public JSObjects2Graphviz execute() throws Exception {
        String methodName = "JSObjects2Graphviz::execute";
        JSMessages.JOM_I_110.toLog(new Object[]{"JSObjects2Graphviz::execute"});
        try {
            this.initialize();
            LOGGER.debug(String.format("%s job chains found", this.schedulerHotFolderFileList.getSortedFileList().size()));
            for (JSObjBase obj : this.schedulerHotFolderFileList.getSortedFileList()) {
                if (!(obj instanceof JSObjJobChain)) continue;
                JSObjJobChain jsObjJobChain = (JSObjJobChain)obj;
                JobChainDiagramCreator jobChainDiagramCreator = new JobChainDiagramCreator(jsObjJobChain, new File(((JSObjects2GraphvizOptions)((Object)this.objOptions)).liveFolderName.getValue()));
                jobChainDiagramCreator.setGraphVizImageType(FileType.pdf);
                jobChainDiagramCreator.setDotOutputPath(this.outputFolderName);
                LOGGER.info(String.format("... call generator %1$s", this.outputFolderName));
                jobChainDiagramCreator.createGraphVizFile(true);
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JOM_F_107.get(new Object[]{"JSObjects2Graphviz::execute"}) + ":" + e.getMessage(), (Throwable)e);
        }
        JSMessages.JOM_I_111.toLog(new Object[]{"JSObjects2Graphviz::execute"});
        return this;
    }
}

