/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.cron;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sos.scheduler.cron.CronConverter;
import sos.scheduler.misc.SchedulerJavaObject;
import sos.spooler.Job;
import sos.spooler.Job_impl;
import sos.spooler.Variable_set;
import sos.util.SOSFile;
import sos.util.SOSFileOperations;
import sos.xml.SOSXMLXPath;

public class JobSchedulerCronAdapter
extends Job_impl {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerCronAdapter.class);
    private static final String XPATH_SPOOLER_ANSWER_ERROR = "//spooler/answer/ERROR";
    private File schedulerCronConfigurationDir = new File("config/live/cron");
    private String crontab = "";
    private CronConverter converter;
    private boolean useDynamicConfiguration = false;
    private String monitoredLiveDir = null;
    private String[] monitoredLiveDirs = null;
    private final Vector<File> liveDirCrontabs = new Vector();
    private Iterator<File> liveDirCrontabsIterator = null;
    public static final String conAttributeJobNAME = "name";
    public static final String conJobSchedulerJobFileNameExtension = ".job.xml";

    public boolean spooler_init() throws Exception {
        File liveFolder = new File(this.spooler.configuration_directory());
        this.schedulerCronConfigurationDir = new File(liveFolder, "cron");
        this.monitoredLiveDir = this.spooler.variables().value("cron_adapter_dynamic_configuration_dir");
        if (this.monitoredLiveDir != null && !this.monitoredLiveDir.isEmpty()) {
            this.spooler_log.info("parameter cron_adapter_dynamic_configuration_dir: " + this.monitoredLiveDir);
            this.monitoredLiveDirs = this.monitoredLiveDir.split(";");
        } else {
            this.monitoredLiveDir = null;
        }
        if (this.spooler_task == null) {
            this.spooler.variables().set_var("cron_adapter_use_dynamic_configuration", "1");
            if (this.monitoredLiveDir == null) {
                this.spooler_log.info("Using dynamic configuration files. Deleting files in " + this.schedulerCronConfigurationDir.getAbsolutePath());
                SOSFileOperations.removeFile((File)this.schedulerCronConfigurationDir);
            } else {
                for (String currentDir : this.monitoredLiveDirs) {
                    File fDir = new File(currentDir);
                    if (!fDir.exists()) {
                        this.spooler_log.info(fDir.getAbsolutePath() + " doesn't exist.");
                        continue;
                    }
                    this.spooler_log.debug5("Looking for " + this.crontab + " files in " + currentDir);
                    Vector crontabsInCurrentDir = SOSFile.getFilelist((String)currentDir, (String)("^" + this.crontab + "$"), (int)0, (boolean)true);
                    for (File crontabFile : crontabsInCurrentDir) {
                        this.spooler_log.info("Deleting configuration files in " + crontabFile.getParent());
                        SOSFileOperations.removeFile((File)crontabFile.getParentFile(), (String)".*\\.xml$", (int)2);
                    }
                }
            }
            return true;
        }
        boolean systemCrontab = false;
        boolean oldRunTime = false;
        String systemUser = System.getProperty("user.name");
        String sChangeUser = "";
        String timeout = "";
        try {
            String sSystemCrontab;
            String sOldRunTime;
            Variable_set params = this.spooler_task.params();
            this.crontab = params.value("crontab");
            if (this.monitoredLiveDir != null && this.crontab.length() == 0) {
                this.crontab = "crontab";
            }
            if (this.crontab.isEmpty()) {
                throw new Exception("missing parameter crontab");
            }
            this.spooler_log.info("parameter crontab: " + this.crontab);
            String dc = this.spooler.variables().var("cron_adapter_use_dynamic_configuration");
            if (dc != null && "1".equals(dc)) {
                this.useDynamicConfiguration = true;
                if (this.monitoredLiveDir == null) {
                    LOGGER.info("Using dynamic configuration files in directory " + this.schedulerCronConfigurationDir.getAbsolutePath());
                }
            }
            if ("/etc/crontab".equalsIgnoreCase(this.crontab)) {
                systemCrontab = true;
            }
            if ("1".equalsIgnoreCase(sOldRunTime = params.value("old_run_time")) || "true".equalsIgnoreCase(sOldRunTime) || "yes".equalsIgnoreCase(sOldRunTime)) {
                oldRunTime = true;
                this.spooler_log.info("parameter old_run_time: true");
            }
            if ((sSystemCrontab = params.value("systab")) != null && !sSystemCrontab.isEmpty()) {
                systemCrontab = "1".equalsIgnoreCase(sSystemCrontab) || "true".equalsIgnoreCase(sSystemCrontab) || "yes".equalsIgnoreCase(sSystemCrontab);
                this.spooler_log.info("parameter systab: " + sSystemCrontab);
            }
            if ((sChangeUser = params.value("changeuser")) != null && !sChangeUser.isEmpty()) {
                this.spooler_log.info("parameter changeuser: " + sChangeUser);
            } else {
                sChangeUser = "";
            }
            if (systemCrontab && "su".equalsIgnoreCase(sChangeUser) && !"root".equalsIgnoreCase(systemUser)) {
                this.spooler_log.warn("You are running the Job Scheduler as " + systemUser + " and you are trying to use a system crontab with 'su'. This will not work. Either run the Job Scheduler as root, or use 'sudo' as change_user_command parameter");
            }
            if ((timeout = params.value("timeout")) != null && !timeout.isEmpty()) {
                this.spooler_log.info("parameter timeout: " + timeout);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reading job parameters: " + e.getMessage(), (Throwable)e);
            return false;
        }
        try {
            this.converter = new CronConverter();
            this.converter.setOldRunTime(oldRunTime);
            this.converter.setSystemCronTab(systemCrontab);
            this.converter.setChangeUserCommand(sChangeUser);
            if (timeout != null && !timeout.isEmpty()) {
                this.converter.setTimeout(timeout);
            }
            if (this.monitoredLiveDir != null) {
                for (String currentDir : this.monitoredLiveDirs) {
                    File fDir = new File(currentDir);
                    if (!fDir.exists()) {
                        this.spooler_log.info(fDir.getAbsolutePath() + " doesn't exist.");
                        continue;
                    }
                    this.spooler_log.debug5("Looking for crontab files in " + currentDir);
                    Vector crontabsInCurrentDir = SOSFile.getFilelist((String)currentDir, (String)"^crontab$", (int)0, (boolean)true);
                    for (File crontabFile : crontabsInCurrentDir) {
                        this.spooler_log.debug7(" found: " + crontabFile.getAbsolutePath());
                        this.liveDirCrontabs.add(crontabFile);
                    }
                }
                this.liveDirCrontabsIterator = this.liveDirCrontabs.iterator();
                if (!this.liveDirCrontabsIterator.hasNext()) {
                    this.spooler_log.info("No crontabs found.");
                    return false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error initializing cron converter: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean spooler_process() throws Exception {
        try {
            HashMap<String, String> previousCommentsMapping;
            HashMap<String, Element> previousMapping;
            File crontabFile = new File(this.crontab);
            if (this.liveDirCrontabsIterator != null) {
                crontabFile = this.liveDirCrontabsIterator.next();
                this.schedulerCronConfigurationDir = crontabFile.getParentFile();
            }
            this.spooler_job.start_when_directory_changed(crontabFile.getParentFile(), "^" + crontabFile.getName() + "$");
            if (!crontabFile.canRead()) {
                LOGGER.info("Failed to read crontab " + crontabFile.getAbsolutePath());
            }
            if ((previousMapping = (HashMap<String, Element>)SchedulerJavaObject.getObject(this.spooler.variables(), this.spooler_job.name() + "_" + crontabFile.getAbsolutePath() + "_cron2job_mapping")) == null) {
                previousMapping = new HashMap<String, Element>();
            }
            if ((previousCommentsMapping = (HashMap<String, String>)SchedulerJavaObject.getObject(this.spooler.variables(), this.spooler_job.name() + "_" + crontabFile.getAbsolutePath() + "_cron2comments_mapping")) == null) {
                previousCommentsMapping = new HashMap<String, String>();
            }
            this.debugHashMap(previousCommentsMapping, "previousCommentsMapping");
            HashMap<String, String> currentCommentsMapping = new HashMap<String, String>();
            HashMap<String, Element> changedJobs = new HashMap<String, Element>();
            HashSet previousEnvVariables = (HashSet)SchedulerJavaObject.getObject(this.spooler.variables(), this.spooler_job.name() + "_" + crontabFile.getAbsolutePath() + "_env_variables");
            HashSet<String> currentEnvVariables = new HashSet<String>();
            boolean environmentChanged = false;
            if (previousEnvVariables == null) {
                previousEnvVariables = new HashSet();
            }
            this.spooler_log.debug1("Comparing new jobs with jobs of previous run.");
            changedJobs.putAll(previousMapping);
            this.converter.getReservedJobNames().clear();
            this.converter.getSkipLines().clear();
            Set previousCronLines = previousMapping.keySet();
            BufferedReader in = new BufferedReader(new StringReader(""));
            if (crontabFile.canRead()) {
                in = new BufferedReader(new FileReader(crontabFile));
            }
            String currentLine = "";
            String currentCommentJobName = "";
            String currentCommentJobTitle = "";
            String currentCommentJobTimeout = "";
            while ((currentLine = in.readLine()) != null) {
                Matcher cronMatcher;
                Matcher envMatcher = this.converter.cronRegExEnvironmentPattern.matcher(currentLine);
                if (envMatcher.matches()) {
                    currentEnvVariables.add(currentLine);
                    if (previousEnvVariables.contains(currentLine)) continue;
                    environmentChanged = true;
                    continue;
                }
                Matcher commentMatcher = this.converter.cronRegExCommentPattern.matcher(currentLine);
                if (commentMatcher.matches()) {
                    Matcher jobNameMatcher = this.converter.cronRegExJobNamePattern.matcher(commentMatcher.group(1));
                    Matcher jobTitleMatcher = this.converter.cronRegExJobTitlePattern.matcher(commentMatcher.group(1));
                    Matcher jobTimeoutMatcher = this.converter.cronRegExJobTimeoutPattern.matcher(commentMatcher.group(1));
                    if (jobNameMatcher.matches()) {
                        currentCommentJobName = jobNameMatcher.group(1);
                    }
                    if (jobTitleMatcher.matches()) {
                        currentCommentJobTitle = jobTitleMatcher.group(1);
                    }
                    if (!jobTimeoutMatcher.matches()) continue;
                    currentCommentJobTimeout = jobTimeoutMatcher.group(1);
                    continue;
                }
                if (previousCronLines.contains(currentLine)) {
                    String commentForThisJob;
                    Element jobElement = (Element)previousMapping.get(currentLine);
                    String jobName = jobElement.getAttribute(conAttributeJobNAME);
                    String previousCommentForThisJob = previousCommentsMapping.get(currentLine).toString();
                    if (!previousCommentForThisJob.equals(commentForThisJob = currentCommentJobName + "-" + currentCommentJobTitle + "-" + currentCommentJobTimeout)) {
                        this.spooler_log.debug6("Job-Manipulating comments for current line have changed.");
                    } else {
                        this.spooler_log.debug6("current line was already submitted in last run: " + currentLine);
                        this.converter.getSkipLines().add(currentLine);
                        this.converter.getReservedJobNames().add(jobName);
                        changedJobs.remove(currentLine);
                    }
                }
                if (!(cronMatcher = this.converter.currentCronPattern.matcher(currentLine)).matches()) continue;
                currentCommentsMapping.put(currentLine, currentCommentJobName + "-" + currentCommentJobTitle + "-" + currentCommentJobTimeout);
                currentCommentJobName = "";
                currentCommentJobTitle = "";
                currentCommentJobTimeout = "";
            }
            if (environmentChanged) {
                if (!previousMapping.isEmpty()) {
                    this.spooler_log.info("Environment has changed, all jobs need to be submitted again.");
                }
                this.converter.getSkipLines().clear();
                this.converter.getReservedJobNames().clear();
            }
            HashSet<String> changedJobNames = new HashSet<String>();
            Collection changedJobElements = changedJobs.values();
            for (Element changedJob : changedJobElements) {
                changedJobNames.add(changedJob.getAttribute(conAttributeJobNAME));
            }
            HashMap<String, Element> updatedMapping = new HashMap<String, Element>();
            if (crontabFile.canRead()) {
                this.converter.cronFile2SchedulerXML(crontabFile, updatedMapping);
            }
            this.spooler_log.debug1("updating changed jobs");
            for (Element updatedJob : updatedMapping.values()) {
                String updatedJobName = updatedJob.getAttribute(conAttributeJobNAME);
                changedJobNames.remove(updatedJobName);
                this.updateJob(updatedJob);
            }
            if (!changedJobNames.isEmpty()) {
                this.spooler_log.debug1("removing renamed/deleted jobs");
                Iterator removedJobsIter = changedJobNames.iterator();
                while (removedJobsIter.hasNext()) {
                    String jobName = ((String)removedJobsIter.next()).toString();
                    this.removeJob(jobName);
                }
            }
            Iterator changedJobsIter = changedJobs.keySet().iterator();
            while (changedJobsIter.hasNext()) {
                previousMapping.remove(changedJobsIter.next());
            }
            previousMapping.putAll(updatedMapping);
            this.spooler_log.debug3("Storing mapping to Scheduler variable");
            SchedulerJavaObject.putObject(previousMapping, this.spooler.variables(), this.spooler_job.name() + "_" + crontabFile.getAbsolutePath() + "_cron2job_mapping");
            this.spooler_log.debug3("Storing comments mapping to Scheduler variable");
            this.debugHashMap(currentCommentsMapping, "currentCommentsMapping");
            SchedulerJavaObject.putObject(currentCommentsMapping, this.spooler.variables(), this.spooler_job.name() + "_" + crontabFile.getAbsolutePath() + "_cron2comments_mapping");
            this.spooler_log.debug3("Storing environment variables to Scheduler variable");
            SchedulerJavaObject.putObject(currentEnvVariables, this.spooler.variables(), this.spooler_job.name() + "_" + crontabFile.getAbsolutePath() + "_env_variables");
        }
        catch (Exception e) {
            LOGGER.error("Error updating Job Scheduler configuration from crontab: " + e.getMessage(), (Throwable)e);
        }
        if (this.liveDirCrontabsIterator != null) {
            return this.liveDirCrontabsIterator.hasNext();
        }
        return false;
    }

    private void debugHashMap(HashMap<String, String> map, String name) throws Exception {
        this.spooler_log.debug9(name + ":");
        Set<String> keys = map.keySet();
        if (keys != null) {
            Iterator<String> iter = keys.iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                String value = map.get(key).toString();
                this.spooler_log.debug9("[" + key + "]: " + value);
            }
        }
    }

    private void removeJob(String jobName) {
        try {
            if (this.useDynamicConfiguration) {
                this.removeJobFile(jobName);
            } else {
                this.removeJobXMLCommand(jobName);
            }
            this.spooler_log.info(String.format("job '%1$s' removed from JS.", new Object[0]));
        }
        catch (Exception e) {
            this.spooler_log.warn("Failed to remove job \"" + jobName + "\": " + e);
        }
    }

    private void removeJobXMLCommand(String jobName) throws Exception {
        Job currentJob = this.spooler.job(jobName);
        if (currentJob == null) {
            throw new Exception("Could not find job: " + jobName);
        }
        currentJob.remove();
    }

    private void removeJobFile(String jobName) throws Exception {
        String fileName = JobSchedulerCronAdapter.normalizeJobName(jobName);
        File jobFile = new File(this.schedulerCronConfigurationDir, fileName + conJobSchedulerJobFileNameExtension);
        if (!jobFile.delete()) {
            throw new Exception("Failed to delete file " + jobFile.getAbsolutePath());
        }
    }

    private void updateJob(Element updatedJob) throws Exception {
        Document jobDocument;
        try {
            jobDocument = this.converter.getDocBuilder().newDocument();
            jobDocument.appendChild(jobDocument.importNode(updatedJob, true));
        }
        catch (Exception e) {
            throw new Exception("Error creating DOM Document for job: " + e.getMessage(), e);
        }
        if (this.useDynamicConfiguration) {
            this.updateJobFile(jobDocument);
        } else {
            this.updateJobXMLCommand(jobDocument);
        }
        Element objJob = jobDocument.getDocumentElement();
        String jobName = objJob.getAttribute(conAttributeJobNAME);
        this.spooler_log.info(String.format("job '%1$s' updated in JS.", jobName));
    }

    private void updateJobXMLCommand(Document updatedJobDoc) throws Exception {
        String jobName = "";
        try {
            Element updatedJob = updatedJobDoc.getDocumentElement();
            jobName = updatedJob.getAttribute(conAttributeJobNAME);
            StringWriter out = new StringWriter();
            OutputFormat format = new OutputFormat(updatedJobDoc);
            format.setEncoding("UTF-8");
            format.setIndenting(true);
            format.setIndent(2);
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.setNamespaces(true);
            serializer.serialize(updatedJobDoc);
            this.spooler_log.info("submitting job...  " + jobName);
            this.spooler_log.debug9(out.toString());
            String answer = this.spooler.execute_xml(out.toString());
            this.spooler_log.debug3("answer from JobScheduler: " + answer);
            SOSXMLXPath xpath = new SOSXMLXPath(new StringBuffer(answer));
            String errorMsg = "";
            if (xpath.selectSingleNodeValue(XPATH_SPOOLER_ANSWER_ERROR) != null) {
                String errorCode = xpath.selectSingleNodeValue("//spooler/answer/ERROR/@code");
                String errorText = xpath.selectSingleNodeValue("//spooler/answer/ERROR/@text");
                errorMsg = errorCode + ":" + errorText;
            }
            if (!"".equals(errorMsg)) {
                throw new Exception("JobScheduler answer ERROR:" + errorMsg + "\n" + answer);
            }
        }
        catch (Exception e) {
            throw new Exception("Error occured updating job \"" + jobName + "\": " + e.getMessage(), e);
        }
    }

    private void updateJobFile(Document updatedJobDoc) throws Exception {
        String jobName = "";
        File jobFile = null;
        try {
            Element updatedJob = updatedJobDoc.getDocumentElement();
            jobName = updatedJob.getAttribute(conAttributeJobNAME);
            String fileName = JobSchedulerCronAdapter.normalizeJobName(jobName);
            updatedJob.removeAttribute(conAttributeJobNAME);
            jobFile = new File(this.schedulerCronConfigurationDir, fileName + conJobSchedulerJobFileNameExtension);
            FileOutputStream fout = new FileOutputStream(jobFile, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            OutputFormat format = new OutputFormat(updatedJobDoc);
            format.setEncoding("UTF-8");
            format.setIndenting(true);
            format.setIndent(2);
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            this.spooler_log.debug3("Writing file " + jobFile.getAbsolutePath());
            serializer.serialize(updatedJobDoc);
            out.close();
        }
        catch (Exception e) {
            if (jobFile != null) {
                throw new Exception("Error occured updating job file \"" + jobFile.getAbsolutePath() + "\": " + e.getMessage(), e);
            }
            throw new Exception("Error occured updating file for job \"" + jobName + "\": " + e.getMessage(), e);
        }
    }

    private static String normalizeJobName(String jobName) {
        String fileName = jobName.replaceAll("\\W", "_");
        return fileName;
    }
}

