/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.messages.JSMessages;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import sos.connection.SOSConnection;
import sos.settings.SOSConnectionSettings;
import sos.settings.SOSProfileSettings;
import sos.settings.SOSSettings;
import sos.spooler.Job;
import sos.spooler.Job_impl;
import sos.spooler.Spooler;
import sos.spooler.Task;
import sos.spooler.Variable_set;
import sos.util.SOSArguments;
import sos.util.SOSString;

public class JobSchedulerJob
extends Job_impl {
    private static Logger LOGGER = LogManager.getLogger(JobSchedulerJob.class);
    public static final String HIBERNATE_DEFAULT_FILE_NAME_SCHEDULER = "hibernate.cfg.xml";
    public static final String HIBERNATE_DEFAULT_FILE_NAME_REPORTING = "reporting.hibernate.cfg.xml";
    public static final String SCHEDULER_PARAM_PROXY_URL = "sos.proxy_url";
    public static final String SCHEDULER_PARAM_HIBERNATE_SCHEDULER = "sos.hibernate_configuration_scheduler";
    public static final String SCHEDULER_PARAM_HIBERNATE_REPORTING = "sos.hibernate_configuration_reporting";
    public static final String SCHEDULER_PARAM_USE_NOTIFICATION = "sos.use_notification";
    private SOSConnection sosConnection = null;
    private SOSConnectionSettings connectionSettings = null;
    private SOSSettings jobSettings = null;
    private Properties jobProperties = null;
    private String application = new String("");
    private String taskJobName = null;
    private String jobName = null;
    private String jobFolder = null;
    private String jobTitle = null;
    private int jobId = 0;
    private Integer schedulerLogLevel = null;
    private boolean loggerConfigured = false;

    public boolean spooler_init() {
        try {
            this.setLogger();
            if (this.spooler_task != null) {
                this.setJobId(this.spooler_task.id());
            }
            if (this.spooler_job != null) {
                String jobName = this.spooler_job.name();
                this.setJobName(jobName);
                this.setJobFolder(this.spooler_job.folder_path());
                this.setJobTitle(this.spooler_job.title());
                this.setSettings(jobName);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return false;
        }
    }

    public void spooler_exit() {
        try {
            try {
                if (this.sosConnection != null) {
                    this.spooler_log.debug6("spooler_exit(): disconnecting.. ..");
                    this.sosConnection.disconnect();
                    this.sosConnection = null;
                }
            }
            catch (Exception e) {
                this.sosConnection = null;
                this.spooler_log.warn("spooler_exit(): disconnect failed: " + e.toString());
                LOGGER.warn(e.toString(), (Throwable)e);
            }
            LOGGER.info("Job " + this.getJobName() + " terminated.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLogger() {
        if (!this.loggerConfigured) {
            JSMessages.LOG_D_0020.toLog();
            LOGGER = LogManager.getRootLogger();
            if (this.schedulerLogLevel == null) {
                this.schedulerLogLevel = this.spooler_log.level();
            }
            if (this.schedulerLogLevel > 1) {
                Configurator.setRootLevel((Level)Level.ERROR);
            } else if (this.schedulerLogLevel == 1) {
                Configurator.setRootLevel((Level)Level.WARN);
            } else if (this.schedulerLogLevel == 0) {
                Configurator.setRootLevel((Level)Level.INFO);
            } else if (this.schedulerLogLevel == -9) {
                Configurator.setRootLevel((Level)Level.TRACE);
                Configurator.setLevel((String)"com.mchange", (Level)Level.INFO);
                Configurator.setLevel((String)"org.hibernate", (Level)Level.INFO);
                Configurator.setLevel((String)"org.hibernate.persister.entity.AbstractEntityPersister", (Level)Level.DEBUG);
                Configurator.setLevel((String)"org.hibernate.type.descriptor.sql", (Level)Level.TRACE);
                Configurator.setLevel((String)"org.hibernate.SQL", (Level)Level.DEBUG);
                Configurator.setLevel((String)"org.hibernate.loader.entity.plan.EntityLoader", (Level)Level.DEBUG);
            } else if (this.schedulerLogLevel < 0) {
                Configurator.setRootLevel((Level)Level.DEBUG);
                Configurator.setLevel((String)"com.mchange", (Level)Level.INFO);
                Configurator.setLevel((String)"org.hibernate", (Level)Level.INFO);
                Configurator.setLevel((String)"org.hibernate.persister.entity.AbstractEntityPersister", (Level)Level.DEBUG);
                Configurator.setLevel((String)"org.hibernate.SQL", (Level)Level.DEBUG);
                Configurator.setLevel((String)"org.hibernate.loader.entity.plan.EntityLoader", (Level)Level.DEBUG);
            }
            this.loggerConfigured = true;
        }
    }

    private SOSConnection connectToJSDataBase() {
        try {
            boolean isUniversalAgent = false;
            try {
                this.setJobSettings((SOSSettings)new SOSProfileSettings(this.spooler.ini_path()));
            }
            catch (Exception e) {
                isUniversalAgent = true;
            }
            if (!isUniversalAgent) {
                this.setJobProperties(this.jobSettings.getSection("spooler"));
                if (this.getJobProperties().isEmpty()) {
                    throw new JobSchedulerException("no settings found in section [spooler] of configuration file: " + this.spooler.ini_path());
                }
                if (this.getJobProperties().getProperty("db") == null || this.getJobProperties().getProperty("db").isEmpty()) {
                    throw new JobSchedulerException("no settings found for entry [db] in section [spooler] of configuration file: " + this.spooler.ini_path());
                }
                if (this.getJobProperties().getProperty("db_class") == null || this.getJobProperties().getProperty("db_class").isEmpty()) {
                    throw new JobSchedulerException("no settings found for entry [db_class] in section [spooler] of configuration file: " + this.spooler.ini_path());
                }
                LOGGER.debug("connecting to database...");
                this.setConnection(JobSchedulerJob.getSchedulerConnection(this.getJobSettings()));
                this.getConnection().connect();
                this.setConnectionSettings(new SOSConnectionSettings(this.getConnection(), "SETTINGS"));
                LOGGER.debug("..successfully connected to JobScheduler database.");
            }
        }
        catch (Exception e) {
            this.spooler_log.info("connect to database failed: ");
            this.spooler_log.info("running without database...");
            LOGGER.info(e.getMessage(), (Throwable)e);
        }
        return this.sosConnection;
    }

    private void setConnection(SOSConnection val) {
        if (this.sosConnection != null && !this.sosConnection.equals(val)) {
            try {
                this.sosConnection.disconnect();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.sosConnection = null;
        }
        this.sosConnection = val;
    }

    public SOSConnection getConnection() {
        if (this.sosConnection == null) {
            this.connectToJSDataBase();
        }
        return this.sosConnection;
    }

    public SOSSettings getJobSettings() {
        return this.jobSettings;
    }

    public void setJobSettings(SOSSettings val) {
        this.jobSettings = val;
    }

    public Properties getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(Properties val) {
        this.jobProperties = val;
    }

    public SOSConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public void setConnectionSettings(SOSConnectionSettings val) {
        this.connectionSettings = val;
    }

    protected int getJobId() {
        return this.jobId;
    }

    protected void setJobId(int val) {
        this.jobId = val;
    }

    protected String getJobName() {
        return this.jobName;
    }

    protected void setJobName(String val) {
        this.jobName = val.replaceFirst(".*/([^/]+)$", "$1");
    }

    protected String getJobFolder() {
        return this.jobFolder;
    }

    protected void setJobFolder(String val) {
        this.jobFolder = val;
    }

    protected String getJobTitle() {
        if (this.jobTitle == null) {
            this.jobTitle = this.spooler_task.job().title();
        }
        return this.jobTitle;
    }

    protected void setJobTitle(String val) {
        this.jobTitle = val;
    }

    protected void setApplication(String val) {
        this.application = val;
    }

    protected String getApplication() {
        return this.application;
    }

    public String getTaskJobName() {
        Job job;
        if (this.taskJobName == null && this.spooler_task != null && (job = this.spooler_task.job()) != null) {
            this.taskJobName = job.name();
        }
        return this.taskJobName;
    }

    public static SOSSettings getSchedulerSettings(String factoryIni) throws Exception {
        SOSProfileSettings schedulerSettings = new SOSProfileSettings(factoryIni);
        return schedulerSettings;
    }

    public static SOSConnection getSchedulerConnection(SOSSettings schedulerSettings) throws Exception {
        String dbProperty = schedulerSettings.getSection("spooler").getProperty("db").replaceAll("jdbc:", "-url=jdbc:");
        if ((dbProperty = dbProperty.substring(dbProperty.indexOf(45))).endsWith("-password=")) {
            dbProperty = dbProperty.substring(0, dbProperty.length() - 10);
        }
        SOSArguments arguments = new SOSArguments(dbProperty);
        return SOSConnection.createInstance((String)schedulerSettings.getSection("spooler").getProperty("db_class"), (String)arguments.asString("-class=", ""), (String)arguments.asString("-url=", ""), (String)arguments.asString("-user=", ""), (String)arguments.asString("-password=", ""));
    }

    public Path getHibernateConfigurationScheduler() {
        return JobSchedulerJob.getHibernateConfigurationScheduler(this.spooler);
    }

    public static Path getHibernateConfigurationScheduler(Spooler spooler) {
        String var;
        Variable_set vs = spooler.variables();
        if (vs != null && !SOSString.isEmpty((String)(var = vs.value(SCHEDULER_PARAM_HIBERNATE_SCHEDULER)))) {
            return Paths.get(var, new String[0]);
        }
        return Paths.get(spooler.directory() + "/config", new String[0]).resolve(HIBERNATE_DEFAULT_FILE_NAME_SCHEDULER);
    }

    public Path getHibernateConfigurationReporting() {
        return JobSchedulerJob.getHibernateConfigurationReporting(this.spooler, this.spooler_task);
    }

    public static Path getHibernateConfigurationReporting(Spooler spooler, Task task) {
        boolean isAgent;
        Path configDir = null;
        boolean bl = isAgent = !SOSString.isEmpty((String)task.agent_url());
        if (isAgent) {
            configDir = Paths.get(System.getenv("SCHEDULER_DATA"), new String[0]).resolve("config");
        } else {
            String var;
            Variable_set vs = spooler.variables();
            if (vs != null && !SOSString.isEmpty((String)(var = vs.value(SCHEDULER_PARAM_HIBERNATE_REPORTING)))) {
                return Paths.get(var, new String[0]);
            }
            configDir = Paths.get(spooler.directory() + "/config", new String[0]);
        }
        Path configFile = configDir.resolve(HIBERNATE_DEFAULT_FILE_NAME_REPORTING);
        if (Files.exists(configFile, new LinkOption[0])) {
            return configFile;
        }
        if (isAgent) {
            throw new JobSchedulerException("no hibernate configuration file found on agent file system!");
        }
        return JobSchedulerJob.getHibernateConfigurationScheduler(spooler);
    }

    private void setSettings(String jobName) {
        try {
            Optional<Object> schedulerIniFile = Optional.empty();
            try {
                schedulerIniFile = Optional.of(new File(this.spooler.ini_path()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!schedulerIniFile.isPresent() || !((File)schedulerIniFile.get()).canRead()) {
                this.spooler_log.debug("No ini file available. Continuing without settings.");
                return;
            }
            this.setJobSettings((SOSSettings)new SOSProfileSettings(((File)schedulerIniFile.get()).getCanonicalPath()));
            this.setJobProperties(this.getJobSettings().getSection("job " + jobName));
            if (this.getJobProperties().isEmpty()) {
                return;
            }
            if (this.getJobProperties().getProperty("delay_after_error") != null) {
                String[] delays = this.getJobProperties().getProperty("delay_after_error").toString().split(";");
                if (delays.length > 0) {
                    this.spooler_job.clear_delay_after_error();
                }
                for (String delay2 : delays) {
                    String[] delay = delay2.split(":");
                    this.spooler_job.set_delay_after_error(Integer.parseInt(delay[0]), delay[1]);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }
}

