/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.JSHelper.Basics.IJSCommands;
import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionElement;
import com.sos.JSHelper.interfaces.IJobSchedulerEventHandler;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.localization.Messages;
import com.sos.scheduler.messages.JSMessages;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.job.JobSchedulerJob;
import sos.scheduler.misc.SpoolerProcess;
import sos.spooler.IMonitor_impl;
import sos.spooler.Job;
import sos.spooler.Job_chain;
import sos.spooler.Job_chain_node;
import sos.spooler.Order;
import sos.spooler.Variable_set;
import sos.util.ParameterSubstitutor;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JobSchedulerJobAdapter
extends JobSchedulerJob
implements JSJobUtilities,
IJSCommands,
IMonitor_impl,
IJobSchedulerEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerJobAdapter.class);
    protected final String EMPTY_STRING = "";
    private static final String MESSAGES_BUNDLE_NAME = "com_sos_scheduler_messages";
    private static final int MAX_LENGTH_OF_STATUSTEXT = 100;
    private Messages messages = null;
    private IJobSchedulerEventHandler eventHandler = null;
    private SpoolerProcess spoolerProcess = null;
    private HashMap<String, String> taskParams = null;
    private HashMap<String, String> globalSchedulerParams = null;
    private HashMap<String, String> schedulerParameters = new HashMap();
    private ParameterSubstitutor parameterSubstitutor;

    public JobSchedulerJobAdapter() {
        this.messages = new Messages(MESSAGES_BUNDLE_NAME, Locale.getDefault());
    }

    public boolean spooler_process() throws Exception {
        try {
            LOGGER.info("1.13.23 (2024-08-21 13:20, revision 158016465b029774567fe088f6e4d3a6b4e909ee) Copyright 2003-2024 SOS GmbH Berlin");
            if (this.spoolerProcess == null) {
                this.spoolerProcess = new SpoolerProcess(this.spooler_job);
            }
            this.spoolerProcess.setOrder(this.spooler_task.order());
            return this.spoolerProcess.isOrderJob();
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Map<String, String> getSpecialVariables() {
        HashMap<String, String> specialVariables = new HashMap<String, String>();
        if (this.spooler_task != null) {
            this.setJobId(this.spooler_task.id());
        }
        if (this.spooler_job != null) {
            String jobName = this.spooler_job.name();
            this.setJobName(jobName);
            this.setJobFolder(this.spooler_job.folder_path());
            this.setJobTitle(this.spooler_job.title());
        }
        specialVariables.put("SCHEDULER_JOB_FOLDER", this.getJobFolder());
        specialVariables.put("SCHEDULER_JOB_PATH", this.getJobFolder() + "/" + this.getJobName());
        specialVariables.put("SCHEDULER_JOB_NAME", this.spooler_job.name());
        specialVariables.put("SCHEDULER_JOB_TITLE", this.spooler_job.title());
        specialVariables.put("SCHEDULER_TASK_ID", String.valueOf(this.spooler_task.id()));
        specialVariables.put("SCHEDULER_ID", String.valueOf(this.spooler.id()));
        if (this.spooler_task.order() != null) {
            specialVariables.put("SCHEDULER_JOB_CHAIN", String.valueOf(this.spooler_task.order().job_chain().name()));
            specialVariables.put("SCHEDULER_ORDER_ID", String.valueOf(this.spooler_task.order().id()));
            Job_chain jobChain = this.spooler_task.order().job_chain();
            if (jobChain != null) {
                Job_chain_node jobChainNode = this.spooler_task.order().job_chain_node();
                specialVariables.put("SCHEDULER_JOB_CHAIN_NAME", jobChain.name());
                specialVariables.put("SCHEDULER_JOB_CHAIN_TITLE", jobChain.title());
                specialVariables.put("SCHEDULER_JOB_CHAIN_PATH", jobChain.path());
                specialVariables.put("SCHEDULER_ORDER_ID", this.spooler_task.order().id());
                specialVariables.put("SCHEDULER_NODE_NAME", this.getCurrentNodeName(this.spooler_task.order(), false));
                specialVariables.put("SCHEDULER_NEXT_NODE_NAME", jobChainNode.next_state());
                specialVariables.put("SCHEDULER_NEXT_ERROR_NODE_NAME", jobChainNode.error_state());
            }
        }
        specialVariables.put("SCHEDULER_CONFIGURATION_DIRECTORY", String.valueOf(this.spooler.configuration_directory()));
        specialVariables.put("SCHEDULER_DIRECTORY", String.valueOf(this.spooler.directory()));
        specialVariables.put("SCHEDULER_HOST", String.valueOf(this.spooler.hostname()));
        specialVariables.put("SCHEDULER_TCP_PORT", String.valueOf(this.spooler.tcp_port()));
        specialVariables.put("SCHEDULER_UDP_PORT", String.valueOf(this.spooler.udp_port()));
        if (this.spooler.supervisor_client() != null) {
            specialVariables.put("SCHEDULER_SUPERVISOR_HOST", String.valueOf(this.spooler.supervisor_client().hostname()));
            specialVariables.put("SCHEDULER_SUPERVISOR_PORT", String.valueOf(this.spooler.supervisor_client().tcp_port()));
        } else {
            specialVariables.put("SCHEDULER_SUPERVISOR_HOST", "");
            specialVariables.put("SCHEDULER_SUPERVISOR_PORT", "");
        }
        return specialVariables;
    }

    protected HashMap<String, String> getSchedulerParameterAsProperties(HashMap<String, String> params) {
        this.schedulerParameters = new HashMap();
        try {
            if (this.isNotNull(params)) {
                this.schedulerParameters = params;
                for (String key : this.schedulerParameters.keySet()) {
                    String value = this.schedulerParameters.get(key);
                    if (value == null) continue;
                    String replacedValue = this.replaceSchedulerVars(value);
                    if (!replacedValue.equalsIgnoreCase(value)) {
                        this.schedulerParameters.put(key, replacedValue);
                        if (key.contains("password") || key.contains("passphrase")) {
                            LOGGER.trace(String.format("%1$s = *****", key));
                            continue;
                        }
                        LOGGER.trace(String.format("%1$s = %2$s", key, replacedValue));
                        continue;
                    }
                    if (key.contains("password") || key.contains("passphrase")) {
                        LOGGER.trace(String.format("%1$s = *****", key));
                        continue;
                    }
                    LOGGER.trace(String.format("%1$s = %2$s", key, value));
                }
            }
            this.schedulerParameters = this.deleteCurrentNodeNameFromKeys(this.schedulerParameters, this.getTaskJobName(), this.getCurrentNodeName(false));
            this.parameterSubstitutor = null;
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JSJ_F_0060.params(new Object[]{e.toString()}), (Throwable)e);
        }
        return this.schedulerParameters;
    }

    protected HashMap<String, String> convertVariableSet2HashMap(Variable_set params) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (this.isNotNull(params)) {
                String[] names = params.names().split(";");
                String value = "";
                for (String key : names) {
                    if ("".equals(key)) continue;
                    value = params.var(key);
                    result.put(key, value);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JSJ_F_0060.params(new Object[]{e.toString()}), (Throwable)e);
        }
    }

    private String getParameterName(String currentJob, String currentNodeName, String parameterName) {
        String pattern1 = "^" + currentNodeName + "/(.*)";
        String pattern2 = "^job::" + currentJob + "/(.*)";
        String pattern3 = "^job::" + currentJob + "\\." + currentNodeName + "/(.*)";
        String newParameter = parameterName.replaceAll(pattern3, "$1");
        newParameter = newParameter.replaceAll(pattern2, "$1");
        newParameter = newParameter.replaceAll(pattern1, "$1");
        return newParameter;
    }

    private HashMap<String, String> deleteCurrentNodeNameFromKeys(HashMap<String, String> params, String currentJob, String currentNodeName) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(params);
        Set<Map.Entry<String, String>> set = params.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String name;
            String key = entry.getKey();
            if (key.equals(name = this.getParameterName(currentJob, currentNodeName, key))) continue;
            String val = entry.getValue();
            result.put(name, val);
        }
        return result;
    }

    protected HashMap<String, String> getSchedulerParameterAsProperties(Order order) {
        return this.getSchedulerParameterAsProperties(this.getJobOrOrderParameters(order));
    }

    protected HashMap<String, String> getJobOrOrderParameters(Order order) {
        try {
            Variable_set orderParams;
            HashMap<String, String> params = new HashMap<String, String>();
            if (order == null) {
                this.taskParams = null;
            }
            params.putAll(this.getTaskParams(this.spooler_task.params()));
            if (order != null && (orderParams = order.params()) != null) {
                params.putAll(this.convertVariableSet2HashMap(orderParams));
            }
            JSMessages.JSJ_D_0070.toLog(new Object[]{params.size()});
            return params;
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JSJ_F_0050.get(e), (Throwable)e);
        }
    }

    public HashMap<String, String> getGlobalSchedulerParameters() {
        if (this.globalSchedulerParams == null) {
            this.globalSchedulerParams = this.convertVariableSet2HashMap(this.spooler.variables());
        }
        return this.globalSchedulerParams;
    }

    @Deprecated
    public void setJSParam(String name, String value) {
        Variable_set orderParams;
        Order order;
        Variable_set taskParams = this.spooler_task.params();
        HashMap<String, String> params = this.getTaskParams(taskParams);
        if (params != null) {
            params.put(name, value);
        }
        if (taskParams != null) {
            taskParams.set_var(name, value);
        }
        Order order2 = order = this.spoolerProcess == null ? this.spooler_task.order() : this.spoolerProcess.getOrder();
        if (order != null && (orderParams = order.params()) != null) {
            orderParams.set_var(name, value);
        }
        if (this.isNotNull(this.schedulerParameters)) {
            this.schedulerParameters.put(name, value);
        }
    }

    @Deprecated
    public void setJSParam(String name, StringBuilder value) {
        this.setJSParam(name, value.toString());
    }

    public HashMap<String, String> getTaskParams(Variable_set params) {
        if (this.taskParams == null) {
            this.taskParams = this.convertVariableSet2HashMap(params);
        }
        return this.taskParams;
    }

    private void fillParameterSubstitutor() {
        if (this.parameterSubstitutor == null) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.putAll(this.schedulerParameters);
            variables.putAll(this.getSpecialVariables());
            this.parameterSubstitutor = new ParameterSubstitutor();
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null || value.isEmpty()) continue;
                this.parameterSubstitutor.addKey(name, value);
            }
        }
    }

    public String replaceSchedulerVars(String string2Modify) {
        String resultString = string2Modify;
        if (this.isNotNull(this.schedulerParameters)) {
            this.fillParameterSubstitutor();
            if (string2Modify.matches("(?s).*\\$\\{[^{]+\\}.*")) {
                this.parameterSubstitutor.setOpenTag("${");
                this.parameterSubstitutor.setCloseTag("}");
                resultString = this.parameterSubstitutor.replace(string2Modify);
            }
            if (resultString.contains("%")) {
                this.parameterSubstitutor.setOpenTag("%");
                this.parameterSubstitutor.setCloseTag("%");
                resultString = this.parameterSubstitutor.replace(resultString);
            }
        }
        return resultString;
    }

    protected JSJobUtilities getJSJobUtilities() {
        return this;
    }

    public void setJSJobUtilites(JSJobUtilities val) {
    }

    private String getCurrentNodeName(boolean verbose) {
        return this.getCurrentNodeName(this.spoolerProcess != null ? this.spoolerProcess.getOrder() : this.spooler_task.order(), verbose);
    }

    public String getCurrentNodeName(Order order, boolean verbose) {
        String method = "JobSchedulerJobAdapter::getCurrentNodeName";
        String name = "unknownNode";
        if (this.spooler_task != null) {
            if (order != null) {
                if (this.spoolerProcess != null) {
                    if (this.spoolerProcess.getCurrentOrderState() == null) {
                        this.spoolerProcess.setCurrentOrderState(order.state());
                    }
                    name = this.spoolerProcess.getCurrentOrderState();
                } else {
                    name = order.state();
                }
                if (verbose) {
                    JSMessages.JSJ_I_0020.toLog(new Object[]{"JobSchedulerJobAdapter::getCurrentNodeName", name});
                }
            } else {
                name = this.getTaskJobName();
                if (verbose) {
                    JSMessages.JSJ_I_0010.toLog(new Object[]{"JobSchedulerJobAdapter::getCurrentNodeName", name});
                }
            }
        }
        return name;
    }

    public Object getSpoolerObject() {
        return this.spooler;
    }

    public String executeXML(String xml) {
        return this.spooler.execute_xml(xml);
    }

    public void setNextNodeState(String state) {
        Order order;
        Order order2 = order = this.spoolerProcess == null ? this.spooler_task.order() : this.spoolerProcess.getOrder();
        if (order != null) {
            order.set_state(state);
        }
    }

    public boolean isNotNull(Object val) {
        return val != null;
    }

    public boolean isNull(Object val) {
        return val == null;
    }

    public boolean signalSuccess(Order order) {
        return order != null;
    }

    protected boolean isNotEmpty(String val) {
        return this.isNotNull(val) && !val.trim().isEmpty();
    }

    protected boolean isEmpty(String val) {
        return this.isNull(val) || val.trim().isEmpty();
    }

    public Properties mapToProperties(Map<String, String> map) {
        Properties p = new Properties();
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            p.put(entry.getKey(), entry.getValue());
        }
        return p;
    }

    public String getJobScript() {
        String script = "";
        Job job = this.spooler_task.job();
        if (job != null) {
            try {
                script = job.script_code();
            }
            catch (Exception e) {
                LOGGER.info("JobScheduler doesn't support reading the script tag.");
            }
            if (this.isEmpty(script)) {
                script = "";
            }
        }
        return script;
    }

    public void setJobScript(SOSOptionElement option) {
        String script;
        if (option.isNotDirty() && this.isNotEmpty(script = this.getJobScript())) {
            option.setValue(script);
            if (LOGGER.isDebugEnabled()) {
                try {
                    LOGGER.debug(String.format("copy script from script-tag of job '%2$s' to option '%1$s'", option.getShortKey(), this.spooler_task.job().name()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean spooler_task_before() throws Exception {
        this.setLogger();
        return true;
    }

    public void spooler_task_after() throws Exception {
        this.setLogger();
    }

    public boolean spooler_process_before() throws Exception {
        this.setLogger();
        return true;
    }

    public boolean spooler_process_after(boolean result) throws Exception {
        this.setLogger();
        return result;
    }

    public void setStateText(String state) {
        if (state != null) {
            Order order;
            String stateText = state;
            if (stateText.length() > 100) {
                stateText = stateText.substring(0, 97) + "...";
            }
            Order order2 = order = this.spoolerProcess == null ? this.spooler_task.order() : this.spoolerProcess.getOrder();
            if (order != null) {
                try {
                    order.set_state_text(stateText);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.spooler_job != null) {
                this.spooler_job.set_state_text(stateText);
            }
        }
    }

    public void setExitCode(int exitCode) {
        if (this.spooler_task != null) {
            LOGGER.debug(String.format("exit code set to %1$d", exitCode));
            this.spooler_task.set_exit_code(exitCode);
        }
    }

    public void spooler_on_error() {
        this.setStateText("! ended with Error !");
    }

    public void spooler_on_success() {
        this.setStateText("*** ended without Errors ***");
    }

    public void sendEvent(String key, Map<String, String> values) {
    }

    public IJobSchedulerEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(IJobSchedulerEventHandler val) {
        this.eventHandler = val;
    }

    public void updateDb(Long id, String type, Map<String, String> values) {
    }

    public HashMap<String, String> getSchedulerParameters() {
        return this.schedulerParameters;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public SpoolerProcess getSpoolerProcess() {
        return this.spoolerProcess;
    }
}

